/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache.redis;

import java.time.Duration;
import java.util.Objects;
import org.apache.shenyu.plugin.cache.ICache;
import org.apache.shenyu.plugin.cache.redis.RedisConfigProperties;
import org.apache.shenyu.plugin.cache.redis.RedisConnectionFactory;
import org.apache.shenyu.plugin.cache.redis.serializer.ShenyuRedisSerializationContext;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import reactor.core.publisher.Mono;

public final class RedisCache
implements ICache {
    private final ReactiveRedisTemplate<String, byte[]> redisTemplate;

    public RedisCache(RedisConfigProperties redisConfigProperties) {
        this.redisTemplate = new ReactiveRedisTemplate((ReactiveRedisConnectionFactory)new RedisConnectionFactory(redisConfigProperties).getLettuceConnectionFactory(), ShenyuRedisSerializationContext.bytesSerializationContext());
    }

    public Mono<Boolean> cacheData(String key, byte[] bytes, long timeoutSeconds) {
        return this.redisTemplate.opsForValue().set((Object)key, (Object)bytes, Duration.ofSeconds(timeoutSeconds));
    }

    public Mono<Boolean> isExist(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Mono<byte[]> getData(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public void close() {
        if (Objects.isNull(this.redisTemplate)) {
            return;
        }
        ReactiveRedisConnectionFactory connectionFactory = this.redisTemplate.getConnectionFactory();
        try {
            ReactiveRedisConnection connection = connectionFactory.getReactiveConnection();
            connection.close();
            connection = connectionFactory.getReactiveClusterConnection();
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

