/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.token.limiter.redis;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.common.enums.RedisModeEnum;

public class RedisConfigProperties {
    private Integer database = 0;
    private String master;
    private String mode = RedisModeEnum.STANDALONE.getName();
    private String url;
    private String password;
    private Integer maxIdle = 8;
    private Integer minIdle = 0;
    private Integer maxActive = 8;
    private Integer maxWait = -1;

    public Integer getDatabase() {
        return this.database;
    }

    public void setDatabase(Integer database) {
        this.database = database;
    }

    public String getMaster() {
        return this.master;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public Duration getMaxWait() {
        return Optional.ofNullable(this.maxWait).map(it -> Duration.ofMillis(this.maxWait.intValue())).orElse(Duration.ofMillis(-1L));
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConfigProperties that = (RedisConfigProperties)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.master, that.master) && Objects.equals(this.mode, that.mode) && Objects.equals(this.url, that.url) && Objects.equals(this.password, that.password) && Objects.equals(this.maxIdle, that.maxIdle) && Objects.equals(this.minIdle, that.minIdle) && Objects.equals(this.maxActive, that.maxActive) && Objects.equals(this.maxWait, that.maxWait);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.master, this.mode, this.url, this.password, this.maxIdle, this.minIdle, this.maxActive, this.maxWait);
    }
}

