/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.trie;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.cache.WindowTinyLFUMap;
import org.apache.shenyu.common.constant.Constants;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.TrieCacheTypeEnum;
import org.apache.shenyu.common.enums.TrieMatchModeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.plugin.base.trie.ShenyuTrieNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuTrie {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuTrie.class);
    private static final String WILDCARD = "*";
    private static final String MATCH_ALL = "**";
    private final Map<String, ShenyuTrieNode> keyRootMap;
    private final TrieMatchModeEnum matchMode;

    public ShenyuTrie(Long cacheSize, String matchMode) {
        this.matchMode = TrieMatchModeEnum.acquireTrieMatch((String)matchMode);
        this.keyRootMap = new WindowTinyLFUMap(cacheSize.longValue());
    }

    public void clear() {
        ShenyuTrie.cleanup(this.keyRootMap);
    }

    public boolean isEmpty() {
        return this.keyRootMap.isEmpty();
    }

    public <T> void putNode(List<String> uriPaths, T source, TrieCacheTypeEnum cacheType) {
        if (CollectionUtils.isNotEmpty(uriPaths)) {
            uriPaths.forEach(path -> this.putNode((String)path, source, cacheType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putNode(String uriPath, T source, TrieCacheTypeEnum cacheType) {
        ShenyuTrieNode node;
        if (StringUtils.isBlank((CharSequence)uriPath)) {
            return;
        }
        String strippedPath = StringUtils.strip((String)uriPath, (String)"/");
        Object[] pathParts = StringUtils.split((String)strippedPath, (String)"/");
        if (ArrayUtils.isEmpty((Object[])pathParts)) {
            return;
        }
        if (TrieMatchModeEnum.PATH_PATTERN.equals((Object)this.matchMode)) {
            this.checkLegalPath(uriPath, (String[])pathParts);
        }
        RuleData ruleData = null;
        SelectorData selectorData = null;
        if (TrieCacheTypeEnum.RULE.equals((Object)cacheType)) {
            ruleData = (RuleData)source;
            node = this.keyRootMap.computeIfAbsent(ruleData.getSelectorId(), key -> new ShenyuTrieNode("/", "/", false));
        } else {
            selectorData = (SelectorData)source;
            node = this.keyRootMap.computeIfAbsent(selectorData.getPluginName(), key -> new ShenyuTrieNode("/", "/", false));
        }
        for (int i = 0; i < pathParts.length; ++i) {
            if (!Objects.isNull(node = this.putNode0((String)pathParts[i], node))) continue;
            this.remove(StringUtils.join((Object[])pathParts, (String)"/", (int)0, (int)i), source, cacheType);
            return;
        }
        node.setFullPath(uriPath);
        node.setEndOfPath(true);
        if (Objects.isNull(node.getPathCache())) {
            node.setPathRuleCache(new ConcurrentHashMap(Constants.TRIE_PATH_CACHE_SIZE));
        }
        if (TrieCacheTypeEnum.RULE.equals((Object)cacheType)) {
            List<?> collections = node.getPathCache().get(ruleData.getSelectorId());
            if (CollectionUtils.isNotEmpty(collections)) {
                List ruleDataList = ListUtil.castList(collections, RuleData.class::cast);
                String string = ruleData.getId();
                synchronized (string) {
                    ruleDataList.add(ruleData);
                    ruleDataList.sort(Comparator.comparing(RuleData::getSort));
                    node.getPathCache().put(ruleData.getSelectorId(), ruleDataList);
                }
            } else {
                node.getPathCache().put(ruleData.getSelectorId(), Lists.newArrayList((Object[])new RuleData[]{ruleData}));
            }
            node.setBizInfo(ruleData.getSelectorId());
            this.buildFailToNode(this.keyRootMap.get(ruleData.getSelectorId()));
        } else {
            List<?> collections = node.getPathCache().get(selectorData.getPluginName());
            if (CollectionUtils.isNotEmpty(collections)) {
                List selectorDataList = ListUtil.castList(collections, SelectorData.class::cast);
                String string = selectorData.getId();
                synchronized (string) {
                    selectorDataList.add(selectorData);
                    selectorDataList.sort(Comparator.comparing(SelectorData::getSort));
                    node.getPathCache().put(selectorData.getPluginName(), selectorDataList);
                }
            } else {
                node.getPathCache().put(selectorData.getPluginName(), Lists.newArrayList((Object[])new SelectorData[]{selectorData}));
            }
            node.setBizInfo(selectorData.getPluginName());
            this.buildFailToNode(this.keyRootMap.get(selectorData.getPluginName()));
        }
    }

    private void buildFailToNode(ShenyuTrieNode root) {
        if (Objects.isNull(root)) {
            return;
        }
        LinkedList queue = new LinkedList();
        Map pathVariableChildren = Optional.ofNullable(root.getPathVariables()).orElse(new HashMap(0));
        Map children = Optional.ofNullable(root.getChildren()).orElse(new HashMap(0));
        HashMap<String, ShenyuTrieNode> allChildren = new HashMap<String, ShenyuTrieNode>();
        allChildren.putAll(children);
        allChildren.putAll(pathVariableChildren);
        allChildren.forEach((key, currentNode) -> {
            currentNode.setFailToNode(root);
            queue.offer(currentNode);
        });
        while (!queue.isEmpty()) {
            ShenyuTrieNode currentNode2 = (ShenyuTrieNode)queue.poll();
            Map childrenList = Optional.ofNullable(currentNode2.getChildren()).orElse(new HashMap(0));
            Map pathList = Optional.ofNullable(currentNode2.getPathVariables()).orElse(new HashMap(0));
            HashMap<String, ShenyuTrieNode> newChildren = new HashMap<String, ShenyuTrieNode>();
            newChildren.putAll(childrenList);
            newChildren.putAll(pathList);
            if (allChildren.containsKey(currentNode2.getMatchStr())) {
                newChildren.forEach((key, node) -> queue.offer(node));
                continue;
            }
            ShenyuTrieNode parent = currentNode2.getParentNode();
            if (!(ShenyuTrie.isMatchWildcard(currentNode2.getMatchStr()) || ShenyuTrie.isMatchAll(currentNode2.getMatchStr()) || ShenyuTrie.isPathVariable(currentNode2.getMatchStr()))) {
                if (ShenyuTrie.containsKey(parent.getChildren(), WILDCARD)) {
                    currentNode2.setFailToNode(parent.getChildren().get(WILDCARD));
                } else if (ShenyuTrie.containsKey(parent.getChildren(), MATCH_ALL)) {
                    currentNode2.setFailToNode(parent.getChildren().get(MATCH_ALL));
                } else if (Objects.nonNull(parent.getPathVariableNode())) {
                    currentNode2.setFailToNode(parent.getPathVariableNode());
                } else {
                    currentNode2.setFailToNode(parent.getFailToNode());
                }
            } else if (ShenyuTrie.isMatchWildcard(currentNode2.getMatchStr())) {
                if (ShenyuTrie.containsKey(parent.getChildren(), MATCH_ALL)) {
                    currentNode2.setFailToNode(parent.getChildren().get(MATCH_ALL));
                } else if (Objects.nonNull(parent.getPathVariableNode())) {
                    currentNode2.setFailToNode(parent.getPathVariableNode());
                } else {
                    currentNode2.setFailToNode(parent.getFailToNode());
                }
            } else if (ShenyuTrie.isMatchAll(currentNode2.getMatchStr())) {
                if (currentNode2.getEndOfPath()) {
                    currentNode2.setFailToNode(null);
                } else if (Objects.nonNull(parent.getPathVariableNode())) {
                    currentNode2.setFailToNode(parent.getPathVariableNode());
                } else {
                    currentNode2.setFailToNode(parent.getFailToNode());
                }
            } else if (ShenyuTrie.isPathVariable(currentNode2.getMatchStr()) && MapUtils.isNotEmpty(parent.getPathVariables())) {
                if (parent.getPathVariables().size() == 1) {
                    currentNode2.setFailToNode(parent.getFailToNode());
                } else if (Objects.isNull(currentNode2.getFailToNode())) {
                    LinkedList pathVariableQueue = new LinkedList();
                    HashMap<String, ShenyuTrieNode> map = new HashMap<String, ShenyuTrieNode>(parent.getPathVariables());
                    map.remove(currentNode2.getMatchStr());
                    map.values().forEach(pathVariableQueue::offer);
                    while (!pathVariableQueue.isEmpty()) {
                        ShenyuTrieNode pathVariableNode = (ShenyuTrieNode)pathVariableQueue.poll();
                        if (pathVariableQueue.size() > 1) {
                            currentNode2.setFailToNode(pathVariableNode);
                            currentNode2 = pathVariableNode;
                            continue;
                        }
                        currentNode2.setFailToNode(pathVariableNode);
                        pathVariableNode.setFailToNode(parent.getFailToNode());
                    }
                }
            } else {
                currentNode2.setFailToNode(parent.getFailToNode());
            }
            newChildren.forEach((key, value) -> queue.offer(value));
        }
    }

    public ShenyuTrieNode match(String uriPath, String bizInfo) {
        String strippedPath = StringUtils.strip((String)uriPath, (String)"/");
        Object[] pathParts = StringUtils.split((String)strippedPath, (String)"/");
        if (ArrayUtils.isEmpty((Object[])pathParts)) {
            return null;
        }
        ShenyuTrieNode currentNode = this.keyRootMap.get(bizInfo);
        int startIndex = 0;
        int[] matchAll = new int[pathParts.length];
        int[] wildcard = new int[pathParts.length];
        int[] pathVariable = new int[pathParts.length];
        while (startIndex < pathParts.length) {
            ShenyuTrieNode matchNode;
            Object pathPart = pathParts[startIndex];
            if (Objects.isNull(currentNode)) {
                return null;
            }
            if (ShenyuTrie.containsKey(currentNode.getChildren(), (String)pathPart)) {
                currentNode = currentNode.getChildren().get(pathPart);
            } else if (this.hasWildcardNode(currentNode.getChildren(), (String)pathPart) && Objects.nonNull(matchNode = ShenyuTrie.findMatchWildcard(currentNode.getChildren(), (String)pathPart)) && wildcard[startIndex] == 0) {
                currentNode = matchNode;
                wildcard[startIndex] = 1;
            } else if (ShenyuTrie.containsKey(currentNode.getChildren(), MATCH_ALL) && matchAll[startIndex] == 0) {
                currentNode = currentNode.getChildren().get(MATCH_ALL);
                matchAll[startIndex] = 1;
                int matchAllIndex = startIndex;
                while (matchAllIndex != pathParts.length - 1) {
                    if (ShenyuTrie.containsKey(currentNode.getChildren(), (String)pathParts[++matchAllIndex])) {
                        currentNode = currentNode.getChildren().get(pathParts[matchAllIndex]);
                        startIndex = matchAllIndex;
                    } else {
                        if (!this.hasWildcardNode(currentNode.getChildren(), (String)pathParts[matchAllIndex]) || !Objects.nonNull(matchNode = ShenyuTrie.findMatchWildcard(currentNode.getChildren(), (String)pathParts[matchAllIndex]))) continue;
                        currentNode = matchNode;
                        wildcard[matchAllIndex] = 1;
                        startIndex = matchAllIndex;
                    }
                    break;
                }
            } else if (Objects.nonNull(currentNode.getPathVariableNode()) && currentNode.getPathVariables().size() == 1 && pathVariable[startIndex] == 0) {
                currentNode = currentNode.getPathVariableNode();
                pathVariable[startIndex] = 1;
            } else {
                ShenyuTrieNode preParentNode = currentNode.getParentNode();
                ShenyuTrieNode newCurrentNode = currentNode.getFailToNode();
                ShenyuTrieNode parentNode = newCurrentNode.getParentNode();
                if (Objects.isNull(parentNode) || Objects.nonNull(parentNode.getFailToNode()) && Objects.nonNull(newCurrentNode.getFailToNode()) && this.completeResolveConflict(parentNode, wildcard, matchAll, pathVariable, startIndex) && parentNode.getFailToNode().equals(newCurrentNode.getFailToNode()) && "/".equals(parentNode.getParentNode().getMatchStr())) {
                    return null;
                }
                --startIndex;
                if (preParentNode.equals(parentNode)) {
                    --startIndex;
                    currentNode = parentNode.getParentNode();
                    continue;
                }
                while (!preParentNode.equals(parentNode)) {
                    preParentNode = preParentNode.getParentNode();
                    --startIndex;
                }
                currentNode = parentNode;
                continue;
            }
            if (startIndex < pathParts.length - 1 && Objects.nonNull(currentNode) && !currentNode.getEndOfPath()) {
                ++startIndex;
                continue;
            }
            if ((startIndex != pathParts.length - 1 || !this.checkNode(currentNode, bizInfo)) && (!Objects.nonNull(currentNode) || !ShenyuTrie.isMatchAll(currentNode.getMatchStr()) || !this.checkNode(currentNode, bizInfo))) continue;
            return currentNode;
        }
        return null;
    }

    private boolean completeResolveConflict(ShenyuTrieNode node, int[] wildcard, int[] matchAll, int[] pathVariable, int index) {
        if (this.hasWildcardNode(node.getChildren(), WILDCARD) && ShenyuTrie.containsKey(node.getChildren(), MATCH_ALL) && Objects.nonNull(node.getPathVariableNode())) {
            return wildcard[index] == 1 && matchAll[index] == 1 && pathVariable[index] == 1;
        }
        if (this.hasWildcardNode(node.getChildren(), WILDCARD) && ShenyuTrie.containsKey(node.getChildren(), MATCH_ALL)) {
            return wildcard[index] == 1 && matchAll[index] == 1;
        }
        if (this.hasWildcardNode(node.getChildren(), WILDCARD) && Objects.nonNull(node.getPathVariableNode())) {
            return wildcard[index] == 1 && pathVariable[index] == 1;
        }
        if (ShenyuTrie.containsKey(node.getChildren(), MATCH_ALL) && Objects.nonNull(node.getPathVariableNode())) {
            return matchAll[index] == 1 && pathVariable[index] == 1;
        }
        return false;
    }

    public <T> void remove(List<String> paths, T source, TrieCacheTypeEnum cacheType) {
        if (CollectionUtils.isNotEmpty(paths)) {
            paths.forEach(path -> this.remove((String)path, source, cacheType));
        }
    }

    public <T> void remove(String path, T source, TrieCacheTypeEnum cacheType) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        String strippedPath = StringUtils.strip((String)path, (String)"/");
        String[] pathParts = StringUtils.split((String)strippedPath, (String)"/");
        if (TrieCacheTypeEnum.RULE.equals((Object)cacheType)) {
            RuleData ruleData = (RuleData)source;
            ShenyuTrieNode currentNode = this.getNode(path, ruleData.getSelectorId());
            Optional.ofNullable(currentNode).ifPresent(node -> {
                List dataList = Optional.ofNullable(node.getPathCache()).map(cache -> (List)cache.get(ruleData.getSelectorId())).orElse(Collections.emptyList());
                if (CollectionUtils.isNotEmpty(dataList)) {
                    this.removeRuleData(currentNode, pathParts, ruleData, dataList);
                }
            });
        } else {
            SelectorData selectorData = (SelectorData)source;
            ShenyuTrieNode currentNode = this.getNode(path, selectorData.getPluginName());
            Optional.ofNullable(currentNode).ifPresent(node -> {
                List dataList = Optional.ofNullable(node.getPathCache()).map(cache -> (List)cache.get(selectorData.getPluginName())).orElse(Collections.emptyList());
                if (CollectionUtils.isNotEmpty(dataList)) {
                    this.removeSelectorData(currentNode, pathParts, selectorData, dataList);
                }
            });
        }
    }

    public void removeByKey(String key) {
        this.keyRootMap.remove(key);
    }

    public ShenyuTrieNode getNode(String uriPath, String bizInfo) {
        if (StringUtils.isBlank((CharSequence)uriPath)) {
            return null;
        }
        String strippedPath = StringUtils.strip((String)uriPath, (String)"/");
        String[] pathParts = StringUtils.split((String)strippedPath, (String)"/");
        ShenyuTrieNode node = this.keyRootMap.get(bizInfo);
        if (Objects.isNull(node)) {
            return null;
        }
        for (int i = 0; i < pathParts.length; ++i) {
            String key = pathParts[i];
            if (Objects.nonNull(node)) {
                ShenyuTrieNode shenyuTrieNode = node = ShenyuTrie.isPathVariable(key) && Objects.nonNull(node.getPathVariables()) ? node.getPathVariables().get(key) : ShenyuTrie.getVal(node.getChildren(), key);
            }
            if (i != pathParts.length - 1) continue;
            return node;
        }
        return null;
    }

    public Set<String> getKeyRootKeys() {
        return this.keyRootMap.keySet();
    }

    private void checkLegalPath(String uriPath, String[] pathParts) {
        for (int i = 0; i < pathParts.length - 1; ++i) {
            if (!ShenyuTrie.isMatchAll(pathParts[i])) continue;
            LOG.error("error path:{}, error position:{}", (Object)uriPath, (Object)i);
            throw new ShenyuException("No more pattern data allowed after ** pattern element");
        }
    }

    private ShenyuTrieNode putNode0(String segment, ShenyuTrieNode shenyuTrieNode) {
        if (ShenyuTrie.isMatchWildcard(segment)) {
            ShenyuTrieNode wildcardNode = this.put(segment, shenyuTrieNode);
            wildcardNode.setWildcard(true);
        } else if (ShenyuTrie.isPathVariable(segment)) {
            ShenyuTrieNode childNode;
            if (ShenyuTrie.containsKey(shenyuTrieNode.getPathVariables(), segment)) {
                childNode = ShenyuTrie.getVal(shenyuTrieNode.getPathVariables(), segment);
            } else {
                childNode = new ShenyuTrieNode();
                childNode.setMatchStr(segment);
                childNode.setParentNode(shenyuTrieNode);
                if (Objects.isNull(shenyuTrieNode.getPathVariables())) {
                    shenyuTrieNode.setPathVariables(new ConcurrentHashMap<String, ShenyuTrieNode>(Constants.TRIE_PATH_VARIABLES_SIZE));
                }
                shenyuTrieNode.getPathVariables().put(segment, childNode);
                shenyuTrieNode.setPathVariableNode(childNode);
            }
            return childNode;
        }
        return this.put(segment, shenyuTrieNode);
    }

    private ShenyuTrieNode put(String segment, ShenyuTrieNode shenyuTrieNode) {
        ShenyuTrieNode childrenNode;
        if (Objects.isNull(shenyuTrieNode.getChildren())) {
            shenyuTrieNode.setChildren(new ConcurrentHashMap<String, ShenyuTrieNode>(Constants.TRIE_CHILDREN_SIZE));
        }
        if (ShenyuTrie.containsKey(shenyuTrieNode.getChildren(), segment)) {
            childrenNode = ShenyuTrie.getVal(shenyuTrieNode.getChildren(), segment);
        } else {
            childrenNode = new ShenyuTrieNode();
            childrenNode.setMatchStr(segment);
            childrenNode.setParentNode(shenyuTrieNode);
            shenyuTrieNode.getChildren().put(segment, childrenNode);
        }
        return childrenNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectorData(ShenyuTrieNode currentNode, String[] pathParts, SelectorData selectorData, List<?> collection) {
        List selectorDataList = ListUtil.castList(collection, SelectorData.class::cast);
        String string = selectorData.getId();
        synchronized (string) {
            selectorDataList.removeIf(selector -> selector.getId().equals(selectorData.getId()));
        }
        currentNode.getPathCache().put(selectorData.getPluginName(), selectorDataList);
        if (CollectionUtils.isEmpty((Collection)selectorDataList) && Objects.isNull(currentNode.getChildren()) && Objects.isNull(currentNode.getPathVariables())) {
            this.removeData(pathParts, selectorData.getPluginName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRuleData(ShenyuTrieNode currentNode, String[] pathParts, RuleData ruleData, List<?> collection) {
        List ruleDataList = ListUtil.castList(collection, RuleData.class::cast);
        String string = ruleData.getId();
        synchronized (string) {
            ruleDataList.removeIf(rule -> ruleData.getId().equals(rule.getId()));
        }
        currentNode.getPathCache().put(ruleData.getSelectorId(), ruleDataList);
        if (CollectionUtils.isEmpty((Collection)ruleDataList) && Objects.isNull(currentNode.getChildren()) && Objects.isNull(currentNode.getPathVariables())) {
            this.removeData(pathParts, ruleData.getSelectorId());
        }
    }

    private void removeData(String[] pathParts, String source) {
        String key = pathParts[pathParts.length - 1];
        Object[] parentPathArray = Arrays.copyOfRange(pathParts, 0, pathParts.length - 1);
        if (ArrayUtils.isEmpty((Object[])parentPathArray)) {
            return;
        }
        String parentPath = String.join((CharSequence)"/", (CharSequence[])parentPathArray);
        ShenyuTrieNode parentNode = this.getNode(parentPath, source);
        if (Objects.isNull(parentNode)) {
            return;
        }
        Optional.ofNullable(parentNode.getChildren()).ifPresent(cache -> cache.remove(key));
    }

    private boolean hasWildcardNode(Map<String, ShenyuTrieNode> children, String key) {
        if (Objects.isNull(children)) {
            return false;
        }
        return children.values().stream().anyMatch(child -> ShenyuTrie.isMatchWildcardPattern(key, child.getMatchStr()));
    }

    private static ShenyuTrieNode findMatchWildcard(Map<String, ShenyuTrieNode> children, String pathPart) {
        if (Objects.isNull(children)) {
            return null;
        }
        return children.values().stream().filter(child -> child.getWildcard() && ShenyuTrie.isMatchWildcardPattern(pathPart, child.getMatchStr())).findFirst().orElse(null);
    }

    private static boolean isMatchWildcardPattern(String segment, String pattern) {
        int pRight;
        int sRight = segment.length();
        for (pRight = pattern.length(); sRight > 0 && pRight > 0 && pattern.charAt(pRight - 1) != '*'; --sRight, --pRight) {
            if (segment.charAt(sRight - 1) == pattern.charAt(pRight - 1)) {
                continue;
            }
            return false;
        }
        if (pRight == 0) {
            return sRight == 0;
        }
        int sIndex = 0;
        int pIndex = 0;
        int sRecord = -1;
        int pRecord = -1;
        while (sIndex < sRight && pIndex < pRight) {
            if (pattern.charAt(pIndex) == '*') {
                sRecord = sIndex;
                pRecord = ++pIndex;
                continue;
            }
            if (segment.charAt(sIndex) == pattern.charAt(pIndex)) {
                ++sIndex;
                ++pIndex;
                continue;
            }
            if (sRecord != -1 && sRecord + 1 < sRight) {
                sIndex = ++sRecord;
                pIndex = pRecord;
                continue;
            }
            return false;
        }
        return ShenyuTrie.allStars(pattern, pIndex, pRight);
    }

    private static boolean allStars(String str, int left, int right) {
        for (int i = left; i < right; ++i) {
            if (str.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    private boolean checkNode(ShenyuTrieNode currentNode, String bizInfo) {
        return Objects.nonNull(currentNode) && currentNode.getEndOfPath() && bizInfo.equals(currentNode.getBizInfo()) && Objects.nonNull(currentNode.getPathCache()) && CollectionUtils.isNotEmpty((Collection)currentNode.getPathCache().get(bizInfo));
    }

    private Object getBizInfo(ShenyuTrieNode trieNode) {
        return trieNode.getBizInfo();
    }

    private static boolean isMatchAll(String key) {
        return MATCH_ALL.equals(key);
    }

    private static boolean isMatchWildcard(String key) {
        return !ShenyuTrie.isPathVariable(key) && !ShenyuTrie.isMatchAll(key) && Objects.nonNull(key) && key.contains(WILDCARD);
    }

    private static boolean isPathVariable(String key) {
        return Objects.nonNull(key) && key.startsWith("{") && key.endsWith("}");
    }

    private static <V> boolean containsKey(Map<String, V> cache, String key) {
        return Objects.nonNull(cache) && cache.containsKey(key);
    }

    private static <V> V getVal(Map<String, V> cache, String key) {
        return Objects.nonNull(cache) ? (V)cache.get(key) : null;
    }

    private static <V> void cleanup(Map<String, V> cache) {
        if (Objects.nonNull(cache)) {
            cache.clear();
        }
    }
}

