/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.NacosProperties;
import org.apache.shenyu.admin.listener.DataChangedInit;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.nacos.NacosDataChangedInit;
import org.apache.shenyu.admin.listener.nacos.NacosDataChangedListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="shenyu.sync.nacos", name={"url"})
@EnableConfigurationProperties(value={NacosProperties.class})
public class NacosSyncConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConfigService.class})
    public ConfigService nacosConfigService(NacosProperties nacosProp) throws Exception {
        Properties properties = new Properties();
        if (Objects.nonNull(nacosProp.getAcm()) && nacosProp.getAcm().isEnabled()) {
            properties.put("endpoint", nacosProp.getAcm().getEndpoint());
            properties.put("namespace", nacosProp.getAcm().getNamespace());
            properties.put("accessKey", nacosProp.getAcm().getAccessKey());
            properties.put("secretKey", nacosProp.getAcm().getSecretKey());
        } else {
            properties.put("serverAddr", nacosProp.getUrl());
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getNamespace())) {
                properties.put("namespace", nacosProp.getNamespace());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getUsername())) {
                properties.put("username", nacosProp.getUsername());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getPassword())) {
                properties.put("password", nacosProp.getPassword());
            }
            if (StringUtils.isNotBlank((CharSequence)nacosProp.getContextPath())) {
                properties.put("contextPath", nacosProp.getContextPath());
            }
        }
        return NacosFactory.createConfigService((Properties)properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={NacosDataChangedListener.class})
    public DataChangedListener nacosDataChangedListener(ConfigService configService) {
        return new NacosDataChangedListener(configService);
    }

    @Bean
    @ConditionalOnMissingBean(value={NacosDataChangedInit.class})
    public DataChangedInit nacosDataChangedInit(ConfigService configService) {
        return new NacosDataChangedInit(configService);
    }
}

