/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractNodeDataChangedListener
implements DataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeDataChangedListener.class);
    private final ChangeData changeData;
    private final Map<String, ReentrantLock> listSaveLockMap = new ConcurrentHashMap<String, ReentrantLock>();

    protected AbstractNodeDataChangedListener(ChangeData changeData) {
        this.changeData = changeData;
    }

    @Override
    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        String configKeyPrefix = namespaceId + "." + this.changeData.getAuthDataId() + ".";
        this.onCommonChanged(configKeyPrefix, changed, eventType, AppAuthData::getAppKey, AppAuthData.class);
        LOG.debug("[DataChangedListener] AppAuthChanged {}", (Object)configKeyPrefix);
    }

    @Override
    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        String configKeyPrefix = namespaceId + "." + this.changeData.getPluginDataId() + ".";
        this.onCommonChanged(configKeyPrefix, changed, eventType, PluginData::getName, PluginData.class);
        LOG.debug("[DataChangedListener] PluginChanged {}", (Object)configKeyPrefix);
    }

    @Override
    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        String configKeyPrefix = namespaceId + "." + this.changeData.getMetaDataId() + ".";
        this.onCommonChanged(configKeyPrefix, changed, eventType, MetaData::getId, MetaData.class);
        LOG.debug("[DataChangedListener] MetaDataChanged {}", (Object)this.changeData.getMetaDataId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void onCommonChanged(String configKeyPrefix, List<T> changedList, DataEventTypeEnum eventType, Function<? super T, ? extends String> mapperToKey, Class<T> tClass) {
        ReentrantLock reentrantLock = this.listSaveLockMap.computeIfAbsent(configKeyPrefix, key -> new ReentrantLock());
        try {
            reentrantLock.lock();
            List<String> changeNames = changedList.stream().map(mapperToKey).collect(Collectors.toList());
            switch (eventType) {
                case DELETE: {
                    changedList.stream().map(mapperToKey).forEach(removeKey -> this.delConfig(configKeyPrefix + removeKey));
                    this.delChangedData(configKeyPrefix, changeNames);
                    return;
                }
                case REFRESH: 
                case MYSELF: {
                    List<String> configDataNames = this.getConfigDataNames(configKeyPrefix);
                    changedList.forEach(changedData -> this.publishConfig(configKeyPrefix + (String)mapperToKey.apply(changedData), changedData));
                    if (Objects.nonNull(configDataNames) && configDataNames.size() > changedList.size()) {
                        configDataNames.removeAll(changeNames);
                        configDataNames.forEach(this::delConfig);
                    }
                    this.publishConfig(configKeyPrefix + "list", changeNames);
                    return;
                }
                default: {
                    changedList.forEach(changedData -> this.publishConfig(configKeyPrefix + (String)mapperToKey.apply(changedData), changedData));
                    this.putChangeData(configKeyPrefix, changeNames);
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.error("AbstractNodeDataChangedListener onCommonMultiChanged error ", (Throwable)e);
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void putChangeData(String configKeyPrefix, List<String> changeNames) {
        String oldNodeListStr = Optional.ofNullable(this.getConfig(configKeyPrefix + "list")).orElse("[]");
        List oldNodeList = GsonUtils.getInstance().fromList(oldNodeListStr, String.class);
        oldNodeList.addAll(changeNames.stream().filter(changeName -> !oldNodeList.contains(changeName)).collect(Collectors.toList()));
        this.publishConfig(configKeyPrefix + "list", oldNodeList);
    }

    private void delChangedData(String configKeyPrefix, List<String> changeNames) {
        String oldNodeListStr = Optional.ofNullable(this.getConfig(configKeyPrefix + "list")).orElse("[]");
        List oldNodeList = GsonUtils.getInstance().fromList(oldNodeListStr, String.class);
        oldNodeList.removeAll(changeNames);
        this.publishConfig(configKeyPrefix + "list", oldNodeList);
    }

    @Override
    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        SelectorData selectorData = (SelectorData)changed.stream().findFirst().orElseThrow(() -> new ShenyuException("selectorData is null"));
        String configKeyPrefix = selectorData.getNamespaceId() + "." + this.changeData.getSelectorDataId() + ".";
        this.onCommonMultiChanged(changed, eventType, configKeyPrefix, SelectorData::getPluginName, SelectorData::getId);
        LOG.debug("[DataChangedListener] SelectorChanged {}", (Object)configKeyPrefix);
    }

    @Override
    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        String configKeyPrefix = namespaceId + "." + this.changeData.getRuleDataId() + ".";
        this.onCommonMultiChanged(changed, eventType, configKeyPrefix, ruleData -> String.join((CharSequence)".", ruleData.getPluginName(), ruleData.getSelectorId()), RuleData::getId);
        LOG.debug("[DataChangedListener] RuleChanged {}", (Object)this.changeData.getRuleDataId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void onCommonMultiChanged(List<T> changedList, DataEventTypeEnum eventType, String configKeyPrefix, Function<? super T, ? extends String> mappingKey, Function<? super T, ? extends String> mappingValue) {
        ReentrantLock reentrantLock = this.listSaveLockMap.computeIfAbsent(configKeyPrefix, key -> new ReentrantLock());
        try {
            reentrantLock.lock();
            Map<String, List<String>> nameToIdMap = changedList.stream().collect(Collectors.groupingBy(mappingKey, Collectors.mapping(mappingValue, Collectors.toList())));
            switch (eventType) {
                case DELETE: {
                    changedList.forEach(changedData -> this.delConfig(configKeyPrefix + (String)mappingKey.apply(changedData) + "." + (String)mappingValue.apply(changedData)));
                    this.delChangedMapToList(nameToIdMap, configKeyPrefix);
                    return;
                }
                default: {
                    changedList.forEach(changedData -> this.publishConfig(configKeyPrefix + (String)mappingKey.apply(changedData) + "." + (String)mappingValue.apply(changedData), changedData));
                    this.putChangedMapToList(nameToIdMap, configKeyPrefix);
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.error("AbstractNodeDataChangedListener onCommonMultiChanged error ", (Throwable)e);
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void putChangedMapToList(Map<String, List<String>> stringListMap, String configKeyPrefix) {
        stringListMap.forEach((key, listIds) -> {
            String oldNodeListStr = Optional.ofNullable(this.getConfig(configKeyPrefix + key + ".list")).orElse("[]");
            List oldNodeList = GsonUtils.getInstance().fromList(oldNodeListStr, String.class);
            oldNodeList.addAll(listIds.stream().filter(selectorId -> !oldNodeList.contains(selectorId)).collect(Collectors.toList()));
            if (ObjectUtils.isEmpty((Object)oldNodeList)) {
                this.delConfig(configKeyPrefix + key + ".list");
            } else {
                this.publishConfig(configKeyPrefix + key + ".list", oldNodeList);
            }
        });
    }

    private void delChangedMapToList(Map<String, List<String>> stringListMap, String configKeyPrefix) {
        stringListMap.forEach((key, listIds) -> {
            String oldNodeListStr = Optional.ofNullable(this.getConfig(configKeyPrefix + key + ".list")).orElse("[]");
            List oldNodeList = GsonUtils.getInstance().fromList(oldNodeListStr, String.class);
            oldNodeList.removeAll((Collection<?>)listIds);
            if (ObjectUtils.isEmpty((Object)oldNodeList)) {
                this.delConfig(configKeyPrefix + key + ".list");
            } else {
                this.publishConfig(configKeyPrefix + key + ".list", oldNodeList);
            }
        });
    }

    @Override
    public void onProxySelectorChanged(List<ProxySelectorData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        String configKeyPrefix = namespaceId + "." + this.changeData.getProxySelectorDataId() + ".";
        this.onCommonMultiChanged(changed, eventType, configKeyPrefix, ProxySelectorData::getPluginName, ProxySelectorData::getId);
        LOG.debug("[DataChangedListener] ProxySelectorChanged {}", (Object)this.changeData.getProxySelectorDataId());
    }

    @Override
    public void onDiscoveryUpstreamChanged(List<DiscoverySyncData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        String namespaceId = changed.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
        String configKeyPrefix = namespaceId + "." + this.changeData.getDiscoveryDataId() + ".";
        this.onCommonMultiChanged(changed, eventType, configKeyPrefix, DiscoverySyncData::getPluginName, DiscoverySyncData::getSelectorId);
        LOG.debug("[DataChangedListener] DiscoveryUpstreamChanged {}", (Object)this.changeData.getDiscoveryDataId());
    }

    private void publishConfig(String dataId, Object data) {
        LOG.debug("[DataChangedListener] publishConfig {}", (Object)dataId);
        this.doPublishConfig(dataId, data);
    }

    public abstract void doPublishConfig(String var1, Object var2);

    private void delConfig(String dataId) {
        LOG.debug("[DataChangedListener] delConfig {}", (Object)dataId);
        this.doDelConfig(dataId);
    }

    protected abstract void doDelConfig(String var1);

    public abstract String getConfig(String var1);

    private <T> List<String> getConfigDataNames(String configKeyPrefix) {
        return GsonUtils.getInstance().fromList(this.getConfig(configKeyPrefix + "list"), String.class);
    }

    public static class ChangeData {
        private final String pluginDataId;
        private final String selectorDataId;
        private final String ruleDataId;
        private final String authDataId;
        private final String metaDataId;
        private final String proxySelectorDataId;
        private final String discoveryDataId;

        public ChangeData(String pluginDataId, String selectorDataId, String ruleDataId, String authDataId, String metaDataId, String proxySelectorDataId, String discoveryDataId) {
            this.pluginDataId = pluginDataId;
            this.selectorDataId = selectorDataId;
            this.ruleDataId = ruleDataId;
            this.authDataId = authDataId;
            this.metaDataId = metaDataId;
            this.proxySelectorDataId = proxySelectorDataId;
            this.discoveryDataId = discoveryDataId;
        }

        public String getPluginDataId() {
            return this.pluginDataId;
        }

        public String getSelectorDataId() {
            return this.selectorDataId;
        }

        public String getRuleDataId() {
            return this.ruleDataId;
        }

        public String getAuthDataId() {
            return this.authDataId;
        }

        public String getMetaDataId() {
            return this.metaDataId;
        }

        public String getProxySelectorDataId() {
            return this.proxySelectorDataId;
        }

        public String getDiscoveryDataId() {
            return this.discoveryDataId;
        }
    }
}

