/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.dto.DiscoveryDTO;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestApi(value={"/discovery"})
public class DiscoveryController {
    private final DiscoveryService discoveryService;

    public DiscoveryController(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @GetMapping(value={"/typeEnums"})
    public ShenyuAdminResult typeEnums() {
        return ShenyuAdminResult.success("success", this.discoveryService.typeEnums());
    }

    @GetMapping(value={""})
    public ShenyuAdminResult discovery(String pluginName, String level, String namespaceId) {
        return ShenyuAdminResult.success("success", this.discoveryService.discovery(pluginName, level, namespaceId));
    }

    @PostMapping(value={"/insertOrUpdate"})
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody DiscoveryDTO discoveryDTO) {
        return ShenyuAdminResult.success("success", this.discoveryService.createOrUpdate(discoveryDTO));
    }

    @DeleteMapping(value={"/{discoveryId}"})
    public ShenyuAdminResult delete(@PathVariable(value="discoveryId") String discoveryId) {
        return ShenyuAdminResult.success("success", this.discoveryService.delete(discoveryId));
    }
}

