/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static List<URI> findResourcesBySuffix(String resourceLocation, String fileNameSuffix) throws IOException, URISyntaxException {
        return ResourceUtil.findResources(resourceLocation, path -> path.toString().endsWith(fileNameSuffix));
    }

    public static List<URI> findResources(String resourceLocation) throws IOException, URISyntaxException {
        return ResourceUtil.findResources(resourceLocation, p -> true);
    }

    public static List<URI> findResources(String resourceLocation, Predicate<Path> filter) throws IOException, URISyntaxException {
        ArrayList<URI> result = new ArrayList<URI>();
        Enumeration<URL> dirURLs = JvmUtils.findClassLoader().getResources(resourceLocation);
        while (dirURLs.hasMoreElements()) {
            URL dirURL = dirURLs.nextElement();
            if (dirURL.getProtocol().equals("file")) {
                Path dirPath = Paths.get(dirURL.toURI());
                ResourceUtil.collectResourcesFromPath(dirPath, filter, result);
                continue;
            }
            FileSystem fileSystem = FileSystems.newFileSystem(dirURL.toURI(), Collections.emptyMap());
            Throwable throwable = null;
            try {
                Path dirPath = fileSystem.getPath(resourceLocation, new String[0]);
                ResourceUtil.collectResourcesFromPath(dirPath, filter, result);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileSystem == null) continue;
                if (throwable != null) {
                    try {
                        fileSystem.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileSystem.close();
            }
        }
        return result;
    }

    private static void collectResourcesFromPath(Path path, Predicate<Path> filter, Collection<URI> resources) throws IOException {
        try (Stream<Path> dirContentTraversalStream = Files.walk(path, new FileVisitOption[0]);){
            dirContentTraversalStream.filter(filter).map(Path::toUri).forEach(resources::add);
        }
    }
}

