/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.heartbeat;

import java.io.Serializable;
import java.util.Objects;
import org.apache.rocketmq.common.UtilAll;

public class BrokerIdentityInfo
implements Serializable {
    private static final long serialVersionUID = 883597359635995567L;
    private final String clusterName;
    private final String brokerName;
    private final Long brokerId;

    public BrokerIdentityInfo(String clusterName, String brokerName, Long brokerId) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.brokerId = brokerId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Long getBrokerId() {
        return this.brokerId;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public boolean isEmpty() {
        return UtilAll.isBlank((String)this.clusterName) && UtilAll.isBlank((String)this.brokerName) && this.brokerId == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BrokerIdentityInfo) {
            BrokerIdentityInfo addr = (BrokerIdentityInfo)obj;
            return this.clusterName.equals(addr.clusterName) && this.brokerName.equals(addr.brokerName) && this.brokerId.equals(addr.brokerId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.brokerName, this.brokerId);
    }

    public String toString() {
        return "BrokerIdentityInfo{clusterName='" + this.clusterName + '\'' + ", brokerName='" + this.brokerName + '\'' + ", brokerId=" + this.brokerId + '}';
    }
}

