/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ExternalServiceException;
import org.apache.qpid.server.util.ExternalServiceTimeoutException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlingFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlingFilter.class);
    private Thread.UncaughtExceptionHandler _uncaughtExceptionHandler;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String requestURI = ((HttpServletRequest)servletRequest).getRequestURI();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Error | ServerScopedRuntimeException e) {
            try {
                if (e instanceof ServerScopedRuntimeException && servletResponse instanceof HttpServletResponse && !servletResponse.isCommitted()) {
                    ((HttpServletResponse)servletResponse).sendError(500);
                }
            }
            finally {
                if (this._uncaughtExceptionHandler == null) {
                    LOGGER.error("Fatal system error", e);
                } else {
                    this._uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
                }
            }
            throw e;
        }
        catch (ExternalServiceTimeoutException e) {
            LOGGER.warn("External request timeout ", (Throwable)e);
            this.sendError((RuntimeException)((Object)e), servletResponse, 504);
        }
        catch (ExternalServiceException e) {
            LOGGER.warn("External request failed ", (Throwable)e);
            this.sendError((RuntimeException)((Object)e), servletResponse, 502);
        }
        catch (ServletException | IOException e) {
            LOGGER.debug("Exception in servlet '{}': ", (Object)requestURI, (Object)e);
            throw e;
        }
        catch (ConnectionScopedRuntimeException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exception in servlet '{}':", (Object)requestURI, (Object)e);
            } else {
                LOGGER.info("Exception in servlet '{}' : {}", (Object)requestURI, (Object)e.getMessage());
            }
            throw e;
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected exception in servlet '{}': ", (Object)requestURI, (Object)e);
            throw e;
        }
    }

    public void destroy() {
    }

    private void sendError(RuntimeException underlyingException, ServletResponse servletResponse, int responseCode) throws IOException {
        if (!(servletResponse instanceof HttpServletResponse) || servletResponse.isCommitted()) {
            throw underlyingException;
        }
        ((HttpServletResponse)servletResponse).sendError(responseCode);
    }
}

