/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class StringUtil {
    private static final String NUMBERS = "0123456789";
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxwy";
    private static final String OTHERS = "_-";
    private static final char[] CHARACTERS = ("0123456789abcdefghijklmnopqrstuvwxwy" + "abcdefghijklmnopqrstuvwxwy".toUpperCase() + "_-").toCharArray();
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private static final Map<CharSequence, CharSequence> HTML_ESCAPE = Map.of("\"", "&quot;", "&", "&amp;", "<", "&lt;", ">", "&gt;", "'", "&#x27;");
    private static final BitSet HTML_ESCAPE_PREFIX_SET = new BitSet();
    private static final int LONGEST_HTML_ESCAPE_ENTRY = HTML_ESCAPE.values().stream().max(Comparator.comparingInt(CharSequence::length)).get().length();
    private static final Random RANDOM = new SecureRandom();

    public static String elideDataUrl(String path) {
        return String.valueOf(path).toLowerCase().startsWith("data:") ? "data:..." : path;
    }

    public static String toHex(byte[] bin) {
        StringBuilder result = new StringBuilder(2 * bin.length);
        for (byte b : bin) {
            result.append(HEX[b >> 4 & 0xF]);
            result.append(HEX[b & 0xF]);
        }
        return result.toString();
    }

    public String randomAlphaNumericString(int maxLength) {
        char[] result = new char[maxLength];
        for (int i = 0; i < maxLength; ++i) {
            result[i] = CHARACTERS[RANDOM.nextInt(CHARACTERS.length)];
        }
        return new String(result);
    }

    public String createUniqueJavaName(String managerName) {
        StringBuilder builder = new StringBuilder();
        boolean initialChar = true;
        for (int i = 0; i < managerName.length(); ++i) {
            char c = managerName.charAt(i);
            if ((!initialChar || !Character.isJavaIdentifierStart(c)) && (initialChar || !Character.isJavaIdentifierPart(c))) continue;
            builder.append(c);
            initialChar = false;
        }
        if (builder.length() > 0) {
            builder.append("_");
        }
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(managerName.getBytes(StandardCharsets.UTF_8));
            builder.append(StringUtil.toHex(digest).toLowerCase());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerScopedRuntimeException(e);
        }
        return builder.toString();
    }

    public static String escapeHtml4(String input) {
        if (input == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(input.length() * 2);
            StringUtil.translate(input, writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException(e);
        }
    }

    private static void translate(CharSequence input, Writer writer) throws IOException {
        int pos = 0;
        int len = input.length();
        while (pos < len) {
            int consumed = StringUtil.translate(input, pos, writer);
            if (consumed == 0) {
                char c2;
                char c1 = input.charAt(pos);
                writer.write(c1);
                if (!Character.isHighSurrogate(c1) || ++pos >= len || !Character.isLowSurrogate(c2 = input.charAt(pos))) continue;
                writer.write(c2);
                ++pos;
                continue;
            }
            for (int pt = 0; pt < consumed; ++pt) {
                pos += Character.charCount(Character.codePointAt(input, pos));
            }
        }
    }

    private static int translate(CharSequence input, int index, Writer writer) throws IOException {
        if (HTML_ESCAPE_PREFIX_SET.get(input.charAt(index))) {
            int max = LONGEST_HTML_ESCAPE_ENTRY;
            if (index + LONGEST_HTML_ESCAPE_ENTRY > input.length()) {
                max = input.length() - index;
            }
            for (int i = max; i >= 1; --i) {
                CharSequence subSeq = input.subSequence(index, index + i);
                String result = (String)HTML_ESCAPE.get(subSeq.toString());
                if (result == null) continue;
                writer.write(result);
                return Character.codePointCount(subSeq, 0, subSeq.length());
            }
        }
        return 0;
    }

    static {
        HTML_ESCAPE.keySet().forEach(key -> HTML_ESCAPE_PREFIX_SET.set(key.charAt(0)));
    }
}

