/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.TransactionObserver;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransaction
implements ServerTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTransaction.class);
    private final List<ServerTransaction.Action> _postTransactionActions = new ArrayList<ServerTransaction.Action>();
    private final TransactionObserver _transactionObserver;
    private volatile Transaction _transaction;
    private final ActivityTimeAccessor _activityTime;
    private final MessageStore _transactionLog;
    private volatile long _txnStartTime = 0L;
    private volatile long _txnUpdateTime = 0L;
    private ListenableFuture<Runnable> _asyncTran;
    private volatile boolean _outstandingWork;
    private final LocalTransactionState _finalState;
    private final Set<LocalTransactionListener> _localTransactionListeners = new CopyOnWriteArraySet<LocalTransactionListener>();
    private final AtomicReference<LocalTransactionState> _state = new AtomicReference<LocalTransactionState>(LocalTransactionState.ACTIVE);

    public LocalTransaction(MessageStore transactionLog) {
        this(transactionLog, TransactionObserver.NOOP_TRANSACTION_OBSERVER);
    }

    public LocalTransaction(MessageStore transactionLog, TransactionObserver transactionObserver) {
        this(transactionLog, null, transactionObserver, false);
    }

    public LocalTransaction(MessageStore transactionLog, ActivityTimeAccessor activityTime, TransactionObserver transactionObserver, boolean resetable) {
        this._transactionLog = transactionLog;
        this._activityTime = activityTime == null ? () -> System.currentTimeMillis() : activityTime;
        this._transactionObserver = transactionObserver == null ? TransactionObserver.NOOP_TRANSACTION_OBSERVER : transactionObserver;
        this._finalState = resetable ? LocalTransactionState.ACTIVE : LocalTransactionState.DISCHARGED;
    }

    @Override
    public long getTransactionStartTime() {
        return this._txnStartTime;
    }

    @Override
    public long getTransactionUpdateTime() {
        return this._txnUpdateTime;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._postTransactionActions.add(postTransactionAction);
    }

    @Override
    public void dequeue(MessageEnqueueRecord record, ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._outstandingWork = true;
        this._postTransactionActions.add(postTransactionAction);
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        if (record != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Dequeue of message number " + record.getMessageNumber() + " from transaction log. Queue : " + record.getQueueId());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(record);
            }
            catch (RuntimeException e) {
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void dequeue(Collection<MessageInstance> queueEntries, ServerTransaction.Action postTransactionAction) {
        this.sync();
        this._outstandingWork = true;
        this._postTransactionActions.add(postTransactionAction);
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        try {
            for (MessageInstance entry : queueEntries) {
                MessageEnqueueRecord record = entry.getEnqueueRecord();
                if (record == null) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Dequeue of message number " + record.getMessageNumber() + " from transaction log. Queue : " + record.getQueueId());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(record);
            }
        }
        catch (RuntimeException e) {
            this.tidyUpOnError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidyUpOnError(RuntimeException e) {
        try {
            this.doRollbackActions();
        }
        finally {
            try {
                if (this._transaction != null) {
                    this._transaction.abortTran();
                }
            }
            finally {
                this.resetDetails();
            }
        }
        throw e;
    }

    private void beginTranIfNecessary() {
        if (this._transaction == null) {
            this._transaction = this._transactionLog.newTransaction();
        }
    }

    @Override
    public void enqueue(TransactionLogResource queue, EnqueueableMessage message, ServerTransaction.EnqueueAction postTransactionAction) {
        this.sync();
        this._outstandingWork = true;
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        this._transactionObserver.onMessageEnqueue(this, message);
        if (queue.getMessageDurability().persist(message.isPersistent())) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + queue.getName());
                }
                this.beginTranIfNecessary();
                final MessageEnqueueRecord record = this._transaction.enqueueMessage(queue, message);
                if (postTransactionAction != null) {
                    final ServerTransaction.EnqueueAction underlying = postTransactionAction;
                    this._postTransactionActions.add(new ServerTransaction.Action(){

                        @Override
                        public void postCommit() {
                            underlying.postCommit(record);
                        }

                        @Override
                        public void onRollback() {
                            underlying.onRollback();
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                if (postTransactionAction != null) {
                    final ServerTransaction.EnqueueAction underlying = postTransactionAction;
                    this._postTransactionActions.add(new ServerTransaction.Action(){

                        @Override
                        public void postCommit() {
                        }

                        @Override
                        public void onRollback() {
                            underlying.onRollback();
                        }
                    });
                }
                this.tidyUpOnError(e);
            }
        } else if (postTransactionAction != null) {
            final ServerTransaction.EnqueueAction underlying = postTransactionAction;
            this._postTransactionActions.add(new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    underlying.postCommit(new MessageEnqueueRecord[]{null});
                }

                @Override
                public void onRollback() {
                    underlying.onRollback();
                }
            });
        }
    }

    @Override
    public void enqueue(Collection<? extends BaseQueue> queues, EnqueueableMessage message, ServerTransaction.EnqueueAction postTransactionAction) {
        this.sync();
        this._outstandingWork = true;
        this.initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime();
        this._transactionObserver.onMessageEnqueue(this, message);
        try {
            final MessageEnqueueRecord[] records = new MessageEnqueueRecord[queues.size()];
            int i = 0;
            for (BaseQueue baseQueue : queues) {
                if (baseQueue.getMessageDurability().persist(message.isPersistent())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + baseQueue.getName());
                    }
                    this.beginTranIfNecessary();
                    records[i] = this._transaction.enqueueMessage(baseQueue, message);
                }
                ++i;
            }
            if (postTransactionAction != null) {
                final ServerTransaction.EnqueueAction underlying = postTransactionAction;
                this._postTransactionActions.add(new ServerTransaction.Action(){

                    @Override
                    public void postCommit() {
                        underlying.postCommit(records);
                    }

                    @Override
                    public void onRollback() {
                        underlying.onRollback();
                    }
                });
                postTransactionAction = null;
            }
        }
        catch (RuntimeException e) {
            if (postTransactionAction != null) {
                final ServerTransaction.EnqueueAction underlying = postTransactionAction;
                this._postTransactionActions.add(new ServerTransaction.Action(){

                    @Override
                    public void postCommit() {
                    }

                    @Override
                    public void onRollback() {
                        underlying.onRollback();
                    }
                });
            }
            this.tidyUpOnError(e);
        }
    }

    @Override
    public void commit() {
        this.commit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Runnable immediateAction) {
        this.sync();
        if (!this._state.compareAndSet(LocalTransactionState.ACTIVE, LocalTransactionState.DISCHARGING)) {
            LocalTransactionState state = this._state.get();
            String message = state == LocalTransactionState.ROLLBACK_ONLY ? "Transaction has been marked as rollback only" : String.format("Cannot commit transaction in state %s", new Object[]{state});
            throw new IllegalStateException(message);
        }
        try {
            if (this._transaction != null) {
                this._transaction.commitTran();
            }
            if (immediateAction != null) {
                immediateAction.run();
            }
            this.doPostTransactionActions();
        }
        finally {
            this.resetDetails();
        }
    }

    private void doRollbackActions() {
        for (ServerTransaction.Action action : this._postTransactionActions) {
            action.onRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAsync(Runnable deferred) {
        this.sync();
        if (!this._state.compareAndSet(LocalTransactionState.ACTIVE, LocalTransactionState.DISCHARGING)) {
            LocalTransactionState state = this._state.get();
            String message = state == LocalTransactionState.ROLLBACK_ONLY ? "Transaction has been marked as rollback only" : String.format("Cannot commit transaction with state '%s'", new Object[]{state});
            throw new IllegalStateException(message);
        }
        if (this._transaction != null) {
            Runnable action = () -> {
                try {
                    this.doPostTransactionActions();
                    deferred.run();
                }
                finally {
                    this.resetDetails();
                }
            };
            this._asyncTran = this._transaction.commitTranAsync(action);
        } else {
            try {
                this.doPostTransactionActions();
                deferred.run();
            }
            finally {
                this.resetDetails();
            }
        }
    }

    private void doPostTransactionActions() {
        LOGGER.debug("Beginning {} post transaction actions", (Object)this._postTransactionActions.size());
        for (int i = 0; i < this._postTransactionActions.size(); ++i) {
            this._postTransactionActions.get(i).postCommit();
        }
        LOGGER.debug("Completed post transaction actions");
    }

    @Override
    public void rollback() {
        this.sync();
        if (!this._state.compareAndSet(LocalTransactionState.ACTIVE, LocalTransactionState.DISCHARGING) && !this._state.compareAndSet(LocalTransactionState.ROLLBACK_ONLY, LocalTransactionState.DISCHARGING) && this._state.get() != LocalTransactionState.DISCHARGING) {
            throw new IllegalStateException(String.format("Cannot roll back transaction with state '%s'", new Object[]{this._state.get()}));
        }
        try {
            if (this._transaction != null) {
                this._transaction.abortTran();
            }
        }
        finally {
            try {
                this.doRollbackActions();
            }
            finally {
                this.resetDetails();
            }
        }
    }

    public void sync() {
        if (this._asyncTran != null) {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        ((Runnable)this._asyncTran.get()).run();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new ServerScopedRuntimeException(e.getCause());
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this._asyncTran = null;
        }
    }

    private void initTransactionStartTimeIfNecessaryAndAdvanceUpdateTime() {
        long currentTime = this._activityTime.getActivityTime();
        if (this._txnStartTime == 0L) {
            this._txnStartTime = currentTime;
        }
        this._txnUpdateTime = currentTime;
    }

    private void resetDetails() {
        this._outstandingWork = false;
        this._transactionObserver.onDischarge(this);
        this._asyncTran = null;
        this._transaction = null;
        this._postTransactionActions.clear();
        this._txnStartTime = 0L;
        this._txnUpdateTime = 0L;
        this._state.set(this._finalState);
        if (!this._localTransactionListeners.isEmpty()) {
            this._localTransactionListeners.forEach(t -> t.transactionCompleted(this));
            this._localTransactionListeners.clear();
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public boolean setRollbackOnly() {
        return this._state.compareAndSet(LocalTransactionState.ACTIVE, LocalTransactionState.ROLLBACK_ONLY);
    }

    public boolean isRollbackOnly() {
        return this._state.get() == LocalTransactionState.ROLLBACK_ONLY;
    }

    public boolean hasOutstandingWork() {
        return this._outstandingWork;
    }

    public boolean isDischarged() {
        return this._state.get() == LocalTransactionState.DISCHARGED;
    }

    public void addTransactionListener(LocalTransactionListener listener) {
        this._localTransactionListeners.add(listener);
    }

    public void removeTransactionListener(LocalTransactionListener listener) {
        this._localTransactionListeners.remove(listener);
    }

    public static interface ActivityTimeAccessor {
        public long getActivityTime();
    }

    public static interface LocalTransactionListener {
        public void transactionCompleted(LocalTransaction var1);
    }

    static enum LocalTransactionState {
        ACTIVE,
        ROLLBACK_ONLY,
        DISCHARGING,
        DISCHARGED;

    }
}

