/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeadersBinding {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadersBinding.class);
    private final Map<String, Object> _mappings;
    private final AbstractExchange.BindingIdentifier _binding;
    private final Set<String> required = new HashSet<String>();
    private final Map<String, Object> matches = new HashMap<String, Object>();
    private final String _replacementRoutingKey;
    private boolean matchAny;
    private FilterManager _filter;

    public HeadersBinding(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) throws AMQInvalidArgumentException {
        this._binding = binding;
        Map<Object, Object> map = arguments = arguments == null ? Map.of() : arguments;
        if (this._binding != null) {
            this._mappings = arguments;
            this.initMappings();
        } else {
            this._mappings = null;
        }
        Object key = arguments.get("x-replacement-routing-key");
        this._replacementRoutingKey = key == null ? null : String.valueOf(key);
    }

    private void initMappings() throws AMQInvalidArgumentException {
        if (FilterSupport.argumentsContainFilter(this._mappings)) {
            this._filter = FilterSupport.createMessageFilter(this._mappings, this._binding.getDestination());
        }
        for (Map.Entry<String, Object> entry : this._mappings.entrySet()) {
            String propertyName = entry.getKey();
            Object value = entry.getValue();
            if (HeadersBinding.isSpecial(propertyName)) {
                this.processSpecial(propertyName, value);
                continue;
            }
            if (value == null || value.equals("")) {
                this.required.add(propertyName);
                continue;
            }
            this.matches.put(propertyName, value);
        }
    }

    public AbstractExchange.BindingIdentifier getBinding() {
        return this._binding;
    }

    public boolean matches(AMQMessageHeader headers) {
        if (headers == null) {
            return this.required.isEmpty() && this.matches.isEmpty();
        }
        return this.matchAny ? this.or(headers) : this.and(headers);
    }

    public boolean matches(Filterable message) {
        return this.matches(message.getMessageHeader()) && (this._filter == null || this._filter.allAllow(message));
    }

    private boolean and(AMQMessageHeader headers) {
        if (headers.containsHeaders(this.required)) {
            for (Map.Entry<String, Object> e : this.matches.entrySet()) {
                if (e.getValue().equals(headers.getHeader(e.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean or(AMQMessageHeader headers) {
        if (this.required.isEmpty()) {
            return this.matches.isEmpty() || this.passesMatchesOr(headers);
        }
        if (!this.passesRequiredOr(headers)) {
            return !this.matches.isEmpty() && this.passesMatchesOr(headers);
        }
        return true;
    }

    private boolean passesMatchesOr(AMQMessageHeader headers) {
        for (Map.Entry<String, Object> entry : this.matches.entrySet()) {
            if (!headers.containsHeader(entry.getKey()) || (entry.getValue() != null || headers.getHeader(entry.getKey()) != null) && !entry.getValue().equals(headers.getHeader(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    private boolean passesRequiredOr(AMQMessageHeader headers) {
        for (String name : this.required) {
            if (!headers.containsHeader(name)) continue;
            return true;
        }
        return false;
    }

    private void processSpecial(String key, Object value) {
        if ("X-match".equalsIgnoreCase(key)) {
            this.matchAny = this.isAny(value);
        } else {
            LOGGER.warn("Ignoring special header: " + key);
        }
    }

    private boolean isAny(Object value) {
        if (value instanceof String) {
            if ("any".equalsIgnoreCase((String)value)) {
                return true;
            }
            if ("all".equalsIgnoreCase((String)value)) {
                return false;
            }
        }
        LOGGER.warn("Ignoring unrecognised match type: " + value);
        return false;
    }

    static boolean isSpecial(Object key) {
        return key instanceof String && HeadersBinding.isSpecial((String)key);
    }

    static boolean isSpecial(String key) {
        return key.startsWith("X-") || key.startsWith("x-");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersBinding hb = (HeadersBinding)o;
        return !(this._binding == null ? hb.getBinding() != null : !this._binding.equals(hb.getBinding()));
    }

    public int hashCode() {
        return this._binding == null ? 0 : this._binding.hashCode();
    }

    public String getReplacementRoutingKey() {
        return this._replacementRoutingKey;
    }

    private static class ExcludeAllFilter
    implements MessageFilter {
        private ExcludeAllFilter() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public boolean startAtTail() {
            return false;
        }

        @Override
        public boolean matches(Filterable message) {
            return false;
        }

        public String toString() {
            return "ExcludeAllFilter[]";
        }
    }
}

