/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.FilterableMessage;
import org.apache.qpid.server.filter.JMSMessagePropertyExpression;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.SelectorParser;
import org.apache.qpid.server.filter.selector.TokenMgrError;
import org.apache.qpid.server.plugin.PluggableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class JMSSelectorFilter
implements MessageFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMSSelectorFilter.class);
    private final String _selector;
    private final BooleanExpression _matcher;

    public JMSSelectorFilter(String selector) throws ParseException, TokenMgrError, SelectorParsingException {
        this._selector = selector;
        SelectorParser<FilterableMessage> selectorParser = new SelectorParser<FilterableMessage>();
        selectorParser.setPropertyExpressionFactory(JMSMessagePropertyExpression.FACTORY);
        this._matcher = selectorParser.parse(selector);
    }

    @Override
    public String getName() {
        return AMQPFilterTypes.JMS_SELECTOR.toString();
    }

    @Override
    public boolean matches(Filterable message) {
        boolean match = this._matcher.matches(message);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message + " match(" + match + ") selector(" + System.identityHashCode(this._selector) + "):" + this._selector);
        }
        return match;
    }

    @Override
    public boolean startAtTail() {
        return false;
    }

    public String getSelector() {
        return this._selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JMSSelectorFilter that = (JMSSelectorFilter)o;
        return this.getSelector().equals(that.getSelector());
    }

    public int hashCode() {
        return this.getSelector().hashCode();
    }

    public String toString() {
        return "JMSSelectorFilter[selector='" + this._selector + "']";
    }
}

