/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.retriever;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.query.engine.retriever.ConfiguredObjectRetriever;
import org.apache.qpid.server.query.engine.retriever.EntityRetriever;

public class SessionRetriever<C extends ConfiguredObject<?>>
extends ConfiguredObjectRetriever<C>
implements EntityRetriever<C> {
    private final Class<C> _type = Connection.class;
    private final List<String> _fieldNames = new ImmutableList.Builder().add((Object)"connectionId").add((Object)"id").add((Object)"name").add((Object)"description").add((Object)"type").add((Object)"desiredState").add((Object)"state").add((Object)"durable").add((Object)"lifetimePolicy").add((Object)"channelId").add((Object)"lastOpenedTime").add((Object)"producerFlowBlocked").add((Object)"lastUpdatedTime").add((Object)"lastUpdatedBy").add((Object)"createdBy").add((Object)"createdTime").add((Object)"statistics").build();
    private final BiFunction<ConfiguredObject<?>, Session<?>, Map<String, Object>> _sessionMapping = (parent, session) -> {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(this._fieldNames.get(0), parent.getId());
        result.put(this._fieldNames.get(1), session.getId());
        result.put(this._fieldNames.get(2), session.getName());
        result.put(this._fieldNames.get(3), session.getDescription());
        result.put(this._fieldNames.get(4), session.getType());
        result.put(this._fieldNames.get(5), session.getDesiredState());
        result.put(this._fieldNames.get(6), session.getState());
        result.put(this._fieldNames.get(7), session.isDurable());
        result.put(this._fieldNames.get(8), session.getLifetimePolicy());
        result.put(this._fieldNames.get(9), session.getChannelId());
        result.put(this._fieldNames.get(10), session.getLastOpenedTime());
        result.put(this._fieldNames.get(11), session.isProducerFlowBlocked());
        result.put(this._fieldNames.get(12), session.getLastUpdatedTime());
        result.put(this._fieldNames.get(13), session.getLastUpdatedBy());
        result.put(this._fieldNames.get(14), session.getCreatedBy());
        result.put(this._fieldNames.get(15), session.getCreatedTime());
        result.put(this._fieldNames.get(16), session.getStatistics());
        return result;
    };

    @Override
    public Stream<Map<String, ?>> retrieve(C broker) {
        Stream<Connection> stream = this.retrieve(broker, this._type).map(connection -> (Connection)connection);
        return stream.flatMap(connection -> connection.getSessions().stream().map(session -> this._sessionMapping.apply((ConfiguredObject<?>)connection, (Session<?>)session)));
    }

    @Override
    public List<String> getFieldNames() {
        return this._fieldNames;
    }
}

