/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.nio.BufferUnderflowException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.ServerAssembler;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerConnectionDelegate;
import org.apache.qpid.server.protocol.v0_10.ServerDisassembler;
import org.apache.qpid.server.protocol.v0_10.ServerInputHandler;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.Session_0_10;
import org.apache.qpid.server.protocol.v0_10.transport.ConnectionCloseCode;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.AbstractAMQPConnection;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.network.NetworkConnection;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPConnection_0_10Impl
extends AbstractAMQPConnection<AMQPConnection_0_10Impl, ServerConnection>
implements AMQPConnection_0_10<AMQPConnection_0_10Impl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQPConnection_0_10Impl.class);
    private final ServerInputHandler _inputHandler;
    private final ServerConnection _connection;
    private volatile boolean _transportBlockedForWriting;
    private final AtomicBoolean _stateChanged = new AtomicBoolean();
    private final AtomicReference<Action<ProtocolEngine>> _workListener = new AtomicReference();
    private ServerDisassembler _disassembler;
    private final Set<AMQPSession<?, ?>> _sessionsWithWork = Collections.newSetFromMap(new ConcurrentHashMap());

    public AMQPConnection_0_10Impl(Broker<?> broker, ServerNetworkConnection network, AmqpPort<?> port, Transport transport, long id, AggregateTicker aggregateTicker) {
        super(broker, network, port, transport, Protocol.AMQP_0_10, id, aggregateTicker);
        this._connection = new ServerConnection(id, broker, port, transport, this);
        ServerConnectionDelegate connDelegate = new ServerConnectionDelegate(port, transport.isSecure(), network.getSelectedHost());
        this._connection.setConnectionDelegate(connDelegate);
        this._connection.setRemoteAddress(network.getRemoteAddress());
        this._inputHandler = new ServerInputHandler(new ServerAssembler(this._connection));
        this._connection.addFrameSizeObserver(this._inputHandler);
        AccessController.doPrivileged(() -> {
            this._connection.setNetworkConnection((NetworkConnection)this.getNetwork());
            this._disassembler = new ServerDisassembler(this.wrapSender(this.getNetwork().getSender()), 4096);
            this._connection.setSender(this._disassembler);
            this._connection.addFrameSizeObserver(this._disassembler);
            return null;
        }, this.getAccessControllerContext());
    }

    private ByteBufferSender wrapSender(final ByteBufferSender sender) {
        return new ByteBufferSender(){

            public boolean isDirectBufferPreferred() {
                return sender.isDirectBufferPreferred();
            }

            public void send(QpidByteBuffer msg) {
                AMQPConnection_0_10Impl.this.updateLastWriteTime();
                sender.send(msg);
            }

            public void flush() {
                sender.flush();
            }

            public void close() {
                sender.close();
            }
        };
    }

    protected void onReceive(QpidByteBuffer buf) {
        try {
            this._inputHandler.received(buf);
            this._connection.receivedComplete();
        }
        catch (IllegalArgumentException | IllegalStateException | BufferUnderflowException e) {
            LOGGER.warn("Unexpected exception", (Throwable)e);
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }

    public void encryptedTransport() {
    }

    public void writerIdle() {
        this._connection.doHeartBeat();
    }

    public final void readerIdle() {
        AccessController.doPrivileged(() -> {
            this._connection.getEventLogger().message(ConnectionMessages.IDLE_CLOSE((CharSequence)("Current connection state: " + this._connection.getConnectionDelegate().getState()), (boolean)true));
            this.getNetwork().close();
            return null;
        }, this.getAccessControllerContext());
    }

    public String getAddress() {
        return this.getNetwork().getRemoteAddress().toString();
    }

    public final void closed() {
        try {
            AccessController.doPrivileged(() -> {
                this._inputHandler.closed();
                if (this._disassembler != null) {
                    this._disassembler.closed();
                }
                return null;
            }, this.getAccessControllerContext());
        }
        finally {
            this.markTransportClosed();
        }
    }

    public boolean isTransportBlockedForWriting() {
        return this._transportBlockedForWriting;
    }

    public boolean isClosing() {
        return this._connection.isClosing() || this._connection.isConnectionLost();
    }

    @Override
    public int getHeartbeatDelay() {
        return this._connection.getHeartBeatDelay();
    }

    public void setTransportBlockedForWriting(boolean blocked) {
        if (this._transportBlockedForWriting != blocked) {
            this._transportBlockedForWriting = blocked;
            this._connection.transportStateChanged();
        }
    }

    public Iterator<Runnable> processPendingIterator() {
        if (this.isIOThread()) {
            return this._connection.processPendingIterator(this._sessionsWithWork);
        }
        return Collections.emptyIterator();
    }

    public boolean hasWork() {
        return this._stateChanged.get();
    }

    public void notifyWork() {
        this._stateChanged.set(true);
        Action<ProtocolEngine> listener = this._workListener.get();
        if (listener != null) {
            listener.performAction((Object)this);
        }
    }

    public void notifyWork(AMQPSession<?, ?> sessionModel) {
        this._sessionsWithWork.add(sessionModel);
        this.notifyWork();
    }

    public void clearWork() {
        this._stateChanged.set(false);
    }

    public void setWorkListener(Action<ProtocolEngine> listener) {
        this._workListener.set(listener);
    }

    public boolean hasSessionWithName(byte[] name) {
        return this._connection.hasSessionWithName(name);
    }

    public void sendConnectionCloseAsync(AMQPConnection.CloseReason reason, String description) {
        this._connection.setConnectionCloseCause(reason, description);
        this.stopConnection();
        this._connection.sendConnectionCloseAsync(ConnectionCloseCode.CONNECTION_FORCED, description);
    }

    public void closeSessionAsync(AMQPSession<?, ?> session, AMQPConnection.CloseReason reason, String message) {
        ServerSession s = ((Session_0_10)session).getServerSession();
        this._connection.closeSessionAsync(s, reason, message);
    }

    protected void addAsyncTask(Action<? super ServerConnection> action) {
        this._connection.addAsyncTask(action);
    }

    public void block() {
        this._connection.block();
    }

    public String getRemoteContainerName() {
        return this.getClientId();
    }

    public Collection<? extends Session_0_10> getSessionModels() {
        Collection sessions = this.getChildren(Session.class);
        ArrayList session_0_10s = new ArrayList(sessions);
        return session_0_10s;
    }

    public void unblock() {
        this._connection.unblock();
    }

    public int getSessionCountLimit() {
        return this._connection.getSessionCountLimit();
    }

    protected boolean isOrderlyClose() {
        return !this._connection.isConnectionLost();
    }

    protected String getCloseCause() {
        String connectionCloseMessage = this._connection.getConnectionCloseMessage();
        if (connectionCloseMessage == null) {
            return null;
        }
        return this._connection.getConnectionCloseCode() + " - " + connectionCloseMessage;
    }

    @Override
    public void initialiseHeartbeating(long writerDelay, long readerDelay) {
        super.initialiseHeartbeating(writerDelay, readerDelay);
    }

    protected boolean isOpeningInProgress() {
        ServerConnectionDelegate.ConnectionState state = this._connection.getConnectionDelegate().getState();
        switch (state) {
            case INIT: 
            case AWAIT_START_OK: 
            case AWAIT_SECURE_OK: 
            case AWAIT_TUNE_OK: 
            case AWAIT_OPEN: {
                return true;
            }
            case OPEN: {
                return false;
            }
        }
        throw new IllegalStateException("Unsupported state " + state);
    }

    public Iterator<ServerTransaction> getOpenTransactions() {
        return this.getSessionModels().stream().filter(sessionModel -> sessionModel.getServerSession().getTransaction() instanceof LocalTransaction).map(sessionModel -> sessionModel.getServerSession().getTransaction()).iterator();
    }
}

