/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.broker.service.MessageExpirer;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.stats.Rate;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentMessageExpiryMonitor
implements AsyncCallbacks.FindEntryCallback,
MessageExpirer {
    private final ManagedCursor cursor;
    private final String subName;
    private final PersistentTopic topic;
    private final String topicName;
    private final Rate msgExpired;
    private final LongAdder totalMsgExpired;
    private final PersistentSubscription subscription;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private volatile int expirationCheckInProgress = 0;
    private static final AtomicIntegerFieldUpdater<PersistentMessageExpiryMonitor> expirationCheckInProgressUpdater = AtomicIntegerFieldUpdater.newUpdater(PersistentMessageExpiryMonitor.class, "expirationCheckInProgress");
    private static final Logger log = LoggerFactory.getLogger(PersistentMessageExpiryMonitor.class);
    private final AsyncCallbacks.MarkDeleteCallback markDeleteCallback = new AsyncCallbacks.MarkDeleteCallback(){

        public void markDeleteComplete(Object ctx) {
            long numMessagesExpired = (Long)ctx - PersistentMessageExpiryMonitor.this.cursor.getNumberOfEntriesInBacklog(false);
            PersistentMessageExpiryMonitor.this.msgExpired.recordMultipleEvents(numMessagesExpired, 0L);
            PersistentMessageExpiryMonitor.this.totalMsgExpired.add(numMessagesExpired);
            if (PersistentMessageExpiryMonitor.this.subscription != null && PersistentMessageExpiryMonitor.this.subscription.getType() == CommandSubscribe.SubType.Key_Shared) {
                PersistentMessageExpiryMonitor.this.subscription.getDispatcher().markDeletePositionMoveForward();
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Mark deleted {} messages", new Object[]{PersistentMessageExpiryMonitor.this.topicName, PersistentMessageExpiryMonitor.this.subName, numMessagesExpired});
            }
        }

        public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
            log.warn("[{}][{}] Message expiry failed - mark delete failed", new Object[]{PersistentMessageExpiryMonitor.this.topicName, PersistentMessageExpiryMonitor.this.subName, exception});
            PersistentMessageExpiryMonitor.this.updateRates();
        }
    };

    public PersistentMessageExpiryMonitor(PersistentTopic topic, String subscriptionName, ManagedCursor cursor, @Nullable PersistentSubscription subscription) {
        this.topic = topic;
        this.topicName = topic.getName();
        this.cursor = cursor;
        this.subName = subscriptionName;
        this.subscription = subscription;
        this.msgExpired = new Rate();
        this.totalMsgExpired = new LongAdder();
    }

    @VisibleForTesting
    public boolean isAutoSkipNonRecoverableData() {
        return this.cursor.getManagedLedger() != null && this.cursor.getManagedLedger().getConfig().isAutoSkipNonRecoverableData();
    }

    @Override
    public boolean expireMessages(int messageTTLInSeconds) {
        if (expirationCheckInProgressUpdater.compareAndSet(this, 0, 1)) {
            log.info("[{}][{}] Starting message expiry check, ttl= {} seconds", new Object[]{this.topicName, this.subName, messageTTLInSeconds});
            this.checkExpiryByLedgerClosureTime(this.cursor, messageTTLInSeconds);
            this.cursor.asyncFindNewestMatching(ManagedCursor.FindPositionConstraint.SearchActiveEntries, entry -> {
                try {
                    long entryTimestamp = Commands.getEntryTimestamp((ByteBuf)entry.getDataBuffer());
                    boolean bl = MessageImpl.isEntryExpired((int)messageTTLInSeconds, (long)entryTimestamp);
                    return bl;
                }
                catch (Exception e) {
                    log.error("[{}][{}] Error deserializing message for expiry check", new Object[]{this.topicName, this.subName, e});
                }
                finally {
                    entry.release();
                }
                return false;
            }, (AsyncCallbacks.FindEntryCallback)this, null);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Ignore expire-message scheduled task, last check is still running", (Object)this.topicName, (Object)this.subName);
        }
        return false;
    }

    private void checkExpiryByLedgerClosureTime(ManagedCursor cursor, int messageTTLInSeconds) {
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo;
        if (messageTTLInSeconds <= 0) {
            return;
        }
        ManagedLedger managedLedger = cursor.getManagedLedger();
        Position deletedPosition = cursor.getMarkDeletedPosition();
        NavigableMap ledgerInfoSortedMap = managedLedger.getLedgersInfo().subMap(deletedPosition.getLedgerId(), true, (Long)managedLedger.getLedgersInfo().lastKey(), true);
        MLDataFormats.ManagedLedgerInfo.LedgerInfo info = null;
        Iterator iterator = ledgerInfoSortedMap.values().iterator();
        while (iterator.hasNext() && (ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)iterator.next()).hasTimestamp() && ledgerInfo.getTimestamp() != 0L && MessageImpl.isEntryExpired((int)messageTTLInSeconds, (long)ledgerInfo.getTimestamp())) {
            info = ledgerInfo;
        }
        if (info != null && info.getLedgerId() > -1L) {
            Position position = PositionFactory.create((long)info.getLedgerId(), (long)(info.getEntries() - 1L));
            if (managedLedger.getLastConfirmedEntry().compareTo(position) < 0) {
                this.findEntryComplete(managedLedger.getLastConfirmedEntry(), null);
            } else {
                this.findEntryComplete(position, null);
            }
        }
    }

    @Override
    public boolean expireMessages(Position messagePosition) {
        Position topicLastPosition = this.topic.getLastPosition();
        if (topicLastPosition.compareTo(messagePosition) < 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Ignore expire-message scheduled task, given position {} is beyond current topic's last position {}", new Object[]{this.topicName, this.subName, messagePosition, topicLastPosition});
            }
            return false;
        }
        if (expirationCheckInProgressUpdater.compareAndSet(this, 0, 1)) {
            log.info("[{}][{}] Starting message expiry check, position= {} seconds", new Object[]{this.topicName, this.subName, messagePosition});
            this.cursor.asyncFindNewestMatching(ManagedCursor.FindPositionConstraint.SearchActiveEntries, entry -> {
                try {
                    boolean bl = entry.getPosition().compareTo(messagePosition) <= 0;
                    return bl;
                }
                finally {
                    entry.release();
                }
            }, (AsyncCallbacks.FindEntryCallback)this, null);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Ignore expire-message scheduled task, last check is still running", (Object)this.topicName, (Object)this.subName);
        }
        return false;
    }

    private void updateRates() {
        this.msgExpired.calculateRate();
    }

    public double getMessageExpiryRate() {
        this.updateRates();
        return this.msgExpired.getRate();
    }

    public long getTotalMessageExpired() {
        return this.totalMsgExpired.sum();
    }

    public void findEntryComplete(Position position, Object ctx) {
        if (position != null) {
            log.info("[{}][{}] Expiring all messages until position {}", new Object[]{this.topicName, this.subName, position});
            Position prevMarkDeletePos = this.cursor.getMarkDeletedPosition();
            this.cursor.asyncMarkDelete(position, this.cursor.getProperties(), this.markDeleteCallback, (Object)this.cursor.getNumberOfEntriesInBacklog(false));
            if (!Objects.equals(this.cursor.getMarkDeletedPosition(), prevMarkDeletePos) && this.subscription != null) {
                this.subscription.updateLastMarkDeleteAdvancedTimestamp();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] No messages to expire", (Object)this.topicName, (Object)this.subName);
            }
            this.updateRates();
        }
        this.expirationCheckInProgress = 0;
    }

    public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Finding expired entry operation failed", new Object[]{this.topicName, this.subName, exception});
        }
        if (this.isAutoSkipNonRecoverableData() && failedReadPosition.isPresent() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException) {
            log.warn("[{}][{}] read failed from ledger at position:{} : {}", new Object[]{this.topicName, this.subName, failedReadPosition, exception.getMessage()});
            if (exception instanceof ManagedLedgerException.LedgerNotExistException) {
                long failedLedgerId = failedReadPosition.get().getLedgerId();
                ManagedLedger ledger = this.cursor.getManagedLedger();
                Position lastPositionInLedger = ledger.getOptionalLedgerInfo(failedLedgerId).map(ledgerInfo -> PositionFactory.create((long)failedLedgerId, (long)(ledgerInfo.getEntries() - 1L))).orElseGet(() -> {
                    Long nextExistingLedger = ledger.getLedgersInfo().ceilingKey(((Position)failedReadPosition.get()).getLedgerId() + 1L);
                    if (nextExistingLedger == null) {
                        log.info("[{}] [{}] Couldn't find next next valid ledger for expiry monitor when find entry failed {}", new Object[]{ledger.getName(), ledger.getName(), failedReadPosition});
                        return (Position)failedReadPosition.get();
                    }
                    return PositionFactory.create((long)nextExistingLedger, (long)-1L);
                });
                log.info("[{}][{}] ledger not existed, will complete the last position of the non-existed ledger:{}", new Object[]{this.topicName, this.subName, lastPositionInLedger});
                this.findEntryComplete(lastPositionInLedger, ctx);
            } else {
                this.findEntryComplete(failedReadPosition.get(), ctx);
            }
            return;
        }
        this.expirationCheckInProgress = 0;
        this.updateRates();
    }
}

