/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.ConsumerIdentityWrapper;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.apache.pulsar.common.policies.data.stats.DrainingHashImpl;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrainingHashesTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DrainingHashesTracker.class);
    private final String dispatcherName;
    private final UnblockingHandler unblockingHandler;
    private final Int2ObjectOpenHashMap<DrainingHashEntry> drainingHashes = new Int2ObjectOpenHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    int batchLevel;
    boolean unblockedWhileBatching;
    private final Map<ConsumerIdentityWrapper, ConsumerDrainingHashesStats> consumerDrainingHashesStatsMap = new ConcurrentHashMap<ConsumerIdentityWrapper, ConsumerDrainingHashesStats>();

    public DrainingHashesTracker(String dispatcherName, UnblockingHandler unblockingHandler) {
        this.dispatcherName = dispatcherName;
        this.unblockingHandler = unblockingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(Consumer consumer, int stickyHash) {
        DrainingHashEntry entry;
        if (stickyHash == 0) {
            throw new IllegalArgumentException("Sticky hash cannot be 0");
        }
        ConsumerDrainingHashesStats addedStatsForNewEntry = null;
        this.lock.writeLock().lock();
        try {
            entry = (DrainingHashEntry)this.drainingHashes.get(stickyHash);
            if (entry == null) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Adding and incrementing draining hash {} for consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, consumer.consumerId(), consumer.consumerName()});
                }
                entry = new DrainingHashEntry(consumer);
                this.drainingHashes.put(stickyHash, (Object)entry);
                addedStatsForNewEntry = this.consumerDrainingHashesStatsMap.computeIfAbsent(new ConsumerIdentityWrapper(consumer), k -> new ConsumerDrainingHashesStats());
            } else {
                if (entry.getConsumer() != consumer) {
                    throw new IllegalStateException("Consumer " + String.valueOf(entry.getConsumer()) + " is already draining hash " + stickyHash + " in dispatcher " + this.dispatcherName + ". Same hash being used for consumer " + String.valueOf(consumer) + ".");
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Draining hash {} incrementing {} consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, entry.getRefCount() + 1, consumer.consumerId(), consumer.consumerName()});
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        entry.incrementRefCount();
        if (addedStatsForNewEntry != null) {
            addedStatsForNewEntry.addHash(stickyHash);
        }
    }

    public void startBatch() {
        this.lock.writeLock().lock();
        try {
            ++this.batchLevel;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void endBatch() {
        boolean notifyUnblocking = false;
        this.lock.writeLock().lock();
        try {
            if (--this.batchLevel == 0 && this.unblockedWhileBatching) {
                this.unblockedWhileBatching = false;
                notifyUnblocking = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (notifyUnblocking) {
            this.unblockingHandler.stickyKeyHashUnblocked(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceRefCount(Consumer consumer, int stickyHash, boolean closing) {
        if (stickyHash == 0) {
            return;
        }
        DrainingHashEntry entry = this.getEntry(stickyHash);
        if (entry == null) {
            return;
        }
        if (entry.getConsumer() != consumer) {
            throw new IllegalStateException("Consumer " + String.valueOf(entry.getConsumer()) + " is already draining hash " + stickyHash + " in dispatcher " + this.dispatcherName + ". Same hash being used for consumer " + String.valueOf(consumer) + ".");
        }
        if (entry.decrementRefCount()) {
            ConsumerDrainingHashesStats drainingHashesStats;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Draining hash {} removing consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, consumer.consumerId(), consumer.consumerName()});
            }
            boolean notifyUnblocking = false;
            this.lock.writeLock().lock();
            try {
                DrainingHashEntry removed = (DrainingHashEntry)this.drainingHashes.remove(stickyHash);
                if (!closing && removed.isBlocking()) {
                    if (this.batchLevel > 0) {
                        this.unblockedWhileBatching = true;
                    } else {
                        notifyUnblocking = true;
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if ((drainingHashesStats = this.consumerDrainingHashesStatsMap.get(new ConsumerIdentityWrapper(consumer))) != null) {
                drainingHashesStats.clearHash(stickyHash);
            }
            if (notifyUnblocking) {
                this.unblockingHandler.stickyKeyHashUnblocked(stickyHash);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Draining hash {} decrementing {} consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, entry.getRefCount(), consumer.consumerId(), consumer.consumerName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldBlockStickyKeyHash(Consumer consumer, int stickyKeyHash) {
        if (stickyKeyHash == 0) {
            log.warn("[{}] Sticky key hash is not set. Allowing dispatching", (Object)this.dispatcherName);
            return false;
        }
        DrainingHashEntry entry = this.getEntry(stickyKeyHash);
        if (entry == null) {
            return false;
        }
        if (entry.getConsumer() == consumer) {
            log.info("[{}] Hash {} has been reassigned consumer {}. The draining hash entry with refCount={} will be removed.", new Object[]{this.dispatcherName, stickyKeyHash, entry.getConsumer(), entry.getRefCount()});
            this.lock.writeLock().lock();
            try {
                this.drainingHashes.remove(stickyKeyHash, (Object)entry);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return false;
        }
        entry.incrementBlockedCount();
        return true;
    }

    public DrainingHashEntry getEntry(int stickyKeyHash) {
        if (stickyKeyHash == 0) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            DrainingHashEntry drainingHashEntry = (DrainingHashEntry)this.drainingHashes.get(stickyKeyHash);
            return drainingHashEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.drainingHashes.clear();
            this.consumerDrainingHashesStatsMap.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void updateConsumerStats(Consumer consumer, ConsumerStatsImpl consumerStats) {
        consumerStats.drainingHashesCount = 0;
        consumerStats.drainingHashesClearedTotal = 0L;
        consumerStats.drainingHashesUnackedMessages = 0;
        consumerStats.drainingHashes = Collections.emptyList();
        ConsumerDrainingHashesStats consumerDrainingHashesStats = this.consumerDrainingHashesStatsMap.get(new ConsumerIdentityWrapper(consumer));
        if (consumerDrainingHashesStats != null) {
            consumerDrainingHashesStats.updateConsumerStats(consumer, consumerStats);
        }
    }

    public void consumerRemoved(Consumer consumer) {
        this.consumerDrainingHashesStatsMap.remove(new ConsumerIdentityWrapper(consumer));
    }

    public static interface UnblockingHandler {
        public void stickyKeyHashUnblocked(int var1);
    }

    public static class DrainingHashEntry {
        private static final AtomicIntegerFieldUpdater<DrainingHashEntry> REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DrainingHashEntry.class, "refCount");
        private static final AtomicIntegerFieldUpdater<DrainingHashEntry> BLOCKED_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DrainingHashEntry.class, "blockedCount");
        private final Consumer consumer;
        private volatile int refCount;
        private volatile int blockedCount;

        DrainingHashEntry(Consumer consumer) {
            this.consumer = consumer;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        void incrementRefCount() {
            REF_COUNT_UPDATER.incrementAndGet(this);
        }

        boolean decrementRefCount() {
            return REF_COUNT_UPDATER.decrementAndGet(this) == 0;
        }

        void incrementBlockedCount() {
            BLOCKED_COUNT_UPDATER.incrementAndGet(this);
        }

        boolean isBlocking() {
            return this.blockedCount > 0;
        }

        int getRefCount() {
            return this.refCount;
        }

        int getBlockedCount() {
            return this.blockedCount;
        }

        @Generated
        public String toString() {
            return "DrainingHashesTracker.DrainingHashEntry(consumer=" + String.valueOf(this.getConsumer()) + ", refCount=" + this.getRefCount() + ", blockedCount=" + this.getBlockedCount() + ")";
        }
    }

    private class ConsumerDrainingHashesStats {
        private final RoaringBitmap drainingHashes = new RoaringBitmap();
        private long drainingHashesClearedTotal;
        private final ReentrantReadWriteLock statsLock = new ReentrantReadWriteLock();

        private ConsumerDrainingHashesStats() {
        }

        public void addHash(int stickyHash) {
            this.statsLock.writeLock().lock();
            try {
                this.drainingHashes.add(stickyHash);
            }
            finally {
                this.statsLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean clearHash(int hash) {
            this.statsLock.writeLock().lock();
            try {
                this.drainingHashes.remove(hash);
                ++this.drainingHashesClearedTotal;
                boolean empty = this.drainingHashes.isEmpty();
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Cleared hash {} in stats. empty={} totalCleared={} hashes={}", new Object[]{DrainingHashesTracker.this.dispatcherName, hash, empty, this.drainingHashesClearedTotal, this.drainingHashes.getCardinality()});
                }
                if (empty) {
                    this.drainingHashes.trim();
                }
                boolean bl = empty;
                return bl;
            }
            finally {
                this.statsLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateConsumerStats(Consumer consumer, ConsumerStatsImpl consumerStats) {
            this.statsLock.readLock().lock();
            try {
                int drainingHashesUnackedMessages = 0;
                ArrayList<DrainingHashImpl> drainingHashesStats = new ArrayList<DrainingHashImpl>();
                PrimitiveIterator.OfInt hashIterator = this.drainingHashes.stream().iterator();
                while (hashIterator.hasNext()) {
                    int hash = hashIterator.nextInt();
                    DrainingHashEntry entry = DrainingHashesTracker.this.getEntry(hash);
                    if (entry == null) {
                        log.warn("[{}] Draining hash {} not found in the tracker for consumer {}", new Object[]{DrainingHashesTracker.this.dispatcherName, hash, consumer});
                        continue;
                    }
                    int unackedMessages = entry.getRefCount();
                    DrainingHashImpl drainingHash = new DrainingHashImpl();
                    drainingHash.hash = hash;
                    drainingHash.unackMsgs = unackedMessages;
                    drainingHash.blockedAttempts = entry.getBlockedCount();
                    drainingHashesStats.add(drainingHash);
                    drainingHashesUnackedMessages += unackedMessages;
                }
                consumerStats.drainingHashesCount = drainingHashesStats.size();
                consumerStats.drainingHashesClearedTotal = this.drainingHashesClearedTotal;
                consumerStats.drainingHashesUnackedMessages = drainingHashesUnackedMessages;
                consumerStats.drainingHashes = drainingHashesStats;
            }
            finally {
                this.statsLock.readLock().unlock();
            }
        }
    }
}

