/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import lombok.Generated;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.mutable.MutableObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.admin.impl.OffloaderObjectsScannerUtils;
import org.apache.pulsar.broker.loadbalance.LeaderBroker;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.GrantTopicPermissionOptions;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.RevokeTopicPermissionOptions;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicHashPositions;
import org.apache.pulsar.common.policies.data.TopicType;
import org.apache.pulsar.common.policies.data.ValidateResult;
import org.apache.pulsar.common.policies.data.impl.AutoTopicCreationOverrideImpl;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamespacesBase
extends AdminResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NamespacesBase.class);

    protected CompletableFuture<List<String>> internalGetTenantNamespaces(String tenant) {
        if (tenant == null) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Tenant should not be null")));
        }
        try {
            NamedEntity.checkName((String)tenant);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Tenant name is invalid {}", new Object[]{this.clientAppId(), tenant, e});
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name is not valid")));
        }
        return ((CompletableFuture)this.validateTenantOperationAsync(tenant, TenantOperation.LIST_NAMESPACES).thenCompose(__ -> this.tenantResources().tenantExistsAsync(tenant))).thenCompose(existed -> {
            if (!existed.booleanValue()) {
                throw new RestException(Response.Status.NOT_FOUND, "Tenant not found");
            }
            return this.tenantResources().getListOfNamespacesAsync(tenant);
        });
    }

    protected CompletableFuture<Void> internalCreateNamespace(Policies policies) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTenantOperationAsync(this.namespaceName.getTenant(), TenantOperation.CREATE_NAMESPACE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.validatePoliciesAsync(this.namespaceName, policies))).thenCompose(__ -> {
            int maxNamespacesPerTenant = this.pulsar().getConfiguration().getMaxNamespacesPerTenant();
            if (maxNamespacesPerTenant > 0) {
                return this.tenantResources().getListOfNamespacesAsync(this.namespaceName.getTenant()).thenAccept(namespaces -> {
                    if (namespaces != null && namespaces.size() > maxNamespacesPerTenant) {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "Exceed the maximum number of namespace in tenant :" + this.namespaceName.getTenant());
                    }
                });
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(__ -> this.namespaceResources().createPoliciesAsync(this.namespaceName, policies))).thenAccept(__ -> log.info("[{}] Created namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName));
    }

    protected CompletableFuture<List<String>> internalGetListOfTopics(Policies policies, CommandGetTopicsOfNamespace.Mode mode) {
        switch (mode) {
            case ALL: {
                return this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName).thenCombine(this.internalGetNonPersistentTopics(policies), (persistentTopics, nonPersistentTopics) -> ListUtils.union((List)persistentTopics, (List)nonPersistentTopics));
            }
            case NON_PERSISTENT: {
                return this.internalGetNonPersistentTopics(policies);
            }
        }
        return this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName);
    }

    protected CompletableFuture<List<String>> internalGetNonPersistentTopics(Policies policies) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        List boundaries = policies.bundles.getBoundaries();
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            String bundle = String.format("%s_%s", boundaries.get(i), boundaries.get(i + 1));
            try {
                futures.add(this.pulsar().getAdminClient().topics().getListInBundleAsync(this.namespaceName.toString(), bundle));
                continue;
            }
            catch (PulsarServerException e) {
                throw new RestException(e);
            }
        }
        return FutureUtil.waitForAll(futures).thenApply(__ -> {
            ArrayList topics = new ArrayList();
            for (int i = 0; i < futures.size(); ++i) {
                List topicList = (List)((CompletableFuture)futures.get(i)).join();
                if (topicList == null) continue;
                topics.addAll(topicList);
            }
            return topics.stream().filter(name -> !TopicName.get((String)name).isPersistent()).collect(Collectors.toList());
        });
    }

    @Nonnull
    protected CompletableFuture<Void> internalDeleteNamespaceAsync(boolean force) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.internalRetryableDeleteNamespaceAsync0(force, 5, future);
        return future;
    }

    private void internalRetryableDeleteNamespaceAsync0(boolean force, int retryTimes, @Nonnull CompletableFuture<Void> callback) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.precheckWhenDeleteNamespace(this.namespaceName, force).thenCompose(policies -> {
            CompletableFuture<List<String>> topicsFuture = policies == null || CollectionUtils.isEmpty((Collection)policies.replication_clusters) ? this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName) : this.pulsar().getNamespaceService().getFullListOfTopics(this.namespaceName);
            return ((CompletableFuture)topicsFuture.thenCompose(allTopics -> this.pulsar().getNamespaceService().getFullListOfPartitionedTopic(this.namespaceName).thenCompose(allPartitionedTopics -> {
                ArrayList<List> topicsSum = new ArrayList<List>(2);
                topicsSum.add((List)allTopics);
                topicsSum.add((List)allPartitionedTopics);
                return CompletableFuture.completedFuture(topicsSum);
            }))).thenCompose(topics -> {
                List allTopics = (List)topics.get(0);
                HashSet<String> allUserCreatedTopics = new HashSet<String>();
                List allPartitionedTopics = (List)topics.get(1);
                HashSet<String> allUserCreatedPartitionTopics = new HashSet<String>();
                boolean hasNonSystemTopic = false;
                HashSet<String> allSystemTopics = new HashSet<String>();
                HashSet<String> allPartitionedSystemTopics = new HashSet<String>();
                HashSet<String> topicPolicy = new HashSet<String>();
                HashSet<String> partitionedTopicPolicy = new HashSet<String>();
                for (String topic : allTopics) {
                    if (!this.pulsar().getBrokerService().isSystemTopic(TopicName.get((String)topic))) {
                        hasNonSystemTopic = true;
                        allUserCreatedTopics.add(topic);
                        continue;
                    }
                    if (SystemTopicNames.isTopicPoliciesSystemTopic((String)topic)) {
                        topicPolicy.add(topic);
                        continue;
                    }
                    if (this.isDeletedAlongWithUserCreatedTopic(topic)) continue;
                    allSystemTopics.add(topic);
                }
                for (String topic : allPartitionedTopics) {
                    if (!this.pulsar().getBrokerService().isSystemTopic(TopicName.get((String)topic))) {
                        hasNonSystemTopic = true;
                        allUserCreatedPartitionTopics.add(topic);
                        continue;
                    }
                    if (SystemTopicNames.isTopicPoliciesSystemTopic((String)topic)) {
                        partitionedTopicPolicy.add(topic);
                        continue;
                    }
                    allPartitionedSystemTopics.add(topic);
                }
                if (!force && hasNonSystemTopic) {
                    throw new RestException(Response.Status.CONFLICT, "Cannot delete non empty namespace");
                }
                CompletableFuture markDeleteFuture = policies != null && policies.deleted ? CompletableFuture.completedFuture(null) : this.namespaceResources().setPoliciesAsync(this.namespaceName, old -> {
                    old.deleted = true;
                    return old;
                });
                return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)markDeleteFuture.thenCompose(__ -> this.internalDeleteTopicsAsync(allUserCreatedTopics))).thenCompose(ignore -> this.internalDeletePartitionedTopicsAsync(allUserCreatedPartitionTopics))).thenCompose(ignore -> this.internalDeleteTopicsAsync(allSystemTopics))).thenCompose(ignore -> this.internalDeletePartitionedTopicsAsync(allPartitionedSystemTopics))).thenCompose(ignore -> this.internalDeleteTopicsAsync(topicPolicy))).thenCompose(ignore -> this.internalDeletePartitionedTopicsAsync(partitionedTopicPolicy));
            });
        })).thenCompose(ignore -> this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundlesAsync(this.namespaceName))).thenCompose(bundles -> FutureUtil.waitForAll((Collection)bundles.getBundles().stream().map(bundle -> this.pulsar().getNamespaceService().checkOwnershipPresentAsync((NamespaceBundle)bundle).thenCompose(present -> {
            if (present.booleanValue()) {
                PulsarAdmin admin;
                try {
                    admin = this.pulsar().getAdminClient();
                }
                catch (PulsarServerException ex) {
                    log.error("[{}] Get admin client error when preparing to delete topics.", (Object)this.clientAppId(), (Object)ex);
                    return FutureUtil.failedFuture((Throwable)ex);
                }
                log.info("[{}] Deleting namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundle.getBundleRange()});
                return admin.namespaces().deleteNamespaceBundleAsync(this.namespaceName.toString(), bundle.getBundleRange(), force);
            }
            log.warn("[{}] Skipping deleting namespace bundle {}/{} as it's not owned by any broker", new Object[]{this.clientAppId(), this.namespaceName, bundle.getBundleRange()});
            return CompletableFuture.completedFuture(null);
        })).collect(Collectors.toList())))).thenCompose(ignore -> this.internalClearZkSources())).whenComplete((result, error) -> {
            if (error != null) {
                Throwable rc = FutureUtil.unwrapCompletionException((Throwable)error);
                if (rc instanceof MetadataStoreException && rc.getCause() != null && rc.getCause() instanceof KeeperException.NotEmptyException) {
                    KeeperException.NotEmptyException ne = (KeeperException.NotEmptyException)rc.getCause();
                    log.info("[{}] There are in-flight topics created during the namespace deletion, retry to delete the namespace again. (path {} is not empty on metadata)", (Object)this.namespaceName, (Object)ne.getPath());
                    int next = retryTimes - 1;
                    if (next > 0) {
                        this.internalRetryableDeleteNamespaceAsync0(force, next, callback);
                    } else {
                        callback.completeExceptionally((Throwable)((Object)new RestException(Response.Status.CONFLICT, "The broker still have in-flight topics created during namespace deletion (path " + ne.getPath() + ") is not empty on metadata store, please try again.")));
                    }
                    return;
                }
                callback.completeExceptionally((Throwable)error);
                return;
            }
            callback.complete((Void)result);
        });
    }

    private boolean isDeletedAlongWithUserCreatedTopic(String topic) {
        return topic.endsWith("__transaction_pending_ack");
    }

    private CompletableFuture<Void> internalDeletePartitionedTopicsAsync(Set<String> topicNames) {
        if (CollectionUtils.isEmpty(topicNames)) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (String topicName : topicNames) {
            TopicName tn = TopicName.get((String)topicName);
            futures.add(this.pulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources().runWithMarkDeleteAsync(tn, () -> this.namespaceResources().getPartitionedTopicResources().deletePartitionedTopicAsync(tn)));
        }
        return FutureUtil.waitForAll(futures);
    }

    private CompletableFuture<Void> internalDeleteTopicsAsync(Set<String> topicNames) {
        PulsarAdmin admin;
        if (CollectionUtils.isEmpty(topicNames)) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            admin = this.pulsar().getAdminClient();
        }
        catch (Exception ex) {
            log.error("[{}] Get admin client error when preparing to delete topics.", (Object)this.clientAppId(), (Object)ex);
            return FutureUtil.failedFuture((Throwable)ex);
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (String topicName : topicNames) {
            futures.add(admin.topics().deleteAsync(topicName, true));
        }
        return FutureUtil.waitForAll(futures);
    }

    private CompletableFuture<Policies> precheckWhenDeleteNamespace(NamespaceName nsName, boolean force) {
        CompletionStage preconditionCheck = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateTenantOperationAsync(nsName.getTenant(), TenantOperation.DELETE_NAMESPACE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> {
            if (force && !this.pulsar().getConfiguration().isForceDeleteNamespaceAllowed()) {
                throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Broker doesn't allow forced deletion of namespaces");
            }
            if (!nsName.isGlobal()) {
                return this.validateClusterOwnershipAsync(nsName.getCluster());
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(__ -> this.namespaceResources().getPoliciesAsync(nsName))).thenCompose(policiesOpt -> {
            if (policiesOpt.isEmpty()) {
                throw new RestException(Response.Status.NOT_FOUND, "Namespace " + String.valueOf(nsName) + " does not exist.");
            }
            if (!nsName.isGlobal()) {
                return CompletableFuture.completedFuture(null);
            }
            Policies policies = (Policies)policiesOpt.get();
            Set replicationClusters = policies.replication_clusters;
            if (replicationClusters.size() > 1) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + String.valueOf(nsName) + ". There are still more than one replication clusters configured.");
            }
            if (replicationClusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                String replCluster = (String)new ArrayList(policies.replication_clusters).get(0);
                return this.clusterResources().getClusterAsync(replCluster).thenCompose(replClusterDataOpt -> {
                    URL replClusterUrl;
                    block5: {
                        ClusterData replClusterData = (ClusterData)replClusterDataOpt.orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist"));
                        try {
                            if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                                replClusterUrl = new URL(replClusterData.getServiceUrl());
                                break block5;
                            }
                            if (StringUtils.isNotBlank((CharSequence)replClusterData.getServiceUrlTls())) {
                                replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                                break block5;
                            }
                            throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                        }
                        catch (MalformedURLException checkedEx) {
                            throw new RestException(checkedEx);
                        }
                    }
                    URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", new Object[]{false}).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
                });
            }
            return CompletableFuture.completedFuture(policies);
        });
        return preconditionCheck;
    }

    protected CompletableFuture<Void> internalClearZkSources() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.namespaceResources().deleteNamespaceAsync(this.namespaceName).thenCompose(ignore -> this.namespaceResources().getPartitionedTopicResources().clearPartitionedTopicMetadataAsync(this.namespaceName))).thenCompose(ignore -> this.pulsar().getPulsarResources().getTopicResources().clearDomainPersistence(this.namespaceName))).thenCompose(ignore -> this.pulsar().getPulsarResources().getTopicResources().clearNamespacePersistence(this.namespaceName))).thenCompose(ignore -> this.namespaceResources().deletePoliciesAsync(this.namespaceName))).thenCompose(ignore -> this.getLocalPolicies().deleteLocalPoliciesAsync(this.namespaceName))).thenCompose(ignore -> this.loadBalanceResources().getBundleDataResources().deleteBundleDataAsync(this.namespaceName));
    }

    protected CompletableFuture<Void> internalDeleteNamespaceBundleAsync(String bundleRange, boolean authoritative, boolean force) {
        log.info("[{}] Deleting namespace bundle {}/{} authoritative:{} force:{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, authoritative, force});
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(this.namespaceName, NamespaceOperation.DELETE_BUNDLE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> {
            if (!this.namespaceName.isGlobal()) {
                return this.validateClusterOwnershipAsync(this.namespaceName.getCluster());
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenCompose(policies -> {
            CompletionStage<Object> future = CompletableFuture.completedFuture(null);
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + String.valueOf(this.namespaceName) + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    String replCluster = (String)new ArrayList(policies.replication_clusters).get(0);
                    future = this.clusterResources().getClusterAsync(replCluster).thenCompose(clusterData -> {
                        URL replClusterUrl;
                        block6: {
                            if (clusterData.isEmpty()) {
                                throw new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist");
                            }
                            ClusterData replClusterData = (ClusterData)clusterData.get();
                            try {
                                if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                                    replClusterUrl = new URL(replClusterData.getServiceUrl());
                                    break block6;
                                }
                                if (StringUtils.isNotBlank((CharSequence)replClusterData.getServiceUrlTls())) {
                                    replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                                    break block6;
                                }
                                throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                            }
                            catch (MalformedURLException malformedURLException) {
                                throw new RestException(malformedURLException);
                            }
                        }
                        URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", new Object[]{false}).build(new Object[0]);
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                        }
                        throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
                    });
                }
            }
            return ((CompletableFuture)future.thenCompose(__ -> this.validateNamespaceBundleOwnershipAsync(this.namespaceName, policies.bundles, bundleRange, authoritative, true))).thenCompose(bundle -> this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName).thenCompose(topics -> {
                CompletableFuture deleteTopicsFuture = CompletableFuture.completedFuture(null);
                if (!force) {
                    ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
                    for (String topic : topics) {
                        futures.add(this.pulsar().getNamespaceService().getBundleAsync(TopicName.get((String)topic)).thenCompose(topicBundle -> {
                            if (bundle.equals(topicBundle)) {
                                throw new RestException(Response.Status.CONFLICT, "Cannot delete non empty bundle");
                            }
                            return CompletableFuture.completedFuture(null);
                        }));
                    }
                    deleteTopicsFuture = FutureUtil.waitForAll(futures);
                }
                return ((CompletableFuture)deleteTopicsFuture.thenCompose(___ -> this.pulsar().getNamespaceService().removeOwnedServiceUnitAsync((NamespaceBundle)bundle))).thenRun(() -> this.pulsar().getBrokerService().getBundleStats().remove(bundle.toString()));
            }));
        });
    }

    protected CompletableFuture<Void> internalGrantPermissionOnNamespaceAsync(String role, Set<AuthAction> actions) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(this.namespaceName, NamespaceOperation.GRANT_PERMISSION).thenAccept(__ -> {
            this.checkNotNull(role, "Role should not be null");
            this.checkNotNull(actions, "Actions should not be null");
        })).thenCompose(__ -> this.getAuthorizationService().grantPermissionAsync(this.namespaceName, actions, role, null))).thenAccept(unused -> log.info("[{}] Successfully granted access for role {}: {} - namespaceName {}", new Object[]{this.clientAppId(), role, actions, this.namespaceName}))).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException || realCause instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", new Object[]{this.clientAppId(), this.namespaceName, ex});
                throw new RestException(Response.Status.NOT_FOUND, "Topic's namespace does not exist");
            }
            if (realCause instanceof MetadataStoreException.BadVersionException || realCause instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            throw new RestException(realCause);
        });
    }

    protected CompletableFuture<Void> internalGrantPermissionOnTopicsAsync(List<GrantTopicPermissionOptions> options) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkNamespace(options.stream().map(o -> TopicName.get((String)o.getTopic()).getNamespace())).thenCompose(__ -> this.validateAdminAccessForTenantAsync(TopicName.get((String)((GrantTopicPermissionOptions)options.get(0)).getTopic()).getTenant()))).thenCompose(__ -> this.internalCheckTopicExists(options.stream().map(o -> TopicName.get((String)o.getTopic()))))).thenCompose(__ -> this.getAuthorizationService().grantPermissionAsync(options))).thenAccept(unused -> log.info("[{}] Successfully granted access for {}", (Object)this.clientAppId(), (Object)options))).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException || realCause instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to grant permissions for namespace {}: does not exist", new Object[]{this.clientAppId(), this.namespaceName, ex});
                throw new RestException(Response.Status.NOT_FOUND, "Topic's namespace does not exist");
            }
            if (realCause instanceof MetadataStoreException.BadVersionException || realCause instanceof IllegalStateException) {
                log.warn("[{}] Failed to grant permissions for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to grant permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            throw new RestException(realCause);
        });
    }

    protected CompletableFuture<Void> internalRevokePermissionOnTopicsAsync(List<RevokeTopicPermissionOptions> options) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkNamespace(options.stream().map(o -> TopicName.get((String)o.getTopic()).getNamespace())).thenCompose(__ -> this.validateAdminAccessForTenantAsync(TopicName.get((String)((RevokeTopicPermissionOptions)options.get(0)).getTopic()).getTenant()))).thenCompose(__ -> this.internalCheckTopicExists(options.stream().map(o -> TopicName.get((String)o.getTopic()))))).thenCompose(__ -> this.getAuthorizationService().revokePermissionAsync(options))).thenAccept(unused -> log.info("[{}] Successfully revoke access for {}", (Object)this.clientAppId(), (Object)options))).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause instanceof MetadataStoreException.NotFoundException || realCause instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to revoke permissions for namespace {}: does not exist", new Object[]{this.clientAppId(), this.namespaceName, ex});
                throw new RestException(Response.Status.NOT_FOUND, "Topic's namespace does not exist");
            }
            if (realCause instanceof MetadataStoreException.BadVersionException || realCause instanceof IllegalStateException) {
                log.warn("[{}] Failed to revoke permissions for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, ex.getCause().getMessage(), ex});
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to revoke permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            throw new RestException(realCause);
        });
    }

    private CompletableFuture<Void> checkNamespace(Stream<String> namespaces) {
        boolean sameNamespace;
        boolean bl = sameNamespace = namespaces.distinct().count() == 1L;
        if (!sameNamespace) {
            throw new RestException(Response.Status.BAD_REQUEST, "The namespace should be the same");
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> internalCheckTopicExists(Stream<TopicName> topicNameStream) {
        List topicNames = topicNameStream.collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])topicNames.stream().map(topic -> this.internalCheckTopicExists((TopicName)topic)).toArray(CompletableFuture[]::new));
    }

    protected CompletableFuture<Void> internalGrantPermissionOnSubscriptionAsync(String subscription, Set<String> roles) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespaceOperationAsync(this.namespaceName, NamespaceOperation.GRANT_PERMISSION).thenAccept(__ -> {
            this.checkNotNull(subscription, "Subscription should not be null");
            this.checkNotNull(roles, "Roles should not be null");
        })).thenCompose(__ -> this.getAuthorizationService().grantSubscriptionPermissionAsync(this.namespaceName, subscription, roles, null))).thenAccept(unused -> log.info("[{}] Successfully granted permission on subscription for role {}:{} - namespaceName {}", new Object[]{this.clientAppId(), roles, subscription, this.namespaceName}))).exceptionally(ex -> {
            Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
            if (realCause.getCause() instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            if (realCause.getCause() instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, realCause});
            throw new RestException(realCause);
        });
    }

    protected CompletableFuture<Void> internalRevokePermissionsOnNamespaceAsync(String role) {
        return ((CompletableFuture)this.validateNamespaceOperationAsync(this.namespaceName, NamespaceOperation.REVOKE_PERMISSION).thenAccept(__ -> this.checkNotNull(role, "Role should not be null"))).thenCompose(__ -> this.getAuthorizationService().revokePermissionAsync(this.namespaceName, role));
    }

    protected CompletableFuture<Void> internalRevokePermissionsOnSubscriptionAsync(String subscriptionName, String role) {
        return ((CompletableFuture)this.validateNamespaceOperationAsync(this.namespaceName, NamespaceOperation.REVOKE_PERMISSION).thenAccept(__ -> {
            this.checkNotNull(subscriptionName, "SubscriptionName should not be null");
            this.checkNotNull(role, "Role should not be null");
        })).thenCompose(__ -> this.getAuthorizationService().revokeSubscriptionPermissionAsync(this.namespaceName, subscriptionName, role, null));
    }

    protected CompletableFuture<Set<String>> internalGetNamespaceReplicationClustersAsync() {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.REPLICATION, PolicyOperation.READ).thenAccept(__ -> {
            if (!this.namespaceName.isGlobal()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot get the replication clusters for a non-global namespace");
            }
        })).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> policies.replication_clusters);
    }

    protected CompletableFuture<Void> internalSetNamespaceReplicationClusters(List<String> clusterIds) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.REPLICATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenApply(__ -> {
            if (CollectionUtils.isEmpty((Collection)clusterIds)) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "ClusterIds should not be null or empty");
            }
            if (!(this.namespaceName.isGlobal() || clusterIds.size() == 1 && ((String)clusterIds.get(0)).equals(this.pulsar().getConfiguration().getClusterName()))) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot set replication on a non-global namespace");
            }
            HashSet replicationClusterSet = Sets.newHashSet((Iterable)clusterIds);
            if (replicationClusterSet.contains("global")) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot specify global in the list of replication clusters");
            }
            return replicationClusterSet;
        })).thenCompose(replicationClusterSet -> this.clustersAsync().thenCompose(clusters -> {
            List futures = replicationClusterSet.stream().map(clusterId -> {
                if (!clusters.contains(clusterId)) {
                    throw new RestException(Response.Status.FORBIDDEN, "Invalid cluster id: " + clusterId);
                }
                return this.validatePeerClusterConflictAsync((String)clusterId, (Set<String>)replicationClusterSet).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName).thenCompose(nsPolicies -> {
                    if (nsPolicies.allowed_clusters.isEmpty()) {
                        return this.validateClusterForTenantAsync(this.namespaceName.getTenant(), (String)clusterId);
                    }
                    if (!nsPolicies.allowed_clusters.contains(clusterId)) {
                        String msg = String.format("Cluster [%s] is not in the list of allowed clusters list for namespace [%s]", clusterId, this.namespaceName.toString());
                        log.info(msg);
                        throw new RestException(Response.Status.FORBIDDEN, msg);
                    }
                    return CompletableFuture.completedFuture(null);
                }));
            }).collect(Collectors.toList());
            return FutureUtil.waitForAll(futures).thenApply(__ -> replicationClusterSet);
        }))).thenCompose(replicationClusterSet -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.replication_clusters = replicationClusterSet;
            return policies;
        }));
    }

    protected CompletableFuture<Void> internalSetNamespaceMessageTTLAsync(Integer messageTTL) {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.TTL, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenAccept(__ -> {
            if (messageTTL != null && messageTTL < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL, message TTL must >= 0");
            }
        })).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.message_ttl_in_seconds = messageTTL;
            return policies;
        }));
    }

    protected CompletableFuture<Void> internalSetSubscriptionExpirationTimeAsync(Integer expirationTime) {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.SUBSCRIPTION_EXPIRATION_TIME, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenAccept(__ -> {
            if (expirationTime != null && expirationTime < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for subscription expiration time");
            }
        })).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.subscription_expiration_time_minutes = expirationTime;
            return policies;
        }));
    }

    protected CompletableFuture<AutoTopicCreationOverride> internalGetAutoTopicCreationAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.AUTO_TOPIC_CREATION, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> policies.autoTopicCreationOverride);
    }

    protected CompletableFuture<Void> internalSetAutoTopicCreationAsync(AutoTopicCreationOverride autoTopicCreationOverride) {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.AUTO_TOPIC_CREATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenAccept(__ -> {
            int maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic();
            if (autoTopicCreationOverride != null) {
                ValidateResult validateResult = AutoTopicCreationOverrideImpl.validateOverride((AutoTopicCreationOverride)autoTopicCreationOverride);
                if (!validateResult.isSuccess()) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid configuration for autoTopicCreationOverride. the detail is " + validateResult.getErrorInfo());
                }
                if (Objects.equals(autoTopicCreationOverride.getTopicType(), TopicType.PARTITIONED.toString()) && maxPartitions > 0 && autoTopicCreationOverride.getDefaultNumPartitions() > maxPartitions) {
                    throw new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be less than or equal to " + maxPartitions);
                }
            }
        })).thenCompose(__ -> this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
            policies.autoTopicCreationOverride = autoTopicCreationOverride;
            return policies;
        }));
    }

    protected CompletableFuture<Void> internalSetAutoSubscriptionCreationAsync(AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.AUTO_SUBSCRIPTION_CREATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(unused -> this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
            policies.autoSubscriptionCreationOverride = autoSubscriptionCreationOverride;
            return policies;
        }))).thenAccept(r -> {
            if (autoSubscriptionCreationOverride != null) {
                String autoOverride = autoSubscriptionCreationOverride.isAllowAutoSubscriptionCreation() ? "enabled" : "disabled";
                log.info("[{}] Successfully {} autoSubscriptionCreation on namespace {}", new Object[]{this.clientAppId(), autoOverride, this.namespaceName});
            } else {
                log.info("[{}] Successfully remove autoSubscriptionCreation on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            }
        });
    }

    protected CompletableFuture<AutoSubscriptionCreationOverride> internalGetAutoSubscriptionCreationAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.AUTO_SUBSCRIPTION_CREATION, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> policies.autoSubscriptionCreationOverride);
    }

    protected CompletableFuture<Void> internalModifyDeduplicationAsync(Boolean enableDeduplication) {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.DEDUPLICATION, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.deduplicationEnabled = enableDeduplication;
            return policies;
        }));
    }

    protected CompletableFuture<Void> internalUnloadNamespaceAsync() {
        return ((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> {
            log.info("[{}] Unloading namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            if (this.namespaceName.isGlobal()) {
                return this.validateGlobalNamespaceOwnershipAsync(this.namespaceName);
            }
            return this.validateClusterOwnershipAsync(this.namespaceName.getCluster()).thenCompose(ignore -> this.validateClusterForTenantAsync(this.namespaceName.getTenant(), this.namespaceName.getCluster()));
        })).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenCompose(policies -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            List boundaries = policies.bundles.getBoundaries();
            for (int i = 0; i < boundaries.size() - 1; ++i) {
                String bundle = String.format("%s_%s", boundaries.get(i), boundaries.get(i + 1));
                try {
                    futures.add(this.pulsar().getAdminClient().namespaces().unloadNamespaceBundleAsync(this.namespaceName.toString(), bundle));
                    continue;
                }
                catch (PulsarServerException e) {
                    log.error("[{}] Failed to unload namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                    throw new RestException(e);
                }
            }
            return FutureUtil.waitForAll(futures);
        });
    }

    protected void internalSetBookieAffinityGroup(BookieAffinityGroupData bookieAffinityGroup) {
        this.validateSuperUserAccess();
        log.info("[{}] Setting bookie-affinity-group {} for namespace {}", new Object[]{this.clientAppId(), bookieAffinityGroup, this.namespaceName});
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        try {
            this.getLocalPolicies().setLocalPoliciesWithCreate(this.namespaceName, oldPolicies -> {
                LocalPolicies localPolicies = oldPolicies.map(policies -> new LocalPolicies(policies.bundles, bookieAffinityGroup, policies.namespaceAntiAffinityGroup, policies.migrated)).orElseGet(() -> new LocalPolicies(PoliciesUtil.getBundles((int)this.config().getDefaultNumberOfNamespaceBundles()), bookieAffinityGroup, null));
                log.info("[{}] Successfully updated local-policies configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, localPolicies});
                return localPolicies;
            });
        }
        catch (MetadataStoreException.NotFoundException e) {
            log.warn("[{}] Failed to update local-policy configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update local-policy configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteBookieAffinityGroup() {
        this.internalSetBookieAffinityGroup(null);
    }

    protected BookieAffinityGroupData internalGetBookieAffinityGroup() {
        this.validateSuperUserAccess();
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        try {
            BookieAffinityGroupData bookkeeperAffinityGroup = ((LocalPolicies)this.getLocalPolicies().getLocalPolicies((NamespaceName)this.namespaceName).orElseThrow((Supplier<RestException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$internalGetBookieAffinityGroup$123(), ()Lorg/apache/pulsar/broker/web/RestException;)())).bookieAffinityGroup;
            return bookkeeperAffinityGroup;
        }
        catch (MetadataStoreException.NotFoundException e) {
            log.warn("[{}] Failed to get local-policy configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist");
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get local-policy configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    private CompletableFuture<Void> validateLeaderBrokerAsync() {
        if (this.isLeaderBroker()) {
            return CompletableFuture.completedFuture(null);
        }
        Optional<LeaderBroker> currentLeaderOpt = this.pulsar().getLeaderElectionService().getCurrentLeader();
        if (currentLeaderOpt.isEmpty()) {
            String errorStr = "The current leader is empty.";
            log.error(errorStr);
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, errorStr)));
        }
        LeaderBroker leaderBroker = this.pulsar().getLeaderElectionService().getCurrentLeader().get();
        String leaderBrokerId = leaderBroker.getBrokerId();
        return this.pulsar().getNamespaceService().createLookupResult(leaderBrokerId, false, null).thenCompose(lookupResult -> {
            String redirectUrl;
            String string = redirectUrl = this.isRequestHttps() ? lookupResult.getLookupData().getHttpUrlTls() : lookupResult.getLookupData().getHttpUrl();
            if (redirectUrl == null) {
                log.error("Redirected broker's service url is not configured");
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Redirected broker's service url is not configured.")));
            }
            try {
                URL url = new URL(redirectUrl);
                URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(url.getHost()).port(url.getPort()).replaceQueryParam("authoritative", new Object[]{false}).build(new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug("Redirecting the request call to leader - {}", (Object)redirect);
                }
                return FutureUtil.failedFuture((Throwable)new WebApplicationException(Response.temporaryRedirect((URI)redirect).build()));
            }
            catch (MalformedURLException exception) {
                log.error("The redirect url is malformed - {}", (Object)redirectUrl);
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(exception)));
            }
        });
    }

    public CompletableFuture<Void> setNamespaceBundleAffinityAsync(String bundleRange, String destinationBroker) {
        if (StringUtils.isBlank((CharSequence)destinationBroker)) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)((CompletableFuture)this.pulsar().getLoadManager().get().getAvailableBrokersAsync().thenCompose(brokers -> {
            if (!brokers.contains(destinationBroker)) {
                log.warn("[{}] Failed to unload namespace bundle {}/{} to inactive broker {}.", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, destinationBroker});
                return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Not allowed unload namespace bundle to inactive destination broker"));
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(__ -> {
            if (ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(this.pulsar())) {
                return CompletableFuture.completedFuture(null);
            }
            return this.validateLeaderBrokerAsync();
        })).thenAccept(__ -> {
            if (ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(this.pulsar())) {
                return;
            }
            this.pulsar().getLoadManager().get().setNamespaceBundleAffinity(bundleRange, destinationBroker);
        });
    }

    public CompletableFuture<Void> internalUnloadNamespaceBundleAsync(String bundleRange, String destinationBrokerParam, boolean authoritative) {
        String destinationBroker = StringUtils.isBlank((CharSequence)destinationBrokerParam) ? null : destinationBrokerParam.replaceFirst("http[s]?://", "");
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> this.setNamespaceBundleAffinityAsync(bundleRange, destinationBroker))).thenAccept(__ -> {
            this.checkNotNull(bundleRange, "BundleRange should not be null");
            log.info("[{}] Unloading namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
        })).thenApply(__ -> this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundle(this.namespaceName.toString(), bundleRange))).thenCompose(bundle -> this.pulsar().getNamespaceService().isNamespaceBundleOwned((NamespaceBundle)bundle).exceptionally(ex -> {
            if (log.isDebugEnabled()) {
                log.debug("Failed to validate cluster ownership for {}-{}, {}", new Object[]{this.namespaceName.toString(), bundleRange, ex.getMessage(), ex});
            }
            return false;
        }))).thenCompose(isOwnedByLocalCluster -> {
            if (!isOwnedByLocalCluster.booleanValue()) {
                if (this.namespaceName.isGlobal()) {
                    return this.validateGlobalNamespaceOwnershipAsync(this.namespaceName);
                }
                return this.validateClusterOwnershipAsync(this.namespaceName.getCluster()).thenCompose(__ -> this.validateClusterForTenantAsync(this.namespaceName.getTenant(), this.namespaceName.getCluster()));
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenCompose(policies -> this.isBundleOwnedByAnyBroker(this.namespaceName, policies.bundles, bundleRange).thenCompose(flag -> {
            if (!flag.booleanValue()) {
                log.info("[{}] Namespace bundle is not owned by any broker {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
                return CompletableFuture.completedFuture(null);
            }
            Optional<String> destinationBrokerOpt = Optional.ofNullable(destinationBroker);
            return this.validateNamespaceBundleOwnershipAsync(this.namespaceName, policies.bundles, bundleRange, authoritative, true).thenCompose(nsBundle -> this.pulsar().getNamespaceService().unloadNamespaceBundle((NamespaceBundle)nsBundle, destinationBrokerOpt));
        }));
    }

    protected CompletableFuture<Void> internalSplitNamespaceBundleAsync(String bundleName, boolean authoritative, boolean unload, String splitAlgorithmName, List<Long> splitBoundaries) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenAccept(__ -> {
            this.checkNotNull(bundleName, "BundleRange should not be null");
            log.info("[{}] Split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleName});
            List supportedNamespaceBundleSplitAlgorithms = this.pulsar().getConfig().getSupportedNamespaceBundleSplitAlgorithms();
            if (StringUtils.isNotBlank((CharSequence)splitAlgorithmName)) {
                if (!supportedNamespaceBundleSplitAlgorithms.contains(splitAlgorithmName)) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Unsupported namespace bundle split algorithm, supported algorithms are " + String.valueOf(supportedNamespaceBundleSplitAlgorithms));
                }
                if (splitAlgorithmName.equalsIgnoreCase("specified_positions_divide") && (splitBoundaries == null || splitBoundaries.size() == 0)) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "With specified_positions_divide split algorithm, splitBoundaries must not be empty");
                }
            }
        })).thenCompose(__ -> {
            if (this.namespaceName.isGlobal()) {
                return this.validateGlobalNamespaceOwnershipAsync(this.namespaceName);
            }
            return this.validateClusterOwnershipAsync(this.namespaceName.getCluster()).thenCompose(ignore -> this.validateClusterForTenantAsync(this.namespaceName.getTenant(), this.namespaceName.getCluster()));
        })).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.getBundleRangeAsync(bundleName))).thenCompose(bundleRange -> ((CompletableFuture)this.getNamespacePoliciesAsync(this.namespaceName).thenCompose(policies -> this.validateNamespaceBundleOwnershipAsync(this.namespaceName, policies.bundles, (String)bundleRange, authoritative, false))).thenCompose(nsBundle -> this.pulsar().getNamespaceService().splitAndOwnBundle((NamespaceBundle)nsBundle, unload, this.pulsar().getNamespaceService().getNamespaceBundleSplitAlgorithmByName(splitAlgorithmName), splitBoundaries)));
    }

    protected CompletableFuture<TopicHashPositions> internalGetTopicHashPositionsAsync(String bundleRange, List<String> topics) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Getting hash position for topic list {}, bundle {}", new Object[]{this.clientAppId(), topics, bundleRange});
        }
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenCompose(policies -> ((CompletableFuture)this.validateNamespaceBundleOwnershipAsync(this.namespaceName, policies.bundles, bundleRange, false, true).thenCompose(nsBundle -> this.pulsar().getNamespaceService().getOwnedTopicListForNamespaceBundle((NamespaceBundle)nsBundle))).thenApply(allTopicsInThisBundle -> {
            HashMap<String, Long> topicHashPositions = new HashMap<String, Long>();
            if (topics == null || topics.size() == 0) {
                allTopicsInThisBundle.forEach(t -> topicHashPositions.put((String)t, this.pulsar().getNamespaceService().getNamespaceBundleFactory().getLongHashCode((String)t)));
            } else {
                for (String topic : topics.stream().map(Codec::decode).toList()) {
                    TopicName topicName = TopicName.get((String)topic);
                    if (topicName.getPartitionIndex() == -1) {
                        allTopicsInThisBundle.stream().filter(t -> TopicName.get((String)t).getPartitionedTopicName().equals(TopicName.get((String)topic).getPartitionedTopicName())).forEach(partition -> topicHashPositions.put((String)partition, this.pulsar().getNamespaceService().getNamespaceBundleFactory().getLongHashCode((String)partition)));
                        continue;
                    }
                    if (!allTopicsInThisBundle.contains(topicName.toString())) continue;
                    topicHashPositions.put(topic, this.pulsar().getNamespaceService().getNamespaceBundleFactory().getLongHashCode(topic));
                }
            }
            return new TopicHashPositions(this.namespaceName.toString(), bundleRange, topicHashPositions);
        }));
    }

    private CompletableFuture<String> getBundleRangeAsync(String bundleName) {
        CompletableFuture<NamespaceBundle> future;
        if (Policies.BundleType.LARGEST.toString().equals(bundleName)) {
            future = this.findLargestBundleWithTopicsAsync(this.namespaceName);
        } else if (Policies.BundleType.HOT.toString().equals(bundleName)) {
            future = this.findHotBundleAsync(this.namespaceName);
        } else {
            return CompletableFuture.completedFuture(bundleName);
        }
        return future.thenApply(nsBundle -> {
            if (nsBundle == null) {
                throw new RestException(Response.Status.NOT_FOUND, String.format("Bundle range %s not found", bundleName));
            }
            return nsBundle.getBundleRange();
        });
    }

    private CompletableFuture<NamespaceBundle> findLargestBundleWithTopicsAsync(NamespaceName namespaceName) {
        return this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundleWithHighestTopicsAsync(namespaceName);
    }

    private CompletableFuture<NamespaceBundle> findHotBundleAsync(NamespaceName namespaceName) {
        return this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundleWithHighestThroughputAsync(namespaceName);
    }

    protected void internalSetPublishRate(PublishRate maxPublishMessageRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace publish-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, maxPublishMessageRate});
        this.updatePolicies(this.namespaceName, policies -> {
            policies.publishMaxMessageRate.put(this.pulsar().getConfiguration().getClusterName(), maxPublishMessageRate);
            return policies;
        });
        log.info("[{}] Successfully updated the publish_max_message_rate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
    }

    protected CompletableFuture<Void> internalSetPublishRateAsync(PublishRate maxPublishMessageRate) {
        log.info("[{}] Set namespace publish-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, maxPublishMessageRate});
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.publishMaxMessageRate.put(this.pulsar().getConfiguration().getClusterName(), maxPublishMessageRate);
            log.info("[{}] Successfully updated the publish_max_message_rate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected void internalRemovePublishRate() {
        this.validateSuperUserAccess();
        log.info("[{}] Remove namespace publish-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName});
        try {
            this.updatePolicies(this.namespaceName, policies -> {
                if (policies.publishMaxMessageRate != null) {
                    policies.publishMaxMessageRate.remove(this.pulsar().getConfiguration().getClusterName());
                }
                return policies;
            });
            log.info("[{}] Successfully remove the publish_max_message_rate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove the publish_max_message_rate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Void> internalRemovePublishRateAsync() {
        log.info("[{}] Remove namespace publish-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName});
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            if (policies.publishMaxMessageRate != null) {
                policies.publishMaxMessageRate.remove(this.pulsar().getConfiguration().getClusterName());
            }
            log.info("[{}] Successfully remove the publish_max_message_rate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected CompletableFuture<PublishRate> internalGetPublishRateAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> (PublishRate)policies.publishMaxMessageRate.get(this.pulsar().getConfiguration().getClusterName()));
    }

    protected CompletableFuture<Void> internalSetTopicDispatchRateAsync(DispatchRateImpl dispatchRate) {
        log.info("[{}] Set namespace dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.topicDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            policies.clusterDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            log.info("[{}] Successfully updated the dispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected CompletableFuture<Void> internalDeleteTopicDispatchRateAsync() {
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.topicDispatchRate.remove(this.pulsar().getConfiguration().getClusterName());
            policies.clusterDispatchRate.remove(this.pulsar().getConfiguration().getClusterName());
            log.info("[{}] Successfully delete the dispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected CompletableFuture<DispatchRate> internalGetTopicDispatchRateAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> (DispatchRate)policies.topicDispatchRate.get(this.pulsar().getConfiguration().getClusterName()));
    }

    protected CompletableFuture<Void> internalSetSubscriptionDispatchRateAsync(DispatchRateImpl dispatchRate) {
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.subscriptionDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            log.info("[{}] Successfully updated the subscriptionDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected CompletableFuture<Void> internalDeleteSubscriptionDispatchRateAsync() {
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.subscriptionDispatchRate.remove(this.pulsar().getConfiguration().getClusterName());
            log.info("[{}] Successfully delete the subscriptionDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected CompletableFuture<DispatchRate> internalGetSubscriptionDispatchRateAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> (DispatchRate)policies.subscriptionDispatchRate.get(this.pulsar().getConfiguration().getClusterName()));
    }

    protected CompletableFuture<Void> internalSetSubscribeRateAsync(SubscribeRate subscribeRate) {
        log.info("[{}] Set namespace subscribe-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, subscribeRate});
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.clusterSubscribeRate.put(this.pulsar().getConfiguration().getClusterName(), subscribeRate);
            log.info("[{}] Successfully updated the subscribeRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected CompletableFuture<Void> internalDeleteSubscribeRateAsync() {
        return this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.WRITE).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.clusterSubscribeRate.remove(this.pulsar().getConfiguration().getClusterName());
            log.info("[{}] Successfully delete the subscribeRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            return policies;
        }));
    }

    protected CompletableFuture<SubscribeRate> internalGetSubscribeRateAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.RATE, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> (SubscribeRate)policies.clusterSubscribeRate.get(this.pulsar().getConfiguration().getClusterName()));
    }

    protected CompletableFuture<Void> setBacklogQuotaAsync(BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota quota) {
        return this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
            boolean passCheck;
            BacklogQuota.BacklogQuotaType quotaType;
            RetentionPolicies retentionPolicies = policies.retention_policies;
            BacklogQuota.BacklogQuotaType backlogQuotaType2 = quotaType = backlogQuotaType != null ? backlogQuotaType : BacklogQuota.BacklogQuotaType.destination_storage;
            if (retentionPolicies == null) {
                policies.backlog_quota_map.put(quotaType, quota);
                return policies;
            }
            BacklogQuota needCheckQuota = null;
            if (quotaType == BacklogQuota.BacklogQuotaType.destination_storage) {
                needCheckQuota = quota;
            }
            if (!(passCheck = this.checkBacklogQuota(needCheckQuota, retentionPolicies))) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Backlog Quota exceeds configured retention quota for namespace. Please increase retention quota and retry");
            }
            policies.backlog_quota_map.put(quotaType, quota);
            return policies;
        });
    }

    protected void internalSetRetention(RetentionPolicies retention) {
        this.validateRetentionPolicies(retention);
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RETENTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Policies policies = (Policies)this.namespaceResources().getPolicies(this.namespaceName).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist"));
            if (!this.checkQuotas(policies, retention)) {
                log.warn("[{}] Failed to update retention configuration for namespace {}: conflicts with backlog quota", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Retention Quota must exceed configured backlog quota for namespace.");
            }
            policies.retention_policies = retention;
            this.namespaceResources().setPolicies(this.namespaceName, p -> policies);
            log.info("[{}] Successfully updated retention configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, this.objectWriter().writeValueAsString((Object)retention)});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update retention configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Void> internalDeletePersistenceAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.doUpdatePersistenceAsync(null));
    }

    protected CompletableFuture<Void> internalSetPersistenceAsync(PersistencePolicies persistence) {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenAccept(__ -> this.validatePersistencePolicies(persistence))).thenCompose(__ -> this.doUpdatePersistenceAsync(persistence));
    }

    private CompletableFuture<Void> doUpdatePersistenceAsync(PersistencePolicies persistence) {
        return this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.persistence = persistence;
            return policies;
        }).thenAccept(__ -> log.info("[{}] Successfully updated persistence configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, persistence}));
    }

    protected void internalClearNamespaceBacklog(AsyncResponse asyncResponse, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().checkOwnershipPresent(nsBundle)) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklogAsync(this.namespaceName.toString(), nsBundle.getBundleRange()));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to clear backlog on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            log.info("[{}] Successfully cleared backlog on all the bundles for namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalClearNamespaceBundleBacklog(String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        this.checkNotNull(bundleRange, "BundleRange should not be null");
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, null);
        log.info("[{}] Successfully cleared backlog on namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
    }

    protected void internalClearNamespaceBacklogForSubscription(AsyncResponse asyncResponse, String subscription, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        this.checkNotNull(subscription, "Subscription should not be null");
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().checkOwnershipPresent(nsBundle)) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklogForSubscriptionAsync(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to clear backlog for subscription {} on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), subscription, this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            log.info("[{}] Successfully cleared backlog for subscription {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalClearNamespaceBundleBacklogForSubscription(String subscription, String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        this.checkNotNull(subscription, "Subscription should not be null");
        this.checkNotNull(bundleRange, "BundleRange should not be null");
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully cleared backlog for subscription {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalUnsubscribeNamespace(AsyncResponse asyncResponse, String subscription, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.UNSUBSCRIBE);
        this.checkNotNull(subscription, "Subscription should not be null");
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().checkOwnershipPresent(nsBundle)) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().unsubscribeNamespaceBundleAsync(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        FutureUtil.waitForAll(futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to unsubscribe {} on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), subscription, this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            log.info("[{}] Successfully unsubscribed {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalUnsubscribeNamespaceBundle(String subscription, String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.UNSUBSCRIBE);
        this.checkNotNull(subscription, "Subscription should not be null");
        this.checkNotNull(bundleRange, "BundleRange should not be null");
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.unsubscribe(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully unsubscribed {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalSetSubscriptionAuthMode(SubscriptionAuthMode subscriptionAuthMode) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SUBSCRIPTION_AUTH_MODE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        SubscriptionAuthMode authMode = subscriptionAuthMode == null ? (subscriptionAuthMode = SubscriptionAuthMode.None) : subscriptionAuthMode;
        try {
            this.updatePolicies(this.namespaceName, policies -> {
                policies.subscription_auth_mode = authMode;
                return policies;
            });
            log.info("[{}] Successfully updated subscription auth mode: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, this.objectWriter().writeValueAsString((Object)authMode)});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update subscription auth mode for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalModifyEncryptionRequired(boolean encryptionRequired) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ENCRYPTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            this.updatePolicies(this.namespaceName, policies -> {
                policies.encryption_required = encryptionRequired;
                return policies;
            });
            log.info("[{}] Successfully {} on namespace {}", new Object[]{this.clientAppId(), encryptionRequired ? "true" : "false", this.namespaceName});
        }
        catch (Exception e) {
            log.error("[{}] Failed to modify encryption required status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Boolean internalGetEncryptionRequired() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ENCRYPTION, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.encryption_required;
    }

    protected void internalSetInactiveTopic(InactiveTopicPolicies inactiveTopicPolicies) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.INACTIVE_TOPIC, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.internalSetPolicies("inactive_topic_policies", inactiveTopicPolicies);
    }

    protected void internalSetPolicies(String fieldName, Object value) {
        try {
            Policies policies = (Policies)this.namespaceResources().getPolicies(this.namespaceName).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist"));
            Field field = Policies.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(policies, value);
            this.namespaceResources().setPolicies(this.namespaceName, p -> policies);
            log.info("[{}] Successfully updated {} configuration: namespace={}, value={}", new Object[]{this.clientAppId(), fieldName, this.namespaceName, this.objectWriter().writeValueAsString(value)});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update {} configuration for namespace {}", new Object[]{this.clientAppId(), fieldName, this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetDelayedDelivery(DelayedDeliveryPolicies delayedDeliveryPolicies) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        this.internalSetPolicies("delayed_delivery_policies", delayedDeliveryPolicies);
    }

    protected void internalSetNamespaceAntiAffinityGroup(String antiAffinityGroup) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.WRITE);
        this.checkNotNull(antiAffinityGroup, "AntiAffinityGroup should not be null");
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Setting anti-affinity group {} for {}", new Object[]{this.clientAppId(), antiAffinityGroup, this.namespaceName});
        if (StringUtils.isBlank((CharSequence)antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "antiAffinityGroup can't be empty");
        }
        try {
            this.getLocalPolicies().setLocalPoliciesWithCreate(this.namespaceName, lp -> lp.map(policies -> new LocalPolicies(policies.bundles, policies.bookieAffinityGroup, antiAffinityGroup, policies.migrated)).orElseGet(() -> new LocalPolicies(PoliciesUtil.defaultBundle(), null, antiAffinityGroup)));
            log.info("[{}] Successfully updated local-policies configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, antiAffinityGroup});
        }
        catch (Exception e) {
            log.error("[{}] Failed to update local-policy configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected String internalGetNamespaceAntiAffinityGroup() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.READ);
        try {
            return this.getLocalPolicies().getLocalPolicies((NamespaceName)this.namespaceName).orElseGet((Supplier<LocalPolicies>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$internalGetNamespaceAntiAffinityGroup$202(), ()Lorg/apache/pulsar/common/policies/data/LocalPolicies;)((NamespacesBase)this)).namespaceAntiAffinityGroup;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get the antiAffinityGroup of namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(Response.Status.NOT_FOUND, "Couldn't find namespace policies");
        }
    }

    protected void internalRemoveNamespaceAntiAffinityGroup() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Deleting anti-affinity group for {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        try {
            this.getLocalPolicies().setLocalPolicies(this.namespaceName, policies -> new LocalPolicies(policies.bundles, policies.bookieAffinityGroup, null, policies.migrated));
            log.info("[{}] Successfully removed anti-affinity group for a namespace={}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove anti-affinity group for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected List<String> internalGetAntiAffinityNamespaces(String cluster, String antiAffinityGroup, String tenant) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.READ);
        this.checkNotNull(cluster, "Cluster should not be null");
        this.checkNotNull(antiAffinityGroup, "AntiAffinityGroup should not be null");
        this.checkNotNull(tenant, "Tenant should not be null");
        log.info("[{}]-{} Finding namespaces for {} in {}", new Object[]{this.clientAppId(), tenant, antiAffinityGroup, cluster});
        if (StringUtils.isBlank((CharSequence)antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "anti-affinity group can't be empty.");
        }
        this.validateClusterExists(cluster);
        try {
            List namespaces = this.tenantResources().getListOfNamespaces(tenant);
            return namespaces.stream().filter(ns -> {
                Optional policies;
                try {
                    policies = this.getLocalPolicies().getLocalPolicies(NamespaceName.get((String)ns));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                String storedAntiAffinityGroup = policies.orElseGet((Supplier<LocalPolicies>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$internalGetAntiAffinityNamespaces$204(), ()Lorg/apache/pulsar/common/policies/data/LocalPolicies;)((NamespacesBase)this)).namespaceAntiAffinityGroup;
                return antiAffinityGroup.equalsIgnoreCase(storedAntiAffinityGroup);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn("Failed to list of properties/namespace from global-zk", (Throwable)e);
            throw new RestException(e);
        }
    }

    private boolean checkQuotas(Policies policies, RetentionPolicies retention) {
        Map backlogQuotaMap = policies.backlog_quota_map;
        if (backlogQuotaMap.isEmpty()) {
            return true;
        }
        BacklogQuota quota = (BacklogQuota)backlogQuotaMap.get(BacklogQuota.BacklogQuotaType.destination_storage);
        return this.checkBacklogQuota(quota, retention);
    }

    private void clearBacklog(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            if (subscription != null) {
                if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                    subscription = PersistentReplicator.getRemoteCluster(subscription);
                }
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic) || this.pulsar().getBrokerService().isSystemTopic(TopicName.get((String)topic.getName()))) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog(subscription));
                }
            } else {
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic) || this.pulsar().getBrokerService().isSystemTopic(TopicName.get((String)topic.getName()))) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog());
                }
            }
            FutureUtil.waitForAll(futures).get();
        }
        catch (Exception e) {
            log.error("[{}] Failed to clear backlog for namespace {}/{}, subscription: {}", new Object[]{this.clientAppId(), nsName.toString(), bundleRange, subscription, e});
            throw new RestException(e);
        }
    }

    private void unsubscribe(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot unsubscribe a replication cursor");
            }
            for (Topic topic : topicList) {
                Subscription sub = topic.getSubscription(subscription);
                if (sub == null) continue;
                futures.add(sub.delete());
            }
            FutureUtil.waitForAll(futures).get();
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to unsubscribe {} for namespace {}/{}", new Object[]{this.clientAppId(), subscription, nsName.toString(), bundleRange, e});
            if (e.getCause() instanceof BrokerServiceException.SubscriptionBusyException) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers");
            }
            throw new RestException(e.getCause());
        }
    }

    protected BundlesData validateBundlesData(BundlesData initialBundles) {
        TreeSet<String> partitions = new TreeSet<String>();
        for (String partition : initialBundles.getBoundaries()) {
            Long partBoundary = Long.decode(partition);
            partitions.add(String.format("0x%08x", partBoundary));
        }
        if (partitions.size() != initialBundles.getBoundaries().size() && log.isDebugEnabled()) {
            log.debug("Input bundles included repeated partition points. Ignored.");
        }
        try {
            NamespaceBundleFactory.validateFullRange(partitions);
        }
        catch (IllegalArgumentException iae) {
            throw new RestException(Response.Status.BAD_REQUEST, "Input bundles do not cover the whole hash range. first:" + (String)partitions.first() + ", last:" + (String)partitions.last());
        }
        ArrayList<String> bundles = new ArrayList<String>();
        bundles.addAll(partitions);
        return BundlesData.builder().boundaries(bundles).numBundles(bundles.size() - 1).build();
    }

    private CompletableFuture<Void> validatePoliciesAsync(NamespaceName ns, Policies policies) {
        if (ns.isV2() && policies.replication_clusters.isEmpty()) {
            policies.replication_clusters = Collections.singleton(this.config().getClusterName());
        }
        return policies.replication_clusters.stream().map(cluster -> this.validateClusterForTenantAsync(ns.getTenant(), (String)cluster)).reduce(CompletableFuture.completedFuture(null), (a, b) -> a.thenCompose(ignore -> b)).thenAccept(__ -> {
            if (policies.message_ttl_in_seconds != null && policies.message_ttl_in_seconds < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL");
            }
            if (policies.bundles != null && policies.bundles.getNumBundles() > 0) {
                policies.bundles = policies.bundles.getBoundaries() == null || policies.bundles.getBoundaries().size() == 0 ? PoliciesUtil.getBundles((int)policies.bundles.getNumBundles()) : this.validateBundlesData(policies.bundles);
            } else {
                int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
                policies.bundles = PoliciesUtil.getBundles((int)defaultNumberOfBundles);
            }
            if (policies.persistence != null) {
                this.validatePersistencePolicies(policies.persistence);
            }
            if (policies.retention_policies != null) {
                this.validateRetentionPolicies(policies.retention_policies);
            }
        });
    }

    protected void internalSetDeduplicationSnapshotInterval(Integer interval) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DEDUPLICATION_SNAPSHOT, PolicyOperation.WRITE);
        if (interval != null && interval < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "interval must be greater than or equal to 0");
        }
        this.internalSetPolicies("deduplicationSnapshotIntervalSeconds", interval);
    }

    protected void internalSetMaxProducersPerTopic(Integer maxProducersPerTopic) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_PRODUCERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (maxProducersPerTopic != null && maxProducersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxProducersPerTopic must be 0 or more");
            }
            this.updatePolicies(this.namespaceName, policies -> {
                policies.max_producers_per_topic = maxProducersPerTopic;
                return policies;
            });
            log.info("[{}] Successfully updated maxProducersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxProducersPerTopic});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxProducersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Boolean> internalGetDeduplicationAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.DEDUPLICATION, PolicyOperation.READ).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> policies.deduplicationEnabled);
    }

    protected void internalSetMaxConsumersPerTopic(Integer maxConsumersPerTopic) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (maxConsumersPerTopic != null && maxConsumersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerTopic must be 0 or more");
            }
            this.updatePolicies(this.namespaceName, policies -> {
                policies.max_consumers_per_topic = maxConsumersPerTopic;
                return policies;
            });
            log.info("[{}] Successfully updated maxConsumersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxConsumersPerTopic});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetMaxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (maxConsumersPerSubscription != null && maxConsumersPerSubscription < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerSubscription must be 0 or more");
            }
            this.updatePolicies(this.namespaceName, policies -> {
                policies.max_consumers_per_subscription = maxConsumersPerSubscription;
                return policies;
            });
            log.info("[{}] Successfully updated maxConsumersPerSubscription configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxConsumersPerSubscription});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetMaxUnackedMessagesPerConsumer(Integer maxUnackedMessagesPerConsumer) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (maxUnackedMessagesPerConsumer != null && maxUnackedMessagesPerConsumer < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedMessagesPerConsumer must be 0 or more");
        }
        try {
            this.updatePolicies(this.namespaceName, policies -> {
                policies.max_unacked_messages_per_consumer = maxUnackedMessagesPerConsumer;
                return policies;
            });
            log.info("[{}] Successfully updated maxUnackedMessagesPerConsumer configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxUnackedMessagesPerConsumer});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxUnackedMessagesPerConsumer configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetMaxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_SUBSCRIPTIONS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (maxSubscriptionsPerTopic != null && maxSubscriptionsPerTopic < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxSubscriptionsPerTopic must be 0 or more");
        }
        this.internalSetPolicies("max_subscriptions_per_topic", maxSubscriptionsPerTopic);
    }

    protected void internalSetMaxUnackedMessagesPerSubscription(Integer maxUnackedMessagesPerSubscription) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (maxUnackedMessagesPerSubscription != null && maxUnackedMessagesPerSubscription < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedMessagesPerSubscription must be 0 or more");
        }
        try {
            this.updatePolicies(this.namespaceName, policies -> {
                policies.max_unacked_messages_per_subscription = maxUnackedMessagesPerSubscription;
                return policies;
            });
            log.info("[{}] Successfully updated maxUnackedMessagesPerSubscription configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, maxUnackedMessagesPerSubscription});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxUnackedMessagesPerSubscription configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetCompactionThreshold(Long newThreshold) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.COMPACTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            if (newThreshold != null && newThreshold < 0L) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "compactionThreshold must be 0 or more");
            }
            this.updatePolicies(this.namespaceName, policies -> {
                policies.compaction_threshold = newThreshold;
                return policies;
            });
            log.info("[{}] Successfully updated compactionThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, newThreshold});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update compactionThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetOffloadThreshold(long newThreshold) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            this.updatePolicies(this.namespaceName, policies -> {
                if (policies.offload_policies == null) {
                    policies.offload_policies = new OffloadPoliciesImpl();
                }
                ((OffloadPoliciesImpl)policies.offload_policies).setManagedLedgerOffloadThresholdInBytes(Long.valueOf(newThreshold));
                policies.offload_threshold = newThreshold;
                return policies;
            });
            log.info("[{}] Successfully updated offloadThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, newThreshold});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Void> internalSetOffloadThresholdInSecondsAsync(long newThreshold) {
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE).thenCompose(v -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(v -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            if (policies.offload_policies == null) {
                policies.offload_policies = new OffloadPoliciesImpl();
            }
            ((OffloadPoliciesImpl)policies.offload_policies).setManagedLedgerOffloadThresholdInSeconds(Long.valueOf(newThreshold));
            policies.offload_threshold_in_seconds = newThreshold;
            return policies;
        }))).thenAccept(v -> {
            log.info("[{}] Successfully updated offloadThresholdInSeconds configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, newThreshold});
            f.complete(null);
        })).exceptionally(t -> {
            Throwable cause = FutureUtil.unwrapCompletionException((Throwable)t);
            log.error("[{}] Failed to update offloadThresholdInSeconds configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, t});
            f.completeExceptionally((Throwable)((Object)new RestException(cause)));
            return null;
        });
        return f;
    }

    protected void internalSetOffloadDeletionLag(Long newDeletionLagMs) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            this.updatePolicies(this.namespaceName, policies -> {
                if (policies.offload_policies == null) {
                    policies.offload_policies = new OffloadPoliciesImpl();
                }
                ((OffloadPoliciesImpl)policies.offload_policies).setManagedLedgerOffloadDeletionLagInMillis(newDeletionLagMs);
                policies.offload_deletion_lag_ms = newDeletionLagMs;
                return policies;
            });
            log.info("[{}] Successfully updated offloadDeletionLagMs configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, newDeletionLagMs});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadDeletionLag configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    @Deprecated
    protected SchemaAutoUpdateCompatibilityStrategy internalGetSchemaAutoUpdateCompatibilityStrategy() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).schema_auto_update_compatibility_strategy;
    }

    @Deprecated
    protected void internalSetSchemaAutoUpdateCompatibilityStrategy(SchemaAutoUpdateCompatibilityStrategy strategy) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_auto_update_compatibility_strategy = strategy;
            return policies;
        }, policies -> policies.schema_auto_update_compatibility_strategy, "schemaAutoUpdateCompatibilityStrategy");
    }

    protected void internalSetSchemaCompatibilityStrategy(SchemaCompatibilityStrategy strategy) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_compatibility_strategy = strategy;
            return policies;
        }, policies -> policies.schema_compatibility_strategy, "schemaCompatibilityStrategy");
    }

    protected void internalSetSchemaValidationEnforced(boolean schemaValidationEnforced) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_validation_enforced = schemaValidationEnforced;
            return policies;
        }, policies -> policies.schema_validation_enforced, "schemaValidationEnforced");
    }

    protected void internalSetIsAllowAutoUpdateSchema(boolean isAllowAutoUpdateSchema) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.is_allow_auto_update_schema = isAllowAutoUpdateSchema;
            return policies;
        }, policies -> policies.is_allow_auto_update_schema, "isAllowAutoUpdateSchema");
    }

    protected void internalSetSubscriptionTypesEnabled(Set<SubscriptionType> subscriptionTypesEnabled) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SUBSCRIPTION_AUTH_MODE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        HashSet subTypes = new HashSet();
        subscriptionTypesEnabled.forEach(subscriptionType -> subTypes.add(subscriptionType.name()));
        this.mutatePolicy(policies -> {
            policies.subscription_types_enabled = subTypes;
            return policies;
        }, policies -> policies.subscription_types_enabled, "subscriptionTypesEnabled");
    }

    private <T> void mutatePolicy(Function<Policies, Policies> policyTransformation, Function<Policies, T> getter, String policyName) {
        try {
            MutableObject exception = new MutableObject(null);
            MutableObject policiesObj = new MutableObject(null);
            this.updatePolicies(this.namespaceName, policies -> {
                try {
                    policies = (Policies)policyTransformation.apply((Policies)policies);
                }
                catch (Exception e) {
                    exception.setValue((Object)e);
                }
                policiesObj.setValue(policies);
                return policies;
            });
            if (exception.getValue() != null) {
                throw (Exception)exception.getValue();
            }
            log.info("[{}] Successfully updated {} configuration: namespace={}, value={}", new Object[]{this.clientAppId(), policyName, this.namespaceName, getter.apply((Policies)policiesObj.getValue())});
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update {} configuration for namespace {}", new Object[]{this.clientAppId(), policyName, this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetOffloadPolicies(AsyncResponse asyncResponse, OffloadPoliciesImpl offloadPolicies) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.validateOffloadPolicies(offloadPolicies);
        try {
            ((CompletableFuture)this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
                if (Objects.equals(offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis(), OffloadPoliciesImpl.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS)) {
                    offloadPolicies.setManagedLedgerOffloadDeletionLagInMillis(policies.offload_deletion_lag_ms);
                } else {
                    policies.offload_deletion_lag_ms = offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis();
                }
                if (Objects.equals(offloadPolicies.getManagedLedgerOffloadThresholdInBytes(), OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES)) {
                    offloadPolicies.setManagedLedgerOffloadThresholdInBytes(Long.valueOf(policies.offload_threshold));
                } else {
                    policies.offload_threshold = offloadPolicies.getManagedLedgerOffloadThresholdInBytes();
                }
                policies.offload_policies = offloadPolicies;
                return policies;
            }).thenApply(r -> {
                log.info("[{}] Successfully updated offload configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, offloadPolicies});
                asyncResponse.resume((Object)Response.noContent().build());
                return null;
            })).exceptionally(e -> {
                log.error("[{}] Failed to update offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("[{}] Failed to update offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e2});
            asyncResponse.resume((Throwable)((Object)(e2.getCause() instanceof MetadataStoreException.NotFoundException ? new RestException(Response.Status.CONFLICT, "Concurrent modification") : new RestException(e2))));
        }
    }

    protected void internalRemoveOffloadPolicies(AsyncResponse asyncResponse) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            ((CompletableFuture)this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
                policies.offload_policies = null;
                return policies;
            }).thenApply(r -> {
                log.info("[{}] Successfully remove offload configuration: namespace={}", (Object)this.clientAppId(), (Object)this.namespaceName);
                asyncResponse.resume((Object)Response.noContent().build());
                return null;
            })).exceptionally(e -> {
                log.error("[{}] Failed to remove offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume((Throwable)((Object)(e.getCause() instanceof MetadataStoreException.NotFoundException ? new RestException(Response.Status.CONFLICT, "Concurrent modification") : new RestException((Throwable)e))));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("[{}] Failed to remove offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e2});
            asyncResponse.resume((Throwable)((Object)new RestException(e2)));
        }
    }

    protected void internalRemoveMaxTopicsPerNamespace() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_TOPICS, PolicyOperation.WRITE);
        this.internalSetMaxTopicsPerNamespace(null);
    }

    protected void internalSetMaxTopicsPerNamespace(Integer maxTopicsPerNamespace) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_TOPICS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (maxTopicsPerNamespace != null && maxTopicsPerNamespace < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxTopicsPerNamespace must be 0 or more");
        }
        this.internalSetPolicies("max_topics_per_namespace", maxTopicsPerNamespace);
    }

    protected void internalSetProperty(String key, String value, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.properties.put(key, value);
            return policies;
        }))).thenAccept(v -> {
            log.info("[{}] Successfully set property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to set property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalSetProperties(Map<String, String> properties, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.properties.putAll(properties);
            return policies;
        }))).thenAccept(v -> {
            log.info("[{}] Successfully set {} properties on namespace {}", new Object[]{this.clientAppId(), properties.size(), this.namespaceName});
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to set {} properties on namespace {}", new Object[]{this.clientAppId(), properties.size(), this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalGetProperty(String key, AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume(policies.properties.get(key)))).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to get property for key {} of namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalGetProperties(AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenAccept(policies -> asyncResponse.resume((Object)policies.properties))).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to get properties of namespace {}", new Object[]{this.clientAppId(), this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalRemoveProperty(String key, AsyncResponse asyncResponse) {
        AtomicReference<Object> oldVal = new AtomicReference<Object>(null);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            oldVal.set(((String)policies.properties.remove(key)));
            return policies;
        }))).thenAccept(v -> {
            asyncResponse.resume(oldVal.get());
            log.info("[{}] Successfully remove property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName});
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to remove property for key {} on namespace {}", new Object[]{this.clientAppId(), key, this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    protected void internalClearProperties(AsyncResponse asyncResponse) {
        AtomicReference<Integer> clearedCount = new AtomicReference<Integer>(0);
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateAdminAccessForTenantAsync(this.namespaceName.getTenant()).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            clearedCount.set(policies.properties.size());
            policies.properties.clear();
            return policies;
        }))).thenAccept(v -> {
            asyncResponse.resume((Object)Response.noContent().build());
            log.info("[{}] Successfully clear {} properties on namespace {}", new Object[]{this.clientAppId(), clearedCount.get(), this.namespaceName});
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            log.error("[{}] Failed to clear {} properties on namespace {}", new Object[]{this.clientAppId(), clearedCount.get(), this.namespaceName, cause});
            asyncResponse.resume(cause);
            return null;
        });
    }

    private CompletableFuture<Void> updatePoliciesAsync(NamespaceName ns, Function<Policies, Policies> updateFunction) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.namespaceResources().setPoliciesAsync(ns, updateFunction).thenAccept(v -> {
            log.info("[{}] Successfully updated the policies on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            result.complete(null);
        })).exceptionally(ex -> {
            Throwable cause = ex.getCause();
            if (cause instanceof MetadataStoreException.NotFoundException) {
                result.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
            } else if (cause instanceof MetadataStoreException.BadVersionException) {
                log.warn("[{}] Failed to update the replication clusters on namespace {} : concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
                result.completeExceptionally((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
            } else {
                log.error("[{}] Failed to update namespace policies {}", new Object[]{this.clientAppId(), this.namespaceName, cause});
                result.completeExceptionally((Throwable)((Object)new RestException(cause)));
            }
            return null;
        });
        return result;
    }

    private void updatePolicies(NamespaceName ns, Function<Policies, Policies> updateFunction) {
        try {
            this.updatePoliciesAsync(ns, updateFunction).get(this.namespaceResources().getOperationTimeoutSec(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof RestException)) {
                throw new RestException(cause);
            }
            throw (RestException)((Object)cause);
        }
    }

    protected void internalSetNamespaceResourceGroup(String rgName) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RESOURCEGROUP, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (rgName != null) {
            try {
                if (!this.resourceGroupResources().resourceGroupExists(rgName)) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "ResourceGroup does not exist");
                }
            }
            catch (Exception e) {
                log.error("[{}] Invalid ResourceGroup {}: {}", new Object[]{this.clientAppId(), rgName, e});
                throw new RestException(e);
            }
        }
        this.internalSetPolicies("resource_group_name", rgName);
    }

    protected void internalScanOffloadedLedgers(OffloaderObjectsScannerUtils.ScannerResultSink sink) throws Exception {
        log.info("internalScanOffloadedLedgers {}", (Object)this.namespaceName);
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        LedgerOffloader managedLedgerOffloader = this.pulsar().getManagedLedgerOffloader(this.namespaceName, (OffloadPoliciesImpl)policies.offload_policies);
        String localClusterName = this.pulsar().getConfiguration().getClusterName();
        OffloaderObjectsScannerUtils.scanOffloadedLedgers(managedLedgerOffloader, localClusterName, this.pulsar().getDefaultManagedLedgerFactory(), sink);
    }

    protected CompletableFuture<Void> internalSetEntryFiltersPerTopicAsync(EntryFilters entryFilters) {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.ENTRY_FILTERS, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenAccept(__ -> this.validateEntryFilters(entryFilters))).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.entryFilters = entryFilters;
            return policies;
        }));
    }

    protected void internalSetReplicatorDispatchRate(AsyncResponse asyncResponse, DispatchRateImpl dispatchRate) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.REPLICATION_RATE, PolicyOperation.WRITE).thenAccept(__ -> log.info("[{}] Set namespace replicator dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate}))).thenCompose(__ -> this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
            String clusterName = this.pulsar().getConfiguration().getClusterName();
            policies.replicatorDispatchRate.put(clusterName, dispatchRate);
            return policies;
        }))).thenAccept(__ -> {
            asyncResponse.resume((Object)Response.noContent().build());
            log.info("[{}] Successfully updated the replicatorDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        })).exceptionally(ex -> {
            NamespacesBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            log.error("[{}] Failed to update the replicatorDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            return null;
        });
    }

    protected void internalGetReplicatorDispatchRate(AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.REPLICATION_RATE, PolicyOperation.READ).thenCompose(__ -> this.namespaceResources().getPoliciesAsync(this.namespaceName))).thenApply(policiesOpt -> {
            if (!policiesOpt.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist");
            }
            String clusterName = this.pulsar().getConfiguration().getClusterName();
            return (DispatchRateImpl)((Policies)policiesOpt.get()).replicatorDispatchRate.get(clusterName);
        })).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            NamespacesBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            log.error("[{}] Failed to get replicator dispatch-rate configured for the namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            return null;
        });
    }

    protected void internalRemoveReplicatorDispatchRate(AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.REPLICATION_RATE, PolicyOperation.WRITE).thenCompose(__ -> this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
            String clusterName = this.pulsar().getConfiguration().getClusterName();
            policies.replicatorDispatchRate.remove(clusterName);
            return policies;
        }))).thenAccept(__ -> {
            asyncResponse.resume((Object)Response.noContent().build());
            log.info("[{}] Successfully delete the replicatorDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        })).exceptionally(ex -> {
            NamespacesBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            log.error("[{}] Failed to delete the replicatorDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            return null;
        });
    }

    protected void internalGetBacklogQuotaMap(AsyncResponse asyncResponse) {
        ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.BACKLOG, PolicyOperation.READ).thenCompose(__ -> this.namespaceResources().getPoliciesAsync(this.namespaceName))).thenAccept(policiesOpt -> {
            Map backlogQuotaMap = ((Policies)policiesOpt.orElseThrow((Supplier<RestException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$internalGetBacklogQuotaMap$288(), ()Lorg/apache/pulsar/broker/web/RestException;)())).backlog_quota_map;
            asyncResponse.resume((Object)backlogQuotaMap);
        })).exceptionally(ex -> {
            NamespacesBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            log.error("[{}] Failed to get backlog quota map on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            return null;
        });
    }

    protected void internalSetBacklogQuota(AsyncResponse asyncResponse, BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.BACKLOG, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.setBacklogQuotaAsync(backlogQuotaType, backlogQuota))).thenAccept(__ -> {
            asyncResponse.resume((Object)Response.noContent().build());
            log.info("[{}] Successfully updated backlog quota map: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, backlogQuota});
        })).exceptionally(ex -> {
            NamespacesBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            return null;
        });
    }

    protected void internalRemoveBacklogQuota(AsyncResponse asyncResponse, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.BACKLOG, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.namespaceResources().setPoliciesAsync(this.namespaceName, policies -> {
            BacklogQuota.BacklogQuotaType quotaType = backlogQuotaType != null ? backlogQuotaType : BacklogQuota.BacklogQuotaType.destination_storage;
            policies.backlog_quota_map.remove(quotaType);
            return policies;
        }))).thenAccept(__ -> {
            asyncResponse.resume((Object)Response.noContent().build());
            log.info("[{}] Successfully removed backlog namespace={}, quota={}", new Object[]{this.clientAppId(), this.namespaceName, backlogQuotaType});
        })).exceptionally(ex -> {
            NamespacesBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            return null;
        });
    }

    protected void internalEnableMigration(boolean migrated) {
        this.validateSuperUserAccess();
        try {
            this.getLocalPolicies().setLocalPoliciesWithCreate(this.namespaceName, oldPolicies -> oldPolicies.map(policies -> new LocalPolicies(policies.bundles, policies.bookieAffinityGroup, policies.namespaceAntiAffinityGroup, migrated)).orElseGet(() -> new LocalPolicies(PoliciesUtil.getBundles((int)this.config().getDefaultNumberOfNamespaceBundles()), null, null, migrated)));
            log.info("Successfully updated migration on namespace {}", (Object)this.namespaceName);
        }
        catch (Exception e) {
            log.error("Failed to update migration on namespace {}", (Object)this.namespaceName, (Object)e);
            throw new RestException(e);
        }
    }

    protected Policies getDefaultPolicesIfNull(Policies policies) {
        if (policies == null) {
            policies = new Policies();
        }
        int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
        if (policies.bundles == null) {
            policies.bundles = PoliciesUtil.getBundles((int)defaultNumberOfBundles);
        }
        return policies;
    }

    protected CompletableFuture<Void> internalSetDispatcherPauseOnAckStatePersistentAsync(boolean dispatcherPauseOnAckStatePersistentEnabled) {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.DISPATCHER_PAUSE_ON_ACK_STATE_PERSISTENT, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.dispatcherPauseOnAckStatePersistentEnabled = dispatcherPauseOnAckStatePersistentEnabled;
            return policies;
        }));
    }

    protected CompletableFuture<Boolean> internalGetDispatcherPauseOnAckStatePersistentAsync() {
        return ((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.DISPATCHER_PAUSE_ON_ACK_STATE_PERSISTENT, PolicyOperation.READ).thenCompose(__ -> this.namespaceResources().getPoliciesAsync(this.namespaceName))).thenApply(policiesOpt -> {
            if (!policiesOpt.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist");
            }
            return policiesOpt.map(p -> p.dispatcherPauseOnAckStatePersistentEnabled).orElse(false);
        });
    }

    protected CompletableFuture<Void> internalSetNamespaceAllowedClusters(List<String> clusterIds) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.ALLOW_CLUSTERS, PolicyOperation.WRITE).thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> FutureUtil.waitForAll((Collection)clusterIds.stream().map(clusterId -> this.validateClusterForTenantAsync(this.namespaceName.getTenant(), (String)clusterId)).collect(Collectors.toList())))).thenCompose(__ -> {
            this.checkNotNull(clusterIds, "ClusterIds should not be null");
            if (clusterIds.contains("global")) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot specify global in the list of allowed clusters");
            }
            return this.getNamespacePoliciesAsync(this.namespaceName).thenApply(namespacePolicies -> {
                namespacePolicies.replication_clusters.forEach(replicationCluster -> {
                    if (!clusterIds.contains(replicationCluster)) {
                        throw new RestException(Response.Status.BAD_REQUEST, String.format("Allowed clusters do not contain the replication cluster %s. Please remove the replication cluster if the cluster is not allowed for this namespace", replicationCluster));
                    }
                });
                return Sets.newHashSet((Iterable)clusterIds);
            });
        })).thenCompose(allowedClusters -> this.clustersAsync().thenCompose(clusters -> {
            List futures = allowedClusters.stream().map(clusterId -> {
                if (!clusters.contains(clusterId)) {
                    throw new RestException(Response.Status.FORBIDDEN, "Invalid cluster id: " + clusterId);
                }
                return this.validatePeerClusterConflictAsync((String)clusterId, (Set<String>)allowedClusters);
            }).collect(Collectors.toList());
            return FutureUtil.waitForAll(futures).thenApply(__ -> allowedClusters);
        }))).thenCompose(allowedClusterSet -> this.updatePoliciesAsync(this.namespaceName, policies -> {
            policies.allowed_clusters = allowedClusterSet;
            return policies;
        }));
    }

    protected CompletableFuture<Set<String>> internalGetNamespaceAllowedClustersAsync() {
        return ((CompletableFuture)((CompletableFuture)this.validateNamespacePolicyOperationAsync(this.namespaceName, PolicyName.ALLOW_CLUSTERS, PolicyOperation.READ).thenAccept(__ -> {
            if (!this.namespaceName.isGlobal()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot get the allowed clusters for a non-global namespace");
            }
        })).thenCompose(__ -> this.getNamespacePoliciesAsync(this.namespaceName))).thenApply(policies -> policies.allowed_clusters);
    }

    private static /* synthetic */ RestException lambda$internalGetBacklogQuotaMap$288() {
        return new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
    }

    private /* synthetic */ LocalPolicies lambda$internalGetAntiAffinityNamespaces$204() {
        return new LocalPolicies(PoliciesUtil.getBundles((int)this.config().getDefaultNumberOfNamespaceBundles()), null, null);
    }

    private /* synthetic */ LocalPolicies lambda$internalGetNamespaceAntiAffinityGroup$202() {
        return new LocalPolicies(PoliciesUtil.getBundles((int)this.config().getDefaultNumberOfNamespaceBundles()), null, null);
    }

    private static /* synthetic */ RestException lambda$internalGetBookieAffinityGroup$123() {
        return new RestException(Response.Status.NOT_FOUND, "Namespace local-policies does not exist");
    }
}

