/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;

public interface Replicator {
    public void startProducer();

    public Topic getLocalTopic();

    public ReplicatorStatsImpl computeStats();

    public CompletableFuture<Void> terminate();

    public CompletableFuture<Void> disconnect(boolean var1, boolean var2);

    public void updateRates();

    public String getRemoteCluster();

    default public void initializeDispatchRateLimiterIfNeeded() {
    }

    default public void updateRateLimiter() {
    }

    default public Optional<DispatchRateLimiter> getRateLimiter() {
        return Optional.empty();
    }

    public boolean isConnected();

    public long getNumberOfEntriesInBacklog();

    public boolean isTerminated();

    public ReplicatorStatsImpl getStats();
}

