/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.util.ShutdownUtil;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.apache.pulsar.functions.worker.Worker;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class FunctionWorkerStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FunctionWorkerStarter.class);

    public static void main(String[] args) throws Exception {
        WorkerArguments workerArguments = new WorkerArguments();
        CommandLine commander = new CommandLine((Object)workerArguments);
        commander.setCommandName("FunctionWorkerStarter");
        commander.parseArgs(args);
        if (workerArguments.help) {
            commander.usage(commander.getOut());
            return;
        }
        if (workerArguments.generateDocs) {
            CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
            cmd.addCommand("functions-worker", (Object)commander);
            cmd.run(null);
            return;
        }
        WorkerConfig workerConfig = StringUtils.isBlank((CharSequence)workerArguments.configFile) ? new WorkerConfig() : WorkerConfig.load((String)workerArguments.configFile);
        Worker worker = new Worker(workerConfig);
        try {
            worker.start();
        }
        catch (Throwable th) {
            log.error("Encountered error in function worker.", th);
            worker.stop();
            ShutdownUtil.triggerImmediateForcefulShutdown();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Stopping function worker service...");
            worker.stop();
        }));
    }

    @CommandLine.Command(name="functions-worker", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
    private static class WorkerArguments {
        @CommandLine.Option(names={"-c", "--conf"}, description={"Configuration File for Function Worker"})
        private String configFile;
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message"})
        private boolean help = false;
        @CommandLine.Option(names={"-g", "--generate-docs"}, description={"Generate docs"})
        private boolean generateDocs = false;

        private WorkerArguments() {
        }
    }
}

