/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.socket.client;

import com.google.common.util.concurrent.RateLimiter;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.proxy.socket.client.SimpleTestProducerSocket;
import org.apache.pulsar.testclient.CmdBase;
import org.apache.pulsar.testclient.IMessageFormatter;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PositiveNumberParameterConvert;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="websocket-producer", description={"Test pulsar websocket producer performance."})
public class PerformanceClient
extends CmdBase {
    private static final LongAdder messagesSent = new LongAdder();
    private static final LongAdder bytesSent = new LongAdder();
    private static final LongAdder totalMessagesSent = new LongAdder();
    private static final LongAdder totalBytesSent = new LongAdder();
    private static IMessageFormatter messageFormatter = null;
    @CommandLine.Option(names={"-cf", "--conf-file"}, description={"Configuration file"})
    public String confFile;
    @CommandLine.Option(names={"-u", "--proxy-url"}, description={"Pulsar Proxy URL, e.g., \"ws://localhost:8080/\""})
    public String proxyURL;
    @CommandLine.Parameters(description={"persistent://tenant/ns/my-topic"}, arity="1")
    public List<String> topics;
    @CommandLine.Option(names={"-r", "--rate"}, description={"Publish rate msg/s across topics"})
    public int msgRate = 100;
    @CommandLine.Option(names={"-s", "--size"}, description={"Message size in byte"})
    public int msgSize = 1024;
    @CommandLine.Option(names={"-t", "--num-topic"}, description={"Number of topics"}, converter={PositiveNumberParameterConvert.class})
    public int numTopics = 1;
    @CommandLine.Option(names={"--auth_plugin"}, description={"Authentication plugin class name"}, hidden=true)
    public String deprecatedAuthPluginClassName;
    @CommandLine.Option(names={"--auth-plugin"}, description={"Authentication plugin class name"})
    public String authPluginClassName;
    @CommandLine.Option(names={"--auth-params"}, description={"Authentication parameters, whose format is determined by the implementation of method `configure` in authentication plugin class, for example \"key1:val1,key2:val2\" or \"{\"key1\":\"val1\",\"key2\":\"val2\"}\"."})
    public String authParams;
    @CommandLine.Option(names={"-m", "--num-messages"}, description={"Number of messages to publish in total. If <= 0, it will keep publishing"})
    public long numMessages = 0L;
    @CommandLine.Option(names={"-f", "--payload-file"}, description={"Use payload from a file instead of empty buffer"})
    public String payloadFilename = null;
    @CommandLine.Option(names={"-e", "--payload-delimiter"}, description={"The delimiter used to split lines when using payload from a file"})
    public String payloadDelimiter = "\\n";
    @CommandLine.Option(names={"-fp", "--format-payload"}, description={"Format %%i as a message index in the stream from producer and/or %%t as the timestamp nanoseconds"})
    public boolean formatPayload = false;
    @CommandLine.Option(names={"-fc", "--format-class"}, description={"Custom Formatter class name"})
    public String formatterClass = "org.apache.pulsar.testclient.DefaultMessageFormatter";
    @CommandLine.Option(names={"-time", "--test-duration"}, description={"Test duration in secs. If <= 0, it will keep publishing"})
    public long testTime = 0L;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    static final DecimalFormat THROUGHPUTFORMAT = new PaddingDecimalFormat("0.0", 8);
    static final DecimalFormat DEC = new PaddingDecimalFormat("0.000", 7);
    static final DecimalFormat TOTALFORMAT = new DecimalFormat("0.000");
    static final DecimalFormat INTFORMAT = new PaddingDecimalFormat("0", 7);
    private static final Logger log = LoggerFactory.getLogger(PerformanceClient.class);

    public PerformanceClient() {
        super("websocket-producer");
    }

    public void loadArguments() {
        CommandLine commander = this.spec.commandLine();
        if (StringUtils.isBlank((CharSequence)this.authPluginClassName) && !StringUtils.isBlank((CharSequence)this.deprecatedAuthPluginClassName)) {
            this.authPluginClassName = this.deprecatedAuthPluginClassName;
        }
        if (this.topics.size() != 1) {
            System.err.println("Only one topic name is allowed");
            commander.usage(commander.getOut());
            PerfClientUtils.exit(1);
        }
        if (this.confFile != null) {
            Properties prop = new Properties(System.getProperties());
            try {
                prop.load(new FileInputStream(this.confFile));
            }
            catch (IOException e) {
                log.error("Error in loading config file");
                commander.usage(commander.getOut());
                PerfClientUtils.exit(1);
            }
            if (StringUtils.isBlank((CharSequence)this.proxyURL)) {
                String webSocketServiceUrl = prop.getProperty("webSocketServiceUrl");
                if (StringUtils.isNotBlank((CharSequence)webSocketServiceUrl)) {
                    this.proxyURL = webSocketServiceUrl;
                } else {
                    String webServiceUrl;
                    String string = webServiceUrl = StringUtils.isNotBlank((CharSequence)prop.getProperty("webServiceUrl")) ? prop.getProperty("webServiceUrl") : prop.getProperty("serviceUrl");
                    if (StringUtils.isNotBlank((CharSequence)webServiceUrl)) {
                        if (webServiceUrl.startsWith("ws://") || webServiceUrl.startsWith("wss://")) {
                            this.proxyURL = webServiceUrl;
                        } else if (webServiceUrl.startsWith("http://") || webServiceUrl.startsWith("https://")) {
                            this.proxyURL = webServiceUrl.replaceFirst("^http", "ws");
                        }
                    }
                }
            }
            if (this.authPluginClassName == null) {
                this.authPluginClassName = prop.getProperty("authPlugin", null);
            }
            if (this.authParams == null) {
                this.authParams = prop.getProperty("authParams", null);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.proxyURL)) {
            this.proxyURL = "ws://localhost:8080/";
        }
        if (!this.proxyURL.endsWith("/")) {
            this.proxyURL = this.proxyURL + "/";
        }
    }

    public void runPerformanceTest() throws InterruptedException, IOException {
        byte[] payloadBytes = new byte[this.msgSize];
        Random random = new Random(0L);
        ArrayList<byte[]> payloadByteList = new ArrayList<byte[]>();
        if (this.payloadFilename != null) {
            Path payloadFilePath = Paths.get(this.payloadFilename, new String[0]);
            if (Files.notExists(payloadFilePath, new LinkOption[0]) || Files.size(payloadFilePath) == 0L) {
                throw new IllegalArgumentException("Payload file doesn't exist or it is empty.");
            }
            String delimiter = this.payloadDelimiter.equals("\\n") ? "\n" : this.payloadDelimiter;
            String[] payloadList = new String(Files.readAllBytes(payloadFilePath), StandardCharsets.UTF_8).split(delimiter);
            log.info("Reading payloads from {} and {} records read", (Object)payloadFilePath.toAbsolutePath(), (Object)payloadList.length);
            for (String payload : payloadList) {
                payloadByteList.add(payload.getBytes(StandardCharsets.UTF_8));
            }
            if (this.formatPayload) {
                messageFormatter = PerformanceClient.getMessageFormatter(this.formatterClass);
            }
        } else {
            for (int i = 0; i < payloadBytes.length; ++i) {
                payloadBytes[i] = (byte)(random.nextInt(26) + 65);
            }
        }
        ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("pulsar-perf-producer-exec"));
        HashMap<String, Tuple> producersMap = new HashMap<String, Tuple>();
        String topicName = this.topics.get(0);
        String restPath = TopicName.get((String)topicName).getRestPath();
        String produceBaseEndPoint = TopicName.get((String)topicName).isV2() ? this.proxyURL + "ws/v2/producer/" + restPath : this.proxyURL + "ws/producer/" + restPath;
        for (int i = 0; i < this.numTopics; ++i) {
            String topic = this.numTopics > 1 ? produceBaseEndPoint + i : produceBaseEndPoint;
            URI produceUri = URI.create(topic);
            WebSocketClient produceClient = new WebSocketClient(new SslContextFactory(true));
            ClientUpgradeRequest produceRequest = new ClientUpgradeRequest();
            if (StringUtils.isNotBlank((CharSequence)this.authPluginClassName) && StringUtils.isNotBlank((CharSequence)this.authParams)) {
                try {
                    Authentication auth = AuthenticationFactory.create((String)this.authPluginClassName, (String)this.authParams);
                    auth.start();
                    AuthenticationDataProvider authData = auth.getAuthData();
                    if (authData.hasDataForHttp()) {
                        for (Map.Entry kv : authData.getHttpHeaders()) {
                            produceRequest.setHeader((String)kv.getKey(), (String)kv.getValue());
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Authentication plugin error: " + e.getMessage());
                }
            }
            SimpleTestProducerSocket produceSocket = new SimpleTestProducerSocket();
            try {
                produceClient.start();
                produceClient.connect((Object)produceSocket, produceUri, produceRequest);
            }
            catch (IOException e1) {
                log.error("Fail in connecting: [{}]", (Object)e1.getMessage());
                return;
            }
            catch (Exception e1) {
                log.error("Fail in starting client[{}]", (Object)e1.getMessage());
                return;
            }
            producersMap.put(produceUri.toString(), new Tuple(produceClient, produceRequest, produceSocket));
        }
        TimeUnit.SECONDS.sleep(5L);
        executor.submit(() -> {
            try {
                RateLimiter rateLimiter = RateLimiter.create((double)this.msgRate);
                long startTime = System.nanoTime();
                long testEndTime = startTime + (long)((double)this.testTime * 1.0E9);
                long totalSent = 0L;
                block2: while (true) {
                    Iterator iterator = producersMap.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        String topic = (String)iterator.next();
                        if (this.testTime > 0L && System.nanoTime() > testEndTime) {
                            log.info("------------- DONE (reached the maximum duration: [{} seconds] of production) --------------", (Object)this.testTime);
                            PerfClientUtils.exit(0);
                        }
                        if (this.numMessages > 0L && totalSent >= this.numMessages) {
                            log.trace("------------- DONE (reached the maximum number: [{}] of production) --------------", (Object)this.numMessages);
                            Thread.sleep(10000L);
                            PerfClientUtils.exit(0);
                        }
                        rateLimiter.acquire();
                        if (((Tuple)producersMap.get(topic)).getSocket().getSession() == null) {
                            Thread.sleep(10000L);
                            PerfClientUtils.exit(0);
                        }
                        byte[] payloadData = this.payloadFilename != null ? (messageFormatter != null ? messageFormatter.formatMessage("", totalSent, (byte[])payloadByteList.get(random.nextInt(payloadByteList.size()))) : (byte[])payloadByteList.get(random.nextInt(payloadByteList.size()))) : payloadBytes;
                        ((Tuple)producersMap.get(topic)).getSocket().sendMsg(String.valueOf(totalSent++), payloadData);
                        messagesSent.increment();
                        bytesSent.add(payloadData.length);
                        totalMessagesSent.increment();
                        totalBytesSent.add(payloadData.length);
                    }
                    break;
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage());
                PerfClientUtils.exit(0);
                return;
            }
        });
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        String statsFileName = "perf-websocket-producer-" + System.currentTimeMillis() + ".hgrm";
        log.info("Dumping latency stats to {} \n", (Object)statsFileName);
        PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
        HistogramLogWriter histogramLogWriter = new HistogramLogWriter(histogramLog);
        histogramLogWriter.outputLogFormatVersion();
        histogramLogWriter.outputLegend();
        while (true) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            long total = totalMessagesSent.sum();
            double rate = (double)messagesSent.sumThenReset() / elapsed;
            double throughput = (double)bytesSent.sumThenReset() / elapsed / 1024.0 / 1024.0 * 8.0;
            reportHistogram = SimpleTestProducerSocket.recorder.getIntervalHistogram(reportHistogram);
            log.info("Throughput produced: {} msg --- {}  msg/s --- {} Mbit/s --- Latency: mean: {} ms - med: {} ms - 95pct: {} ms - 99pct: {} ms - 99.9pct: {} ms - 99.99pct: {} ms", new Object[]{INTFORMAT.format(total), THROUGHPUTFORMAT.format(rate), THROUGHPUTFORMAT.format(throughput), DEC.format(reportHistogram.getMean() / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0)});
            histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportHistogram);
            reportHistogram.reset();
            oldTime = now;
        }
        TimeUnit.SECONDS.sleep(100L);
        executor.shutdown();
    }

    static IMessageFormatter getMessageFormatter(String formatterClass) {
        try {
            ClassLoader classLoader = PerformanceClient.class.getClassLoader();
            Class<?> clz = classLoader.loadClass(formatterClass);
            return (IMessageFormatter)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void run() throws Exception {
        this.loadArguments();
        PerfClientUtils.printJVMInformation(log);
        long start = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            PerformanceClient.printAggregatedThroughput(start);
            PerformanceClient.printAggregatedStats();
        }));
        this.runPerformanceTest();
    }

    private static void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        double rate = (double)totalMessagesSent.sum() / elapsed;
        double throughput = (double)totalBytesSent.sum() / elapsed / 1024.0 / 1024.0 * 8.0;
        log.info("Aggregated throughput stats --- {} records sent --- {} msg/s --- {} Mbit/s", new Object[]{totalMessagesSent, TOTALFORMAT.format(rate), TOTALFORMAT.format(throughput)});
    }

    private static void printAggregatedStats() {
        Histogram reportHistogram = SimpleTestProducerSocket.recorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{DEC.format(reportHistogram.getMean()), reportHistogram.getValueAtPercentile(50.0), reportHistogram.getValueAtPercentile(95.0), reportHistogram.getValueAtPercentile(99.0), reportHistogram.getValueAtPercentile(99.9), reportHistogram.getValueAtPercentile(99.99), reportHistogram.getValueAtPercentile(99.999), reportHistogram.getMaxValue()});
    }

    private class Tuple {
        private WebSocketClient produceClient;
        private ClientUpgradeRequest produceRequest;
        private SimpleTestProducerSocket produceSocket;

        public Tuple(WebSocketClient produceClient, ClientUpgradeRequest produceRequest, SimpleTestProducerSocket produceSocket) {
            this.produceClient = produceClient;
            this.produceRequest = produceRequest;
            this.produceSocket = produceSocket;
        }

        public SimpleTestProducerSocket getSocket() {
            return this.produceSocket;
        }
    }
}

