/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.oxia;

import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreProvider;
import org.apache.pulsar.metadata.impl.oxia.OxiaMetadataStore;

public class OxiaMetadataStoreProvider
implements MetadataStoreProvider {
    public static final String DefaultNamespace = "default";
    public static final String OXIA_SCHEME = "oxia";
    public static final String OXIA_SCHEME_IDENTIFIER = "oxia:";

    @Override
    public String urlScheme() {
        return OXIA_SCHEME;
    }

    @Override
    @NonNull
    public MetadataStore create(String metadataURL, MetadataStoreConfig metadataStoreConfig, boolean enableSessionWatcher) throws MetadataStoreException {
        Pair<String, String> serviceAddress = this.getServiceAddressAndNamespace(metadataURL);
        try {
            return new OxiaMetadataStore((String)serviceAddress.getLeft(), (String)serviceAddress.getRight(), metadataStoreConfig, enableSessionWatcher);
        }
        catch (Exception e) {
            throw new MetadataStoreException(e);
        }
    }

    @NonNull
    Pair<String, String> getServiceAddressAndNamespace(String metadataURL) throws MetadataStoreException {
        if (metadataURL == null || !metadataURL.startsWith(this.urlScheme() + "://")) {
            throw new MetadataStoreException("Invalid metadata URL. Must start with 'oxia://'.");
        }
        String addressWithNamespace = metadataURL.substring("oxia://".length());
        String[] split = addressWithNamespace.split("/");
        if (split.length > 2) {
            throw new MetadataStoreException("Invalid metadata URL. the oxia metadata format should be 'oxia://host:port/[namespace]'.");
        }
        if (split.length == 1) {
            return Pair.of((Object)split[0], (Object)DefaultNamespace);
        }
        return Pair.of((Object)split[0], (Object)split[1]);
    }
}

