/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.RateLimiter;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedCursorMXBean;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ScanOutcome;
import org.apache.bookkeeper.mledger.impl.LedgerMetadataUtils;
import org.apache.bookkeeper.mledger.impl.ManagedCursorMXBeanImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.NonDurableCursorImpl;
import org.apache.bookkeeper.mledger.impl.OpFindNewest;
import org.apache.bookkeeper.mledger.impl.OpReadEntry;
import org.apache.bookkeeper.mledger.impl.OpScan;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.impl.PositionImplRecyclable;
import org.apache.bookkeeper.mledger.impl.RangeSetWrapper;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.Errors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.LongPairRangeSet;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedCursorImpl
implements ManagedCursor {
    private static final Comparator<Entry> ENTRY_COMPARATOR = (e1, e2) -> {
        if (e1.getLedgerId() != e2.getLedgerId()) {
            return e1.getLedgerId() < e2.getLedgerId() ? -1 : 1;
        }
        if (e1.getEntryId() != e2.getEntryId()) {
            return e1.getEntryId() < e2.getEntryId() ? -1 : 1;
        }
        return 0;
    };
    protected final BookKeeper bookkeeper;
    protected final ManagedLedgerImpl ledger;
    private final String name;
    public static final String CURSOR_INTERNAL_PROPERTY_PREFIX = "#pulsar.internal.";
    private volatile Map<String, String> cursorProperties;
    private final BookKeeper.DigestType digestType;
    protected volatile PositionImpl markDeletePosition;
    protected volatile PositionImpl persistentMarkDeletePosition;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, PositionImpl> INPROGRESS_MARKDELETE_PERSIST_POSITION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, PositionImpl.class, "inProgressMarkDeletePersistPosition");
    protected volatile PositionImpl inProgressMarkDeletePersistPosition;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, PositionImpl> READ_POSITION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, PositionImpl.class, "readPosition");
    protected volatile PositionImpl readPosition;
    protected volatile PositionImpl statsLastReadPosition;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, MarkDeleteEntry> LAST_MARK_DELETE_ENTRY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, MarkDeleteEntry.class, "lastMarkDeleteEntry");
    protected volatile MarkDeleteEntry lastMarkDeleteEntry;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, OpReadEntry> WAITING_READ_OP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, OpReadEntry.class, "waitingReadOp");
    private volatile OpReadEntry waitingReadOp = null;
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<ManagedCursorImpl> RESET_CURSOR_IN_PROGRESS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ManagedCursorImpl.class, "resetCursorInProgress");
    private volatile int resetCursorInProgress = 0;
    private static final AtomicIntegerFieldUpdater<ManagedCursorImpl> PENDING_READ_OPS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ManagedCursorImpl.class, "pendingReadOps");
    private volatile int pendingReadOps = 0;
    private static final AtomicLongFieldUpdater<ManagedCursorImpl> MSG_CONSUMED_COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(ManagedCursorImpl.class, "messagesConsumedCounter");
    protected volatile long messagesConsumedCounter;
    @VisibleForTesting
    volatile LedgerHandle cursorLedger;
    private boolean isCursorLedgerReadOnly = true;
    private volatile Stat cursorLedgerStat;
    private volatile MLDataFormats.ManagedCursorInfo managedCursorInfo;
    private static final LongPairRangeSet.LongPairConsumer<PositionImpl> positionRangeConverter = PositionImpl::new;
    private static final LongPairRangeSet.RangeBoundConsumer<PositionImpl> positionRangeReverseConverter = position -> new LongPairRangeSet.LongPair(position.ledgerId, position.entryId);
    private static final LongPairRangeSet.LongPairConsumer<PositionImplRecyclable> recyclePositionRangeConverter = (key, value) -> {
        PositionImplRecyclable position = PositionImplRecyclable.create();
        position.ledgerId = key;
        position.entryId = value;
        position.ackSet = null;
        return position;
    };
    protected final RangeSetWrapper<PositionImpl> individualDeletedMessages;
    @Nullable
    @VisibleForTesting
    protected final ConcurrentSkipListMap<PositionImpl, BitSet> batchDeletedIndexes;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private RateLimiter markDeleteLimiter;
    private volatile boolean isDirty = false;
    private boolean alwaysInactive = false;
    private static final long NO_MAX_SIZE_LIMIT = -1L;
    private long entriesReadCount;
    private long entriesReadSize;
    private int individualDeletedMessagesSerializedSize;
    private static final String COMPACTION_CURSOR_NAME = "__compaction";
    private volatile boolean cacheReadEntry = false;
    private volatile boolean isActive = false;
    protected final ArrayDeque<MarkDeleteEntry> pendingMarkDeleteOps = new ArrayDeque();
    private static final AtomicIntegerFieldUpdater<ManagedCursorImpl> PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ManagedCursorImpl.class, "pendingMarkDeletedSubmittedCount");
    private volatile int pendingMarkDeletedSubmittedCount = 0;
    private volatile long lastLedgerSwitchTimestamp;
    private final Clock clock;
    private volatile long lastActive;
    protected static final AtomicReferenceFieldUpdater<ManagedCursorImpl, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ManagedCursorImpl.class, State.class, "state");
    protected volatile State state = null;
    protected final ManagedCursorMXBean mbean;
    private static final Logger log = LoggerFactory.getLogger(ManagedCursorImpl.class);

    ManagedCursorImpl(BookKeeper bookkeeper, ManagedLedgerImpl ledger, String cursorName) {
        this.bookkeeper = bookkeeper;
        this.cursorProperties = Collections.emptyMap();
        this.ledger = ledger;
        this.name = cursorName;
        this.individualDeletedMessages = new RangeSetWrapper<PositionImpl>(positionRangeConverter, positionRangeReverseConverter, this);
        this.batchDeletedIndexes = this.getConfig().isDeletionAtBatchIndexLevelEnabled() ? new ConcurrentSkipListMap() : null;
        this.digestType = BookKeeper.DigestType.fromApiDigestType((DigestType)this.getConfig().getDigestType());
        STATE_UPDATER.set(this, State.Uninitialized);
        PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.set(this, 0);
        PENDING_READ_OPS_UPDATER.set(this, 0);
        RESET_CURSOR_IN_PROGRESS_UPDATER.set(this, 0);
        WAITING_READ_OP_UPDATER.set(this, null);
        this.clock = this.getConfig().getClock();
        this.lastActive = this.clock.millis();
        this.lastLedgerSwitchTimestamp = this.clock.millis();
        this.markDeleteLimiter = this.getConfig().getThrottleMarkDelete() > 0.0 ? RateLimiter.create((double)this.getConfig().getThrottleMarkDelete()) : null;
        this.mbean = new ManagedCursorMXBeanImpl(this);
    }

    private void updateCursorLedgerStat(MLDataFormats.ManagedCursorInfo cursorInfo, Stat stat) {
        this.managedCursorInfo = cursorInfo;
        this.cursorLedgerStat = stat;
    }

    @Override
    public Map<String, Long> getProperties() {
        return this.lastMarkDeleteEntry != null ? this.lastMarkDeleteEntry.properties : Collections.emptyMap();
    }

    @Override
    public boolean isCursorDataFullyPersistable() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.individualDeletedMessages.size() <= this.getConfig().getMaxUnackedRangesToPersist();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Map<String, String> getCursorProperties() {
        return this.cursorProperties;
    }

    private CompletableFuture<Void> computeCursorProperties(Function<Map<String, String>, Map<String, String>> updateFunction) {
        final CompletableFuture<Void> updateCursorPropertiesResult = new CompletableFuture<Void>();
        final Map<String, String> newProperties = updateFunction.apply(this.cursorProperties);
        if (!this.isDurable()) {
            this.cursorProperties = Collections.unmodifiableMap(newProperties);
            updateCursorPropertiesResult.complete(null);
            return updateCursorPropertiesResult;
        }
        final MLDataFormats.ManagedCursorInfo copy = MLDataFormats.ManagedCursorInfo.newBuilder(this.managedCursorInfo).clearCursorProperties().addAllCursorProperties(ManagedCursorImpl.buildStringPropertiesMap(newProperties)).build();
        Stat lastCursorLedgerStat = this.cursorLedgerStat;
        this.ledger.getStore().asyncUpdateCursorInfo(this.ledger.getName(), this.name, copy, lastCursorLedgerStat, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                log.info("[{}] Updated ledger cursor: {}", (Object)ManagedCursorImpl.this.ledger.getName(), (Object)ManagedCursorImpl.this.name);
                ManagedCursorImpl.this.cursorProperties = Collections.unmodifiableMap(newProperties);
                ManagedCursorImpl.this.updateCursorLedgerStat(copy, stat);
                updateCursorPropertiesResult.complete(result);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.error("[{}] Error while updating ledger cursor: {} properties {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, newProperties, e});
                updateCursorPropertiesResult.completeExceptionally(e);
            }
        });
        return updateCursorPropertiesResult;
    }

    @Override
    public CompletableFuture<Void> setCursorProperties(Map<String, String> cursorProperties) {
        HashMap newProperties = cursorProperties == null ? new HashMap() : new HashMap<String, String>(cursorProperties);
        Set keys = newProperties.keySet();
        for (String key : keys) {
            if (!key.startsWith(CURSOR_INTERNAL_PROPERTY_PREFIX)) continue;
            return FutureUtil.failedFuture((Throwable)new IllegalArgumentException("The property key can't start with #pulsar.internal."));
        }
        return this.computeCursorProperties(lastRead -> {
            if (lastRead != null) {
                lastRead.forEach((k, v) -> {
                    if (k.startsWith(CURSOR_INTERNAL_PROPERTY_PREFIX)) {
                        newProperties.put(k, v);
                    }
                });
            }
            return newProperties;
        });
    }

    @Override
    public CompletableFuture<Void> putCursorProperty(String key, String value) {
        return this.computeCursorProperties(lastRead -> {
            HashMap<String, String> newProperties = lastRead == null ? new HashMap<String, String>() : new HashMap(lastRead);
            newProperties.put(key, value);
            return newProperties;
        });
    }

    @Override
    public CompletableFuture<Void> removeCursorProperty(String key) {
        return this.computeCursorProperties(lastRead -> {
            HashMap newProperties = lastRead == null ? new HashMap() : new HashMap(lastRead);
            newProperties.remove(key);
            return newProperties;
        });
    }

    @Override
    public boolean putProperty(String key, Long value) {
        if (this.lastMarkDeleteEntry != null) {
            LAST_MARK_DELETE_ENTRY_UPDATER.updateAndGet(this, last -> {
                Map<String, Long> properties = last.properties;
                HashMap<String, Long> newProperties = properties == null ? new HashMap<String, Long>() : new HashMap<String, Long>(properties);
                newProperties.put(key, value);
                MarkDeleteEntry newLastMarkDeleteEntry = new MarkDeleteEntry(last.newPosition, newProperties, last.callback, last.ctx);
                newLastMarkDeleteEntry.callbackGroup = last.callbackGroup;
                return newLastMarkDeleteEntry;
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean removeProperty(String key) {
        if (this.lastMarkDeleteEntry != null) {
            LAST_MARK_DELETE_ENTRY_UPDATER.updateAndGet(this, last -> {
                Map<String, Long> properties = last.properties;
                if (properties != null && properties.containsKey(key)) {
                    properties.remove(key);
                }
                return last;
            });
            return true;
        }
        return false;
    }

    void recover(final VoidCallback callback) {
        log.info("[{}] Recovering from bookkeeper ledger cursor: {}", (Object)this.ledger.getName(), (Object)this.name);
        this.ledger.getStore().asyncGetCursorInfo(this.ledger.getName(), this.name, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedCursorInfo info, Stat stat) {
                ManagedCursorImpl.this.updateCursorLedgerStat(info, stat);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Recover cursor last active to [{}]", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.lastActive});
                }
                Map<String, String> recoveredCursorProperties = Collections.emptyMap();
                if (info.getCursorPropertiesCount() > 0) {
                    recoveredCursorProperties = new HashMap();
                    for (int i = 0; i < info.getCursorPropertiesCount(); ++i) {
                        MLDataFormats.StringProperty property = info.getCursorProperties(i);
                        recoveredCursorProperties.put(property.getName(), property.getValue());
                    }
                }
                ManagedCursorImpl.this.cursorProperties = recoveredCursorProperties;
                if (info.getCursorsLedgerId() == -1L) {
                    PositionImpl recoveredPosition = new PositionImpl(info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId());
                    if (info.getIndividualDeletedMessagesCount() > 0) {
                        ManagedCursorImpl.this.recoverIndividualDeletedMessages(info.getIndividualDeletedMessagesList());
                    }
                    Map<String, Long> recoveredProperties = Collections.emptyMap();
                    if (info.getPropertiesCount() > 0) {
                        recoveredProperties = new HashMap();
                        for (int i = 0; i < info.getPropertiesCount(); ++i) {
                            MLDataFormats.LongProperty property = info.getProperties(i);
                            recoveredProperties.put(property.getName(), property.getValue());
                        }
                    }
                    ManagedCursorImpl.this.recoveredCursor(recoveredPosition, recoveredProperties, recoveredCursorProperties, null);
                    callback.operationComplete();
                } else {
                    log.info("[{}] Cursor {} meta-data recover from ledger {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, info.getCursorsLedgerId()});
                    ManagedCursorImpl.this.recoverFromLedger(info, callback);
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                callback.operationFailed(e);
            }
        });
    }

    protected void recoverFromLedger(MLDataFormats.ManagedCursorInfo info, VoidCallback callback) {
        this.ledger.mbean.startCursorLedgerOpenOp();
        long ledgerId = info.getCursorsLedgerId();
        AsyncCallback.OpenCallback openCallback = (rc, lh, ctx) -> {
            if (log.isInfoEnabled()) {
                log.info("[{}] Opened ledger {} for cursor {}. rc={}", new Object[]{this.ledger.getName(), ledgerId, this.name, rc});
            }
            if (ManagedCursorImpl.isBkErrorNotRecoverable(rc)) {
                log.error("[{}] Error opening metadata ledger {} for cursor {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc)});
                this.initialize(this.getRollbackPosition(info), Collections.emptyMap(), this.cursorProperties, callback);
                return;
            }
            if (rc != 0) {
                log.warn("[{}] Error opening metadata ledger {} for cursor {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc)});
                callback.operationFailed(new ManagedLedgerException(BKException.getMessage((int)rc)));
                return;
            }
            long lastEntryInLedger = lh.getLastAddConfirmed();
            if (lastEntryInLedger < 0L) {
                log.warn("[{}] Error reading from metadata ledger {} for cursor {}: No entries in ledger", new Object[]{this.ledger.getName(), ledgerId, this.name});
                this.initialize(this.getRollbackPosition(info), Collections.emptyMap(), this.cursorProperties, callback);
                return;
            }
            lh.asyncReadEntries(lastEntryInLedger, lastEntryInLedger, (rc1, lh1, seq, ctx1) -> {
                MLDataFormats.PositionInfo positionInfo;
                if (log.isDebugEnabled()) {
                    log.debug("[{}} readComplete rc={} entryId={}", new Object[]{this.ledger.getName(), rc1, lh1.getLastAddConfirmed()});
                }
                if (ManagedCursorImpl.isBkErrorNotRecoverable(rc1)) {
                    log.error("[{}] Error reading from metadata ledger {} for cursor {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc1)});
                    this.initialize(this.getRollbackPosition(info), Collections.emptyMap(), this.cursorProperties, callback);
                    return;
                }
                if (rc1 != 0) {
                    log.warn("[{}] Error reading from metadata ledger {} for cursor {}: {}", new Object[]{this.ledger.getName(), ledgerId, this.name, BKException.getMessage((int)rc1)});
                    callback.operationFailed(ManagedLedgerImpl.createManagedLedgerException(rc1));
                    return;
                }
                LedgerEntry entry = (LedgerEntry)seq.nextElement();
                this.mbean.addReadCursorLedgerSize(entry.getLength());
                try {
                    positionInfo = MLDataFormats.PositionInfo.parseFrom(entry.getEntry());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(new ManagedLedgerException(e));
                    return;
                }
                Map<String, Long> recoveredProperties = Collections.emptyMap();
                if (positionInfo.getPropertiesCount() > 0) {
                    recoveredProperties = new HashMap();
                    for (int i = 0; i < positionInfo.getPropertiesCount(); ++i) {
                        MLDataFormats.LongProperty property = positionInfo.getProperties(i);
                        recoveredProperties.put(property.getName(), property.getValue());
                    }
                }
                PositionImpl position = new PositionImpl(positionInfo);
                this.recoverIndividualDeletedMessages(positionInfo);
                if (this.getConfig().isDeletionAtBatchIndexLevelEnabled() && positionInfo.getBatchedEntryDeletionIndexInfoCount() > 0) {
                    this.recoverBatchDeletedIndexes(positionInfo.getBatchedEntryDeletionIndexInfoList());
                }
                this.recoveredCursor(position, recoveredProperties, this.cursorProperties, lh);
                callback.operationComplete();
            }, null);
        };
        try {
            this.bookkeeper.asyncOpenLedger(ledgerId, this.digestType, this.getConfig().getPassword(), openCallback, null);
        }
        catch (Throwable t) {
            log.error("[{}] Encountered error on opening cursor ledger {} for cursor {}", new Object[]{this.ledger.getName(), ledgerId, this.name, t});
            openCallback.openComplete(-999, null, null);
        }
    }

    public void recoverIndividualDeletedMessages(MLDataFormats.PositionInfo positionInfo) {
        if (positionInfo.getIndividualDeletedMessagesCount() > 0) {
            this.recoverIndividualDeletedMessages(positionInfo.getIndividualDeletedMessagesList());
        } else if (positionInfo.getIndividualDeletedMessageRangesCount() > 0) {
            List<MLDataFormats.LongListMap> rangeList = positionInfo.getIndividualDeletedMessageRangesList();
            try {
                Map<Long, long[]> rangeMap = rangeList.stream().collect(Collectors.toMap(MLDataFormats.LongListMap::getKey, list -> list.getValuesList().stream().mapToLong(i -> i).toArray()));
                if (this.getConfig().isUnackedRangesOpenCacheSetEnabled()) {
                    this.individualDeletedMessages.build(rangeMap);
                } else {
                    RangeSetWrapper<PositionImpl> rangeSetWrapperV2 = new RangeSetWrapper<PositionImpl>(positionRangeConverter, positionRangeReverseConverter, true, this.getConfig().isPersistentUnackedRangesWithMultipleEntriesEnabled());
                    rangeSetWrapperV2.build(rangeMap);
                    rangeSetWrapperV2.forEach((LongPairRangeSet.RangeProcessor<PositionImpl>)((LongPairRangeSet.RangeProcessor)range -> {
                        this.individualDeletedMessages.addOpenClosed(((PositionImpl)range.lowerEndpoint()).getLedgerId(), ((PositionImpl)range.lowerEndpoint()).getEntryId(), ((PositionImpl)range.upperEndpoint()).getLedgerId(), ((PositionImpl)range.upperEndpoint()).getEntryId());
                        return true;
                    }));
                    rangeSetWrapperV2.clear();
                }
            }
            catch (Exception e) {
                log.warn("[{}]-{} Failed to recover individualDeletedMessages from serialized data", new Object[]{this.ledger.getName(), this.name, e});
            }
        }
    }

    private List<MLDataFormats.LongListMap> buildLongPropertiesMap(Map<Long, long[]> properties) {
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MLDataFormats.LongListMap> longListMap = new ArrayList<MLDataFormats.LongListMap>();
        MutableInt serializedSize = new MutableInt();
        properties.forEach((id, ranges) -> {
            if (ranges == null || ((long[])ranges).length <= 0) {
                return;
            }
            MLDataFormats.LongListMap.Builder lmBuilder = MLDataFormats.LongListMap.newBuilder().setKey((long)id);
            for (long range : ranges) {
                lmBuilder.addValues(range);
            }
            MLDataFormats.LongListMap lm = lmBuilder.build();
            longListMap.add(lm);
            serializedSize.add(lm.getSerializedSize());
        });
        this.individualDeletedMessagesSerializedSize = serializedSize.toInteger();
        return longListMap;
    }

    private void recoverIndividualDeletedMessages(List<MLDataFormats.MessageRange> individualDeletedMessagesList) {
        this.lock.writeLock().lock();
        try {
            this.individualDeletedMessages.clear();
            individualDeletedMessagesList.forEach(messageRange -> {
                MLDataFormats.NestedPositionInfo lowerEndpoint = messageRange.getLowerEndpoint();
                MLDataFormats.NestedPositionInfo upperEndpoint = messageRange.getUpperEndpoint();
                if (lowerEndpoint.getLedgerId() == upperEndpoint.getLedgerId()) {
                    this.individualDeletedMessages.addOpenClosed(lowerEndpoint.getLedgerId(), lowerEndpoint.getEntryId(), upperEndpoint.getLedgerId(), upperEndpoint.getEntryId());
                } else {
                    MLDataFormats.ManagedLedgerInfo.LedgerInfo lowerEndpointLedgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgersInfo().get(lowerEndpoint.getLedgerId());
                    if (lowerEndpointLedgerInfo != null) {
                        this.individualDeletedMessages.addOpenClosed(lowerEndpoint.getLedgerId(), lowerEndpoint.getEntryId(), lowerEndpoint.getLedgerId(), lowerEndpointLedgerInfo.getEntries() - 1L);
                    } else {
                        log.warn("[{}][{}] No ledger info of lower endpoint {}:{}", new Object[]{this.ledger.getName(), this.name, lowerEndpoint.getLedgerId(), lowerEndpoint.getEntryId()});
                    }
                    for (MLDataFormats.ManagedLedgerInfo.LedgerInfo li : this.ledger.getLedgersInfo().subMap(lowerEndpoint.getLedgerId(), false, upperEndpoint.getLedgerId(), false).values()) {
                        this.individualDeletedMessages.addOpenClosed(li.getLedgerId(), -1L, li.getLedgerId(), li.getEntries() - 1L);
                    }
                    this.individualDeletedMessages.addOpenClosed(upperEndpoint.getLedgerId(), -1L, upperEndpoint.getLedgerId(), upperEndpoint.getEntryId());
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void recoverBatchDeletedIndexes(List<MLDataFormats.BatchedEntryDeletionIndexInfo> batchDeletedIndexInfoList) {
        Objects.requireNonNull(this.batchDeletedIndexes);
        this.lock.writeLock().lock();
        try {
            this.batchDeletedIndexes.clear();
            batchDeletedIndexInfoList.forEach(batchDeletedIndexInfo -> {
                if (batchDeletedIndexInfo.getDeleteSetCount() > 0) {
                    long[] array = new long[batchDeletedIndexInfo.getDeleteSetCount()];
                    for (int i = 0; i < batchDeletedIndexInfo.getDeleteSetList().size(); ++i) {
                        array[i] = batchDeletedIndexInfo.getDeleteSetList().get(i);
                    }
                    this.batchDeletedIndexes.put(PositionImpl.get(batchDeletedIndexInfo.getPosition().getLedgerId(), batchDeletedIndexInfo.getPosition().getEntryId()), BitSet.valueOf(array));
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void recoveredCursor(PositionImpl position, Map<String, Long> properties, Map<String, String> cursorProperties, LedgerHandle recoveredFromCursorLedger) {
        if (position.getEntryId() == -1L && !this.ledger.ledgerExists(position.getLedgerId())) {
            Long nextExistingLedger = this.ledger.getNextValidLedger(position.getLedgerId());
            if (nextExistingLedger == null) {
                log.info("[{}] [{}] Couldn't find next next valid ledger for recovery {}", new Object[]{this.ledger.getName(), this.name, position});
            }
            PositionImpl positionImpl = position = nextExistingLedger != null ? PositionImpl.get(nextExistingLedger, -1L) : position;
        }
        if (position.compareTo(this.ledger.getLastPosition()) > 0) {
            log.warn("[{}] [{}] Current position {} is ahead of last position {}", new Object[]{this.ledger.getName(), this.name, position, this.ledger.getLastPosition()});
            position = this.ledger.getLastPosition();
        }
        log.info("[{}] Cursor {} recovered to position {}", new Object[]{this.ledger.getName(), this.name, position});
        this.cursorProperties = cursorProperties == null ? Collections.emptyMap() : cursorProperties;
        this.messagesConsumedCounter = -this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)position, (Comparable)this.ledger.getLastPosition()));
        this.markDeletePosition = position;
        this.persistentMarkDeletePosition = position;
        this.inProgressMarkDeletePersistPosition = null;
        this.readPosition = this.ledger.getNextValidPosition(position);
        this.ledger.onCursorReadPositionUpdated(this, this.readPosition);
        this.lastMarkDeleteEntry = new MarkDeleteEntry(this.markDeletePosition, properties, null, null);
        this.cursorLedger = recoveredFromCursorLedger;
        this.isCursorLedgerReadOnly = true;
        STATE_UPDATER.set(this, State.NoLedger);
    }

    void initialize(PositionImpl position, Map<String, Long> properties, Map<String, String> cursorProperties, final VoidCallback callback) {
        this.recoveredCursor(position, properties, cursorProperties, null);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Consumer {} cursor initialized with counters: consumed {} mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
        }
        this.persistPositionMetaStore(this.cursorLedger != null ? this.cursorLedger.getId() : -1L, position, properties, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                STATE_UPDATER.set(ManagedCursorImpl.this, State.NoLedger);
                callback.operationComplete();
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                callback.operationFailed(e);
            }
        }, false);
    }

    @Override
    public List<Entry> readEntries(int numberOfEntriesToRead) throws InterruptedException, ManagedLedgerException {
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            List<Entry> entries = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncReadEntries(numberOfEntriesToRead, new AsyncCallbacks.ReadEntriesCallback(){
            {
            }

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                result.entries = entries;
                counter.countDown();
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null, PositionImpl.LATEST);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entries;
    }

    @Override
    public void asyncReadEntries(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        this.asyncReadEntries(numberOfEntriesToRead, -1L, callback, ctx, maxPosition);
    }

    @Override
    public void asyncReadEntries(int numberOfEntriesToRead, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        this.asyncReadEntriesWithSkip(numberOfEntriesToRead, maxSizeBytes, callback, ctx, maxPosition, null);
    }

    @Override
    public void asyncReadEntriesWithSkip(int numberOfEntriesToRead, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition, Predicate<PositionImpl> skipCondition) {
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        if (this.isClosed()) {
            callback.readEntriesFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        int numOfEntriesToRead = this.applyMaxSizeCap(numberOfEntriesToRead, maxSizeBytes);
        PENDING_READ_OPS_UPDATER.incrementAndGet(this);
        skipCondition = skipCondition == null ? this::isMessageDeleted : skipCondition.or(this::isMessageDeleted);
        OpReadEntry op = OpReadEntry.create(this, this.readPosition, numOfEntriesToRead, callback, ctx, maxPosition, skipCondition);
        this.ledger.asyncReadEntries(op);
    }

    @Override
    public Entry getNthEntry(int n, ManagedCursor.IndividualDeletedEntries deletedEntries) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            Entry entry = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncGetNthEntry(n, deletedEntries, new AsyncCallbacks.ReadEntryCallback(){
            {
            }

            @Override
            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }

            @Override
            public void readEntryComplete(Entry entry, Object ctx) {
                result.entry = entry;
                counter.countDown();
            }

            public String toString() {
                return String.format("Cursor [%s] get Nth entry", ManagedCursorImpl.this);
            }
        }, null);
        counter.await(this.ledger.getConfig().getMetadataOperationsTimeoutSeconds(), TimeUnit.SECONDS);
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entry;
    }

    @Override
    public void asyncGetNthEntry(int n, ManagedCursor.IndividualDeletedEntries deletedEntries, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        PositionImpl endPosition;
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        if (this.isClosed()) {
            callback.readEntryFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        PositionImpl startPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
        if (startPosition.compareTo(endPosition = this.ledger.getLastPosition()) <= 0) {
            long numOfEntries = this.getNumberOfEntries((Range<PositionImpl>)Range.closed((Comparable)startPosition, (Comparable)endPosition));
            if (numOfEntries >= (long)n) {
                long deletedMessages = 0L;
                if (deletedEntries == ManagedCursor.IndividualDeletedEntries.Exclude) {
                    deletedMessages = this.getNumIndividualDeletedEntriesToSkip(n);
                }
                PositionImpl positionAfterN = this.ledger.getPositionAfterN(this.markDeletePosition, (long)n + deletedMessages, ManagedLedgerImpl.PositionBound.startExcluded);
                this.ledger.asyncReadEntry(positionAfterN, callback, ctx);
            } else {
                callback.readEntryComplete(null, ctx);
            }
        } else {
            callback.readEntryComplete(null, ctx);
        }
    }

    @Override
    public List<Entry> readEntriesOrWait(int numberOfEntriesToRead) throws InterruptedException, ManagedLedgerException {
        return this.readEntriesOrWait(numberOfEntriesToRead, -1L);
    }

    @Override
    public List<Entry> readEntriesOrWait(int numberOfEntriesToRead, long maxSizeBytes) throws InterruptedException, ManagedLedgerException {
        Preconditions.checkArgument((numberOfEntriesToRead > 0 ? 1 : 0) != 0);
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            List<Entry> entries = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncReadEntriesOrWait(numberOfEntriesToRead, maxSizeBytes, new AsyncCallbacks.ReadEntriesCallback(){
            {
            }

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                result.entries = entries;
                counter.countDown();
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null, PositionImpl.LATEST);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entries;
    }

    @Override
    public void asyncReadEntriesOrWait(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        this.asyncReadEntriesOrWait(numberOfEntriesToRead, -1L, callback, ctx, maxPosition);
    }

    @Override
    public void asyncReadEntriesOrWait(int maxEntries, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition) {
        this.asyncReadEntriesWithSkipOrWait(maxEntries, maxSizeBytes, callback, ctx, maxPosition, null);
    }

    @Override
    public void asyncReadEntriesWithSkipOrWait(int maxEntries, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition, Predicate<PositionImpl> skipCondition) {
        this.asyncReadEntriesWithSkipOrWait(maxEntries, -1L, callback, ctx, maxPosition, skipCondition);
    }

    @Override
    public void asyncReadEntriesWithSkipOrWait(int maxEntries, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, PositionImpl maxPosition, Predicate<PositionImpl> skipCondition) {
        Preconditions.checkArgument((maxEntries > 0 ? 1 : 0) != 0);
        if (this.isClosed()) {
            callback.readEntriesFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        int numberOfEntriesToRead = this.applyMaxSizeCap(maxEntries, maxSizeBytes);
        if (this.hasMoreEntries() && maxPosition.compareTo(this.readPosition) >= 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Read entries immediately", (Object)this.ledger.getName(), (Object)this.name);
            }
            this.asyncReadEntriesWithSkip(numberOfEntriesToRead, -1L, callback, ctx, maxPosition, skipCondition);
        } else {
            OpReadEntry op = OpReadEntry.create(this, this.readPosition, numberOfEntriesToRead, callback, ctx, maxPosition, skipCondition = skipCondition == null ? this::isMessageDeleted : skipCondition.or(this::isMessageDeleted));
            if (!WAITING_READ_OP_UPDATER.compareAndSet(this, null, op)) {
                op.recycle();
                callback.readEntriesFailed(new ManagedLedgerException.ConcurrentWaitCallbackException(), ctx);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Deferring retry of read at position {}", new Object[]{this.ledger.getName(), this.name, op.readPosition});
            }
            if (this.getConfig().getNewEntriesCheckDelayInMillis() > 0) {
                this.ledger.getScheduledExecutor().schedule(() -> this.checkForNewEntries(op, callback, ctx), (long)this.getConfig().getNewEntriesCheckDelayInMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.checkForNewEntries(op, callback, ctx);
            }
        }
    }

    private void checkForNewEntries(OpReadEntry op, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Re-trying the read at position {}", new Object[]{this.ledger.getName(), this.name, op.readPosition});
            }
            if (this.isClosed()) {
                callback.readEntriesFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
                return;
            }
            if (!this.hasMoreEntries()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Still no entries available. Register for notification", (Object)this.ledger.getName(), (Object)this.name);
                }
                this.ledger.addWaitingCursor(this);
            } else if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Skip notification registering since we do have entries available", (Object)this.ledger.getName(), (Object)this.name);
            }
            if (this.hasMoreEntries()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Found more entries", (Object)this.ledger.getName(), (Object)this.name);
                }
                if (WAITING_READ_OP_UPDATER.compareAndSet(this, op, null)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] Cancelled notification and scheduled read at {}", new Object[]{this.ledger.getName(), this.name, op.readPosition});
                    }
                    PENDING_READ_OPS_UPDATER.incrementAndGet(this);
                    this.ledger.asyncReadEntries(op);
                } else if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] notification was already cancelled", (Object)this.ledger.getName(), (Object)this.name);
                }
            } else if (this.ledger.isTerminated()) {
                callback.readEntriesFailed(new ManagedLedgerException.NoMoreEntriesToReadException("Topic was terminated"), ctx);
            }
        }
        catch (Throwable t) {
            callback.readEntriesFailed(new ManagedLedgerException(t), ctx);
        }
    }

    @Override
    public boolean isClosed() {
        return this.state == State.Closed || this.state == State.Closing;
    }

    @Override
    public boolean cancelPendingReadRequest() {
        OpReadEntry op;
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Cancel pending read request", (Object)this.ledger.getName(), (Object)this.name);
        }
        if ((op = (OpReadEntry)WAITING_READ_OP_UPDATER.getAndSet(this, null)) != null) {
            op.recycle();
        }
        return op != null;
    }

    public boolean hasPendingReadRequest() {
        return WAITING_READ_OP_UPDATER.get(this) != null;
    }

    @Override
    public boolean hasMoreEntries() {
        PositionImpl writerPosition = this.ledger.getLastPosition();
        if (writerPosition.getEntryId() != -1L) {
            return this.readPosition.compareTo(writerPosition) <= 0;
        }
        return this.getNumberOfEntries() > 0L;
    }

    @Override
    public long getNumberOfEntries() {
        if (this.readPosition.compareTo(this.ledger.getLastPosition().getNext()) > 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Read position {} is ahead of last position {}. There are no entries to read", new Object[]{this.ledger.getName(), this.name, this.readPosition, this.ledger.getLastPosition()});
            }
            return 0L;
        }
        return this.getNumberOfEntries((Range<PositionImpl>)Range.closedOpen((Comparable)this.readPosition, (Comparable)this.ledger.getLastPosition().getNext()));
    }

    @Override
    public long getNumberOfEntriesSinceFirstNotAckedMessage() {
        PositionImpl markDeletePosition = this.markDeletePosition;
        PositionImpl readPosition = this.readPosition;
        return markDeletePosition != null && readPosition != null && markDeletePosition.compareTo(readPosition) < 0 ? this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)markDeletePosition, (Comparable)readPosition)) : 0L;
    }

    @Override
    public int getTotalNonContiguousDeletedMessagesRange() {
        this.lock.readLock().lock();
        try {
            int n = this.individualDeletedMessages.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getNonContiguousDeletedMessagesRangeSerializedSize() {
        return this.individualDeletedMessagesSerializedSize;
    }

    @Override
    public long getEstimatedSizeSinceMarkDeletePosition() {
        return this.ledger.estimateBacklogFromPosition(this.markDeletePosition);
    }

    private long getNumberOfEntriesInBacklog() {
        if (this.markDeletePosition.compareTo(this.ledger.getLastPosition()) >= 0) {
            return 0L;
        }
        return this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)this.markDeletePosition, (Comparable)this.ledger.getLastPosition()));
    }

    @Override
    public long getNumberOfEntriesInBacklog(boolean isPrecise) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Consumer {} cursor ml-entries: {} -- deleted-counter: {} other counters: mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, ManagedLedgerImpl.ENTRIES_ADDED_COUNTER_UPDATER.get(this.ledger), this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
        }
        if (isPrecise) {
            return this.getNumberOfEntriesInBacklog();
        }
        long backlog = ManagedLedgerImpl.ENTRIES_ADDED_COUNTER_UPDATER.get(this.ledger) - this.messagesConsumedCounter;
        if (backlog < 0L) {
            backlog = this.getNumberOfEntriesInBacklog();
        }
        return backlog;
    }

    public long getNumberOfEntriesInStorage() {
        return this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)this.markDeletePosition, (Comparable)this.ledger.getLastPosition()));
    }

    @Override
    public Position findNewestMatching(Predicate<Entry> condition) throws InterruptedException, ManagedLedgerException {
        return this.findNewestMatching(ManagedCursor.FindPositionConstraint.SearchActiveEntries, condition);
    }

    @Override
    public CompletableFuture<ScanOutcome> scan(Optional<Position> position, Predicate<Entry> condition, int batchSize, long maxEntries, long timeOutMs) {
        PositionImpl startPosition = (PositionImpl)position.orElseGet(() -> this.ledger.getNextValidPosition(this.markDeletePosition));
        final CompletableFuture<ScanOutcome> future = new CompletableFuture<ScanOutcome>();
        OpScan op = new OpScan(this, batchSize, startPosition, condition, new AsyncCallbacks.ScanCallback(){

            @Override
            public void scanComplete(Position position, ScanOutcome scanOutcome, Object ctx) {
                future.complete(scanOutcome);
            }

            @Override
            public void scanFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null, maxEntries, timeOutMs);
        op.find();
        return future;
    }

    @Override
    public Position findNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            Position position = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncFindNewestMatching(constraint, condition, new AsyncCallbacks.FindEntryCallback(){
            {
            }

            @Override
            public void findEntryComplete(Position position, Object ctx) {
                result.position = position;
                counter.countDown();
            }

            @Override
            public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.position;
    }

    @Override
    public void asyncFindNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition, AsyncCallbacks.FindEntryCallback callback, Object ctx) {
        this.asyncFindNewestMatching(constraint, condition, callback, ctx, false);
    }

    @Override
    public void asyncFindNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition, AsyncCallbacks.FindEntryCallback callback, Object ctx, boolean isFindFromLedger) {
        PositionImpl startPosition = null;
        long max = 0L;
        switch (constraint) {
            case SearchAllAvailableEntries: {
                startPosition = (PositionImpl)this.getFirstPosition();
                max = this.ledger.getNumberOfEntries() - 1L;
                break;
            }
            case SearchActiveEntries: {
                startPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
                max = this.getNumberOfEntriesInStorage();
                break;
            }
            default: {
                callback.findEntryFailed(new ManagedLedgerException("Unknown position constraint"), Optional.empty(), ctx);
                return;
            }
        }
        if (startPosition == null) {
            callback.findEntryFailed(new ManagedLedgerException("Couldn't find start position"), Optional.empty(), ctx);
            return;
        }
        OpFindNewest op = isFindFromLedger ? new OpFindNewest(this.ledger, startPosition, condition, max, callback, ctx) : new OpFindNewest(this, startPosition, condition, max, callback, ctx);
        op.find();
    }

    @Override
    public void setActive() {
        if (!this.isActive && !this.alwaysInactive) {
            this.ledger.activateCursor(this);
            this.isActive = true;
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setInactive() {
        if (this.isActive) {
            this.ledger.deactivateCursor(this);
            this.isActive = false;
        }
    }

    @Override
    public void setAlwaysInactive() {
        this.setInactive();
        this.alwaysInactive = true;
    }

    @Override
    public Position getFirstPosition() {
        Long firstLedgerId = (Long)this.ledger.getLedgersInfo().firstKey();
        return firstLedgerId == null ? null : new PositionImpl(firstLedgerId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalResetCursor(PositionImpl proposedReadPosition, AsyncCallbacks.ResetCursorCallback resetCursorCallback) {
        final PositionImpl newReadPosition = proposedReadPosition.equals(PositionImpl.EARLIEST) ? this.ledger.getFirstPosition() : (proposedReadPosition.equals(PositionImpl.LATEST) ? this.ledger.getNextValidPosition(this.ledger.getLastPosition()) : proposedReadPosition);
        log.info("[{}] Initiate reset readPosition from {} to {} on cursor {}", new Object[]{this.ledger.getName(), this.readPosition, newReadPosition, this.name});
        ArrayDeque<MarkDeleteEntry> arrayDeque = this.pendingMarkDeleteOps;
        synchronized (arrayDeque) {
            if (!RESET_CURSOR_IN_PROGRESS_UPDATER.compareAndSet(this, 0, 1)) {
                log.error("[{}] reset requested - readPosition [{}], previous reset in progress - cursor {}", new Object[]{this.ledger.getName(), newReadPosition, this.name});
                resetCursorCallback.resetFailed(new ManagedLedgerException.ConcurrentFindCursorPositionException("reset already in progress"), newReadPosition);
                return;
            }
        }
        final AsyncCallbacks.ResetCursorCallback callback = resetCursorCallback;
        final PositionImpl newMarkDeletePosition = this.ledger.getPreviousPosition(newReadPosition);
        final VoidCallback finalCallback = new VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete() {
                ManagedCursorImpl.this.lock.writeLock().lock();
                try {
                    PositionImpl oldReadPosition;
                    if (ManagedCursorImpl.this.markDeletePosition.compareTo(newMarkDeletePosition) >= 0) {
                        MSG_CONSUMED_COUNTER_UPDATER.addAndGet(ManagedCursorImpl.this.cursorImpl(), -ManagedCursorImpl.this.getNumberOfEntries((Range<PositionImpl>)Range.closedOpen((Comparable)newMarkDeletePosition, (Comparable)ManagedCursorImpl.this.markDeletePosition)));
                    } else {
                        MSG_CONSUMED_COUNTER_UPDATER.addAndGet(ManagedCursorImpl.this.cursorImpl(), ManagedCursorImpl.this.getNumberOfEntries((Range<PositionImpl>)Range.closedOpen((Comparable)ManagedCursorImpl.this.markDeletePosition, (Comparable)newMarkDeletePosition)));
                    }
                    ManagedCursorImpl.this.markDeletePosition = newMarkDeletePosition;
                    ManagedCursorImpl.this.lastMarkDeleteEntry = new MarkDeleteEntry(newMarkDeletePosition, ManagedCursorImpl.this.isCompactionCursor() ? ManagedCursorImpl.this.getProperties() : Collections.emptyMap(), null, null);
                    ManagedCursorImpl.this.individualDeletedMessages.clear();
                    if (ManagedCursorImpl.this.batchDeletedIndexes != null) {
                        ManagedCursorImpl.this.batchDeletedIndexes.clear();
                        long[] resetWords = newReadPosition.ackSet;
                        if (resetWords != null) {
                            ManagedCursorImpl.this.batchDeletedIndexes.put(newReadPosition, BitSet.valueOf(resetWords));
                        }
                    }
                    if ((oldReadPosition = ManagedCursorImpl.this.readPosition).compareTo(newReadPosition) >= 0) {
                        log.info("[{}] reset readPosition to {} before current read readPosition {} on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newReadPosition, oldReadPosition, ManagedCursorImpl.this.name});
                    } else {
                        log.info("[{}] reset readPosition to {} skipping from current read readPosition {} on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newReadPosition, oldReadPosition, ManagedCursorImpl.this.name});
                    }
                    ManagedCursorImpl.this.readPosition = newReadPosition;
                    ManagedCursorImpl.this.ledger.onCursorReadPositionUpdated(ManagedCursorImpl.this, newReadPosition);
                }
                finally {
                    ManagedCursorImpl.this.lock.writeLock().unlock();
                }
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    ManagedCursorImpl.this.pendingMarkDeleteOps.clear();
                    if (!RESET_CURSOR_IN_PROGRESS_UPDATER.compareAndSet(ManagedCursorImpl.this, 1, 0)) {
                        log.error("[{}] expected reset readPosition [{}], but another reset in progress on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newReadPosition, ManagedCursorImpl.this.name});
                    }
                }
                callback.resetComplete(newReadPosition);
                ManagedCursorImpl.this.updateLastActive();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationFailed(ManagedLedgerException exception) {
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    if (!RESET_CURSOR_IN_PROGRESS_UPDATER.compareAndSet(ManagedCursorImpl.this, 1, 0)) {
                        log.error("[{}] expected reset readPosition [{}], but another reset in progress on cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), newReadPosition, ManagedCursorImpl.this.name});
                    }
                }
                callback.resetFailed(new ManagedLedgerException.InvalidCursorPositionException("unable to persist readPosition for cursor reset " + String.valueOf(newReadPosition)), newReadPosition);
            }
        };
        this.persistentMarkDeletePosition = null;
        this.inProgressMarkDeletePersistPosition = null;
        this.lastMarkDeleteEntry = new MarkDeleteEntry(newMarkDeletePosition, this.getProperties(), null, null);
        this.internalAsyncMarkDelete(newMarkDeletePosition, this.isCompactionCursor() ? this.getProperties() : Collections.emptyMap(), new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                finalCallback.operationComplete();
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                finalCallback.operationFailed(exception);
            }
        }, null);
    }

    @Override
    public void asyncResetCursor(Position newPos, boolean forceReset, AsyncCallbacks.ResetCursorCallback callback) {
        Preconditions.checkArgument((boolean)(newPos instanceof PositionImpl));
        PositionImpl newPosition = (PositionImpl)newPos;
        this.ledger.getExecutor().execute(() -> {
            PositionImpl actualPosition = newPosition;
            if (!(this.ledger.isValidPosition(actualPosition) || actualPosition.equals(PositionImpl.EARLIEST) || actualPosition.equals(PositionImpl.LATEST) || forceReset || (actualPosition = this.ledger.getNextValidPosition(actualPosition)) != null)) {
                actualPosition = PositionImpl.LATEST;
            }
            this.internalResetCursor(actualPosition, callback);
        });
    }

    @Override
    public void resetCursor(Position newPos) throws ManagedLedgerException, InterruptedException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncResetCursor(newPos, false, new AsyncCallbacks.ResetCursorCallback(){
            {
            }

            @Override
            public void resetComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void resetFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        });
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            if (result.exception != null) {
                log.warn("[{}] Reset cursor to {} on cursor {} timed out with exception {}", new Object[]{this.ledger.getName(), newPos, this.name, result.exception});
            }
            throw new ManagedLedgerException("Timeout during reset cursor");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public List<Entry> replayEntries(Set<? extends Position> positions) throws InterruptedException, ManagedLedgerException {
        final CountDownLatch counter = new CountDownLatch(1);
        class Result {
            ManagedLedgerException exception = null;
            List<Entry> entries = null;

            Result() {
            }
        }
        final Result result = new Result();
        this.asyncReplayEntries(positions, new AsyncCallbacks.ReadEntriesCallback(){
            {
            }

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                result.entries = entries;
                counter.countDown();
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        counter.await();
        if (result.exception != null) {
            throw result.exception;
        }
        return result.entries;
    }

    @Override
    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        return this.asyncReplayEntries(positions, callback, ctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions, final AsyncCallbacks.ReadEntriesCallback callback, Object ctx, final boolean sortEntries) {
        final ArrayList entries = Lists.newArrayListWithExpectedSize((int)positions.size());
        if (positions.isEmpty()) {
            callback.readEntriesComplete(entries, ctx);
            return Collections.emptySet();
        }
        HashSet alreadyAcknowledgedPositions = new HashSet();
        this.lock.readLock().lock();
        try {
            positions.stream().filter(this::internalIsMessageDeleted).forEach(alreadyAcknowledgedPositions::add);
        }
        finally {
            this.lock.readLock().unlock();
        }
        final int totalValidPositions = positions.size() - alreadyAcknowledgedPositions.size();
        final AtomicReference exception = new AtomicReference();
        AsyncCallbacks.ReadEntryCallback cb = new AsyncCallbacks.ReadEntryCallback(){
            int pendingCallbacks;
            {
                this.pendingCallbacks = totalValidPositions;
            }

            @Override
            public synchronized void readEntryComplete(Entry entry, Object ctx) {
                if (exception.get() != null) {
                    entry.release();
                    if (--this.pendingCallbacks == 0) {
                        callback.readEntriesFailed((ManagedLedgerException)exception.get(), ctx);
                    }
                } else {
                    entries.add(entry);
                    if (--this.pendingCallbacks == 0) {
                        if (sortEntries) {
                            entries.sort(ENTRY_COMPARATOR);
                        }
                        callback.readEntriesComplete(entries, ctx);
                    }
                }
            }

            @Override
            public synchronized void readEntryFailed(ManagedLedgerException mle, Object ctx) {
                log.warn("[{}][{}] Error while replaying entries", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, mle});
                if (exception.compareAndSet(null, mle)) {
                    entries.forEach(Entry::release);
                }
                if (--this.pendingCallbacks == 0) {
                    callback.readEntriesFailed((ManagedLedgerException)exception.get(), ctx);
                }
            }

            public String toString() {
                return String.format("Cursor [%s] async replay entries", ManagedCursorImpl.this);
            }
        };
        positions.stream().filter(position -> !alreadyAcknowledgedPositions.contains(position)).forEach(p -> {
            if (((PositionImpl)p).compareTo(this.readPosition) == 0) {
                this.setReadPosition(this.readPosition.getNext());
                log.warn("[{}][{}] replayPosition{} equals readPosition{}, need set next readPosition", new Object[]{this.ledger.getName(), this.name, p, this.readPosition});
            }
            this.ledger.asyncReadEntry((PositionImpl)p, cb, ctx);
        });
        return alreadyAcknowledgedPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNumberOfEntries(Range<PositionImpl> range) {
        long allEntries = this.ledger.getNumberOfEntries(range);
        if (log.isDebugEnabled()) {
            log.debug("[{}] getNumberOfEntries. {} allEntries: {}", new Object[]{this.ledger.getName(), range, allEntries});
        }
        AtomicLong deletedEntries = new AtomicLong(0L);
        this.lock.readLock().lock();
        try {
            if (this.getConfig().isUnackedRangesOpenCacheSetEnabled()) {
                int cardinality = this.individualDeletedMessages.cardinality(((PositionImpl)range.lowerEndpoint()).ledgerId, ((PositionImpl)range.lowerEndpoint()).entryId, ((PositionImpl)range.upperEndpoint()).ledgerId, ((PositionImpl)range.upperEndpoint()).entryId);
                deletedEntries.addAndGet(cardinality);
            } else {
                this.individualDeletedMessages.forEach((LongPairRangeSet.RangeProcessor<PositionImpl>)((LongPairRangeSet.RangeProcessor)r -> {
                    try {
                        if (r.isConnected(range)) {
                            Range commonEntries = r.intersection(range);
                            long commonCount = this.ledger.getNumberOfEntries((Range<PositionImpl>)commonEntries);
                            if (log.isDebugEnabled()) {
                                log.debug("[{}] [{}] Discounting {} entries for already deleted range {}", new Object[]{this.ledger.getName(), this.name, commonCount, commonEntries});
                            }
                            deletedEntries.addAndGet(commonCount);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        if (r.lowerEndpoint() instanceof PositionImplRecyclable) {
                            ((PositionImplRecyclable)r.lowerEndpoint()).recycle();
                            ((PositionImplRecyclable)r.upperEndpoint()).recycle();
                        }
                    }
                }), recyclePositionRangeConverter);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Found {} entries - deleted: {}", new Object[]{this.ledger.getName(), allEntries - deletedEntries.get(), deletedEntries});
        }
        return allEntries - deletedEntries.get();
    }

    @Override
    public void markDelete(Position position) throws InterruptedException, ManagedLedgerException {
        this.markDelete(position, Collections.emptyMap());
    }

    @Override
    public void markDelete(Position position, Map<String, Long> properties) throws InterruptedException, ManagedLedgerException {
        Objects.requireNonNull(position);
        Preconditions.checkArgument((boolean)(position instanceof PositionImpl));
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncMarkDelete(position, properties, new AsyncCallbacks.MarkDeleteCallback(){
            {
            }

            @Override
            public void markDeleteComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during mark-delete operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public void clearBacklog() throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncClearBacklog(new AsyncCallbacks.ClearBacklogCallback(){
            {
            }

            @Override
            public void clearBacklogComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void clearBacklogFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during clear backlog operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public void asyncClearBacklog(final AsyncCallbacks.ClearBacklogCallback callback, Object ctx) {
        this.asyncMarkDelete(this.ledger.getLastPosition(), new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                callback.clearBacklogComplete(ctx);
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                if (exception.getCause() instanceof IllegalArgumentException) {
                    callback.clearBacklogComplete(ctx);
                } else {
                    callback.clearBacklogFailed(exception, ctx);
                }
            }
        }, ctx);
    }

    @Override
    public void skipEntries(int numEntriesToSkip, ManagedCursor.IndividualDeletedEntries deletedEntries) throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        this.asyncSkipEntries(numEntriesToSkip, deletedEntries, new AsyncCallbacks.SkipEntriesCallback(){
            {
            }

            @Override
            public void skipEntriesComplete(Object ctx) {
                counter.countDown();
            }

            @Override
            public void skipEntriesFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during skip messages operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    @Override
    public void asyncSkipEntries(final int numEntriesToSkip, ManagedCursor.IndividualDeletedEntries deletedEntries, final AsyncCallbacks.SkipEntriesCallback callback, Object ctx) {
        log.info("[{}] Skipping {} entries on cursor {}", new Object[]{this.ledger.getName(), numEntriesToSkip, this.name});
        long numDeletedMessages = 0L;
        if (deletedEntries == ManagedCursor.IndividualDeletedEntries.Exclude) {
            numDeletedMessages = this.getNumIndividualDeletedEntriesToSkip(numEntriesToSkip);
        }
        this.asyncMarkDelete(this.ledger.getPositionAfterN(this.markDeletePosition, (long)numEntriesToSkip + numDeletedMessages, ManagedLedgerImpl.PositionBound.startExcluded), new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                callback.skipEntriesComplete(ctx);
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                if (exception.getCause() instanceof IllegalArgumentException) {
                    callback.skipEntriesComplete(ctx);
                } else {
                    log.error("[{}] Skip {} entries failed for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), numEntriesToSkip, ManagedCursorImpl.this.name, exception});
                    callback.skipEntriesFailed(exception, ctx);
                }
            }
        }, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNumIndividualDeletedEntriesToSkip(long numEntries) {
        this.lock.readLock().lock();
        try {
            InvidualDeletedMessagesHandlingState state = new InvidualDeletedMessagesHandlingState(this.markDeletePosition);
            this.individualDeletedMessages.forEach((LongPairRangeSet.RangeProcessor<PositionImpl>)((LongPairRangeSet.RangeProcessor)r -> {
                try {
                    state.endPosition = (PositionImpl)r.lowerEndpoint();
                    if (state.startPosition.compareTo(state.endPosition) <= 0) {
                        Range range = Range.openClosed((Comparable)state.startPosition, (Comparable)state.endPosition);
                        long entries = this.ledger.getNumberOfEntries((Range<PositionImpl>)range);
                        if (state.totalEntriesToSkip + entries >= numEntries) {
                            boolean bl = false;
                            return bl;
                        }
                        state.totalEntriesToSkip += entries;
                        state.deletedMessages += this.ledger.getNumberOfEntries((Range<PositionImpl>)r);
                        state.startPosition = (PositionImpl)r.upperEndpoint();
                    } else if (log.isDebugEnabled()) {
                        log.debug("[{}] deletePosition {} moved ahead without clearing deleteMsgs {} for cursor {}", new Object[]{this.ledger.getName(), this.markDeletePosition, r.lowerEndpoint(), this.name});
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (r.lowerEndpoint() instanceof PositionImplRecyclable) {
                        ((PositionImplRecyclable)r.lowerEndpoint()).recycle();
                    }
                }
            }), recyclePositionRangeConverter);
            long l = state.deletedMessages;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    boolean hasMoreEntries(PositionImpl position) {
        PositionImpl lastPositionInLedger = this.ledger.getLastPosition();
        if (position.compareTo(lastPositionInLedger) <= 0) {
            return this.getNumberOfEntries((Range<PositionImpl>)Range.closed((Comparable)position, (Comparable)lastPositionInLedger)) > 0L;
        }
        return false;
    }

    void initializeCursorPosition(Pair<PositionImpl, Long> lastPositionCounter) {
        this.readPosition = this.ledger.getNextValidPosition((PositionImpl)lastPositionCounter.getLeft());
        this.ledger.onCursorReadPositionUpdated(this, this.readPosition);
        this.markDeletePosition = (PositionImpl)lastPositionCounter.getLeft();
        this.lastMarkDeleteEntry = new MarkDeleteEntry(this.markDeletePosition, this.getProperties(), null, null);
        this.persistentMarkDeletePosition = null;
        this.inProgressMarkDeletePersistPosition = null;
        this.messagesConsumedCounter = (Long)lastPositionCounter.getRight();
    }

    PositionImpl setAcknowledgedPosition(PositionImpl newMarkDeletePosition) {
        if (newMarkDeletePosition.compareTo(this.markDeletePosition) < 0) {
            throw new MarkDeletingMarkedPosition("Mark deleting an already mark-deleted position. Current mark-delete: " + String.valueOf(this.markDeletePosition) + " -- attempted mark delete: " + String.valueOf(newMarkDeletePosition));
        }
        PositionImpl oldMarkDeletePosition = this.markDeletePosition;
        if (!newMarkDeletePosition.equals(oldMarkDeletePosition)) {
            long skippedEntries = 0L;
            skippedEntries = newMarkDeletePosition.getLedgerId() == oldMarkDeletePosition.getLedgerId() && newMarkDeletePosition.getEntryId() == oldMarkDeletePosition.getEntryId() + 1L ? (this.individualDeletedMessages.contains(newMarkDeletePosition.getLedgerId(), newMarkDeletePosition.getEntryId()) ? 0L : 1L) : this.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)oldMarkDeletePosition, (Comparable)newMarkDeletePosition));
            PositionImpl positionAfterNewMarkDelete = this.ledger.getNextValidPosition(newMarkDeletePosition);
            while (positionAfterNewMarkDelete.compareTo(this.ledger.lastConfirmedEntry) <= 0 && this.individualDeletedMessages.contains(positionAfterNewMarkDelete.getLedgerId(), positionAfterNewMarkDelete.getEntryId())) {
                Range<PositionImpl> rangeToBeMarkDeleted = this.individualDeletedMessages.rangeContaining(positionAfterNewMarkDelete.getLedgerId(), positionAfterNewMarkDelete.getEntryId());
                newMarkDeletePosition = (PositionImpl)rangeToBeMarkDeleted.upperEndpoint();
                positionAfterNewMarkDelete = this.ledger.getNextValidPosition(newMarkDeletePosition);
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] Moved ack position from: {} to: {} -- skipped: {}", new Object[]{this.ledger.getName(), oldMarkDeletePosition, newMarkDeletePosition, skippedEntries});
            }
            MSG_CONSUMED_COUNTER_UPDATER.addAndGet(this, skippedEntries);
        }
        this.markDeletePosition = newMarkDeletePosition;
        this.individualDeletedMessages.removeAtMost(this.markDeletePosition.getLedgerId(), this.markDeletePosition.getEntryId());
        READ_POSITION_UPDATER.updateAndGet(this, currentReadPosition -> {
            if (currentReadPosition.compareTo(this.markDeletePosition) <= 0) {
                PositionImpl newReadPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Moved read position from: {} to: {}, and new mark-delete position {}", new Object[]{this.ledger.getName(), currentReadPosition, newReadPosition, this.markDeletePosition});
                }
                this.ledger.onCursorReadPositionUpdated(this, newReadPosition);
                return newReadPosition;
            }
            return currentReadPosition;
        });
        return newMarkDeletePosition;
    }

    @Override
    public void asyncMarkDelete(Position position, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        this.asyncMarkDelete(position, Collections.emptyMap(), callback, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncMarkDelete(Position position, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        Objects.requireNonNull(position);
        Preconditions.checkArgument((boolean)(position instanceof PositionImpl));
        if (this.isClosed()) {
            callback.markDeleteFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        if (RESET_CURSOR_IN_PROGRESS_UPDATER.get(this) == 1) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] cursor reset in progress - ignoring mark delete on position [{}] for cursor [{}]", new Object[]{this.ledger.getName(), position, this.name});
            }
            callback.markDeleteFailed(new ManagedLedgerException("Reset cursor in progress - unable to mark delete position " + position.toString()), ctx);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Mark delete cursor {} up to position: {}", new Object[]{this.ledger.getName(), this.name, position});
        }
        PositionImpl newPosition = this.ackBatchPosition((PositionImpl)position);
        if (((PositionImpl)this.ledger.getLastConfirmedEntry()).compareTo(newPosition) < 0) {
            boolean shouldCursorMoveForward = false;
            try {
                long ledgerEntries = this.ledger.getLedgerInfo(this.markDeletePosition.getLedgerId()).get().getEntries();
                Long nextValidLedger = this.ledger.getNextValidLedger(this.ledger.getLastConfirmedEntry().getLedgerId());
                shouldCursorMoveForward = nextValidLedger != null && this.markDeletePosition.getEntryId() + 1L >= ledgerEntries && newPosition.getLedgerId() == nextValidLedger.longValue();
            }
            catch (Exception e) {
                log.warn("Failed to get ledger entries while setting mark-delete-position", (Throwable)e);
            }
            if (shouldCursorMoveForward) {
                log.info("[{}] move mark-delete-position from {} to {} since all the entries have been consumed", new Object[]{this.ledger.getName(), this.markDeletePosition, newPosition});
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Failed mark delete due to invalid markDelete {} is ahead of last-confirmed-entry {} for cursor [{}]", new Object[]{this.ledger.getName(), position, this.ledger.getLastConfirmedEntry(), this.name});
                }
                callback.markDeleteFailed(new ManagedLedgerException("Invalid mark deleted position"), ctx);
                return;
            }
        }
        this.lock.writeLock().lock();
        try {
            newPosition = this.setAcknowledgedPosition(newPosition);
        }
        catch (IllegalArgumentException e) {
            callback.markDeleteFailed(ManagedLedgerException.getManagedLedgerException(e), ctx);
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (this.markDeleteLimiter != null && !this.markDeleteLimiter.tryAcquire()) {
            this.isDirty = true;
            this.updateLastMarkDeleteEntryToLatest(newPosition, properties);
            callback.markDeleteComplete(ctx);
            return;
        }
        this.internalAsyncMarkDelete(newPosition, properties, callback, ctx);
    }

    private PositionImpl ackBatchPosition(PositionImpl position) {
        return Optional.ofNullable(position.getAckSet()).map(ackSet -> {
            if (this.batchDeletedIndexes == null) {
                return this.ledger.getPreviousPosition(position);
            }
            BitSet givenBitSet = BitSet.valueOf(ackSet);
            this.batchDeletedIndexes.compute(position, (k, v) -> {
                if (v == null || givenBitSet.nextSetBit(0) > v.nextSetBit(0)) {
                    return givenBitSet;
                }
                return v;
            });
            PositionImpl newPosition = this.ledger.getPreviousPosition(position);
            this.batchDeletedIndexes.subMap((Object)PositionImpl.EARLIEST, (Object)newPosition).clear();
            return newPosition;
        }).orElse(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalAsyncMarkDelete(PositionImpl newPosition, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        this.ledger.mbean.addMarkDeleteOp();
        MarkDeleteEntry mdEntry = new MarkDeleteEntry(newPosition, properties, callback, ctx);
        ArrayDeque<MarkDeleteEntry> arrayDeque = this.pendingMarkDeleteOps;
        synchronized (arrayDeque) {
            switch (STATE_UPDATER.get(this)) {
                case Closed: {
                    callback.markDeleteFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
                    return;
                }
                case NoLedger: {
                    this.pendingMarkDeleteOps.add(mdEntry);
                    this.startCreatingNewMetadataLedger();
                    break;
                }
                case SwitchingLedger: {
                    this.pendingMarkDeleteOps.add(mdEntry);
                    break;
                }
                case Open: {
                    if (PENDING_READ_OPS_UPDATER.get(this) > 0) {
                        this.pendingMarkDeleteOps.add(mdEntry);
                        break;
                    }
                    this.internalMarkDelete(mdEntry);
                    break;
                }
                default: {
                    log.error("[{}][{}] Invalid cursor state: {}", new Object[]{this.ledger.getName(), this.name, this.state});
                    callback.markDeleteFailed(new ManagedLedgerException("Cursor was in invalid state: " + String.valueOf((Object)this.state)), ctx);
                }
            }
        }
    }

    void internalMarkDelete(final MarkDeleteEntry mdEntry) {
        if (this.persistentMarkDeletePosition != null && mdEntry.newPosition.compareTo(this.persistentMarkDeletePosition) < 0) {
            if (log.isInfoEnabled()) {
                log.info("Skipping updating mark delete position to {}. The persisted mark delete position {} is later.", (Object)mdEntry.newPosition, (Object)this.persistentMarkDeletePosition);
            }
            this.ledger.getExecutor().execute(() -> mdEntry.triggerComplete());
            return;
        }
        PositionImpl inProgressLatest = INPROGRESS_MARKDELETE_PERSIST_POSITION_UPDATER.updateAndGet(this, current -> {
            if (current != null && current.compareTo(mdEntry.newPosition) > 0) {
                return current;
            }
            return mdEntry.newPosition;
        });
        if (inProgressLatest != mdEntry.newPosition) {
            if (log.isInfoEnabled()) {
                log.info("Skipping updating mark delete position to {}. The mark delete position update in progress {} is later.", (Object)mdEntry.newPosition, (Object)inProgressLatest);
            }
            this.ledger.getExecutor().execute(() -> mdEntry.triggerComplete());
            return;
        }
        PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.incrementAndGet(this);
        LAST_MARK_DELETE_ENTRY_UPDATER.updateAndGet(this, last -> {
            if (last != null && last.newPosition.compareTo(mdEntry.newPosition) > 0) {
                return last;
            }
            return mdEntry;
        });
        VoidCallback cb = new VoidCallback(){

            @Override
            public void operationComplete() {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Mark delete cursor {} to position {} succeeded", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, mdEntry.newPosition});
                }
                INPROGRESS_MARKDELETE_PERSIST_POSITION_UPDATER.compareAndSet(ManagedCursorImpl.this, mdEntry.newPosition, null);
                ManagedCursorImpl.this.lock.writeLock().lock();
                try {
                    ManagedCursorImpl.this.individualDeletedMessages.removeAtMost(mdEntry.newPosition.getLedgerId(), mdEntry.newPosition.getEntryId());
                    if (ManagedCursorImpl.this.batchDeletedIndexes != null) {
                        ManagedCursorImpl.this.batchDeletedIndexes.subMap((Object)PositionImpl.EARLIEST, false, (Object)PositionImpl.get(mdEntry.newPosition.getLedgerId(), mdEntry.newPosition.getEntryId()), true).clear();
                    }
                    ManagedCursorImpl.this.persistentMarkDeletePosition = mdEntry.newPosition;
                }
                finally {
                    ManagedCursorImpl.this.lock.writeLock().unlock();
                }
                ManagedCursorImpl.this.ledger.onCursorMarkDeletePositionUpdated(ManagedCursorImpl.this, mdEntry.newPosition);
                ManagedCursorImpl.this.decrementPendingMarkDeleteCount();
                mdEntry.triggerComplete();
            }

            @Override
            public void operationFailed(ManagedLedgerException exception) {
                INPROGRESS_MARKDELETE_PERSIST_POSITION_UPDATER.compareAndSet(ManagedCursorImpl.this, mdEntry.newPosition, null);
                ManagedCursorImpl.this.isDirty = true;
                log.warn("[{}] Failed to mark delete position for cursor={} position={}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this, mdEntry.newPosition});
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Consumer {} cursor mark delete failed with counters: consumed {} mdPos {} rdPos {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.messagesConsumedCounter, ManagedCursorImpl.this.markDeletePosition, ManagedCursorImpl.this.readPosition});
                }
                ManagedCursorImpl.this.decrementPendingMarkDeleteCount();
                mdEntry.triggerFailed(exception);
            }
        };
        if (State.NoLedger.equals((Object)STATE_UPDATER.get(this))) {
            if (this.ledger.isNoMessagesAfterPos(mdEntry.newPosition)) {
                this.persistPositionToMetaStore(mdEntry, cb);
            } else {
                cb.operationFailed(new ManagedLedgerException("Switch new cursor ledger failed"));
            }
        } else {
            this.persistPositionToLedger(this.cursorLedger, mdEntry, cb);
        }
    }

    @Override
    public void delete(Position position) throws InterruptedException, ManagedLedgerException {
        this.delete(Collections.singletonList(position));
    }

    @Override
    public void asyncDelete(Position pos, AsyncCallbacks.DeleteCallback callback, Object ctx) {
        this.asyncDelete(Collections.singletonList(pos), callback, ctx);
    }

    @Override
    public void delete(final Iterable<Position> positions) throws InterruptedException, ManagedLedgerException {
        Objects.requireNonNull(positions);
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch counter = new CountDownLatch(1);
        final AtomicBoolean timeout = new AtomicBoolean(false);
        this.asyncDelete(positions, new AsyncCallbacks.DeleteCallback(){
            {
            }

            @Override
            public void deleteComplete(Object ctx) {
                if (timeout.get()) {
                    log.warn("[{}] [{}] Delete operation timeout. Callback deleteComplete at position {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, positions});
                }
                counter.countDown();
            }

            @Override
            public void deleteFailed(ManagedLedgerException exception, Object ctx) {
                result.exception = exception;
                if (timeout.get()) {
                    log.warn("[{}] [{}] Delete operation timeout. Callback deleteFailed at position {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, positions});
                }
                counter.countDown();
            }
        }, null);
        if (!counter.await(30L, TimeUnit.SECONDS)) {
            timeout.set(true);
            log.warn("[{}] [{}] Delete operation timeout. No callback was triggered at position {}", new Object[]{this.ledger.getName(), this.name, positions});
            throw new ManagedLedgerException("Timeout during delete operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDelete(Iterable<Position> positions, final AsyncCallbacks.DeleteCallback callback, Object ctx) {
        if (this.isClosed()) {
            callback.deleteFailed(new ManagedLedgerException.CursorAlreadyClosedException("Cursor was already closed"), ctx);
            return;
        }
        PositionImpl newMarkDeletePosition = null;
        this.lock.writeLock().lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Deleting individual messages at {}. Current status: {} - md-position: {}", new Object[]{this.ledger.getName(), this.name, positions, this.individualDeletedMessages, this.markDeletePosition});
            }
            for (Position pos : positions) {
                BitSet bitSet;
                PositionImpl position = (PositionImpl)Objects.requireNonNull(pos);
                if (((PositionImpl)this.ledger.getLastConfirmedEntry()).compareTo(position) < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Failed mark delete due to invalid markDelete {} is ahead of last-confirmed-entry {} for cursor [{}]", new Object[]{this.ledger.getName(), position, this.ledger.getLastConfirmedEntry(), this.name});
                    }
                    callback.deleteFailed(new ManagedLedgerException("Invalid mark deleted position"), ctx);
                    return;
                }
                if (this.internalIsMessageDeleted(position)) {
                    if (this.batchDeletedIndexes != null) {
                        this.batchDeletedIndexes.remove(position);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("[{}] [{}] Position was already deleted {}", new Object[]{this.ledger.getName(), this.name, position});
                    continue;
                }
                if (position.ackSet == null) {
                    if (this.batchDeletedIndexes != null) {
                        this.batchDeletedIndexes.remove(position);
                    }
                    PositionImpl previousPosition = position.getEntryId() == 0L ? new PositionImpl(position.getLedgerId(), -1L) : this.ledger.getPreviousPosition(position);
                    this.individualDeletedMessages.addOpenClosed(previousPosition.getLedgerId(), previousPosition.getEntryId(), position.getLedgerId(), position.getEntryId());
                    MSG_CONSUMED_COUNTER_UPDATER.incrementAndGet(this);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("[{}] [{}] Individually deleted messages: {}", new Object[]{this.ledger.getName(), this.name, this.individualDeletedMessages});
                    continue;
                }
                if (this.batchDeletedIndexes == null) continue;
                BitSet givenBitSet = BitSet.valueOf(position.ackSet);
                if (givenBitSet != (bitSet = this.batchDeletedIndexes.computeIfAbsent(position, __ -> givenBitSet))) {
                    bitSet.and(givenBitSet);
                }
                if (!bitSet.isEmpty()) continue;
                PositionImpl previousPosition = this.ledger.getPreviousPosition(position);
                this.individualDeletedMessages.addOpenClosed(previousPosition.getLedgerId(), previousPosition.getEntryId(), position.getLedgerId(), position.getEntryId());
                MSG_CONSUMED_COUNTER_UPDATER.incrementAndGet(this);
                this.batchDeletedIndexes.remove(position);
            }
            if (this.individualDeletedMessages.isEmpty()) {
                return;
            }
            Range<PositionImpl> range = this.individualDeletedMessages.firstRange();
            if (((PositionImpl)range.upperEndpoint()).compareTo(this.markDeletePosition) <= 0) {
                this.individualDeletedMessages.removeAtMost(this.markDeletePosition.getLedgerId(), this.markDeletePosition.getEntryId());
                range = this.individualDeletedMessages.firstRange();
            }
            if (range == null) {
                return;
            }
            if (((PositionImpl)range.lowerEndpoint()).compareTo(this.markDeletePosition) <= 0 || this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)this.markDeletePosition, (Comparable)((PositionImpl)range.lowerEndpoint()))) <= 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Found a position range to mark delete for cursor {}: {} ", new Object[]{this.ledger.getName(), this.name, range});
                }
                newMarkDeletePosition = (PositionImpl)range.upperEndpoint();
            }
            newMarkDeletePosition = newMarkDeletePosition != null ? this.setAcknowledgedPosition(newMarkDeletePosition) : this.markDeletePosition;
        }
        catch (Exception e) {
            log.warn("[{}] [{}] Error while updating individualDeletedMessages [{}]", new Object[]{this.ledger.getName(), this.name, e.getMessage(), e});
            callback.deleteFailed(ManagedLedgerException.getManagedLedgerException(e), ctx);
            return;
        }
        finally {
            boolean empty = this.individualDeletedMessages.isEmpty();
            this.lock.writeLock().unlock();
            if (empty) {
                callback.deleteComplete(ctx);
            }
        }
        if (this.markDeleteLimiter != null && !this.markDeleteLimiter.tryAcquire()) {
            this.isDirty = true;
            this.updateLastMarkDeleteEntryToLatest(newMarkDeletePosition, null);
            callback.deleteComplete(ctx);
            return;
        }
        try {
            Map<String, Long> properties = this.lastMarkDeleteEntry != null ? this.lastMarkDeleteEntry.properties : Collections.emptyMap();
            this.internalAsyncMarkDelete(newMarkDeletePosition, properties, new AsyncCallbacks.MarkDeleteCallback(){

                @Override
                public void markDeleteComplete(Object ctx) {
                    callback.deleteComplete(ctx);
                }

                @Override
                public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                    callback.deleteFailed(exception, ctx);
                }
            }, ctx);
        }
        catch (Exception e) {
            log.warn("[{}] [{}] Error doing asyncDelete [{}]", new Object[]{this.ledger.getName(), this.name, e.getMessage(), e});
            if (log.isDebugEnabled()) {
                log.debug("[{}] Consumer {} cursor asyncDelete error, counters: consumed {} mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
            }
            callback.deleteFailed(new ManagedLedgerException(e), ctx);
        }
    }

    private void updateLastMarkDeleteEntryToLatest(PositionImpl newPosition, Map<String, Long> properties) {
        LAST_MARK_DELETE_ENTRY_UPDATER.updateAndGet(this, last -> {
            if (last != null && last.newPosition.compareTo(newPosition) > 0) {
                return last;
            }
            Map<String, Long> propertiesToUse = properties != null ? properties : (last != null ? last.properties : Collections.emptyMap());
            return new MarkDeleteEntry(newPosition, propertiesToUse, null, null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Entry> filterReadEntries(List<Entry> entries) {
        this.lock.readLock().lock();
        try {
            Range<PositionImpl> span;
            Range entriesRange = Range.closed((Comparable)((PositionImpl)entries.get(0).getPosition()), (Comparable)((PositionImpl)entries.get(entries.size() - 1).getPosition()));
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Filtering entries {} - alreadyDeleted: {}", new Object[]{this.ledger.getName(), this.name, entriesRange, this.individualDeletedMessages});
            }
            Range<PositionImpl> range = span = this.individualDeletedMessages.isEmpty() ? null : this.individualDeletedMessages.span();
            if (span == null || !entriesRange.isConnected(span)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] No filtering needed for entries {}", new Object[]{this.ledger.getName(), this.name, entriesRange});
                }
                List<Entry> list = entries;
                return list;
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(entries, entry -> {
                boolean includeEntry;
                boolean bl = includeEntry = !this.individualDeletedMessages.contains(entry.getLedgerId(), entry.getEntryId());
                if (!includeEntry) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] Filtering entry at {} - already deleted", new Object[]{this.ledger.getName(), this.name, entry.getPosition()});
                    }
                    entry.release();
                }
                return includeEntry;
            }));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ledger", (Object)this.ledger.getName()).add("name", (Object)this.name).add("ackPos", (Object)this.markDeletePosition).add("readPos", (Object)this.readPosition).toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLastActive() {
        return this.lastActive;
    }

    @Override
    public void updateLastActive() {
        this.lastActive = System.currentTimeMillis();
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public Position getReadPosition() {
        return this.readPosition;
    }

    @Override
    public Position getMarkDeletedPosition() {
        return this.markDeletePosition;
    }

    @Override
    public Position getPersistentMarkDeletedPosition() {
        return this.persistentMarkDeletePosition;
    }

    @Override
    public void rewind() {
        this.rewind(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewind(boolean readCompacted) {
        this.lock.writeLock().lock();
        try {
            PositionImpl newReadPosition = readCompacted ? this.markDeletePosition.getNext() : this.ledger.getNextValidPosition(this.markDeletePosition);
            PositionImpl oldReadPosition = this.readPosition;
            log.info("[{}-{}] Rewind from {} to {}", new Object[]{this.ledger.getName(), this.name, oldReadPosition, newReadPosition});
            this.readPosition = newReadPosition;
            this.ledger.onCursorReadPositionUpdated(this, newReadPosition);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(Position newReadPositionInt, boolean force) {
        Preconditions.checkArgument((boolean)(newReadPositionInt instanceof PositionImpl));
        PositionImpl newReadPosition = (PositionImpl)newReadPositionInt;
        this.lock.writeLock().lock();
        try {
            if (!force && newReadPosition.compareTo(this.markDeletePosition) <= 0) {
                newReadPosition = this.ledger.getNextValidPosition(this.markDeletePosition);
            }
            this.readPosition = newReadPosition;
            this.ledger.onCursorReadPositionUpdated(this, newReadPosition);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    boolean closeCursorLedger() throws BKException, InterruptedException {
        if (this.cursorLedger != null) {
            this.cursorLedger.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws InterruptedException, ManagedLedgerException {
        class Result {
            ManagedLedgerException exception = null;

            Result() {
            }
        }
        final Result result = new Result();
        final CountDownLatch latch = new CountDownLatch(1);
        this.asyncClose(new AsyncCallbacks.CloseCallback(){
            {
            }

            @Override
            public void closeComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Successfully closed ledger for cursor {}", (Object)ManagedCursorImpl.this.ledger.getName(), (Object)ManagedCursorImpl.this.name);
                }
                latch.countDown();
            }

            @Override
            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Closing ledger failed for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, exception});
                result.exception = exception;
                latch.countDown();
            }
        }, null);
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            throw new ManagedLedgerException("Timeout during close operation");
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    void persistPositionWhenClosing(PositionImpl position, Map<String, Long> properties, final AsyncCallbacks.CloseCallback callback, final Object ctx) {
        if (this.shouldPersistUnackRangesToLedger()) {
            this.persistPositionToLedger(this.cursorLedger, new MarkDeleteEntry(position, properties, null, null), new VoidCallback(){

                @Override
                public void operationComplete() {
                    log.info("[{}][{}] Updated md-position={} into cursor-ledger {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.markDeletePosition, ManagedCursorImpl.this.cursorLedger.getId()});
                    ManagedCursorImpl.this.asyncCloseCursorLedger(callback, ctx);
                }

                @Override
                public void operationFailed(ManagedLedgerException e) {
                    log.warn("[{}][{}] Failed to persist mark-delete position into cursor-ledger{}: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.cursorLedger.getId(), e.getMessage()});
                    callback.closeFailed(e, ctx);
                }
            });
        } else {
            this.persistPositionMetaStore(-1L, position, properties, new MetaStore.MetaStoreCallback<Void>(){

                @Override
                public void operationComplete(Void result, Stat stat) {
                    log.info("[{}][{}] Closed cursor at md-position={}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.markDeletePosition});
                    callback.closeComplete(ctx);
                    ManagedCursorImpl.this.asyncDeleteLedger(ManagedCursorImpl.this.cursorLedger);
                }

                @Override
                public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                    log.warn("[{}][{}] Failed to update cursor info when closing: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, e.getMessage()});
                    callback.closeFailed(e, ctx);
                }
            }, true);
        }
    }

    private boolean shouldPersistUnackRangesToLedger() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.cursorLedger != null && !this.isCursorLedgerReadOnly && this.getConfig().getMaxUnackedRangesToPersist() > 0 && this.individualDeletedMessages.size() > this.getConfig().getMaxUnackedRangesToPersistInMetadataStore();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void persistPositionMetaStore(long cursorsLedgerId, PositionImpl position, Map<String, Long> properties, final MetaStore.MetaStoreCallback<Void> callback, boolean persistIndividualDeletedMessageRanges) {
        if (this.state == State.Closed) {
            this.ledger.getExecutor().execute(() -> callback.operationFailed(new ManagedLedgerException.MetaStoreException(new ManagedLedgerException.CursorAlreadyClosedException(this.name + " cursor already closed"))));
            return;
        }
        Stat lastCursorLedgerStat = this.cursorLedgerStat;
        MLDataFormats.ManagedCursorInfo.Builder info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(cursorsLedgerId).setMarkDeleteLedgerId(position.getLedgerId()).setMarkDeleteEntryId(position.getEntryId()).setLastActive(this.lastActive);
        info.addAllProperties(ManagedCursorImpl.buildPropertiesMap(properties));
        info.addAllCursorProperties(ManagedCursorImpl.buildStringPropertiesMap(this.cursorProperties));
        if (persistIndividualDeletedMessageRanges) {
            info.addAllIndividualDeletedMessages(this.buildIndividualDeletedMessageRanges());
            if (this.getConfig().isDeletionAtBatchIndexLevelEnabled()) {
                info.addAllBatchedEntryDeletionIndexInfo(this.buildBatchEntryDeletionIndexInfoList());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}]  Closing cursor at md-position: {}", new Object[]{this.ledger.getName(), this.name, position});
        }
        final MLDataFormats.ManagedCursorInfo cursorInfo = info.build();
        this.ledger.getStore().asyncUpdateCursorInfo(this.ledger.getName(), this.name, cursorInfo, lastCursorLedgerStat, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                ManagedCursorImpl.this.updateCursorLedgerStat(cursorInfo, stat);
                callback.operationComplete(result, stat);
            }

            @Override
            public void operationFailed(final ManagedLedgerException.MetaStoreException topLevelException) {
                if (topLevelException instanceof ManagedLedgerException.BadVersionException) {
                    log.warn("[{}] Failed to update cursor metadata for {} due to version conflict {}", new Object[]{ManagedCursorImpl.this.ledger.name, ManagedCursorImpl.this.name, topLevelException.getMessage()});
                    if (ManagedCursorImpl.this.ledger.mlOwnershipChecker != null) {
                        ManagedCursorImpl.this.ledger.mlOwnershipChecker.get().whenComplete((hasOwnership, t) -> {
                            if (t == null && hasOwnership.booleanValue()) {
                                ManagedCursorImpl.this.ledger.getStore().asyncGetCursorInfo(ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

                                    @Override
                                    public void operationComplete(MLDataFormats.ManagedCursorInfo info, Stat stat) {
                                        ManagedCursorImpl.this.updateCursorLedgerStat(info, stat);
                                        callback.operationFailed(topLevelException);
                                    }

                                    @Override
                                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                                        if (log.isDebugEnabled()) {
                                            log.debug("[{}] Failed to refresh cursor metadata-version for {} due to {}", new Object[]{ManagedCursorImpl.this.ledger.name, ManagedCursorImpl.this.name, e.getMessage()});
                                        }
                                        callback.operationFailed(topLevelException);
                                    }
                                });
                            } else {
                                callback.operationFailed(topLevelException);
                            }
                        });
                    } else {
                        callback.operationFailed(topLevelException);
                    }
                } else {
                    callback.operationFailed(topLevelException);
                }
            }
        });
    }

    @Override
    public void asyncClose(final AsyncCallbacks.CloseCallback callback, Object ctx) {
        boolean alreadyClosing;
        boolean bl = alreadyClosing = !this.trySetStateToClosing();
        if (alreadyClosing) {
            log.info("[{}] [{}] State is already closed", (Object)this.ledger.getName(), (Object)this.name);
            callback.closeComplete(ctx);
            return;
        }
        this.persistPositionWhenClosing(this.lastMarkDeleteEntry.newPosition, this.lastMarkDeleteEntry.properties, new AsyncCallbacks.CloseCallback(){

            @Override
            public void closeComplete(Object ctx) {
                STATE_UPDATER.set(ManagedCursorImpl.this, State.Closed);
                callback.closeComplete(ctx);
            }

            @Override
            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] [{}] persistent position failure when closing, the state will remain in state-closing and will no longer work", (Object)ManagedCursorImpl.this.ledger.getName(), (Object)ManagedCursorImpl.this.name);
                callback.closeFailed(exception, ctx);
            }
        }, ctx);
    }

    void setReadPosition(Position newReadPositionInt) {
        Preconditions.checkArgument((boolean)(newReadPositionInt instanceof PositionImpl));
        if (this.markDeletePosition == null || ((PositionImpl)newReadPositionInt).compareTo(this.markDeletePosition) > 0) {
            this.readPosition = (PositionImpl)newReadPositionInt;
            this.ledger.onCursorReadPositionUpdated(this, newReadPositionInt);
        }
    }

    @Override
    public void skipNonRecoverableLedger(long ledgerId) {
        MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgersInfo().get(ledgerId);
        if (ledgerInfo == null) {
            return;
        }
        log.warn("[{}] [{}] Since the ledger [{}] is lost and the autoSkipNonRecoverableData is true, this ledger will be auto acknowledge in subscription", new Object[]{this.ledger.getName(), this.name, ledgerId});
        this.asyncDelete(() -> LongStream.range(0L, ledgerInfo.getEntries()).mapToObj(i -> PositionImpl.get(ledgerId, i)).iterator(), new AsyncCallbacks.DeleteCallback(){

            @Override
            public void deleteComplete(Object ctx) {
            }

            @Override
            public void deleteFailed(ManagedLedgerException ex, Object ctx) {
            }
        }, null);
    }

    void startCreatingNewMetadataLedger() {
        State oldState = STATE_UPDATER.getAndSet(this, State.SwitchingLedger);
        if (oldState == State.SwitchingLedger) {
            return;
        }
        if (PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.get(this) == 0) {
            this.createNewMetadataLedger();
        }
    }

    void createNewMetadataLedger() {
        this.createNewMetadataLedger(new VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete() {
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    ManagedCursorImpl.this.flushPendingMarkDeletes();
                    STATE_UPDATER.set(ManagedCursorImpl.this, State.Open);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationFailed(ManagedLedgerException exception) {
                log.error("[{}][{}] Metadata ledger creation failed {}, try to persist the position in the metadata store.", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, exception});
                ArrayDeque<MarkDeleteEntry> arrayDeque = ManagedCursorImpl.this.pendingMarkDeleteOps;
                synchronized (arrayDeque) {
                    STATE_UPDATER.set(ManagedCursorImpl.this, State.NoLedger);
                    if (!(exception instanceof ManagedLedgerException.MetaStoreException)) {
                        ManagedCursorImpl.this.flushPendingMarkDeletes();
                    } else {
                        while (!ManagedCursorImpl.this.pendingMarkDeleteOps.isEmpty()) {
                            MarkDeleteEntry entry = ManagedCursorImpl.this.pendingMarkDeleteOps.poll();
                            entry.callback.markDeleteFailed(exception, entry.ctx);
                        }
                    }
                }
            }
        });
    }

    private boolean trySetStateToClosing() {
        AtomicBoolean notClosing = new AtomicBoolean(false);
        STATE_UPDATER.updateAndGet(this, state -> {
            switch (state) {
                case Closed: 
                case Closing: {
                    notClosing.set(false);
                    return state;
                }
            }
            notClosing.set(true);
            return State.Closing;
        });
        return notClosing.get();
    }

    private void flushPendingMarkDeletes() {
        if (!this.pendingMarkDeleteOps.isEmpty()) {
            this.internalFlushPendingMarkDeletes();
        }
    }

    void internalFlushPendingMarkDeletes() {
        MarkDeleteEntry lastEntry = this.pendingMarkDeleteOps.getLast();
        lastEntry.callbackGroup = Lists.newArrayList(this.pendingMarkDeleteOps);
        this.pendingMarkDeleteOps.clear();
        this.internalMarkDelete(lastEntry);
    }

    void createNewMetadataLedger(VoidCallback callback) {
        this.ledger.mbean.startCursorLedgerCreateOp();
        ((CompletableFuture)this.doCreateNewMetadataLedger().thenAccept(newLedgerHandle -> {
            if (newLedgerHandle == null) {
                return;
            }
            final MarkDeleteEntry mdEntry = this.lastMarkDeleteEntry;
            this.persistPositionToLedger((LedgerHandle)newLedgerHandle, mdEntry, new VoidCallback(){
                final /* synthetic */ LedgerHandle val$newLedgerHandle;
                final /* synthetic */ VoidCallback val$callback;
                {
                    this.val$newLedgerHandle = ledgerHandle;
                    this.val$callback = voidCallback;
                }

                @Override
                public void operationComplete() {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Persisted position {} for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), mdEntry.newPosition, ManagedCursorImpl.this.name});
                    }
                    ManagedCursorImpl.this.switchToNewLedger(this.val$newLedgerHandle, this.val$callback);
                }

                @Override
                public void operationFailed(ManagedLedgerException exception) {
                    log.warn("[{}] Failed to persist position {} for cursor {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), mdEntry.newPosition, ManagedCursorImpl.this.name});
                    ManagedCursorImpl.this.deleteLedgerAsync(this.val$newLedgerHandle);
                    this.val$callback.operationFailed(exception);
                }
            });
        })).whenComplete((result, e) -> {
            this.ledger.mbean.endCursorLedgerCreateOp();
            if (e != null) {
                callback.operationFailed(ManagedLedgerImpl.createManagedLedgerException(e));
            }
        });
    }

    private CompletableFuture<LedgerHandle> doCreateNewMetadataLedger() {
        CompletableFuture<LedgerHandle> future = new CompletableFuture<LedgerHandle>();
        this.ledger.asyncCreateLedger(this.bookkeeper, this.getConfig(), this.digestType, (rc, lh, ctx) -> {
            if (this.ledger.checkAndCompleteLedgerOpTask(rc, lh, ctx)) {
                future.complete(null);
                return;
            }
            this.ledger.getExecutor().execute(() -> {
                this.ledger.mbean.endCursorLedgerCreateOp();
                if (rc != 0) {
                    log.warn("[{}] Error creating ledger for cursor {}: {}", new Object[]{this.ledger.getName(), this.name, BKException.getMessage((int)rc)});
                    future.completeExceptionally(new ManagedLedgerException(BKException.getMessage((int)rc)));
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Created ledger {} for cursor {}", new Object[]{this.ledger.getName(), lh.getId(), this.name});
                }
                future.complete(lh);
            });
        }, LedgerMetadataUtils.buildAdditionalMetadataForCursor(this.name));
        return future;
    }

    private CompletableFuture<Void> deleteLedgerAsync(LedgerHandle ledgerHandle) {
        this.ledger.mbean.startCursorLedgerDeleteOp();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.bookkeeper.asyncDeleteLedger(ledgerHandle.getId(), (rc, ctx) -> {
            future.complete(null);
            this.ledger.mbean.endCursorLedgerDeleteOp();
            if (rc != 0) {
                log.warn("[{}] Failed to delete orphan ledger {}", (Object)this.ledger.getName(), (Object)ledgerHandle.getId());
            }
        }, null);
        return future;
    }

    private static List<MLDataFormats.LongProperty> buildPropertiesMap(Map<String, Long> properties) {
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MLDataFormats.LongProperty> longProperties = new ArrayList<MLDataFormats.LongProperty>();
        properties.forEach((name, value) -> {
            MLDataFormats.LongProperty lp = MLDataFormats.LongProperty.newBuilder().setName((String)name).setValue((long)value).build();
            longProperties.add(lp);
        });
        return longProperties;
    }

    private static List<MLDataFormats.StringProperty> buildStringPropertiesMap(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MLDataFormats.StringProperty> stringProperties = new ArrayList<MLDataFormats.StringProperty>();
        properties.forEach((name, value) -> {
            MLDataFormats.StringProperty sp = MLDataFormats.StringProperty.newBuilder().setName((String)name).setValue((String)value).build();
            stringProperties.add(sp);
        });
        return stringProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MLDataFormats.MessageRange> buildIndividualDeletedMessageRanges() {
        this.lock.writeLock().lock();
        try {
            if (this.individualDeletedMessages.isEmpty()) {
                this.individualDeletedMessagesSerializedSize = 0;
                List<MLDataFormats.MessageRange> list = Collections.emptyList();
                return list;
            }
            MLDataFormats.NestedPositionInfo.Builder nestedPositionBuilder = MLDataFormats.NestedPositionInfo.newBuilder();
            MLDataFormats.MessageRange.Builder messageRangeBuilder = MLDataFormats.MessageRange.newBuilder();
            AtomicInteger acksSerializedSize = new AtomicInteger(0);
            ArrayList<MLDataFormats.MessageRange> rangeList = new ArrayList<MLDataFormats.MessageRange>();
            this.individualDeletedMessages.forEachRawRange((lowerKey, lowerValue, upperKey, upperValue) -> {
                MLDataFormats.NestedPositionInfo lowerPosition = nestedPositionBuilder.setLedgerId(lowerKey).setEntryId(lowerValue).build();
                MLDataFormats.NestedPositionInfo upperPosition = nestedPositionBuilder.setLedgerId(upperKey).setEntryId(upperValue).build();
                MLDataFormats.MessageRange messageRange = messageRangeBuilder.setLowerEndpoint(lowerPosition).setUpperEndpoint(upperPosition).build();
                acksSerializedSize.addAndGet(messageRange.getSerializedSize());
                rangeList.add(messageRange);
                return rangeList.size() <= this.getConfig().getMaxUnackedRangesToPersist();
            });
            this.individualDeletedMessagesSerializedSize = acksSerializedSize.get();
            this.individualDeletedMessages.resetDirtyKeys();
            ArrayList<MLDataFormats.MessageRange> arrayList = rangeList;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MLDataFormats.BatchedEntryDeletionIndexInfo> buildBatchEntryDeletionIndexInfoList() {
        this.lock.readLock().lock();
        try {
            if (this.batchDeletedIndexes == null || this.batchDeletedIndexes.isEmpty()) {
                List<MLDataFormats.BatchedEntryDeletionIndexInfo> list = Collections.emptyList();
                return list;
            }
            MLDataFormats.NestedPositionInfo.Builder nestedPositionBuilder = MLDataFormats.NestedPositionInfo.newBuilder();
            MLDataFormats.BatchedEntryDeletionIndexInfo.Builder batchDeletedIndexInfoBuilder = MLDataFormats.BatchedEntryDeletionIndexInfo.newBuilder();
            ArrayList<MLDataFormats.BatchedEntryDeletionIndexInfo> result = new ArrayList<MLDataFormats.BatchedEntryDeletionIndexInfo>();
            Iterator<Map.Entry<PositionImpl, BitSet>> iterator = this.batchDeletedIndexes.entrySet().iterator();
            while (iterator.hasNext() && result.size() < this.getConfig().getMaxBatchDeletedIndexToPersist()) {
                Map.Entry<PositionImpl, BitSet> entry = iterator.next();
                nestedPositionBuilder.setLedgerId(entry.getKey().getLedgerId());
                nestedPositionBuilder.setEntryId(entry.getKey().getEntryId());
                batchDeletedIndexInfoBuilder.setPosition(nestedPositionBuilder.build());
                long[] array = entry.getValue().toLongArray();
                ArrayList<Long> deleteSet = new ArrayList<Long>(array.length);
                for (long l : array) {
                    deleteSet.add(l);
                }
                batchDeletedIndexInfoBuilder.clearDeleteSet();
                batchDeletedIndexInfoBuilder.addAllDeleteSet(deleteSet);
                result.add(batchDeletedIndexInfoBuilder.build());
            }
            ArrayList<MLDataFormats.BatchedEntryDeletionIndexInfo> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void persistPositionToLedger(LedgerHandle lh, MarkDeleteEntry mdEntry, VoidCallback callback) {
        PositionImpl position = mdEntry.newPosition;
        MLDataFormats.PositionInfo.Builder piBuilder = MLDataFormats.PositionInfo.newBuilder().setLedgerId(position.getLedgerId()).setEntryId(position.getEntryId()).addAllBatchedEntryDeletionIndexInfo(this.buildBatchEntryDeletionIndexInfoList()).addAllProperties(ManagedCursorImpl.buildPropertiesMap(mdEntry.properties));
        Map<Long, long[]> internalRanges = null;
        if (this.getConfig().isUnackedRangesOpenCacheSetEnabled() && this.getConfig().isPersistIndividualAckAsLongArray()) {
            try {
                internalRanges = this.individualDeletedMessages.toRanges(this.getConfig().getMaxUnackedRangesToPersist());
            }
            catch (Exception e) {
                log.warn("[{}]-{} Failed to serialize individualDeletedMessages", new Object[]{this.ledger.getName(), this.name, e});
            }
        }
        if (internalRanges != null && !internalRanges.isEmpty()) {
            piBuilder.addAllIndividualDeletedMessageRanges(this.buildLongPropertiesMap(internalRanges));
        } else {
            piBuilder.addAllIndividualDeletedMessages(this.buildIndividualDeletedMessageRanges());
        }
        MLDataFormats.PositionInfo pi = piBuilder.build();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Cursor {} Appending to ledger={} position={}", new Object[]{this.ledger.getName(), this.name, lh.getId(), position});
        }
        Objects.requireNonNull(lh);
        byte[] data = pi.toByteArray();
        lh.asyncAddEntry(data, (rc, lh1, entryId, ctx) -> {
            if (rc == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Updated cursor {} position {} in meta-ledger {}", new Object[]{this.ledger.getName(), this.name, position, lh1.getId()});
                }
                this.rolloverLedgerIfNeeded(lh1);
                this.mbean.persistToLedger(true);
                this.mbean.addWriteCursorLedgerSize(data.length);
                callback.operationComplete();
            } else {
                if (this.state == State.Closed) {
                    callback.operationFailed(new ManagedLedgerException.CursorAlreadyClosedException(String.format("%s %s skipped this persistence, because the cursor already closed", this.ledger.getName(), this.name)));
                    return;
                }
                log.warn("[{}] Error updating cursor {} position {} in meta-ledger {}: {}", new Object[]{this.ledger.getName(), this.name, position, lh1.getId(), BKException.getMessage((int)rc)});
                STATE_UPDATER.compareAndSet(this, State.Open, State.NoLedger);
                this.persistPositionToMetaStore(mdEntry, callback);
            }
        }, null);
    }

    @Override
    public boolean periodicRollover() {
        LedgerHandle lh = this.cursorLedger;
        if (State.Open.equals((Object)STATE_UPDATER.get(this)) && lh != null && lh.getLength() > 0L) {
            boolean triggered = this.rolloverLedgerIfNeeded(lh);
            if (triggered) {
                log.info("[{}] Periodic rollover triggered for cursor {} (length={} bytes)", new Object[]{this.ledger.getName(), this.name, lh.getLength()});
            } else {
                log.debug("[{}] Periodic rollover skipped for cursor {} (length={} bytes)", new Object[]{this.ledger.getName(), this.name, lh.getLength()});
            }
            return triggered;
        }
        return false;
    }

    boolean rolloverLedgerIfNeeded(LedgerHandle lh1) {
        if (this.shouldCloseLedger(lh1)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Need to create new metadata ledger for cursor {}", (Object)this.ledger.getName(), (Object)this.name);
            }
            this.startCreatingNewMetadataLedger();
            return true;
        }
        return false;
    }

    void persistPositionToMetaStore(MarkDeleteEntry mdEntry, final VoidCallback callback) {
        final PositionImpl newPosition = mdEntry.newPosition;
        STATE_UPDATER.compareAndSet(this, State.Open, State.NoLedger);
        this.mbean.persistToLedger(false);
        this.persistPositionMetaStore(-1L, newPosition, mdEntry.properties, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Updated cursor in meta store after previous failure in ledger at position {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, newPosition});
                }
                ManagedCursorImpl.this.mbean.persistToZookeeper(true);
                callback.operationComplete();
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.warn("[{}][{}] Failed to update cursor in meta store after previous failure in ledger: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, e.getMessage()});
                ManagedCursorImpl.this.mbean.persistToZookeeper(false);
                callback.operationFailed(ManagedLedgerImpl.createManagedLedgerException(e));
            }
        }, true);
    }

    boolean shouldCloseLedger(LedgerHandle lh) {
        long now = this.clock.millis();
        if (this.ledger.getFactory().isMetadataServiceAvailable() && (lh.getLastAddConfirmed() >= (long)this.getConfig().getMetadataMaxEntriesPerLedger() || this.lastLedgerSwitchTimestamp < now - (long)(this.getConfig().getLedgerRolloverTimeout() * 1000)) && STATE_UPDATER.get(this) != State.Closed && STATE_UPDATER.get(this) != State.Closing) {
            this.lastLedgerSwitchTimestamp = now;
            return true;
        }
        return false;
    }

    void switchToNewLedger(final LedgerHandle lh, final VoidCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Switching cursor {} to ledger {}", new Object[]{this.ledger.getName(), this.name, lh.getId()});
        }
        this.persistPositionMetaStore(lh.getId(), this.lastMarkDeleteEntry.newPosition, this.lastMarkDeleteEntry.properties, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                log.info("[{}] Updated cursor {} with ledger id {} md-position={} rd-position={}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, lh.getId(), ManagedCursorImpl.this.markDeletePosition, ManagedCursorImpl.this.readPosition});
                LedgerHandle oldLedger = ManagedCursorImpl.this.cursorLedger;
                ManagedCursorImpl.this.cursorLedger = lh;
                ManagedCursorImpl.this.isCursorLedgerReadOnly = false;
                callback.operationComplete();
                ManagedCursorImpl.this.asyncDeleteLedger(oldLedger);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                log.warn("[{}] Failed to update cursor metadata {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, e});
                ManagedCursorImpl.this.deleteLedgerAsync(lh).thenRun(() -> callback.operationFailed(e));
            }
        }, false);
    }

    void notifyEntriesAvailable() {
        OpReadEntry opReadEntry;
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Received ml notification", (Object)this.ledger.getName(), (Object)this.name);
        }
        if ((opReadEntry = (OpReadEntry)WAITING_READ_OP_UPDATER.getAndSet(this, null)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Received notification of new messages persisted, reading at {} -- last: {}", new Object[]{this.ledger.getName(), this.name, opReadEntry.readPosition, this.ledger.lastConfirmedEntry});
                log.debug("[{}] Consumer {} cursor notification: other counters: consumed {} mdPos {} rdPos {}", new Object[]{this.ledger.getName(), this.name, this.messagesConsumedCounter, this.markDeletePosition, this.readPosition});
            }
            PENDING_READ_OPS_UPDATER.incrementAndGet(this);
            opReadEntry.readPosition = (PositionImpl)this.getReadPosition();
            this.ledger.asyncReadEntries(opReadEntry);
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Received notification but had no pending read operation", (Object)this.ledger.getName(), (Object)this.name);
        }
    }

    void asyncCloseCursorLedger(final AsyncCallbacks.CloseCallback callback, Object ctx) {
        LedgerHandle lh = this.cursorLedger;
        this.ledger.mbean.startCursorLedgerCloseOp();
        log.info("[{}] [{}] Closing metadata ledger {}", new Object[]{this.ledger.getName(), this.name, lh.getId()});
        lh.asyncClose(new AsyncCallback.CloseCallback(){

            public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                ManagedCursorImpl.this.ledger.mbean.endCursorLedgerCloseOp();
                if (rc == 0) {
                    log.info("[{}][{}] Closed cursor-ledger {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.cursorLedger.getId()});
                    callback.closeComplete(ctx);
                } else {
                    log.warn("[{}][{}] Failed to close cursor-ledger {}: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, ManagedCursorImpl.this.cursorLedger.getId(), BKException.getMessage((int)rc)});
                    callback.closeFailed(ManagedLedgerImpl.createManagedLedgerException(rc), ctx);
                }
            }
        }, ctx);
    }

    void decrementPendingMarkDeleteCount() {
        State state;
        if (PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.decrementAndGet(this) == 0 && (state = STATE_UPDATER.get(this)) == State.SwitchingLedger) {
            this.createNewMetadataLedger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readOperationCompleted() {
        if (PENDING_READ_OPS_UPDATER.decrementAndGet(this) == 0) {
            ArrayDeque<MarkDeleteEntry> arrayDeque = this.pendingMarkDeleteOps;
            synchronized (arrayDeque) {
                if (STATE_UPDATER.get(this) == State.Open) {
                    this.flushPendingMarkDeletes();
                } else if (PENDING_MARK_DELETED_SUBMITTED_COUNT_UPDATER.get(this) != 0) {
                    log.info("[{}] read operation completed and cursor was closed. need to call any queued cursor close", (Object)this.name);
                }
            }
        }
    }

    void asyncDeleteLedger(LedgerHandle lh) {
        this.asyncDeleteLedger(lh, 3);
    }

    private void asyncDeleteLedger(LedgerHandle lh, int retry) {
        if (lh == null || retry <= 0) {
            if (lh != null) {
                log.warn("[{}-{}] Failed to delete ledger after retries {}", new Object[]{this.ledger.getName(), this.name, lh.getId()});
            }
            return;
        }
        this.ledger.mbean.startCursorLedgerDeleteOp();
        this.bookkeeper.asyncDeleteLedger(lh.getId(), (rc, ctx) -> {
            this.ledger.mbean.endCursorLedgerDeleteOp();
            if (rc != 0) {
                log.warn("[{}] Failed to delete ledger {}: {}", new Object[]{this.ledger.getName(), lh.getId(), BKException.getMessage((int)rc)});
                if (!Errors.isNoSuchLedgerExistsException(rc)) {
                    this.ledger.getScheduledExecutor().schedule(() -> this.asyncDeleteLedger(lh, retry - 1), 60L, TimeUnit.SECONDS);
                }
                return;
            }
            log.info("[{}][{}] Successfully closed & deleted ledger {} in cursor", new Object[]{this.ledger.getName(), this.name, lh.getId()});
        }, null);
    }

    void asyncDeleteCursorLedger() {
        this.asyncDeleteCursorLedger(3);
    }

    private void asyncDeleteCursorLedger(int retry) {
        STATE_UPDATER.set(this, State.Closed);
        if (this.cursorLedger == null || retry <= 0) {
            if (this.cursorLedger != null) {
                log.warn("[{}-{}] Failed to delete ledger after retries {}", new Object[]{this.ledger.getName(), this.name, this.cursorLedger.getId()});
            }
            return;
        }
        this.ledger.mbean.startCursorLedgerDeleteOp();
        this.bookkeeper.asyncDeleteLedger(this.cursorLedger.getId(), (rc, ctx) -> {
            this.ledger.mbean.endCursorLedgerDeleteOp();
            if (rc == 0) {
                log.info("[{}][{}] Deleted cursor ledger {}", new Object[]{this.ledger.getName(), this.name, this.cursorLedger.getId()});
            } else {
                log.warn("[{}][{}] Failed to delete ledger {}: {}", new Object[]{this.ledger.getName(), this.name, this.cursorLedger.getId(), BKException.getMessage((int)rc)});
                if (!Errors.isNoSuchLedgerExistsException(rc)) {
                    this.ledger.getScheduledExecutor().schedule(() -> this.asyncDeleteCursorLedger(retry - 1), 60L, TimeUnit.SECONDS);
                }
            }
        }, null);
    }

    public static boolean isBkErrorNotRecoverable(int rc) {
        switch (rc) {
            case -25: 
            case -13: 
            case -10: 
            case -7: 
            case -1: {
                return true;
            }
        }
        return false;
    }

    private PositionImpl getRollbackPosition(MLDataFormats.ManagedCursorInfo info) {
        PositionImpl firstPosition = this.ledger.getFirstPosition();
        PositionImpl snapshottedPosition = new PositionImpl(info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId());
        if (firstPosition == null) {
            return snapshottedPosition;
        }
        if (snapshottedPosition.compareTo(firstPosition) < 0) {
            return firstPosition;
        }
        return snapshottedPosition;
    }

    public int getPendingReadOpsCount() {
        return PENDING_READ_OPS_UPDATER.get(this);
    }

    public long getMessagesConsumedCounter() {
        return this.messagesConsumedCounter;
    }

    public long getCursorLedger() {
        LedgerHandle lh = this.cursorLedger;
        return lh != null ? lh.getId() : -1L;
    }

    public long getCursorLedgerLastEntry() {
        LedgerHandle lh = this.cursorLedger;
        return lh != null ? lh.getLastAddConfirmed() : -1L;
    }

    public String getIndividuallyDeletedMessages() {
        this.lock.readLock().lock();
        try {
            String string = this.individualDeletedMessages.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    public LongPairRangeSet<PositionImpl> getIndividuallyDeletedMessagesSet() {
        return this.individualDeletedMessages;
    }

    public boolean isMessageDeleted(Position position) {
        Preconditions.checkArgument((boolean)(position instanceof PositionImpl));
        this.lock.readLock().lock();
        try {
            boolean bl = this.internalIsMessageDeleted(position);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean internalIsMessageDeleted(Position position) {
        return ((PositionImpl)position).compareTo(this.markDeletePosition) <= 0 || this.individualDeletedMessages.contains(position.getLedgerId(), position.getEntryId());
    }

    public long[] getBatchPositionAckSet(Position position) {
        if (!(position instanceof PositionImpl)) {
            return null;
        }
        if (this.batchDeletedIndexes != null) {
            BitSet bitSet = this.batchDeletedIndexes.get(position);
            if (bitSet == null) {
                return null;
            }
            return bitSet.toLongArray();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionImpl getNextAvailablePosition(PositionImpl position) {
        this.lock.readLock().lock();
        try {
            Range<PositionImpl> range = this.individualDeletedMessages.rangeContaining(position.getLedgerId(), position.getEntryId());
            if (range != null) {
                PositionImpl nextPosition = ((PositionImpl)range.upperEndpoint()).getNext();
                PositionImpl positionImpl = nextPosition != null && nextPosition.compareTo(position) > 0 ? nextPosition : position.getNext();
                return positionImpl;
            }
            PositionImpl positionImpl = position.getNext();
            return positionImpl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Position getNextLedgerPosition(long currentLedgerId) {
        Long nextExistingLedger = this.ledger.getNextValidLedger(currentLedgerId);
        return nextExistingLedger != null ? PositionImpl.get(nextExistingLedger, 0L) : null;
    }

    public boolean isIndividuallyDeletedEntriesEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.individualDeletedMessages.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getLastLedgerSwitchTimestamp() {
        return this.lastLedgerSwitchTimestamp;
    }

    public String getState() {
        return STATE_UPDATER.get(this).toString();
    }

    @Override
    public double getThrottleMarkDelete() {
        return this.markDeleteLimiter.getRate();
    }

    @Override
    public void setThrottleMarkDelete(double throttleMarkDelete) {
        if (throttleMarkDelete > 0.0) {
            if (this.markDeleteLimiter == null) {
                this.markDeleteLimiter = RateLimiter.create((double)throttleMarkDelete);
            } else {
                this.markDeleteLimiter.setRate(throttleMarkDelete);
            }
        } else {
            this.markDeleteLimiter = null;
        }
    }

    @Override
    public ManagedLedger getManagedLedger() {
        return this.ledger;
    }

    @Override
    public Range<PositionImpl> getLastIndividualDeletedRange() {
        this.lock.readLock().lock();
        try {
            Range<PositionImpl> range = this.individualDeletedMessages.lastRange();
            return range;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void trimDeletedEntries(List<Entry> entries) {
        entries.removeIf(entry -> {
            boolean isDeleted = this.isMessageDeleted(entry.getPosition());
            if (isDeleted) {
                entry.release();
            }
            return isDeleted;
        });
    }

    private ManagedCursorImpl cursorImpl() {
        return this;
    }

    @Override
    public long[] getDeletedBatchIndexesAsLongArray(PositionImpl position) {
        if (this.batchDeletedIndexes != null) {
            BitSet bitSet = this.batchDeletedIndexes.get(position);
            return bitSet == null ? null : bitSet.toLongArray();
        }
        return null;
    }

    @Override
    public ManagedCursorMXBean getStats() {
        return this.mbean;
    }

    public void updateReadStats(int readEntriesCount, long readEntriesSize) {
        this.entriesReadCount += (long)readEntriesCount;
        this.entriesReadSize += readEntriesSize;
    }

    void flush() {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        this.asyncMarkDelete(this.lastMarkDeleteEntry.newPosition, this.lastMarkDeleteEntry.properties, new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Flushed dirty mark-delete position", (Object)ManagedCursorImpl.this.ledger.getName(), (Object)ManagedCursorImpl.this.name);
                }
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                if (exception.getCause() instanceof MarkDeletingMarkedPosition) {
                    log.info("[{}][{}] Cannot flush mark-delete position: {}", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, exception.getCause().getMessage()});
                } else {
                    log.warn("[{}][{}] Failed to flush mark-delete position", new Object[]{ManagedCursorImpl.this.ledger.getName(), ManagedCursorImpl.this.name, exception});
                }
            }
        }, null);
    }

    public int applyMaxSizeCap(int maxEntries, long maxSizeBytes) {
        if (maxSizeBytes == -1L) {
            return maxEntries;
        }
        int maxEntriesBasedOnSize = Long.valueOf(ManagedCursorImpl.estimateEntryCountBySize(maxSizeBytes, this.readPosition, this.ledger)).intValue();
        return Math.min(maxEntriesBasedOnSize, maxEntries);
    }

    static long estimateEntryCountBySize(long bytesSize, PositionImpl readPosition, ManagedLedgerImpl ml) {
        PositionImpl posToRead = readPosition;
        if (!ml.isValidPosition(readPosition)) {
            posToRead = ml.getNextValidPosition(readPosition);
        }
        long result = 0L;
        long remainingBytesSize = bytesSize;
        while (remainingBytesSize > 0L) {
            if (posToRead.getLedgerId() == ml.getCurrentLedger().getId()) {
                if (ml.getCurrentLedgerSize() == 0L || ml.getCurrentLedgerEntries() == 0L) {
                    return 1L;
                }
                long avg = Math.max(1L, ml.getCurrentLedgerSize() / ml.getCurrentLedgerEntries()) + 64L;
                result += remainingBytesSize / avg;
                break;
            }
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ml.getLedgersInfo().get(posToRead.getLedgerId());
            if (ledgerInfo.getSize() == 0L || ledgerInfo.getEntries() == 0L) {
                posToRead = ml.getNextValidPosition(PositionImpl.get(posToRead.getLedgerId(), Long.MAX_VALUE));
                continue;
            }
            long avg = Math.max(1L, ledgerInfo.getSize() / ledgerInfo.getEntries()) + 64L;
            long remainEntriesOfLedger = ledgerInfo.getEntries() - posToRead.getEntryId();
            if (remainEntriesOfLedger * avg >= remainingBytesSize) {
                result += remainingBytesSize / avg;
                break;
            }
            result += remainEntriesOfLedger;
            remainingBytesSize -= remainEntriesOfLedger * avg;
            posToRead = ml.getNextValidPosition(PositionImpl.get(posToRead.getLedgerId(), Long.MAX_VALUE));
        }
        return Math.max(result, 1L);
    }

    @Override
    public boolean checkAndUpdateReadPositionChanged() {
        PositionImpl lastEntry = this.ledger.lastConfirmedEntry;
        boolean isReadPositionOnTail = lastEntry == null || this.readPosition == null || lastEntry.compareTo(this.readPosition) <= 0;
        boolean isReadPositionChanged = this.readPosition != null && !this.readPosition.equals(this.statsLastReadPosition);
        this.statsLastReadPosition = this.readPosition;
        return isReadPositionOnTail || isReadPositionChanged;
    }

    private boolean isCompactionCursor() {
        return COMPACTION_CURSOR_NAME.equals(this.name);
    }

    @VisibleForTesting
    public void setState(State state) {
        this.state = state;
    }

    public void setCacheReadEntry(boolean cacheReadEntry) {
        this.cacheReadEntry = cacheReadEntry;
    }

    public boolean isCacheReadEntry() {
        return this.cacheReadEntry;
    }

    public ManagedLedgerConfig getConfig() {
        return this.getManagedLedger().getConfig();
    }

    public ManagedCursor duplicateNonDurableCursor(String nonDurableCursorName) throws ManagedLedgerException {
        NonDurableCursorImpl newNonDurableCursor = (NonDurableCursorImpl)this.ledger.newNonDurableCursor(this.getMarkDeletedPosition(), nonDurableCursorName);
        this.lock.readLock().lock();
        try {
            if (this.individualDeletedMessages != null) {
                this.individualDeletedMessages.forEach((LongPairRangeSet.RangeProcessor<PositionImpl>)((LongPairRangeSet.RangeProcessor)range -> {
                    newNonDurableCursor.individualDeletedMessages.addOpenClosed(((PositionImpl)range.lowerEndpoint()).getLedgerId(), ((PositionImpl)range.lowerEndpoint()).getEntryId(), ((PositionImpl)range.upperEndpoint()).getLedgerId(), ((PositionImpl)range.upperEndpoint()).getEntryId());
                    return true;
                }));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (this.batchDeletedIndexes != null) {
            Objects.requireNonNull(newNonDurableCursor.batchDeletedIndexes);
            for (Map.Entry<PositionImpl, BitSet> entry : this.batchDeletedIndexes.entrySet()) {
                newNonDurableCursor.batchDeletedIndexes.put(entry.getKey(), (BitSet)entry.getValue().clone());
            }
        }
        return newNonDurableCursor;
    }

    @Nullable
    @Generated
    public ConcurrentSkipListMap<PositionImpl, BitSet> getBatchDeletedIndexes() {
        return this.batchDeletedIndexes;
    }

    public static enum State {
        Uninitialized,
        NoLedger,
        Open,
        SwitchingLedger,
        Closing,
        Closed;

    }

    class MarkDeleteEntry {
        final PositionImpl newPosition;
        final AsyncCallbacks.MarkDeleteCallback callback;
        final Object ctx;
        final Map<String, Long> properties;
        List<MarkDeleteEntry> callbackGroup;

        public MarkDeleteEntry(PositionImpl newPosition, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
            this.newPosition = newPosition;
            this.properties = properties;
            this.callback = callback;
            this.ctx = ctx;
        }

        public void triggerComplete() {
            if (this.callbackGroup != null) {
                for (MarkDeleteEntry e : this.callbackGroup) {
                    e.callback.markDeleteComplete(e.ctx);
                }
            } else if (this.callback != null) {
                this.callback.markDeleteComplete(this.ctx);
            }
        }

        public void triggerFailed(ManagedLedgerException exception) {
            if (this.callbackGroup != null) {
                for (MarkDeleteEntry e : this.callbackGroup) {
                    e.callback.markDeleteFailed(exception, e.ctx);
                }
            } else if (this.callback != null) {
                this.callback.markDeleteFailed(exception, this.ctx);
            }
        }
    }

    public static interface VoidCallback {
        public void operationComplete();

        public void operationFailed(ManagedLedgerException var1);
    }

    private static class InvidualDeletedMessagesHandlingState {
        long totalEntriesToSkip = 0L;
        long deletedMessages = 0L;
        PositionImpl startPosition;
        PositionImpl endPosition;

        InvidualDeletedMessagesHandlingState(PositionImpl startPosition) {
            this.startPosition = startPosition;
        }
    }

    private final class MarkDeletingMarkedPosition
    extends IllegalArgumentException {
        public MarkDeletingMarkedPosition(String s) {
            super(s);
        }
    }
}

