/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.MessageExpirer;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentMessageExpiryMonitor;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.stats.Rate;
import org.apache.pulsar.common.util.Backoff;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentReplicator
extends AbstractReplicator
implements Replicator,
AsyncCallbacks.ReadEntriesCallback,
AsyncCallbacks.DeleteCallback,
MessageExpirer {
    protected final PersistentTopic topic;
    protected final ManagedCursor cursor;
    protected Optional<DispatchRateLimiter> dispatchRateLimiter = Optional.empty();
    private final Object dispatchRateLimiterLock = new Object();
    private int readBatchSize;
    private final int readMaxSizeBytes;
    private final int producerQueueThreshold;
    protected static final AtomicIntegerFieldUpdater<PersistentReplicator> PENDING_MESSAGES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PersistentReplicator.class, "pendingMessages");
    private volatile int pendingMessages = 0;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<PersistentReplicator> HAVE_PENDING_READ_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PersistentReplicator.class, "havePendingRead");
    private volatile int havePendingRead = 0;
    protected final Rate msgOut = new Rate();
    protected final Rate msgExpired = new Rate();
    protected int messageTTLInSeconds = 0;
    private final Backoff readFailureBackoff = new Backoff(1L, TimeUnit.SECONDS, 1L, TimeUnit.MINUTES, 0L, TimeUnit.MILLISECONDS);
    private final PersistentMessageExpiryMonitor expiryMonitor;
    private static final int MINIMUM_BACKLOG_FOR_EXPIRY_CHECK = 1000;
    private final ReplicatorStatsImpl stats = new ReplicatorStatsImpl();
    protected volatile boolean fetchSchemaInProgress = false;
    private static final Logger log = LoggerFactory.getLogger(PersistentReplicator.class);

    public PersistentReplicator(String localCluster, PersistentTopic localTopic, ManagedCursor cursor, String remoteCluster, String remoteTopic, BrokerService brokerService, PulsarClientImpl replicationClient) throws PulsarServerException {
        super(localCluster, localTopic, remoteCluster, remoteTopic, localTopic.getReplicatorPrefix(), brokerService, replicationClient);
        this.topic = localTopic;
        this.cursor = cursor;
        this.expiryMonitor = new PersistentMessageExpiryMonitor(localTopic, Codec.decode((String)cursor.getName()), cursor, null);
        HAVE_PENDING_READ_UPDATER.set(this, 0);
        PENDING_MESSAGES_UPDATER.set(this, 0);
        this.readBatchSize = Math.min(this.producerQueueSize, localTopic.getBrokerService().pulsar().getConfiguration().getDispatcherMaxReadBatchSize());
        this.readMaxSizeBytes = localTopic.getBrokerService().pulsar().getConfiguration().getDispatcherMaxReadSizeBytes();
        this.producerQueueThreshold = (int)((double)this.producerQueueSize * 0.9);
        this.initializeDispatchRateLimiterIfNeeded();
        this.startProducer();
    }

    @Override
    protected void setProducerAndTriggerReadEntries(Producer<byte[]> producer) {
        this.cursor.rewind();
        this.cursor.cancelPendingReadRequest();
        ImmutablePair<Boolean, AbstractReplicator.State> changeStateRes = this.compareSetAndGetState(AbstractReplicator.State.Starting, AbstractReplicator.State.Started);
        if (((Boolean)changeStateRes.getLeft()).booleanValue()) {
            if (!(producer instanceof ProducerImpl)) {
                log.error("[{}] The partitions count between two clusters is not the same, the replicator can not be created successfully: {}", (Object)this.replicatorId, (Object)this.state);
                this.doCloseProducerAsync(producer, () -> {});
                throw new ClassCastException(producer.getClass().getName() + " can not be cast to ProducerImpl");
            }
            this.producer = (ProducerImpl)producer;
            HAVE_PENDING_READ_UPDATER.set(this, 0);
            log.info("[{}] Created replicator producer, Replicator state: {}", (Object)this.replicatorId, (Object)this.state);
            this.backOff.reset();
            this.cursor.setActive();
            this.readMoreEntries();
        } else {
            if (changeStateRes.getRight() == AbstractReplicator.State.Started) {
                log.warn("[{}] Replicator was already started by another thread while creating the producer. Closing the producer newly created. Replicator state: {}", (Object)this.replicatorId, (Object)this.state);
            } else if (changeStateRes.getRight() == AbstractReplicator.State.Terminating || changeStateRes.getRight() == AbstractReplicator.State.Terminated) {
                log.info("[{}] Replicator was terminated, so close the producer. Replicator state: {}", (Object)this.replicatorId, (Object)this.state);
            } else {
                log.error("[{}] Replicator state is not expected, so close the producer. Replicator state: {}", (Object)this.replicatorId, changeStateRes.getRight());
            }
            this.doCloseProducerAsync(producer, () -> {});
        }
    }

    @Override
    protected Position getReplicatorReadPosition() {
        return this.cursor.getMarkDeletedPosition();
    }

    @Override
    public long getNumberOfEntriesInBacklog() {
        return this.cursor.getNumberOfEntriesInBacklog(true);
    }

    @Override
    protected void disableReplicatorRead() {
        if (this.cursor != null) {
            this.cursor.setInactive();
        }
    }

    private int getAvailablePermits() {
        int availablePermits = this.producerQueueSize - PENDING_MESSAGES_UPDATER.get(this);
        if (availablePermits <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Producer queue is full, availablePermits: {}, pause reading", (Object)this.replicatorId, (Object)availablePermits);
            }
            return 0;
        }
        if (this.dispatchRateLimiter.isPresent() && this.dispatchRateLimiter.get().isDispatchRateLimitingEnabled()) {
            DispatchRateLimiter rateLimiter = this.dispatchRateLimiter.get();
            long availablePermitsOnMsg = rateLimiter.getAvailableDispatchRateLimitOnMsg();
            long availablePermitsOnByte = rateLimiter.getAvailableDispatchRateLimitOnByte();
            if (availablePermitsOnByte == 0L || availablePermitsOnMsg == 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] message-read exceeded topic replicator message-rate {}/{}, schedule after a {}", new Object[]{this.replicatorId, rateLimiter.getDispatchRateOnMsg(), rateLimiter.getDispatchRateOnByte(), 1000});
                }
                return -1;
            }
            if (availablePermitsOnMsg > 0L) {
                availablePermits = Math.min(availablePermits, (int)availablePermitsOnMsg);
            }
        }
        return availablePermits;
    }

    protected void readMoreEntries() {
        if (this.fetchSchemaInProgress) {
            log.info("[{}] Skip the reading due to new detected schema", (Object)this.replicatorId);
            return;
        }
        int availablePermits = this.getAvailablePermits();
        if (availablePermits > 0) {
            int messagesToRead = Math.min(availablePermits, this.readBatchSize);
            if (!this.isWritable()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Throttling replication traffic because producer is not writable", (Object)this.replicatorId);
                }
                messagesToRead = 1;
            }
            messagesToRead = Math.max(messagesToRead, 1);
            if (HAVE_PENDING_READ_UPDATER.compareAndSet(this, 0, 1)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Schedule read of {} messages", (Object)this.replicatorId, (Object)messagesToRead);
                }
                this.cursor.asyncReadEntriesOrWait(messagesToRead, (long)this.readMaxSizeBytes, (AsyncCallbacks.ReadEntriesCallback)this, null, this.topic.getMaxReadPosition());
            } else if (log.isDebugEnabled()) {
                log.debug("[{}] Not scheduling read due to pending read. Messages To Read {}", (Object)this.replicatorId, (Object)messagesToRead);
            }
        } else if (availablePermits == -1) {
            this.topic.getBrokerService().executor().schedule(() -> this.readMoreEntries(), 1000L, TimeUnit.MILLISECONDS);
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] No Permits for reading. availablePermits: {}", (Object)this.replicatorId, (Object)availablePermits);
        }
    }

    public void readEntriesComplete(List<Entry> entries, Object ctx) {
        int maxReadBatchSize;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Read entries complete of {} messages", (Object)this.replicatorId, (Object)entries.size());
        }
        if (this.readBatchSize < (maxReadBatchSize = this.topic.getBrokerService().pulsar().getConfiguration().getDispatcherMaxReadBatchSize())) {
            int newReadBatchSize = Math.min(this.readBatchSize * 2, maxReadBatchSize);
            if (log.isDebugEnabled()) {
                log.debug("[{}] Increasing read batch size from {} to {}", new Object[]{this.replicatorId, this.readBatchSize, newReadBatchSize});
            }
            this.readBatchSize = newReadBatchSize;
        }
        this.readFailureBackoff.reduceToHalf();
        boolean atLeastOneMessageSentForReplication = this.replicateEntries(entries);
        HAVE_PENDING_READ_UPDATER.set(this, 0);
        if (atLeastOneMessageSentForReplication && !this.isWritable()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Pausing replication traffic. at-least-one: {} is-writable: {}", new Object[]{this.replicatorId, atLeastOneMessageSentForReplication, this.isWritable()});
            }
        } else {
            this.readMoreEntries();
        }
    }

    protected abstract boolean replicateEntries(List<Entry> var1);

    protected CompletableFuture<SchemaInfo> getSchemaInfo(MessageImpl msg) throws ExecutionException {
        if (msg.getSchemaVersion() == null || msg.getSchemaVersion().length == 0) {
            return CompletableFuture.completedFuture(null);
        }
        return ((SchemaInfoProvider)this.client.getSchemaProviderLoadingCache().get((Object)this.localTopicName)).getSchemaByVersion(msg.getSchemaVersion());
    }

    public void updateCursorState() {
        if (this.cursor != null) {
            if (this.producer != null && this.producer.isConnected()) {
                this.cursor.setActive();
            } else {
                this.cursor.setInactive();
            }
        }
    }

    public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        if (this.state != AbstractReplicator.State.Started) {
            log.info("[{}] Replicator was disconnected while reading entries. Stop reading. Replicator state: {}", (Object)this.replicatorId, STATE_UPDATER.get(this));
            return;
        }
        this.readBatchSize = this.topic.getBrokerService().pulsar().getConfiguration().getDispatcherMinReadBatchSize();
        long waitTimeMillis = this.readFailureBackoff.next();
        if (exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
            log.warn("[{}] Error reading entries because replicator is already deleted and cursor is already closed {}, ({})", new Object[]{this.replicatorId, ctx, exception.getMessage(), exception});
            this.terminate();
            return;
        }
        if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
            log.error("[{}] Error reading entries at {}. Retrying to read in {}s. ({})", new Object[]{this.replicatorId, ctx, (double)waitTimeMillis / 1000.0, exception.getMessage(), exception});
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Throttled by bookies while reading at {}. Retrying to read in {}s. ({})", new Object[]{this.replicatorId, ctx, (double)waitTimeMillis / 1000.0, exception.getMessage(), exception});
        }
        HAVE_PENDING_READ_UPDATER.set(this, 0);
        this.brokerService.executor().schedule(this::readMoreEntries, waitTimeMillis, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Void> clearBacklog() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Backlog size before clearing: {}", (Object)this.replicatorId, (Object)this.cursor.getNumberOfEntriesInBacklog(false));
        }
        this.cursor.asyncClearBacklog(new AsyncCallbacks.ClearBacklogCallback(){

            public void clearBacklogComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Backlog size after clearing: {}", (Object)PersistentReplicator.this.replicatorId, (Object)PersistentReplicator.this.cursor.getNumberOfEntriesInBacklog(false));
                }
                future.complete(null);
            }

            public void clearBacklogFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to clear backlog", (Object)PersistentReplicator.this.replicatorId, (Object)exception);
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    public CompletableFuture<Void> skipMessages(final int numMessagesToSkip) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Skipping {} messages, current backlog {}", new Object[]{this.replicatorId, numMessagesToSkip, this.cursor.getNumberOfEntriesInBacklog(false)});
        }
        this.cursor.asyncSkipEntries(numMessagesToSkip, ManagedCursor.IndividualDeletedEntries.Exclude, new AsyncCallbacks.SkipEntriesCallback(){

            public void skipEntriesComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Skipped {} messages, new backlog {}", new Object[]{PersistentReplicator.this.replicatorId, numMessagesToSkip, PersistentReplicator.this.cursor.getNumberOfEntriesInBacklog(false)});
                }
                future.complete(null);
            }

            public void skipEntriesFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to skip {} messages", new Object[]{PersistentReplicator.this.replicatorId, numMessagesToSkip, exception});
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    public CompletableFuture<Entry> peekNthMessage(int messagePosition) {
        final CompletableFuture<Entry> future = new CompletableFuture<Entry>();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Getting message at position {}", (Object)this.replicatorId, (Object)messagePosition);
        }
        this.cursor.asyncGetNthEntry(messagePosition, ManagedCursor.IndividualDeletedEntries.Exclude, new AsyncCallbacks.ReadEntryCallback(){

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }

            public void readEntryComplete(Entry entry, Object ctx) {
                future.complete(entry);
            }

            public String toString() {
                return String.format("Replication [%s] peek Nth message", PersistentReplicator.this.producer.getProducerName());
            }
        }, null);
        return future;
    }

    public void deleteComplete(Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Deleted message at {}", (Object)this.replicatorId, ctx);
        }
    }

    public void deleteFailed(ManagedLedgerException exception, Object ctx) {
        PositionImpl deletedEntry;
        log.error("[{}] Failed to delete message at {}: {}", new Object[]{this.replicatorId, ctx, exception.getMessage(), exception});
        if (exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
            log.warn("[{}] Asynchronous ack failure because replicator is already deleted and cursor is already closed {}, ({})", new Object[]{this.replicatorId, ctx, exception.getMessage(), exception});
            this.terminate();
            return;
        }
        if (ctx instanceof PositionImpl && (deletedEntry = (PositionImpl)ctx).compareTo((PositionImpl)this.cursor.getMarkDeletedPosition()) > 0) {
            this.brokerService.getPulsar().getExecutor().schedule(() -> this.cursor.asyncDelete((Position)deletedEntry, (AsyncCallbacks.DeleteCallback)this, (Object)deletedEntry), 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void updateRates() {
        this.msgOut.calculateRate();
        this.msgExpired.calculateRate();
        this.expiryMonitor.updateRates();
        this.stats.msgRateOut = this.msgOut.getRate();
        this.stats.msgThroughputOut = this.msgOut.getValueRate();
        this.stats.msgRateExpired = this.msgExpired.getRate() + this.expiryMonitor.getMessageExpiryRate();
    }

    @Override
    public ReplicatorStatsImpl getStats() {
        this.stats.replicationBacklog = this.cursor != null ? this.cursor.getNumberOfEntriesInBacklog(false) : 0L;
        this.stats.connected = this.producer != null && this.producer.isConnected();
        this.stats.replicationDelayInSeconds = this.getReplicationDelayInSeconds();
        ProducerImpl producer = this.producer;
        if (producer != null) {
            this.stats.outboundConnection = producer.getConnectionId();
            this.stats.outboundConnectedSince = producer.getConnectedSince();
        } else {
            this.stats.outboundConnection = null;
            this.stats.outboundConnectedSince = null;
        }
        return this.stats;
    }

    public void updateMessageTTL(int messageTTLInSeconds) {
        this.messageTTLInSeconds = messageTTLInSeconds;
    }

    private long getReplicationDelayInSeconds() {
        if (this.producer != null) {
            return TimeUnit.MILLISECONDS.toSeconds(this.producer.getDelayInMillis());
        }
        return 0L;
    }

    @Override
    public boolean expireMessages(int messageTTLInSeconds) {
        long backlog = this.cursor.getNumberOfEntriesInBacklog(false);
        if (backlog == 0L || backlog < 1000L && !this.topic.isOldestMessageExpired(this.cursor, messageTTLInSeconds)) {
            return false;
        }
        return this.expiryMonitor.expireMessages(messageTTLInSeconds);
    }

    @Override
    public boolean expireMessages(Position position) {
        return this.expiryMonitor.expireMessages(position);
    }

    @Override
    public Optional<DispatchRateLimiter> getRateLimiter() {
        return this.dispatchRateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeDispatchRateLimiterIfNeeded() {
        Object object = this.dispatchRateLimiterLock;
        synchronized (object) {
            if (!this.dispatchRateLimiter.isPresent() && DispatchRateLimiter.isDispatchRateEnabled((DispatchRate)this.topic.getReplicatorDispatchRate())) {
                this.dispatchRateLimiter = Optional.of(this.topic.getBrokerService().getDispatchRateLimiterFactory().createReplicatorDispatchRateLimiter(this.topic, Codec.decode((String)this.cursor.getName())));
            }
        }
    }

    @Override
    public void updateRateLimiter() {
        this.initializeDispatchRateLimiterIfNeeded();
        this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::updateDispatchRate);
    }

    protected void checkReplicatedSubscriptionMarker(Position position, MessageImpl<?> msg, ByteBuf payload) {
        if (!msg.getMessageBuilder().hasMarkerType()) {
            return;
        }
        int markerType = msg.getMessageBuilder().getMarkerType();
        if (!msg.getMessageBuilder().hasReplicatedFrom() || !this.remoteCluster.equals(msg.getMessageBuilder().getReplicatedFrom())) {
            return;
        }
        switch (markerType) {
            case 10: 
            case 11: 
            case 13: {
                this.topic.receivedReplicatedSubscriptionMarker(position, markerType, payload);
                break;
            }
        }
    }

    @Override
    public boolean isConnected() {
        ProducerImpl producer = this.producer;
        return producer != null && producer.isConnected();
    }

    @Override
    protected void doReleaseResources() {
        this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
    }

    @VisibleForTesting
    public ManagedCursor getCursor() {
        return this.cursor;
    }

    protected static final class ProducerSendCallback
    implements SendCallback {
        private PersistentReplicator replicator;
        private Entry entry;
        private MessageImpl msg;
        private final Recycler.Handle<ProducerSendCallback> recyclerHandle;
        private static final Recycler<ProducerSendCallback> RECYCLER = new Recycler<ProducerSendCallback>(){

            protected ProducerSendCallback newObject(Recycler.Handle<ProducerSendCallback> handle) {
                return new ProducerSendCallback(handle);
            }
        };

        public void sendComplete(Exception exception) {
            if (exception != null && !(exception instanceof PulsarClientException.InvalidMessageException)) {
                log.error("[{}] Error producing on remote broker", (Object)this.replicator.replicatorId, (Object)exception);
                this.replicator.cursor.rewind();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Message persisted on remote broker", (Object)this.replicator.replicatorId, (Object)exception);
                }
                this.replicator.cursor.asyncDelete(this.entry.getPosition(), (AsyncCallbacks.DeleteCallback)this.replicator, (Object)this.entry.getPosition());
            }
            this.entry.release();
            int pending = PENDING_MESSAGES_UPDATER.decrementAndGet(this.replicator);
            if (pending < this.replicator.producerQueueThreshold && HAVE_PENDING_READ_UPDATER.get(this.replicator) == 0) {
                if (pending == 0 || this.replicator.producer.isWritable()) {
                    this.replicator.readMoreEntries();
                } else if (log.isDebugEnabled()) {
                    log.debug("[{}] Not resuming reads. pending: {} is-writable: {}", new Object[]{this.replicator.replicatorId, pending, this.replicator.producer.isWritable()});
                }
            }
            this.recycle();
        }

        private ProducerSendCallback(Recycler.Handle<ProducerSendCallback> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static ProducerSendCallback create(PersistentReplicator replicator, Entry entry, MessageImpl msg) {
            ProducerSendCallback sendCallback = (ProducerSendCallback)RECYCLER.get();
            sendCallback.replicator = replicator;
            sendCallback.entry = entry;
            sendCallback.msg = msg;
            return sendCallback;
        }

        private void recycle() {
            this.replicator = null;
            this.entry = null;
            if (this.msg != null) {
                this.msg.recycle();
                this.msg = null;
            }
            this.recyclerHandle.recycle((Object)this);
        }

        public void addCallback(MessageImpl<?> msg, SendCallback scb) {
        }

        public SendCallback getNextSendCallback() {
            return null;
        }

        public MessageImpl<?> getNextMessage() {
            return null;
        }

        public CompletableFuture<MessageId> getFuture() {
            return CompletableFuture.completedFuture(null);
        }
    }
}

