/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.lookup.LookupResult;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;

public class ExtensibleLoadManagerWrapper
implements LoadManager {
    private PulsarService pulsar;
    private final ExtensibleLoadManagerImpl loadManager;

    public ExtensibleLoadManagerWrapper(ExtensibleLoadManagerImpl loadManager) {
        this.loadManager = loadManager;
    }

    @Override
    public void start() throws PulsarServerException {
        this.loadManager.start();
    }

    @Override
    public void initialize(PulsarService pulsar) {
        this.loadManager.initialize(pulsar);
        this.pulsar = pulsar;
    }

    @Override
    public boolean isCentralized() {
        return true;
    }

    @Override
    public CompletableFuture<Optional<LookupResult>> findBrokerServiceUrl(Optional<ServiceUnitId> topic, ServiceUnitId bundle, LookupOptions options) {
        return this.loadManager.assign(topic, bundle, options).thenApply(lookupData -> lookupData.map(data -> {
            try {
                return data.toLookupResult(options);
            }
            catch (PulsarServerException ex) {
                throw FutureUtil.wrapToCompletionException((Throwable)ex);
            }
        }));
    }

    @Override
    public CompletableFuture<Boolean> checkOwnershipAsync(Optional<ServiceUnitId> topic, ServiceUnitId bundle) {
        return this.loadManager.checkOwnershipAsync(topic, bundle);
    }

    @Override
    public void disableBroker() throws Exception {
        this.loadManager.disableBroker();
    }

    @Override
    public Set<String> getAvailableBrokers() throws Exception {
        return this.getAvailableBrokersAsync().get(this.pulsar.getConfiguration().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public CompletableFuture<Set<String>> getAvailableBrokersAsync() {
        return this.loadManager.getBrokerRegistry().getAvailableBrokersAsync().thenApply(HashSet::new);
    }

    @Override
    public String setNamespaceBundleAffinity(String bundle, String broker) {
        return null;
    }

    @Override
    public void stop() throws PulsarServerException {
        this.loadManager.close();
    }

    @Override
    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId su) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public LoadManagerReport generateLoadReport() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoadReportForceUpdateFlag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLoadReportOnZookeeper() throws Exception {
    }

    @Override
    public void writeResourceQuotasToZooKeeper() throws Exception {
    }

    @Override
    public List<Metrics> getLoadBalancingMetrics() {
        return this.loadManager.getMetrics();
    }

    @Override
    public void doLoadShedding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doNamespaceBundleSplit() {
        throw new UnsupportedOperationException();
    }

    public ExtensibleLoadManagerImpl get() {
        return this.loadManager;
    }
}

