/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import com.google.common.util.concurrent.RateLimiter;
import io.prometheus.client.Counter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class RateLimitingFilter
implements Filter {
    private final RateLimiter limiter;
    private static final Counter httpRejectedRequests = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_broker_http_rejected_requests")).help("Counter of HTTP requests rejected by rate limiting")).register();

    public RateLimitingFilter(double rateLimit) {
        this.limiter = RateLimiter.create((double)rateLimit);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.limiter.tryAcquire()) {
            chain.doFilter(request, response);
        } else {
            httpRejectedRequests.inc();
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(429, "Too Many Requests");
        }
    }

    public void destroy() {
    }
}

