/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.Symbol;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.StandardFunctionResolution;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.sql.relational.optimizer.ExpressionOptimizer;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BindExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.TimeLiteral;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.sql.tree.WhenClause;
import io.trino.type.DateTimes;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import io.trino.util.DateTimeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SqlToRowExpressionTranslator {
    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, Map<NodeRef<Expression>, Type> types, Map<Symbol, Integer> layout, Metadata metadata, Session session, boolean optimize) {
        Visitor visitor = new Visitor(metadata, types, layout, session);
        RowExpression result = (RowExpression)visitor.process((Node)expression, null);
        Objects.requireNonNull(result, "result is null");
        if (optimize) {
            ExpressionOptimizer optimizer = new ExpressionOptimizer(metadata, session);
            return optimizer.optimize(result);
        }
        return result;
    }

    private static class Visitor
    extends AstVisitor<RowExpression, Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> types;
        private final Map<Symbol, Integer> layout;
        private final Session session;
        private final StandardFunctionResolution standardFunctionResolution;

        private Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> types, Map<Symbol, Integer> layout, Session session) {
            this.metadata = metadata;
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
            this.layout = layout;
            this.session = session;
            this.standardFunctionResolution = new StandardFunctionResolution(session, metadata);
        }

        private Type getType(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }

        protected RowExpression visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        protected RowExpression visitFieldReference(FieldReference node, Void context) {
            return Expressions.field(node.getFieldIndex(), this.getType((Expression)node));
        }

        protected RowExpression visitNullLiteral(NullLiteral node, Void context) {
            return Expressions.constantNull((Type)UnknownType.UNKNOWN);
        }

        protected RowExpression visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)BooleanType.BOOLEAN);
        }

        protected RowExpression visitLongLiteral(LongLiteral node, Void context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return Expressions.constant(node.getValue(), (Type)IntegerType.INTEGER);
            }
            return Expressions.constant(node.getValue(), (Type)BigintType.BIGINT);
        }

        protected RowExpression visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)DoubleType.DOUBLE);
        }

        protected RowExpression visitDecimalLiteral(DecimalLiteral node, Void context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return Expressions.constant(parseResult.getObject(), (Type)parseResult.getType());
        }

        protected RowExpression visitStringLiteral(StringLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice())));
        }

        protected RowExpression visitCharLiteral(CharLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)CharType.createCharType((long)node.getValue().length()));
        }

        protected RowExpression visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)VarbinaryType.VARBINARY);
        }

        protected RowExpression visitGenericLiteral(GenericLiteral node, Void context) {
            Type type = this.getType((Expression)node);
            if (JsonType.JSON.equals(type)) {
                return Expressions.call(this.metadata.resolveFunction(this.session, QualifiedName.of((String)"json_parse"), TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR})), Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
            }
            return Expressions.call(this.metadata.getCoercion(this.session, (Type)VarcharType.VARCHAR, type), Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
        }

        protected RowExpression visitTimeLiteral(TimeLiteral node, Void context) {
            Type type = this.getType((Expression)node);
            Object value = type instanceof TimeWithTimeZoneType ? DateTimes.parseTimeWithTimeZone(((TimeWithTimeZoneType)type).getPrecision(), node.getValue()) : Long.valueOf(DateTimes.parseTime(node.getValue()));
            return Expressions.constant(value, type);
        }

        protected RowExpression visitTimestampLiteral(TimestampLiteral node, Void context) {
            Object value;
            Type type = this.getType((Expression)node);
            if (type instanceof TimestampType) {
                int precision = ((TimestampType)type).getPrecision();
                value = DateTimes.parseTimestamp(precision, node.getValue());
            } else if (type instanceof TimestampWithTimeZoneType) {
                int precision = ((TimestampWithTimeZoneType)type).getPrecision();
                value = DateTimes.parseTimestampWithTimeZone(precision, node.getValue());
            } else {
                throw new IllegalStateException("Unexpected type: " + type);
            }
            return Expressions.constant(value, type);
        }

        protected RowExpression visitIntervalLiteral(IntervalLiteral node, Void context) {
            long value = node.isYearToMonth() ? (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()) : (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitComparisonExpression(ComparisonExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            ComparisonExpression.Operator operator = node.getOperator();
            switch (node.getOperator()) {
                case NOT_EQUAL: {
                    return new CallExpression(this.metadata.resolveFunction(this.session, QualifiedName.of((String)"not"), TypeSignatureProvider.fromTypes(new Type[]{BooleanType.BOOLEAN})), (List<RowExpression>)ImmutableList.of((Object)this.visitComparisonExpression(ComparisonExpression.Operator.EQUAL, left, right)));
                }
                case GREATER_THAN: {
                    return this.visitComparisonExpression(ComparisonExpression.Operator.LESS_THAN, right, left);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.visitComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, right, left);
                }
            }
            return this.visitComparisonExpression(operator, left, right);
        }

        private RowExpression visitComparisonExpression(ComparisonExpression.Operator operator, RowExpression left, RowExpression right) {
            return Expressions.call(this.standardFunctionResolution.comparisonFunction(operator, left.getType(), right.getType()), left, right);
        }

        protected RowExpression visitFunctionCall(FunctionCall node, Void context) {
            List arguments = (List)node.getArguments().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            return new CallExpression(this.metadata.decodeFunction(node.getName()), arguments);
        }

        protected RowExpression visitSymbolReference(SymbolReference node, Void context) {
            Integer field = this.layout.get(Symbol.from((Expression)node));
            if (field != null) {
                return Expressions.field(field, this.getType((Expression)node));
            }
            return new VariableReferenceExpression(node.getName(), this.getType((Expression)node));
        }

        protected RowExpression visitLambdaExpression(LambdaExpression node, Void context) {
            RowExpression body = (RowExpression)this.process((Node)node.getBody(), context);
            Type type = this.getType((Expression)node);
            List typeParameters = type.getTypeParameters();
            List<Type> argumentTypes = typeParameters.subList(0, typeParameters.size() - 1);
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            return new LambdaDefinitionExpression(argumentTypes, argumentNames, body);
        }

        protected RowExpression visitBindExpression(BindExpression node, Void context) {
            ImmutableList.Builder valueTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                RowExpression valueRowExpression = (RowExpression)this.process((Node)value, context);
                valueTypesBuilder.add((Object)valueRowExpression.getType());
                argumentsBuilder.add((Object)valueRowExpression);
            }
            RowExpression function = (RowExpression)this.process((Node)node.getFunction(), context);
            argumentsBuilder.add((Object)function);
            return new SpecialForm(SpecialForm.Form.BIND, this.getType((Expression)node), (List<RowExpression>)argumentsBuilder.build());
        }

        protected RowExpression visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(this.standardFunctionResolution.arithmeticFunction(node.getOperator(), left.getType(), right.getType()), left, right);
        }

        protected RowExpression visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            switch (node.getSign()) {
                case PLUS: {
                    return expression;
                }
                case MINUS: {
                    return Expressions.call(this.metadata.resolveOperator(this.session, OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)expression.getType())), expression);
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected RowExpression visitLogicalExpression(LogicalExpression node, Void context) {
            SpecialForm.Form form;
            switch (node.getOperator()) {
                case AND: {
                    form = SpecialForm.Form.AND;
                    break;
                }
                case OR: {
                    form = SpecialForm.Form.OR;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown logical operator: " + node.getOperator());
                }
            }
            return new SpecialForm(form, (Type)BooleanType.BOOLEAN, (List)node.getTerms().stream().map(term -> (RowExpression)this.process((Node)term, context)).collect(ImmutableList.toImmutableList()));
        }

        protected RowExpression visitCast(Cast node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getExpression(), context);
            Type returnType = this.getType((Expression)node);
            if (node.isTypeOnly()) {
                return Visitor.changeType(value, returnType);
            }
            if (node.isSafe()) {
                return Expressions.call(this.metadata.getCoercion(this.session, QualifiedName.of((String)"TRY_CAST"), value.getType(), returnType), value);
            }
            return Expressions.call(this.metadata.getCoercion(this.session, value.getType(), returnType), value);
        }

        private static RowExpression changeType(RowExpression value, Type targetType) {
            ChangeTypeVisitor visitor = new ChangeTypeVisitor(targetType);
            return value.accept(visitor, null);
        }

        protected RowExpression visitCoalesceExpression(CoalesceExpression node, Void context) {
            List arguments = (List)node.getOperands().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            return new SpecialForm(SpecialForm.Form.COALESCE, this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            RowExpression value = (RowExpression)this.process((Node)node.getOperand(), context);
            arguments.add((Object)value);
            ImmutableList.Builder functionDependencies = ImmutableList.builder();
            for (WhenClause clause : node.getWhenClauses()) {
                RowExpression operand = (RowExpression)this.process((Node)clause.getOperand(), context);
                RowExpression result = (RowExpression)this.process((Node)clause.getResult(), context);
                functionDependencies.add((Object)this.metadata.resolveOperator(this.session, OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.getType(), (Object)operand.getType())));
                arguments.add((Object)new SpecialForm(SpecialForm.Form.WHEN, this.getType((Expression)clause), operand, result));
            }
            Type returnType = this.getType((Expression)node);
            arguments.add((Object)node.getDefaultValue().map(defaultValue -> (RowExpression)this.process((Node)defaultValue, context)).orElse(Expressions.constantNull(returnType)));
            return new SpecialForm(SpecialForm.Form.SWITCH, returnType, (List<RowExpression>)arguments.build(), (List<ResolvedFunction>)functionDependencies.build());
        }

        protected RowExpression visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            RowExpression expression = node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse(Expressions.constantNull(this.getType((Expression)node)));
            for (WhenClause clause : Lists.reverse((List)node.getWhenClauses())) {
                expression = new SpecialForm(SpecialForm.Form.IF, this.getType((Expression)node), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context), expression);
            }
            return expression;
        }

        protected RowExpression visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add((Object)((RowExpression)this.process((Node)node.getCondition(), context))).add((Object)((RowExpression)this.process((Node)node.getTrueValue(), context)));
            if (node.getFalseValue().isPresent()) {
                arguments.add((Object)((RowExpression)this.process((Node)node.getFalseValue().get(), context)));
            } else {
                arguments.add((Object)Expressions.constantNull(this.getType((Expression)node)));
            }
            return new SpecialForm(SpecialForm.Form.IF, this.getType((Expression)node), (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitInPredicate(InPredicate node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            arguments.add((Object)value);
            InListExpression values = (InListExpression)node.getValueList();
            for (Expression testValue : values.getValues()) {
                arguments.add((Object)((RowExpression)this.process((Node)testValue, context)));
            }
            ImmutableList functionDependencies = ImmutableList.builder().add((Object)this.metadata.resolveOperator(this.session, OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.getType(), (Object)value.getType()))).add((Object)this.metadata.resolveOperator(this.session, OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)value.getType()))).add((Object)this.metadata.resolveOperator(this.session, OperatorType.INDETERMINATE, (List<? extends Type>)ImmutableList.of((Object)value.getType()))).build();
            return new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build(), (List<ResolvedFunction>)functionDependencies);
        }

        protected RowExpression visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return this.notExpression(new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression)));
        }

        protected RowExpression visitIsNullPredicate(IsNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return new SpecialForm(SpecialForm.Form.IS_NULL, (Type)BooleanType.BOOLEAN, expression);
        }

        protected RowExpression visitNotExpression(NotExpression node, Void context) {
            return this.notExpression((RowExpression)this.process((Node)node.getValue(), context));
        }

        private RowExpression notExpression(RowExpression value) {
            return new CallExpression(this.metadata.resolveFunction(this.session, QualifiedName.of((String)"not"), TypeSignatureProvider.fromTypes(new Type[]{BooleanType.BOOLEAN})), (List<RowExpression>)ImmutableList.of((Object)value));
        }

        protected RowExpression visitNullIfExpression(NullIfExpression node, Void context) {
            RowExpression first = (RowExpression)this.process((Node)node.getFirst(), context);
            RowExpression second = (RowExpression)this.process((Node)node.getSecond(), context);
            ResolvedFunction resolvedFunction = this.metadata.resolveOperator(this.session, OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)first.getType(), (Object)second.getType()));
            ImmutableList functionDependencies = ImmutableList.builder().add((Object)resolvedFunction).add((Object)this.metadata.getCoercion(this.session, first.getType(), resolvedFunction.getSignature().getArgumentTypes().get(0))).add((Object)this.metadata.getCoercion(this.session, second.getType(), resolvedFunction.getSignature().getArgumentTypes().get(0))).build();
            return new SpecialForm(SpecialForm.Form.NULL_IF, this.getType((Expression)node), (List<RowExpression>)ImmutableList.of((Object)first, (Object)second), (List<ResolvedFunction>)functionDependencies);
        }

        protected RowExpression visitBetweenPredicate(BetweenPredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression min = (RowExpression)this.process((Node)node.getMin(), context);
            RowExpression max = (RowExpression)this.process((Node)node.getMax(), context);
            ImmutableList functionDependencies = ImmutableList.builder().add((Object)this.metadata.resolveOperator(this.session, OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.getType(), (Object)max.getType()))).build();
            return new SpecialForm(SpecialForm.Form.BETWEEN, (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)value, (Object)min, (Object)max), (List<ResolvedFunction>)functionDependencies);
        }

        protected RowExpression visitSubscriptExpression(SubscriptExpression node, Void context) {
            RowExpression base = (RowExpression)this.process((Node)node.getBase(), context);
            RowExpression index = (RowExpression)this.process((Node)node.getIndex(), context);
            if (this.getType(node.getBase()) instanceof RowType) {
                long value = (Long)((ConstantExpression)index).getValue();
                return new SpecialForm(SpecialForm.Form.DEREFERENCE, this.getType((Expression)node), base, Expressions.constant((int)value - 1, (Type)IntegerType.INTEGER));
            }
            return Expressions.call(this.metadata.resolveOperator(this.session, OperatorType.SUBSCRIPT, (List<? extends Type>)ImmutableList.of((Object)base.getType(), (Object)index.getType())), base, index);
        }

        protected RowExpression visitRow(Row node, Void context) {
            List arguments = (List)node.getItems().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            Type returnType = this.getType((Expression)node);
            return new SpecialForm(SpecialForm.Form.ROW_CONSTRUCTOR, returnType, arguments);
        }

        private static class ChangeTypeVisitor
        implements RowExpressionVisitor<RowExpression, Void> {
            private final Type targetType;

            private ChangeTypeVisitor(Type targetType) {
                this.targetType = targetType;
            }

            @Override
            public RowExpression visitCall(CallExpression call, Void context) {
                return new CallExpression(call.getResolvedFunction(), call.getArguments());
            }

            @Override
            public RowExpression visitSpecialForm(SpecialForm specialForm, Void context) {
                return new SpecialForm(specialForm.getForm(), this.targetType, specialForm.getArguments());
            }

            @Override
            public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
                return Expressions.field(reference.getField(), this.targetType);
            }

            @Override
            public RowExpression visitConstant(ConstantExpression literal, Void context) {
                return Expressions.constant(literal.getValue(), this.targetType);
            }

            @Override
            public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
                return new VariableReferenceExpression(reference.getName(), this.targetType);
            }
        }
    }
}

