/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.TableElement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ColumnDefinition
extends TableElement {
    private final Identifier name;
    private final DataType type;
    private final boolean nullable;
    private final List<Property> properties;
    private final Optional<String> comment;

    public ColumnDefinition(Identifier name, DataType type, boolean nullable, List<Property> properties, Optional<String> comment) {
        this(Optional.empty(), name, type, nullable, properties, comment);
    }

    public ColumnDefinition(NodeLocation location, Identifier name, DataType type, boolean nullable, List<Property> properties, Optional<String> comment) {
        this(Optional.of(location), name, type, nullable, properties, comment);
    }

    private ColumnDefinition(Optional<NodeLocation> location, Identifier name, DataType type, boolean nullable, List<Property> properties, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.nullable = nullable;
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumnDefinition(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDefinition o = (ColumnDefinition)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.type, o.type) && this.nullable == o.nullable && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type, this.properties, this.comment, this.nullable);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("nullable", this.nullable).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

