/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.procedure;

import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Procedure {
    private final String schema;
    private final String name;
    private final List<Argument> arguments;
    private final MethodHandle methodHandle;

    public Procedure(String schema, String name, List<Argument> arguments, MethodHandle methodHandle) {
        this.schema = Procedure.checkNotNullOrEmpty(schema, "schema").toLowerCase(Locale.ENGLISH);
        this.name = Procedure.checkNotNullOrEmpty(name, "name").toLowerCase(Locale.ENGLISH);
        this.arguments = List.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        HashSet<String> names = new HashSet<String>();
        for (Argument argument : arguments) {
            Procedure.checkArgument(names.add(argument.getName()), String.format("Duplicate argument name: '%s'", argument.getName()));
        }
        for (int index = 1; index < arguments.size(); ++index) {
            if (!arguments.get(index - 1).isOptional() || !arguments.get(index).isRequired()) continue;
            throw new IllegalArgumentException("Optional arguments should follow required ones");
        }
        Procedure.checkArgument(!methodHandle.isVarargsCollector(), "Method must have fixed arity");
        Procedure.checkArgument(methodHandle.type().returnType() == Void.TYPE, "Method must return void");
        long parameterCount = methodHandle.type().parameterList().stream().filter(type -> !ConnectorSession.class.equals(type)).filter(type -> !ConnectorAccessControl.class.equals(type)).count();
        Procedure.checkArgument(parameterCount == (long)arguments.size(), "Method parameter count must match arguments");
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public String toString() {
        return this.schema + '.' + this.name + '(' + this.arguments.stream().map(Object::toString).collect(Collectors.joining(", ")) + ')';
    }

    private static String checkNotNullOrEmpty(String value, String name) {
        Objects.requireNonNull(value, name + " is null");
        Procedure.checkArgument(!value.isEmpty(), name + " is empty");
        return value;
    }

    private static void checkArgument(boolean assertion, String message) {
        if (!assertion) {
            throw new IllegalArgumentException(message);
        }
    }

    public static class Argument {
        private final String name;
        private final Type type;
        private final boolean required;
        private final Object defaultValue;

        public Argument(String name, Type type) {
            this(name, type, true, null);
        }

        public Argument(String name, Type type, boolean required, @Nullable Object defaultValue) {
            this.name = Procedure.checkNotNullOrEmpty(name, "name");
            this.type = Objects.requireNonNull(type, "type is null");
            this.required = required;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isOptional() {
            return !this.required;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            return this.name + " " + this.type;
        }
    }
}

