/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.sanity.AllFunctionsResolved;
import io.trino.sql.planner.sanity.DynamicFiltersChecker;
import io.trino.sql.planner.sanity.NoDuplicatePlanNodeIdsChecker;
import io.trino.sql.planner.sanity.NoIdentifierLeftChecker;
import io.trino.sql.planner.sanity.NoSubqueryExpressionLeftChecker;
import io.trino.sql.planner.sanity.SugarFreeChecker;
import io.trino.sql.planner.sanity.TableExecuteStructureValidator;
import io.trino.sql.planner.sanity.TableScanValidator;
import io.trino.sql.planner.sanity.TypeValidator;
import io.trino.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import io.trino.sql.planner.sanity.ValidateDependenciesChecker;
import io.trino.sql.planner.sanity.ValidateLimitWithPresortedInput;
import io.trino.sql.planner.sanity.ValidateStreamingAggregations;
import io.trino.sql.planner.sanity.VerifyNoFilteredAggregations;
import io.trino.sql.planner.sanity.VerifyOnlyOneOutputNode;
import io.trino.sql.planner.sanity.VerifyUseConnectorNodePartitioningSet;

public final class PlanSanityChecker {
    public static final PlanSanityChecker DISTRIBUTED_PLAN_SANITY_CHECKER = new PlanSanityChecker(false);
    private final Multimap<Stage, Checker> checkers;

    public PlanSanityChecker(boolean forceSingleNode) {
        this.checkers = ImmutableListMultimap.builder().putAll((Object)Stage.INTERMEDIATE, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new AllFunctionsResolved(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode()}).putAll((Object)Stage.FINAL, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new SugarFreeChecker(), new AllFunctionsResolved(), new TypeValidator(), new NoSubqueryExpressionLeftChecker(), new NoIdentifierLeftChecker(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations(), new VerifyUseConnectorNodePartitioningSet(), new ValidateAggregationsWithDefaultValues(forceSingleNode), new ValidateStreamingAggregations(), new ValidateLimitWithPresortedInput(), new DynamicFiltersChecker(), new TableScanValidator(), new TableExecuteStructureValidator()}).build();
    }

    public void validateFinalPlan(PlanNode planNode, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.FINAL).forEach(checker -> checker.validate(planNode, session, plannerContext, typeAnalyzer, types, warningCollector));
    }

    public void validateIntermediatePlan(PlanNode planNode, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        this.checkers.get((Object)Stage.INTERMEDIATE).forEach(checker -> checker.validate(planNode, session, plannerContext, typeAnalyzer, types, warningCollector));
    }

    private static enum Stage {
        INTERMEDIATE,
        FINAL;

    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, PlannerContext var3, TypeAnalyzer var4, TypeProvider var5, WarningCollector var6);
    }
}

