/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Set;
import java.util.stream.Stream;

public class PruneAggregationSourceColumns
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{aggregationNode.getGroupingKeys().stream(), aggregationNode.getHashSymbol().stream(), aggregationNode.getAggregations().values().stream().flatMap(aggregation -> SymbolsExtractor.extractUnique(aggregation).stream())}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), aggregationNode, requiredInputs).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

