/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.server.security.jwt.FileSigningKeyResolver;
import io.trino.server.security.jwt.ForJwk;
import io.trino.server.security.jwt.JwkService;
import io.trino.server.security.jwt.JwkSigningKeyResolver;
import io.trino.server.security.jwt.JwtAuthenticatorConfig;
import java.net.URI;
import javax.inject.Singleton;

public class JwtAuthenticatorSupportModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(JwtAuthenticatorConfig.class);
        this.install(ConditionalModule.conditionalModule(JwtAuthenticatorConfig.class, JwtAuthenticatorSupportModule::isHttp, (Module)new JwkModule(), jwkBinder -> jwkBinder.bind(SigningKeyResolver.class).to(FileSigningKeyResolver.class).in(Scopes.SINGLETON)));
    }

    private static boolean isHttp(JwtAuthenticatorConfig config) {
        return config.getKeyFile().startsWith("https://") || config.getKeyFile().startsWith("http://");
    }

    private static class JwkModule
    implements Module {
        private JwkModule() {
        }

        public void configure(Binder binder) {
            binder.bind(SigningKeyResolver.class).to(JwkSigningKeyResolver.class).in(Scopes.SINGLETON);
            binder.bind(JwkService.class).in(Scopes.SINGLETON);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("jwk", ForJwk.class).withConfigDefaults(config -> config.setKeyStorePath(null).setKeyStorePassword(null).setTrustStorePath(null).setTrustStorePassword(null).setAutomaticHttpsSharedSecret(null));
        }

        @Provides
        @Singleton
        @ForJwk
        public static URI createJwkAddress(JwtAuthenticatorConfig config) {
            return URI.create(config.getKeyFile());
        }

        public int hashCode() {
            return JwkModule.class.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof JwkModule;
        }
    }
}

