/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import io.trino.util.DateTimeZoneIndex;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToTimestampCast {
    private TimestampWithTimeZoneToTimestampCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") long timestamp) {
        long epochMillis = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestamp)).getZone().convertUTCToLocal(DateTimeEncoding.unpackMillisUtc((long)timestamp));
        return DateTimes.round(DateTimes.scaleEpochMillisToMicros(epochMillis), (int)(6L - targetPrecision));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        long epochMillis = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).getZone().convertUTCToLocal(timestamp.getEpochMillis());
        int picosOfMilli = timestamp.getPicosOfMilli();
        long epochMicros = DateTimes.toEpochMicros(epochMillis, picosOfMilli);
        int picosOfMicro = picosOfMilli % 1000000;
        if (targetPrecision < 6L) {
            epochMicros = DateTimes.round(epochMicros, (int)(6L - targetPrecision));
        } else if (DateTimes.roundToNearest(picosOfMicro, 1000000L) == 1000000L) {
            ++epochMicros;
        }
        return epochMicros;
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp shortToLong(@SqlType(value="timestamp(sourcePrecision) with time zone") long timestamp) {
        long epochMillis = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestamp)).getZone().convertUTCToLocal(DateTimeEncoding.unpackMillisUtc((long)timestamp));
        return new LongTimestamp(DateTimes.scaleEpochMillisToMicros(epochMillis), 0);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        long epochMillis = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).getZone().convertUTCToLocal(timestamp.getEpochMillis());
        int picosOfMilli = timestamp.getPicosOfMilli();
        long epochMicros = DateTimes.toEpochMicros(epochMillis, picosOfMilli);
        int picosOfMicro = picosOfMilli % 1000000;
        if ((picosOfMicro = (int)DateTimes.round(picosOfMicro, (int)(12L - targetPrecision))) == 1000000) {
            ++epochMicros;
            picosOfMicro = 0;
        }
        return new LongTimestamp(epochMicros, picosOfMicro);
    }
}

