/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.Type;
import io.trino.type.BigintOperators;
import io.trino.type.IntervalDayTimeType;

@AggregationFunction(value="sum")
public final class IntervalDayToSecondSumAggregation {
    private IntervalDayToSecondSumAggregation() {
    }

    @InputFunction
    public static void sum(NullableLongState state, @SqlType(value="interval day to second") long value) {
        state.setNull(false);
        state.setValue(BigintOperators.add(state.getValue(), value));
    }

    @CombineFunction
    public static void combine(NullableLongState state, NullableLongState otherState) {
        if (state.isNull()) {
            state.set(otherState);
            return;
        }
        state.setValue(BigintOperators.add(state.getValue(), otherState.getValue()));
    }

    @OutputFunction(value="interval day to second")
    public static void output(NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)IntervalDayTimeType.INTERVAL_DAY_TIME, state, out);
    }
}

