/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionInvoker {
    private final MethodHandle methodHandle;
    private final Optional<MethodHandle> instanceFactory;
    private final List<Class<?>> lambdaInterfaces;

    public FunctionInvoker(MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
        this.lambdaInterfaces = ImmutableList.of();
    }

    public FunctionInvoker(MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, List<Class<?>> lambdaInterfaces) {
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
        this.lambdaInterfaces = Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null");
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public Optional<MethodHandle> getInstanceFactory() {
        return this.instanceFactory;
    }

    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }
}

