/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.provider.annotation;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlDynamicExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;

public class CsdlLogicalOrComparisonExpression
extends CsdlDynamicExpression
implements CsdlAnnotatable {
    private final LogicalOrComparisonExpressionType type;
    private CsdlExpression left;
    private CsdlExpression right;
    private List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    public CsdlLogicalOrComparisonExpression(LogicalOrComparisonExpressionType type) {
        this.type = type;
    }

    @Override
    public List<CsdlAnnotation> getAnnotations() {
        return this.annotations;
    }

    public CsdlLogicalOrComparisonExpression setAnnotations(List<CsdlAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public LogicalOrComparisonExpressionType getType() {
        return this.type;
    }

    public CsdlExpression getLeft() {
        return this.left;
    }

    public CsdlLogicalOrComparisonExpression setLeft(CsdlExpression left) {
        this.left = left;
        if (this.getType() == LogicalOrComparisonExpressionType.Not) {
            this.right = left;
        }
        return this;
    }

    public CsdlExpression getRight() {
        return this.right;
    }

    public CsdlLogicalOrComparisonExpression setRight(CsdlExpression right) {
        this.right = right;
        if (this.getType() == LogicalOrComparisonExpressionType.Not) {
            this.left = right;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsdlLogicalOrComparisonExpression)) {
            return false;
        }
        CsdlLogicalOrComparisonExpression csdlLogComp = (CsdlLogicalOrComparisonExpression)obj;
        return (this.getLeft() == null ? csdlLogComp.getLeft() == null : this.getLeft().equals(csdlLogComp.getLeft())) && (this.getRight() == null ? csdlLogComp.getRight() == null : this.getRight().equals(csdlLogComp.getRight())) && (this.getType() == null ? csdlLogComp.getType() == null : this.getType().equals((Object)csdlLogComp.getType())) && (this.getAnnotations() == null ? csdlLogComp.getAnnotations() == null : this.checkAnnotations(csdlLogComp.getAnnotations()));
    }

    private boolean checkAnnotations(List<CsdlAnnotation> csdlLogCompAnnot) {
        if (csdlLogCompAnnot == null) {
            return false;
        }
        if (this.getAnnotations().size() == csdlLogCompAnnot.size()) {
            for (int i = 0; i < this.getAnnotations().size(); ++i) {
                if (this.getAnnotations().get(i).equals(csdlLogCompAnnot.get(i))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        return result;
    }

    public static enum LogicalOrComparisonExpressionType {
        And,
        Or,
        Not,
        Eq,
        Ne,
        Gt,
        Ge,
        Lt,
        Le;


        public static LogicalOrComparisonExpressionType fromString(String value) {
            LogicalOrComparisonExpressionType result = null;
            try {
                result = LogicalOrComparisonExpressionType.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return result;
        }
    }
}

