/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.utils.ClasspathResourceFinder;
import org.apache.juneau.utils.ClasspathResourceFinderBasic;

public final class ClasspathResourceManager {
    private final ConcurrentHashMap<ResourceKey, byte[]> byteCache;
    private final ConcurrentHashMap<ResourceKey, String> stringCache;
    private final Class<?> baseClass;
    private final ClasspathResourceFinder resourceFinder;
    private final boolean useCache;

    public ClasspathResourceManager(Class<?> baseClass, ClasspathResourceFinder resourceFinder, boolean useCache) {
        this.baseClass = baseClass;
        this.resourceFinder = resourceFinder;
        this.useCache = useCache;
        if (useCache) {
            this.byteCache = new ConcurrentHashMap();
            this.stringCache = new ConcurrentHashMap();
        } else {
            this.byteCache = null;
            this.stringCache = null;
        }
    }

    public ClasspathResourceManager(Class<?> baseClass) {
        this(baseClass, new ClasspathResourceFinderBasic(), false);
    }

    public InputStream getStream(String name) throws IOException {
        return this.getStream(name, null);
    }

    public InputStream getStream(String name, Locale locale) throws IOException {
        return this.getStream(this.baseClass, name, locale);
    }

    public InputStream getStream(Class<?> baseClass, String name, Locale locale) throws IOException {
        if (baseClass == null) {
            baseClass = this.baseClass;
        }
        if (!this.useCache) {
            return this.resourceFinder.findResource(baseClass, name, locale);
        }
        ResourceKey key = new ResourceKey(name, locale);
        byte[] r = this.byteCache.get(key);
        if (r == null) {
            try (InputStream is = this.resourceFinder.findResource(baseClass, name, locale);){
                if (is != null) {
                    this.byteCache.putIfAbsent(key, IOUtils.readBytes(is, 1024));
                }
            }
        }
        return (r = this.byteCache.get(key)) == null ? null : new ByteArrayInputStream(r);
    }

    public String getString(String name) throws IOException {
        return this.getString(this.baseClass, name, null);
    }

    public String getString(Class<?> baseClass, String name) throws IOException {
        return this.getString(baseClass, name, null);
    }

    public String getString(String name, Locale locale) throws IOException {
        return this.getString(this.baseClass, name, locale);
    }

    public String getString(Class<?> baseClass, String name, Locale locale) throws IOException {
        if (baseClass == null) {
            baseClass = this.baseClass;
        }
        if (!this.useCache) {
            try (InputStream is = this.resourceFinder.findResource(baseClass, name, locale);){
                String string = IOUtils.read(is, IOUtils.UTF8);
                return string;
            }
        }
        ResourceKey key = new ResourceKey(name, locale);
        String r = this.stringCache.get(key);
        if (r == null) {
            try (InputStream is = this.resourceFinder.findResource(baseClass, name, locale);){
                if (is != null) {
                    this.stringCache.putIfAbsent(key, IOUtils.read(is, IOUtils.UTF8));
                }
            }
        }
        return this.stringCache.get(key);
    }

    private class ResourceKey {
        final String name;
        final Locale locale;

        ResourceKey(String name, Locale locale) {
            this.name = name;
            this.locale = locale;
        }

        public int hashCode() {
            return this.name.hashCode() + (this.locale == null ? 0 : this.locale.hashCode());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            ResourceKey ok = (ResourceKey)o;
            return ObjectUtils.equals(this.name, ok.name) && ObjectUtils.equals(this.locale, ok.locale);
        }
    }
}

