/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.util.Map;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ContextBuilder;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.encode.ConfigEncoder;
import org.apache.juneau.config.store.ConfigMemoryStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolver;

public class ConfigBuilder
extends ContextBuilder {
    public ConfigBuilder() {
    }

    public ConfigBuilder(PropertyStore ps) {
        super(ps);
    }

    @Override
    public Config build() {
        return this.build(Config.class);
    }

    public ConfigBuilder name(String value) {
        return this.set("Config.name.s", value);
    }

    public ConfigBuilder store(ConfigStore value) {
        return this.set("Config.store.o", value);
    }

    public ConfigBuilder memStore() {
        return this.set("Config.store.o", ConfigMemoryStore.DEFAULT);
    }

    public ConfigBuilder serializer(WriterSerializer value) {
        return this.set("Config.serializer.o", value);
    }

    public ConfigBuilder serializer(Class<? extends WriterSerializer> value) {
        return this.set("Config.serializer.o", value);
    }

    public ConfigBuilder parser(ReaderParser value) {
        return this.set("Config.parser.o", value);
    }

    public ConfigBuilder parser(Class<? extends ReaderParser> value) {
        return this.set("Config.parser.o", value);
    }

    public ConfigBuilder encoder(ConfigEncoder value) {
        return this.set("Config.encoder.o", value);
    }

    public ConfigBuilder encoder(Class<? extends ConfigEncoder> value) {
        return this.set("Config.encoder.o", value);
    }

    public ConfigBuilder varResolver(VarResolver value) {
        return this.set("Config.varResolver.o", value);
    }

    public ConfigBuilder varResolver(Class<? extends VarResolver> value) {
        return this.set("Config.varResolver.o", value);
    }

    public ConfigBuilder binaryLineLength(int value) {
        return this.set("Config.binaryLineLength.i", value);
    }

    public ConfigBuilder binaryFormat(BinaryFormat value) {
        return this.set("Config.binaryFormat.s", (Object)value);
    }

    public ConfigBuilder multiLineValuesOnSeparateLines() {
        return this.set("Config.multiLineValuesOnSeparateLines.b", true);
    }

    public ConfigBuilder readOnly() {
        return this.set("Config.readOnly.b", true);
    }

    @Override
    public ConfigBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public ConfigBuilder set(Map<String, Object> properties) {
        super.set(properties);
        return this;
    }

    @Override
    public ConfigBuilder add(Map<String, Object> properties) {
        super.add(properties);
        return this;
    }

    @Override
    public ConfigBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public ConfigBuilder addTo(String name, String key, Object value) {
        super.addTo(name, key, value);
        return this;
    }

    @Override
    public ConfigBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public ConfigBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }
}

