/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedFilterChain
implements FilterChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxiedFilterChain.class);
    private FilterChain orig;
    private List<Filter> filters;
    private int index;

    public ProxiedFilterChain(FilterChain orig, List<Filter> filters) {
        if (orig == null) {
            throw new NullPointerException("original FilterChain cannot be null.");
        }
        this.orig = orig;
        this.filters = filters;
        this.index = 0;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.filters == null || this.filters.size() == this.index) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Invoking original filter chain.");
            }
            this.orig.doFilter(request, response);
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Invoking wrapped filter at index [" + this.index + "]");
            }
            this.filters.get(this.index++).doFilter(request, response, this);
        }
    }
}

