/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.lang.codec;

import java.io.IOException;

public final class H64 {
    private static final byte FF = -1;
    private static final char[] ITOA_64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    private H64() {
    }

    private static short toShort(byte b) {
        return (short)(b & 0xFFFFFFFF);
    }

    private static int toInt(byte[] bytes, int offset, int numBytes) {
        if (numBytes < 1 || numBytes > 4) {
            throw new IllegalArgumentException("numBytes must be between 1 and 4.");
        }
        int val = H64.toShort(bytes[offset]);
        block5: for (int i = 1; i < numBytes; ++i) {
            short s = H64.toShort(bytes[offset + i]);
            switch (i) {
                case 1: {
                    val |= s << 8;
                    continue block5;
                }
                case 2: {
                    val |= s << 16;
                    continue block5;
                }
                case 3: {
                    val |= s << 24;
                    continue block5;
                }
            }
        }
        return val;
    }

    private static void append(Appendable buf, char c) {
        try {
            buf.append(c);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Unable to append character to internal buffer.", e2);
        }
    }

    private static void encodeAndAppend(int value, Appendable buf, int numChars) {
        for (int i = 0; i < numChars; ++i) {
            H64.append(buf, ITOA_64[value & 0x3F]);
            value >>= 6;
        }
    }

    public static String encodeToString(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int length = bytes.length;
        int remainder = length % 3;
        int last3ByteIndex = length - remainder;
        for (i = 0; i < last3ByteIndex; i += 3) {
            int twentyFourBit = H64.toInt(bytes, i, 3);
            H64.encodeAndAppend(twentyFourBit, buf, 4);
        }
        if (remainder > 0) {
            int a = H64.toInt(bytes, i, remainder);
            H64.encodeAndAppend(a, buf, remainder + 1);
        }
        return buf.toString();
    }
}

