/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.base.block;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.block.Block;
import org.apache.jena.tdb1.base.block.BlockException;
import org.apache.jena.tdb1.base.block.BlockMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrTracker
implements BlockMgr {
    private static Logger loggerDefault = LoggerFactory.getLogger(BlockMgrTracker.class);
    public static boolean verbose = false;
    static final Long NoId = -9L;
    protected final MultiSet<Long> activeReadBlocks = new HashMultiSet<Long>();
    protected final MultiSet<Long> activeWriteBlocks = new HashMultiSet<Long>();
    protected final MultiSet<Long> activeIterBlocks = new HashMultiSet<Long>();
    protected final List<Pair<Action, Long>> actions = new ArrayList<Pair<Action, Long>>();
    protected final List<Iterator<?>> activeIterators = new ArrayList();
    protected final BlockMgr blockMgr;
    private int inRead = 0;
    private int inIterator = 0;
    private boolean inUpdate = false;
    private final Logger log;
    private final String label;

    private void clearInternalRW() {
        this.activeReadBlocks.clear();
        this.activeWriteBlocks.clear();
        this.actions.clear();
    }

    public static BlockMgr track(BlockMgr blkMgr) {
        return BlockMgrTracker.track(blkMgr.getLabel(), blkMgr);
    }

    private static BlockMgr track(String label, BlockMgr blkMgr) {
        return new BlockMgrTracker(label, blkMgr);
    }

    private BlockMgrTracker(String label, BlockMgr blockMgr) {
        this(loggerDefault, label, blockMgr);
    }

    public BlockMgrTracker(Logger logger, String label, BlockMgr blockMgr) {
        this.blockMgr = blockMgr;
        this.log = logger;
        this.label = blockMgr.getLabel();
    }

    private void add(Action action, Long id) {
        this.actions.add(new Pair<Action, Long>(action, id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block allocate(int blockSize) {
        Block block;
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkUpdate(Action.Alloc);
            block = this.blockMgr.allocate(blockSize);
            Long id = block.getId();
            this.activeWriteBlocks.add(id);
            this.add(Action.Alloc, id);
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getRead(long id) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkRead(Action.GetRead);
            Long x = id;
            this.add(Action.GetRead, x);
            if (this.activeWriteBlocks.contains(x)) {
                this.activeWriteBlocks.add(x);
            } else {
                this.activeReadBlocks.add(x);
            }
        }
        return this.blockMgr.getRead(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getReadIterator(long id) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkReadOrIter(Action.IterRead);
            Long x = id;
            this.add(Action.IterRead, x);
            this.activeIterBlocks.add(x);
        }
        return this.blockMgr.getReadIterator(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block getWrite(long id) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkUpdate(Action.GetWrite);
            Long x = id;
            this.add(Action.GetWrite, x);
            this.activeWriteBlocks.add(x);
        }
        return this.blockMgr.getWrite(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block promote(Block block) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkUpdate(Action.Promote);
            Long id = block.getId();
            this.add(Action.Promote, id);
            if (!this.activeWriteBlocks.contains(id) && !this.activeReadBlocks.contains(id)) {
                this.error(Action.Promote, id + " is not an active block");
            }
            if (this.activeReadBlocks.contains(id)) {
                this.activeReadBlocks.remove(id);
            }
            if (!this.activeWriteBlocks.contains(id)) {
                this.activeWriteBlocks.add(id);
            }
        }
        return this.blockMgr.promote(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Block block) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkReadOrIter(Action.Release);
            Long id = block.getId();
            this.add(Action.Release, id);
            if (!(this.activeReadBlocks.contains(id) || this.activeIterBlocks.contains(id) || this.activeWriteBlocks.contains(id))) {
                this.error(Action.Release, id + " is not an active block");
            }
            if (this.activeWriteBlocks.contains(id)) {
                this.activeWriteBlocks.remove(id);
            } else {
                this.activeReadBlocks.remove(block.getId());
            }
            this.activeIterBlocks.remove(block.getId());
        }
        this.blockMgr.release(block);
    }

    @Override
    public void write(Block block) {
        this.writeTracker(block);
        this.blockMgr.write(block);
    }

    @Override
    public synchronized void overwrite(Block block) {
        this.writeTracker(block);
        this.blockMgr.overwrite(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTracker(Block block) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkUpdate(Action.Write);
            Long id = block.getId();
            this.add(Action.Write, id);
            if (!this.activeWriteBlocks.contains(id)) {
                this.error(Action.Write, id + " is not an active write block");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Block block) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            this.checkUpdate(Action.Free);
            Long id = block.getId();
            this.add(Action.Free, id);
            if (this.activeReadBlocks.contains(id)) {
                this.error(Action.Free, id + " is a read block");
            } else if (!this.activeWriteBlocks.contains(id)) {
                this.error(Action.Free, id + " is not a write block");
            }
            this.activeWriteBlocks.remove(id);
        }
        this.blockMgr.free(block);
    }

    @Override
    public void sync() {
        this.blockMgr.sync();
    }

    @Override
    public void syncForce() {
        this.blockMgr.syncForce();
    }

    @Override
    public void close() {
        this.blockMgr.close();
    }

    @Override
    public boolean isEmpty() {
        return this.blockMgr.isEmpty();
    }

    @Override
    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    @Override
    public boolean isClosed() {
        return this.blockMgr.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginIterator(Iterator<?> iter) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            if (this.activeIterators.contains(iter)) {
                this.error(Action.BeginIter, "Iterator already active: " + String.valueOf(iter));
            }
            this.activeIterators.add(iter);
        }
        this.blockMgr.beginIterator(iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endIterator(Iterator<?> iter) {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            if (!this.activeIterators.contains(iter)) {
                this.error(Action.EndIter, "Iterator not active: " + String.valueOf(iter));
            }
            this.activeIterators.remove(iter);
            if (this.activeIterators.size() == 0) {
                this.checkEmpty("Outstanding iterator read blocks", this.activeIterBlocks);
            }
        }
        this.blockMgr.endIterator(iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void beginRead() {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            if (this.inUpdate) {
                this.error(Action.BeginRead, "beginRead when already in update");
            }
            ++this.inRead;
            this.inUpdate = false;
        }
        this.blockMgr.beginRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void endRead() {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            if (this.inRead == 0) {
                this.error(Action.EndRead, "endRead but not in read");
            }
            if (this.inUpdate) {
                this.error(Action.EndRead, "endRead when in update");
            }
            this.checkEmpty("Outstanding write blocks at end of read operations!", this.activeWriteBlocks);
            if (this.inRead == 0) {
                this.checkEmpty("Outstanding read blocks at end of read operations", this.activeReadBlocks);
                this.clearInternalRW();
            }
            this.inUpdate = false;
            --this.inRead;
        }
        this.blockMgr.endRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginUpdate() {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            if (this.inRead > 0) {
                this.error(Action.BeginUpdate, "beginUpdate when already in read");
            }
            if (this.inUpdate) {
                this.error(Action.BeginUpdate, "beginUpdate when already in update");
            }
            this.inUpdate = true;
        }
        this.blockMgr.beginUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endUpdate() {
        BlockMgrTracker blockMgrTracker = this;
        synchronized (blockMgrTracker) {
            if (!this.inUpdate) {
                this.error(Action.EndUpdate, "endUpdate but not in update");
            }
            if (this.inRead > 0) {
                this.error(Action.EndUpdate, "endUpdate when in read");
            }
            this.checkEmpty("Outstanding read blocks at end of update operations", this.activeReadBlocks);
            this.checkEmpty("Outstanding write blocks at end of update operations", this.activeWriteBlocks);
            this.inUpdate = false;
            this.inRead = 0;
            this.clearInternalRW();
        }
        this.blockMgr.endUpdate();
    }

    private void checkUpdate(Action action) {
        if (!this.inUpdate) {
            this.error(action, "called outside update");
        }
    }

    private void checkRead(Action action) {
        if (!this.inUpdate && this.inRead == 0) {
            this.error(action, "Called outside update and read");
        }
    }

    private void checkReadOrIter(Action action) {
        if (!this.inUpdate && this.inRead == 0 && this.activeIterators.size() == 0) {
            this.error(action, "Called outside update, read or an iterator");
        }
    }

    private void checkEmpty(String string, MultiSet<Long> blocks) {
        if (!blocks.isEmpty()) {
            this.error(string);
            for (Long id : blocks) {
                this.info("    Block: " + id);
            }
            this.history();
            throw new TDB1Exception();
        }
    }

    private String msg(String string) {
        if (this.label == null) {
            return string;
        }
        return this.label + ": " + string;
    }

    private void info(String string) {
        this.log.info(this.msg(string));
    }

    private void warn(String string) {
        this.log.warn(this.msg(string));
    }

    private void error(String string) {
        this.log.error(this.msg(string));
    }

    private void error(Action action, String string) {
        if (verbose) {
            this.error(String.valueOf((Object)action) + ": " + string);
            this.history();
        }
        throw new BlockException(this.msg(String.valueOf((Object)action) + ": " + string));
    }

    private void history() {
        this.info("History");
        for (Pair<Action, Long> p : this.actions) {
            if (p.getRight() != NoId) {
                this.log.info(String.format("%s:     %-12s  %d", new Object[]{this.label, p.getLeft(), p.getRight()}));
                continue;
            }
            this.log.info(String.format("%s:     %-12s", new Object[]{this.label, p.getLeft()}));
        }
    }

    public String toString() {
        return "BlockMgrTracker" + (String)(this.label == null ? "" : ": " + this.label);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    static enum Action {
        Alloc,
        Promote,
        GetRead,
        GetWrite,
        Write,
        Release,
        Free,
        IterRead,
        BeginRead,
        EndRead,
        BeginUpdate,
        EndUpdate,
        BeginIter,
        EndIter;

    }
}

