/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Factory;
import org.apache.jena.tdb1.assembler.VocabTDB1;
import org.apache.jena.tdb1.base.file.Location;

public class DatasetAssemblerTDB1
extends DatasetAssembler {
    @Override
    public DatasetGraph createDataset(Assembler a, Resource root2) {
        return DatasetAssemblerTDB1.make(a, root2);
    }

    public static DatasetGraph make(Assembler a, Resource root2) {
        if (!GraphUtils.exactlyOneProperty(root2, VocabTDB1.pLocation)) {
            throw new AssemblerException(root2, "No location given");
        }
        String dir = GraphUtils.getStringValue(root2, VocabTDB1.pLocation);
        Location loc = Location.create(dir);
        DatasetGraph dsg = TDB1Factory.createDatasetGraph(loc);
        if (root2.hasProperty(VocabTDB1.pUnionDefaultGraph)) {
            Node b = root2.getProperty(VocabTDB1.pUnionDefaultGraph).getObject().asNode();
            NodeValue nv = NodeValue.makeNode(b);
            if (nv.isBoolean()) {
                dsg.getContext().set(TDB1.symUnionDefaultGraph, nv.getBoolean());
            } else {
                Log.warn(DatasetAssemblerTDB1.class, "Failed to recognize value for union graph setting (ignored): " + String.valueOf(b));
            }
        }
        AssemblerUtils.mergeContext(root2, dsg.getContext());
        return dsg;
    }

    static {
        JenaSystem.init();
    }
}

