/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.function.Supplier;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.sys.ShaclSystem;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.validation.ValidationListener;
import org.apache.jena.shacl.validation.event.ValidationEvent;
import org.apache.jena.sparql.path.Path;

public class ValidationContext {
    public static boolean VERBOSE = false;
    private final ValidationReport.Builder validationReportBuilder = ValidationReport.create();
    private boolean verbose = false;
    private boolean seenValidationReportEntry = false;
    private final Shapes shapes;
    private final Graph dataGraph;
    private boolean strict = false;
    private final ValidationListener validationListener;
    private final ErrorHandler errorHandler;
    private final IndentedWriter out;

    public static ValidationContext create(Shapes shapes, Graph data) {
        return ValidationContext.create(shapes, data, ShaclSystem.systemShaclErrorHandler, null);
    }

    public static ValidationContext create(Shapes shapes, Graph data, ValidationListener validationListener) {
        return ValidationContext.create(shapes, data, null, validationListener);
    }

    public static ValidationContext create(Shapes shapes, Graph data, ErrorHandler errorHandler) {
        return ValidationContext.create(shapes, data, errorHandler, null);
    }

    public static ValidationContext create(Shapes shapes, Graph data, ErrorHandler errorHandler, ValidationListener validationListener) {
        ValidationContext vCxt = new ValidationContext(shapes, data, errorHandler, validationListener);
        vCxt.setVerbose(VERBOSE);
        return vCxt;
    }

    public static ValidationContext create(ValidationContext vCxt) {
        return new ValidationContext(vCxt);
    }

    private ValidationContext(ValidationContext vCxt) {
        this.shapes = vCxt.shapes;
        this.dataGraph = vCxt.dataGraph;
        this.verbose = vCxt.verbose;
        this.strict = vCxt.strict;
        this.validationListener = vCxt.validationListener;
        this.errorHandler = vCxt.errorHandler;
        this.out = vCxt.out;
    }

    private ValidationContext(Shapes shapes, Graph data, ErrorHandler errorHandler, ValidationListener validationListener) {
        this.shapes = shapes;
        this.dataGraph = data;
        this.validationListener = validationListener;
        if (errorHandler == null) {
            errorHandler = ShaclSystem.systemShaclErrorHandler;
        }
        this.errorHandler = errorHandler;
        this.out = IndentedWriter.stdout.clone();
        this.validationReportBuilder.addPrefixes(data.getPrefixMapping());
        this.validationReportBuilder.addPrefixes(shapes.getGraph().getPrefixMapping());
    }

    public void reportEntry(ReportItem item, Shape shape, Node focusNode, Path path, Constraint constraint) {
        this.reportEntry(item.getMessage(), shape, focusNode, path, item.getValue(), constraint);
    }

    public void reportEntry(String message, Shape shape, Node focusNode, Path path, Node valueNode, Constraint constraint) {
        if (this.verbose) {
            System.out.println("Validation report entry");
        }
        this.seenValidationReportEntry = true;
        this.validationReportBuilder.addReportEntry(message, shape, focusNode, path, valueNode, constraint);
    }

    public ValidationReport generateReport() {
        return this.validationReportBuilder.build();
    }

    public IndentedWriter out() {
        return this.out;
    }

    public boolean hasViolation() {
        return this.seenValidationReportEntry;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setStrict(boolean value) {
        this.strict = value;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public Graph getShapesGraph() {
        return this.shapes.getGraph();
    }

    public Graph getDataGraph() {
        return this.dataGraph;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void notifyValidationListener(Supplier<ValidationEvent> eventSupplier) {
        if (this.validationListener != null) {
            ValidationEvent event = eventSupplier.get();
            this.validationListener.onValidationEvent(event);
        }
    }
}

