/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog;

import java.io.OutputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.filelog.rotate.ManagedOutput;
import org.apache.jena.rdfpatch.system.URNs;
import org.apache.jena.rdfpatch.text.RDFChangesWriterText;
import org.apache.jena.rdfpatch.text.TokenWriter;
import org.apache.jena.rdfpatch.text.TokenWriterText;

public class RDFChangesManagedOutput
extends RDFChangesWriterText {
    private final ManagedOutput managedOutput;
    private OutputStream currentStream = null;
    private Node previous = null;

    public RDFChangesManagedOutput(ManagedOutput output) {
        super(null);
        this.managedOutput = output;
    }

    @Override
    public void txnBegin() {
        this.startOutput();
        super.txnBegin();
    }

    @Override
    public void txnCommit() {
        super.txnCommit();
        this.finishOutput();
    }

    @Override
    public void txnAbort() {
        super.txnAbort();
        this.finishOutput();
    }

    @Override
    public void segment() {
        super.segment();
    }

    private void startOutput() {
        TokenWriter tokenWriter;
        if (this.currentStream != null) {
            Log.warn(this, "Already writing");
            return;
        }
        this.currentStream = this.managedOutput.output();
        this.tok = tokenWriter = TokenWriterText.create(this.currentStream);
        Node id = URNs.unique();
        this.header("id", id);
        if (this.previous != null) {
            this.header("prev", this.previous);
        }
        this.previous = id;
    }

    private void finishOutput() {
        this.tok.flush();
        IO.close(this.currentStream);
        this.currentStream = null;
        this.tok = null;
    }
}

