/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri3986.provider;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.iri3986.provider.IssueGroup;
import org.apache.jena.rfc3986.Issue;

class Issues {
    private static Map<Issue, IssueGroup> issuesGroups = Issues.issuesGroups();
    private static Map<String, IssueGroup> schemeNameMap = new ConcurrentHashMap<String, IssueGroup>();
    private static Map<IssueGroup, STRICT_MODE> strictnessMap = new ConcurrentHashMap<IssueGroup, STRICT_MODE>();

    Issues() {
    }

    public static IssueGroup getScheme(String schemeName) {
        schemeName = Lib.lowercase(schemeName);
        return schemeNameMap.computeIfAbsent(schemeName, IssueGroup::get);
    }

    public static IssueGroup groupForIssue(Issue issue) {
        return issuesGroups.get((Object)issue);
    }

    static boolean isStrict(Issue issue) {
        Objects.requireNonNull(issue);
        IssueGroup issueGroup = Issues.groupForIssue(issue);
        return Issues.isStrict(issueGroup);
    }

    static boolean isStrict(IssueGroup issueGroup) {
        Objects.requireNonNull(issueGroup);
        return strictnessMap.get((Object)issueGroup) == STRICT_MODE.STRICT;
    }

    static void setStrictness(IssueGroup issueGroup, boolean strict) {
        Issues.setStrictness(issueGroup, strict ? STRICT_MODE.STRICT : STRICT_MODE.NON_STRICT);
    }

    static void setStrictness(IssueGroup issueGroup, STRICT_MODE mode) {
        if (mode == null) {
            strictnessMap.remove((Object)issueGroup);
        } else {
            strictnessMap.put(issueGroup, mode);
        }
    }

    private static Map<Issue, IssueGroup> issuesGroups() {
        ConcurrentHashMap<Issue, IssueGroup> issueGroups = new ConcurrentHashMap<Issue, IssueGroup>();
        Issues.entry(issueGroups, Issue.ParseError, IssueGroup.SYNTAX);
        Issues.entry(issueGroups, Issue.iri_percent_not_uppercase, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_host_not_lowercase, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_user_info_present, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_password, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_bad_ipv4_address, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_bad_ipv6_address, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_scheme_name_is_not_lowercase, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_scheme_expected, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.iri_scheme_unexpected, IssueGroup.GENERAL);
        Issues.entry(issueGroups, Issue.http_no_host, IssueGroup.HTTP);
        Issues.entry(issueGroups, Issue.http_empty_host, IssueGroup.HTTP);
        Issues.entry(issueGroups, Issue.http_empty_port, IssueGroup.HTTP);
        Issues.entry(issueGroups, Issue.http_port_not_advised, IssueGroup.HTTP);
        Issues.entry(issueGroups, Issue.http_omit_well_known_port, IssueGroup.HTTP);
        Issues.entry(issueGroups, Issue.uuid_bad_pattern, IssueGroup.UUID);
        Issues.entry(issueGroups, Issue.uuid_has_query, IssueGroup.UUID);
        Issues.entry(issueGroups, Issue.uuid_has_fragment, IssueGroup.UUID);
        Issues.entry(issueGroups, Issue.uuid_not_lowercase, IssueGroup.UUID);
        Issues.entry(issueGroups, Issue.uuid_scheme_not_registered, IssueGroup.UUID);
        Issues.entry(issueGroups, Issue.urn_bad_pattern, IssueGroup.URN);
        Issues.entry(issueGroups, Issue.urn_bad_nid, IssueGroup.URN);
        Issues.entry(issueGroups, Issue.urn_bad_nss, IssueGroup.URN);
        Issues.entry(issueGroups, Issue.urn_bad_components, IssueGroup.URN);
        Issues.entry(issueGroups, Issue.urn_non_ascii_character, IssueGroup.URN);
        Issues.entry(issueGroups, Issue.urn_bad_informal_namespace, IssueGroup.URN);
        Issues.entry(issueGroups, Issue.urn_x_namespace, IssueGroup.URN);
        Issues.entry(issueGroups, Issue.file_bad_form, IssueGroup.FILE);
        Issues.entry(issueGroups, Issue.file_relative_path, IssueGroup.FILE);
        Issues.entry(issueGroups, Issue.did_bad_syntax, IssueGroup.DID);
        Issues.entry(issueGroups, Issue.oid_bad_syntax, IssueGroup.OID);
        Issues.entry(issueGroups, Issue.oid_scheme_not_registered, IssueGroup.OID);
        Issues.checkComplete(issueGroups);
        return issueGroups;
    }

    private static void entry(Map<Issue, IssueGroup> issueGroups, Issue issue, IssueGroup issueGroup) {
        issueGroups.put(issue, issueGroup);
    }

    private static void checkComplete(Map<Issue, IssueGroup> issuesGroups) {
        for (Issue issue : Issue.values()) {
            if (issuesGroups.containsKey((Object)issue)) continue;
            FmtLog.error(Issues.class, "IssueGroup : Missing entry for issue %s", new Object[]{issue});
        }
        for (Enum enum_ : IssueGroup.values()) {
            if (issuesGroups.containsValue(enum_)) continue;
            FmtLog.error(Issues.class, "IssueGroup : No entries for issue group %s", issuesGroups);
        }
    }

    private static enum STRICT_MODE {
        STRICT,
        NON_STRICT;

    }
}

