/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.DatasetDescriptionMap;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.main.cmds.FusekiMain;
import org.apache.jena.fuseki.mgt.Template;
import org.apache.jena.fuseki.mgt.TemplateFunctions;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.FusekiVocabG;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.system.G;

public class FusekiServerCtl {
    public static final String envFusekiBase = "FUSEKI_BASE";
    public static final String envFusekiShiro = "FUSEKI_SHIRO";
    public static final String DFT_SHIRO_INI = "shiro.ini";
    private static final String databasesLocationBase = "databases";
    private static final String databaseIndexesDir = "text_indexes";
    private static final String backupDirNameBase = "backups";
    private static final String configDirNameBase = "configuration";
    private static final String logsNameBase = "logs";
    private static final String systemFileAreaBase = "system_files";
    private static final String templatesNameBase = "templates";
    private static final String DFT_CONFIG = "config.ttl";
    private static int BaseFusekiAutoModuleLevel;
    public static int levelFModAdmin;
    public static int levelFModUI;
    public static int levelFModShiro;
    public static Path dirDatabases;
    public static Path dirBackups;
    public static Path dirConfiguration;
    public static Path dirLogs;
    public static Path dirSystemFileArea;
    public static Path dirTemplates;
    private static boolean initialized;
    static boolean serverInitialized;
    public static final String dftFusekiBase = "run";
    private Path fusekiBase = null;

    public static FusekiServerCtl get(ServletContext cxt) {
        if (cxt == null) {
            return null;
        }
        FusekiServerCtl fusekiServerCtl = (FusekiServerCtl)cxt.getAttribute("org.apache.jena.fuseki:ServerCtl");
        if (fusekiServerCtl == null) {
            Log.warn(FusekiServerCtl.class, "No FusekiServerCtl in ServletContext");
        }
        return fusekiServerCtl;
    }

    public FusekiServerCtl(Path location) {
        if (location == null) {
            location = this.envFusekiBase();
        }
        this.fusekiBase = location;
    }

    public Path getFusekiBase() {
        return this.fusekiBase;
    }

    private Path envFusekiBase() {
        if (this.fusekiBase != null) {
            return this.fusekiBase;
        }
        String valueFusekiBase = Lib.getenv(envFusekiBase);
        if (valueFusekiBase == null) {
            valueFusekiBase = dftFusekiBase;
        }
        Path setting = Path.of(valueFusekiBase, new String[0]);
        setting = setting.toAbsolutePath();
        return setting;
    }

    public void setup() {
        this.setBaseAreaOnDisk();
        this.ensureBaseArea();
    }

    private void setBaseAreaOnDisk() {
        FmtLog.info(Fuseki.configLog, "Fuseki Base = %s", this.fusekiBase);
        if (!Files.exists(this.fusekiBase, new LinkOption[0])) {
            try {
                Files.createDirectories(this.fusekiBase, new FileAttribute[0]);
            }
            catch (IOException e2) {
                throw new FusekiConfigException("Failed to create Fuseki Base: " + String.valueOf(this.fusekiBase));
            }
        }
    }

    private void ensureBaseArea() {
        Path baseArea = this.fusekiBase;
        if (Files.exists(baseArea, new LinkOption[0])) {
            if (!Files.isDirectory(baseArea, new LinkOption[0])) {
                throw new FusekiConfigException("Fuseki base is not a directory: " + String.valueOf(baseArea));
            }
            if (!Files.isWritable(baseArea)) {
                throw new FusekiConfigException("Fuseki base is not writable: " + String.valueOf(baseArea));
            }
        } else {
            FusekiServerCtl.ensureDir(baseArea);
        }
        dirTemplates = FusekiServerCtl.writeableDirectory(baseArea, templatesNameBase);
        dirDatabases = FusekiServerCtl.writeableDirectory(baseArea, databasesLocationBase);
        dirBackups = FusekiServerCtl.writeableDirectory(baseArea, backupDirNameBase);
        dirConfiguration = FusekiServerCtl.writeableDirectory(baseArea, configDirNameBase);
        dirLogs = FusekiServerCtl.writeableDirectory(baseArea, logsNameBase);
        dirSystemFileArea = FusekiServerCtl.writeableDirectory(baseArea, systemFileAreaBase);
        if (Lib.getenv(envFusekiShiro) == null) {
            FusekiServerCtl.copyFileIfMissing(null, DFT_SHIRO_INI, baseArea);
            System.setProperty(envFusekiShiro, baseArea.resolve(DFT_SHIRO_INI).toString());
        }
        FusekiServerCtl.copyFileIfMissing(null, DFT_CONFIG, baseArea);
        for (String n : Template.templateNames) {
            FusekiServerCtl.copyFileIfMissing(null, n, baseArea);
        }
        serverInitialized = true;
    }

    private static List<DataAccessPoint> processServerConfigFile(String configFilename) {
        if (!FileOps.exists(configFilename)) {
            Fuseki.configLog.warn("Configuration file '" + configFilename + "' does not exist");
            return Collections.emptyList();
        }
        Model model = AssemblerUtils.readAssemblerFile(configFilename);
        if (model.size() == 0L) {
            return Collections.emptyList();
        }
        List<DataAccessPoint> x = FusekiConfig.processServerConfiguration(model, Fuseki.getContext());
        return x;
    }

    private DataAccessPoint configFromTemplate(String templateFile, String datasetPath, boolean allowUpdate, Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
            params.put("NAME", datasetPath);
        } else if (!params.containsKey("NAME")) {
            Fuseki.configLog.warn("No NAME found in template parameters (added)");
            params.put("NAME", datasetPath);
        }
        Fuseki.configLog.info("Template file: " + templateFile);
        String dir = params.get("DIR");
        if (dir != null && !Objects.equals(dir, "--mem--") && !FileOps.exists(dir)) {
            throw new CmdException("Directory not found: " + dir);
        }
        datasetPath = DataAccessPoint.canonical(datasetPath);
        this.addGlobals(params);
        String str2 = TemplateFunctions.templateFile(this.fusekiBase, templateFile, params, Lang.TTL);
        Lang lang = RDFLanguages.filenameToLang(str2, Lang.TTL);
        Graph configuration = RDFParser.fromString(str2, lang).toGraph();
        List<Node> x = G.listPO(configuration, FusekiVocabG.pServiceName, null);
        if (x.isEmpty()) {
            ServletOps.errorBadRequest("No name given in description of Fuseki service");
        }
        if (x.size() > 1) {
            ServletOps.errorBadRequest("Multiple names given in description of Fuseki service");
        }
        Node fusekiService = x.get(0);
        DatasetDescriptionMap registry = new DatasetDescriptionMap();
        DataAccessPoint dap = FusekiConfig.buildDataAccessPoint(configuration, fusekiService, registry);
        return dap;
    }

    public void addGlobals(Map<String, String> params) {
        if (params == null) {
            Fuseki.configLog.warn("FusekiApp.addGlobals : params is null", new Throwable());
            return;
        }
        if (!params.containsKey(envFusekiBase)) {
            params.put(envFusekiBase, FusekiServerCtl.pathStringOrElse(this.fusekiBase, "unset"));
        }
    }

    private static void copyFileIfMissing(Path src, String fn, Path dst) {
        Path dstFile = dst.resolve(fn);
        if (Files.exists(dstFile, new LinkOption[0])) {
            return;
        }
        if (src != null) {
            Path srcFile = src.resolve(fn);
            if (!Files.exists(dstFile, new LinkOption[0])) {
                throw new FusekiConfigException("File not found: " + String.valueOf(srcFile));
            }
            try {
                IOX.safeWrite(dstFile, output -> Files.copy(srcFile, output));
            }
            catch (RuntimeIOException e2) {
                throw new FusekiConfigException("Failed to copy file " + String.valueOf(srcFile) + " to " + String.valueOf(dstFile), e2);
            }
        } else {
            FusekiServerCtl.copyFileFromResource(fn, dstFile);
        }
    }

    private static void copyFileFromResource(String fn, Path dstFile) {
        try {
            String absName = "org/apache/jena/fuseki/server/" + fn;
            InputStream input = FusekiServerCtl.class.getClassLoader().getResourceAsStream(absName);
            if (input == null) {
                throw new FusekiConfigException("Failed to find resource '" + absName + "'");
            }
            IOX.safeWrite(dstFile, output -> input.transferTo((OutputStream)output));
        }
        catch (RuntimeException e2) {
            throw new FusekiConfigException("Failed to copy " + fn + " to " + String.valueOf(dstFile), e2);
        }
    }

    private static String pathStringOrElse(Path path, String dft) {
        if (path == null) {
            return dft;
        }
        return path.toString();
    }

    private static Statement getOne(Model m, Resource s, Property p, RDFNode o) {
        StmtIterator iter = m.listStatements(s, p, o);
        if (!iter.hasNext()) {
            return null;
        }
        Statement stmt = (Statement)iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return stmt;
    }

    private static DataAccessPoint datasetDefaultConfiguration(String name, DatasetGraph dsg, boolean allowUpdate) {
        name = DataAccessPoint.canonical(name);
        DataService ds = FusekiConfig.buildDataServiceStd(dsg, allowUpdate);
        DataAccessPoint dap = new DataAccessPoint(name, ds);
        return dap;
    }

    private static void ensureDir(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            boolean b = dir.mkdirs();
            if (!b) {
                throw new FusekiConfigException("Failed to create directory: " + String.valueOf(directory));
            }
        } else if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + String.valueOf(directory));
        }
    }

    private static void mustExist(Path directory) {
        File dir = directory.toFile();
        if (!dir.exists()) {
            throw new FusekiConfigException("Does not exist: " + String.valueOf(directory));
        }
        if (!dir.isDirectory()) {
            throw new FusekiConfigException("Not a directory: " + String.valueOf(directory));
        }
    }

    private static boolean emptyDir(Path dir) {
        return dir.toFile().list().length <= 2;
    }

    private static boolean exists(Path directory) {
        File dir = directory.toFile();
        return dir.exists();
    }

    private static Path writeableDirectory(Path root2, String relName) {
        Path p = FusekiServerCtl.makePath(root2, relName);
        FusekiServerCtl.ensureDir(p);
        if (!Files.isWritable(p)) {
            throw new FusekiConfigException("Not writable: " + String.valueOf(p));
        }
        return p;
    }

    public static void clearUpSystemState() {
        System.getProperties().remove(envFusekiShiro);
        System.getProperties().remove(envFusekiBase);
        FusekiMain.resetCustomisers();
    }

    private static Path makePath(Path root2, String relName) {
        Path path = root2.resolve(relName);
        return path;
    }

    public static String datasetNameToConfigurationFile(HttpAction action, String dsName) {
        List<String> existing = FusekiServerCtl.existingConfigurationFile(dsName);
        if (!existing.isEmpty()) {
            if (existing.size() > 1) {
                action.log.warn(String.format("[%d] Multiple existing configuration files for %s : %s", action.id, dsName, existing));
                ServletOps.errorBadRequest("Multiple existing configuration files for " + dsName);
                return null;
            }
            return existing.get(0).toString();
        }
        return FusekiServerCtl.generateConfigurationFilename(dsName);
    }

    public static String generateConfigurationFilename(String dsName) {
        String filename = dsName;
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        Path p = dirConfiguration.resolve(filename + ".ttl");
        return p.toString();
    }

    public static List<String> existingConfigurationFile(String baseFilename) {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirConfiguration, baseFilename + ".*");){
                stream.forEach(p -> paths.add(dirConfiguration.resolve((Path)p).toString()));
            }
            return paths;
        }
        catch (IOException ex) {
            throw new InternalErrorException("Failed to read configuration directory " + String.valueOf(dirConfiguration));
        }
    }

    static {
        levelFModAdmin = BaseFusekiAutoModuleLevel = 500;
        levelFModUI = BaseFusekiAutoModuleLevel + 10;
        levelFModShiro = BaseFusekiAutoModuleLevel + 20;
        dirDatabases = null;
        dirBackups = null;
        dirConfiguration = null;
        dirLogs = null;
        dirSystemFileArea = null;
        dirTemplates = null;
        initialized = false;
        serverInitialized = false;
    }
}

