/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Transitive {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Node, Collection<Node>> transitive(Graph graph, Node property) {
        HashMap<Node, Collection<Node>> reachable = new HashMap<Node, Collection<Node>>();
        try (ExtendedIterator<Triple> props = G.find(graph, null, property, null);){
            while (props.hasNext()) {
                Triple triple = (Triple)props.next();
                Node node = triple.getSubject();
                if (reachable.containsKey(node)) continue;
                HashSet<Node> subs = new HashSet<Node>();
                Transitive.transitiveExc(graph, true, node, property, subs);
                reachable.put(node, subs);
            }
        }
        return reachable;
    }

    public static void transitiveInc(Graph graph, boolean forward, Node node, Node predicate, Collection<Node> output) {
        HashSet<Node> visited = new HashSet<Node>();
        Transitive.recurse(graph, forward, 0, -1, node, predicate, visited, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transitiveExc(Graph graph, boolean forward, Node node, Node predicate, Collection<Node> output) {
        try (ExtendedIterator<Node> iter = Transitive.singleStep(graph, forward, node, predicate);){
            HashSet<Node> visited = new HashSet<Node>();
            while (iter.hasNext()) {
                Node n1 = (Node)iter.next();
                Transitive.recurse(graph, forward, 1, -1, n1, predicate, visited, output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recurse(Graph graph, boolean forward, int stepCount, int maxStepCount, Node node, Node predicate, Set<Node> visited, Collection<Node> output) {
        if (maxStepCount >= 0 && stepCount > maxStepCount) {
            return;
        }
        if (!visited.add(node)) {
            return;
        }
        output.add(node);
        try (ExtendedIterator<Node> iter1 = Transitive.singleStep(graph, forward, node, predicate);){
            while (iter1.hasNext()) {
                Node n1 = (Node)iter1.next();
                Transitive.recurse(graph, forward, stepCount + 1, maxStepCount, n1, predicate, visited, output);
            }
        }
    }

    private static ExtendedIterator<Node> singleStep(Graph graph, boolean forward, Node node, Node property) {
        if (forward) {
            return G.iterSP(graph, node, property);
        }
        return G.iterPO(graph, property, node);
    }
}

