/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformApplyElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.QuerySyntaxSubstituteScope;
import org.apache.jena.sparql.syntax.syntaxtransform.TransformElementLib;

public class QueryTransformOps {
    public static Query syntaxSubstitute(Query input, Map<Var, ? extends Node> substitutions) {
        Query query2 = QueryTransformOps.transformSubstitute(input, substitutions);
        if (input.isSelectType()) {
            query2.setQueryResultStar(false);
            List<Var> projectVars = query2.getProjectVars();
            substitutions.forEach((v, n) -> {
                if (!projectVars.contains(v)) {
                    NodeValue nv = NodeValue.makeNode(n);
                    query2.getProject().update((Var)((Object)v), NodeValue.makeNode(n));
                }
            });
        }
        return query2;
    }

    @Deprecated
    public static Query transform(Query query, Map<Var, ? extends Node> substitutions) {
        return QueryTransformOps.replaceVars(query, substitutions);
    }

    public static Query replaceVars(Query query, Map<Var, ? extends Node> substitutions) {
        return QueryTransformOps.transformSubstitute(query, substitutions);
    }

    @Deprecated
    public static Query transformQuery(Query query, Map<String, ? extends RDFNode> substitutions) {
        return QueryTransformOps.queryReplaceVars(query, substitutions);
    }

    public static Query queryReplaceVars(Query query, Map<String, ? extends RDFNode> substitutions) {
        Map<Var, Node> map = TransformElementLib.convert(substitutions);
        return QueryTransformOps.replaceVars(query, map);
    }

    private static Query transformSubstitute(Query query, Map<Var, ? extends Node> substitutions) {
        HashSet<Var> varsForConst = new HashSet<Var>();
        substitutions.forEach((var, node) -> {
            if (!(node instanceof Var)) {
                varsForConst.add((Var)((Object)var));
            }
        });
        QuerySyntaxSubstituteScope.scopeCheck(query, varsForConst);
        ElementTransformSubst eltrans = new ElementTransformSubst(substitutions);
        NodeTransformSubst nodeTransform = new NodeTransformSubst(substitutions);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, eltrans);
        return QueryTransformOps.transform(query, eltrans, exprTrans);
    }

    public static Query transform(Query query, ElementTransform transform) {
        ExprTransformApplyElementTransform noop = new ExprTransformApplyElementTransform(transform);
        return QueryTransformOps.transform(query, transform, noop);
    }

    public static Query transform(Query query, ElementTransform transform, ExprTransform exprTransform) {
        Query q2 = QueryTransformOps.shallowCopy(query);
        QueryTransformOps.mutateByQueryType(q2, exprTransform);
        QueryTransformOps.mutateVarExprList(q2.getGroupBy(), exprTransform);
        QueryTransformOps.mutateExprList(q2.getHavingExprs(), exprTransform);
        if (q2.getOrderBy() != null) {
            QueryTransformOps.mutateSortConditions(q2.getOrderBy(), exprTransform);
        }
        QueryTransformOps.mutateQueryPattern(q2, transform, exprTransform);
        if (query.isQueryResultStar()) {
            q2.resetResultVars();
        }
        QueryTransformOps.setAggregators(q2, query, exprTransform);
        return q2;
    }

    private static void mutateQueryPattern(Query q2, ElementTransform transform, ExprTransform exprTransform) {
        Element el2;
        Element el = q2.getQueryPattern();
        Element element = el2 = el == null ? null : ElementTransformer.transform(el, transform, exprTransform);
        if (el2 != null && !(el2 instanceof ElementGroup) && !(el2 instanceof ElementSubQuery)) {
            ElementGroup eg = new ElementGroup();
            eg.addElement(el2);
            el2 = eg;
        }
        q2.setQueryPattern(el2);
        if (q2.hasValues()) {
            ElementData elData = new ElementData(q2.getValuesVariables(), q2.getValuesData());
            Element rawElData2 = ElementTransformer.transform(elData, transform, exprTransform);
            if (!(rawElData2 instanceof ElementData)) {
                throw new ARQException("Can't transform a values data block to a different type other than ElementData. Transform yeld type " + Objects.toString(rawElData2.getClass()));
            }
            ElementData elData2 = (ElementData)rawElData2;
            q2.setValuesDataBlock(elData2.getVars(), elData2.getRows());
        }
    }

    private static void setAggregators(Query newQuery, Query query, ExprTransform exprTransform) {
        for (ExprAggregator aggregator : query.getAggregators()) {
            newQuery.getAggregators().add((ExprAggregator)exprTransform.transform(aggregator));
        }
    }

    private static void mutateByQueryType(Query q2, ExprTransform exprTransform) {
        switch (q2.queryType()) {
            case ASK: {
                break;
            }
            case CONSTRUCT: {
                Template template = q2.getConstructTemplate();
                QuadAcc acc = new QuadAcc();
                List<Quad> quads = template.getQuads();
                quads.forEach(q -> {
                    Node g = QueryTransformOps.transformOrSame(q.getGraph(), exprTransform);
                    Node s = QueryTransformOps.transformOrSame(q.getSubject(), exprTransform);
                    Node p = QueryTransformOps.transformOrSame(q.getPredicate(), exprTransform);
                    Node o = QueryTransformOps.transformOrSame(q.getObject(), exprTransform);
                    acc.addQuad(Quad.create(g, s, p, o));
                });
                Template template2 = new Template(acc);
                q2.setConstructTemplate(template2);
                break;
            }
            case DESCRIBE: {
                QueryTransformOps.mutateDescribeVar(q2.getProjectVars(), q2.getResultURIs(), exprTransform);
                break;
            }
            case SELECT: {
                QueryTransformOps.mutateVarExprList(q2.getProject(), exprTransform);
                break;
            }
            case CONSTRUCT_JSON: {
                Map<String, Node> newJsonMapping = QueryTransformOps.transformJsonMapping(q2.getJsonMapping(), exprTransform);
                q2.setJsonMapping(newJsonMapping);
                break;
            }
            default: {
                throw new JenaException("Unknown query type");
            }
        }
    }

    private static void mutateConstruct(Query query, Query query2, ElementTransform transform) {
        if (query.isConstructQuad()) {
            Template template = query.getConstructTemplate();
            List<Quad> quads = template.getQuads();
            QuadAcc accQuads = new QuadAcc();
            quads.forEach(quad1 -> {
                Quad quad2 = transform.transform((Quad)quad1);
                accQuads.addQuad(quad2);
            });
            Template template2 = new Template(accQuads);
            query2.setConstructTemplate(template2);
            return;
        }
        if (query.isConstructType()) {
            Template template = query.getConstructTemplate();
            List<Triple> triples = template.getBGP().getList();
            BasicPattern accTriple = new BasicPattern();
            triples.forEach(triple1 -> {
                Triple triple2 = transform.transform((Triple)triple1);
                accTriple.add(triple2);
            });
            Template template2 = new Template(accTriple);
            query2.setConstructTemplate(template2);
            return;
        }
    }

    private static void mutateExprList(List<Expr> exprList, ExprTransform exprTransform) {
        for (int i = 0; i < exprList.size(); ++i) {
            Expr e1 = exprList.get(0);
            Expr e2 = ExprTransformer.transform(exprTransform, e1);
            if (e2 == null || e2 == e1) continue;
            exprList.set(i, e2);
        }
    }

    private static void mutateSortConditions(List<SortCondition> conditions, ExprTransform exprTransform) {
        for (int i = 0; i < conditions.size(); ++i) {
            SortCondition s1 = conditions.get(i);
            Expr e2 = ExprTransformer.transform(exprTransform, s1.expression);
            if (e2 == null || s1.expression.equals(e2)) continue;
            conditions.set(i, new SortCondition(e2, s1.direction));
        }
    }

    private static void mutateVarExprList(VarExprList varExprList, ExprTransform exprTransform) {
        VarExprList x = QueryTransformOps.transformVarExprList(varExprList, exprTransform);
        varExprList.clear();
        varExprList.addAll(x);
    }

    private static void mutateDescribeVar(List<Var> varList, List<Node> constants, ExprTransform exprTransform) {
        ArrayList<Var> varList2 = new ArrayList<Var>(varList.size());
        for (Var v : varList) {
            Node n = QueryTransformOps.transformOrSame((Node)v, exprTransform);
            if (n != v) {
                if (constants.contains(n)) continue;
                constants.add(n);
                continue;
            }
            varList2.add(v);
        }
        if (varList2.size() != varList.size()) {
            varList.clear();
            varList.addAll(varList2);
        }
    }

    private static VarExprList transformVarExprList(VarExprList varExprList, ExprTransform exprTransform) {
        VarExprList varExprList2 = new VarExprList();
        boolean changed = false;
        for (Var v : varExprList.getVars()) {
            Expr e2 = varExprList.getExpr(v);
            ExprVar ev = new ExprVar(v);
            Expr ev2 = exprTransform.transform(ev);
            if (ev != ev2) {
                changed = true;
            }
            if (e2 == null) {
                if (ev2.isConstant()) {
                    varExprList2.remove(v);
                    varExprList2.add(v, ev2);
                    continue;
                }
                if (ev2.isVariable()) {
                    varExprList2.add(ev2.asVar());
                    continue;
                }
                throw new ARQException("Can't substitute " + String.valueOf((Object)v) + " because it's not a simple value: " + String.valueOf(ev2));
            }
            Expr e22 = ExprTransformer.transform(exprTransform, e2);
            if (e22 != e2) {
                changed = true;
            }
            if (!ev2.isVariable()) {
                throw new ARQException("Can't substitute (" + String.valueOf((Object)v) + ", " + String.valueOf(e2) + ") as (" + String.valueOf(ev2) + ", " + String.valueOf(e22) + ")");
            }
            varExprList2.add(ev.asVar(), e22);
        }
        return varExprList2;
    }

    private static Map<String, Node> transformJsonMapping(Map<String, Node> jsonMapping, ExprTransform exprTransform) {
        LinkedHashMap<String, Node> result = new LinkedHashMap<String, Node>();
        jsonMapping.forEach((k, n) -> {
            Node n2 = QueryTransformOps.transformOrSame(n, exprTransform);
            result.put((String)k, n2);
        });
        return result;
    }

    private static Node transformOrSame(Node node, ExprTransform exprTransform) {
        if (!Var.isVar(node)) {
            return node;
        }
        Expr e2 = exprTransform.transform(node);
        if (e2 == null) {
            return node;
        }
        if (!e2.isConstant()) {
            return node;
        }
        return e2.getConstant().getNode();
    }

    public static Query shallowCopy(Query query) {
        QueryShallowCopy copy = new QueryShallowCopy();
        query.visit(copy);
        Query q2 = copy.newQuery;
        return q2;
    }

    static class QueryShallowCopy
    implements QueryVisitor {
        final Query newQuery = new Query();

        QueryShallowCopy() {
        }

        @Override
        public void startVisit(Query query) {
            this.newQuery.setSyntax(query.getSyntax());
            if (query.explicitlySetBaseURI()) {
                this.newQuery.setBaseURI(query.getPrologue().getBaseURI());
            }
            this.newQuery.setQueryResultStar(query.isQueryResultStar());
            if (query.hasDatasetDescription()) {
                DatasetDescription desc = query.getDatasetDescription();
                for (String x : desc.getDefaultGraphURIs()) {
                    this.newQuery.addGraphURI(x);
                }
                for (String x : desc.getNamedGraphURIs()) {
                    this.newQuery.addNamedGraphURI(x);
                }
            }
        }

        @Override
        public void visitPrologue(Prologue prologue) {
            PrefixMapping pmap = new PrefixMappingImpl().setNsPrefixes(prologue.getPrefixMapping());
            this.newQuery.setPrefixMapping(pmap);
        }

        @Override
        public void visitResultForm(Query q) {
        }

        @Override
        public void visitSelectResultForm(Query query) {
            this.newQuery.setQuerySelectType();
            this.newQuery.setDistinct(query.isDistinct());
            this.newQuery.setReduced(query.isReduced());
            this.copyProjection(query);
        }

        @Override
        public void visitConstructResultForm(Query query) {
            this.newQuery.setQueryConstructType();
            this.newQuery.setConstructTemplate(query.getConstructTemplate());
        }

        @Override
        public void visitDescribeResultForm(Query query) {
            this.newQuery.setQueryDescribeType();
            for (Node x : query.getResultURIs()) {
                this.newQuery.addDescribeNode(x);
            }
            this.copyProjection(query);
        }

        @Override
        public void visitAskResultForm(Query query) {
            this.newQuery.setQueryAskType();
        }

        @Override
        public void visitJsonResultForm(Query query) {
            this.newQuery.setQueryJsonType();
            this.newQuery.setJsonMapping(query.getJsonMapping());
        }

        @Override
        public void visitDatasetDecl(Query query) {
        }

        @Override
        public void visitQueryPattern(Query query) {
            this.newQuery.setQueryPattern(query.getQueryPattern());
        }

        @Override
        public void visitGroupBy(Query query) {
            if (query.hasGroupBy()) {
                VarExprList x = query.getGroupBy();
                for (Var v : x.getVars()) {
                    Expr expr = x.getExpr(v);
                    if (expr == null) {
                        this.newQuery.addGroupBy((Node)v);
                        continue;
                    }
                    this.newQuery.addGroupBy(v, expr);
                }
            }
        }

        @Override
        public void visitHaving(Query query) {
            if (query.hasHaving()) {
                for (Expr expr : query.getHavingExprs()) {
                    this.newQuery.addHavingCondition(expr);
                }
            }
        }

        @Override
        public void visitOrderBy(Query query) {
            if (query.hasOrderBy()) {
                for (SortCondition sc : query.getOrderBy()) {
                    this.newQuery.addOrderBy(sc);
                }
            }
        }

        @Override
        public void visitLimit(Query query) {
            this.newQuery.setLimit(query.getLimit());
        }

        @Override
        public void visitOffset(Query query) {
            this.newQuery.setOffset(query.getOffset());
        }

        @Override
        public void visitValues(Query query) {
            if (query.hasValues()) {
                this.newQuery.setValuesDataBlock(query.getValuesVariables(), query.getValuesData());
            }
        }

        @Override
        public void finishVisit(Query query) {
        }

        public void copyProjection(Query query) {
            VarExprList x = query.getProject();
            for (Var v : x.getVars()) {
                Expr expr = x.getExpr(v);
                if (expr == null) {
                    this.newQuery.addResultVar((Node)v);
                    continue;
                }
                this.newQuery.addResultVar((Node)v, expr);
            }
        }
    }
}

