/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.nquads;

import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import com.apicatalog.rdf.nquads.NQuadsReaderException;
import com.apicatalog.rdf.nquads.NQuadsTokenizer;
import java.io.Reader;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public class NQuadsReader {
    protected final NQuadsTokenizer tokenizer;
    protected final Predicate<String> testAbsoluteIRI;
    protected String ltObject;
    protected String ltDatatype;
    protected String ltLangTag;
    protected String ltDirection;

    public NQuadsReader(Reader reader) {
        this(new NQuadsTokenizer(reader), NQuadsReader::startsWithScheme);
    }

    public NQuadsReader(Reader reader, Predicate<String> testAbsoluteIRI) {
        this(new NQuadsTokenizer(reader), testAbsoluteIRI);
    }

    public NQuadsReader(Reader reader, int bufferSize) {
        this(new NQuadsTokenizer(reader, bufferSize), NQuadsReader::startsWithScheme);
    }

    public NQuadsReader(Reader reader, int bufferSize, Predicate<String> testAbsoluteIRI) {
        this(new NQuadsTokenizer(reader, bufferSize), testAbsoluteIRI);
    }

    protected NQuadsReader(NQuadsTokenizer tokenizer, Predicate<String> testAbsoluteIRI) {
        this.tokenizer = tokenizer;
        this.testAbsoluteIRI = testAbsoluteIRI;
    }

    public void provide(RdfQuadConsumer consumer) throws NQuadsReaderException, RdfConsumerException {
        while (this.tokenizer.hasNext()) {
            if (this.tokenizer.accept(NQuadsTokenizer.TokenType.END_OF_LINE) || this.tokenizer.accept(NQuadsTokenizer.TokenType.WHITE_SPACE) || this.tokenizer.accept(NQuadsTokenizer.TokenType.COMMENT)) continue;
            this.statement(consumer);
        }
    }

    protected void statement(RdfQuadConsumer consumer) throws NQuadsReaderException, RdfConsumerException {
        String subject = this.resource("Subject");
        this.skipWhitespace(0);
        String predicate = this.resource("Predicate");
        this.skipWhitespace(0);
        this.object();
        String graphName = null;
        this.skipWhitespace(0);
        if (NQuadsTokenizer.TokenType.IRI_REF == this.tokenizer.token().getType()) {
            String graphNameIri = this.tokenizer.token().getValue();
            this.assertAbsoluteIri(graphNameIri, "Graph name");
            graphName = graphNameIri;
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (NQuadsTokenizer.TokenType.BLANK_NODE_LABEL == this.tokenizer.token().getType()) {
            graphName = "_:".concat(this.tokenizer.token().getValue());
            this.tokenizer.next();
            this.skipWhitespace(0);
        }
        if (NQuadsTokenizer.TokenType.END_OF_STATEMENT != this.tokenizer.token().getType()) {
            NQuadsReader.unexpected(this.tokenizer.token(), NQuadsTokenizer.TokenType.END_OF_STATEMENT);
        }
        this.tokenizer.next();
        this.skipWhitespace(0);
        if (NQuadsTokenizer.TokenType.COMMENT == this.tokenizer.token().getType()) {
            this.tokenizer.next();
        } else if (NQuadsTokenizer.TokenType.END_OF_LINE != this.tokenizer.token().getType() && NQuadsTokenizer.TokenType.END_OF_INPUT != this.tokenizer.token().getType()) {
            NQuadsReader.unexpected(this.tokenizer.token(), NQuadsTokenizer.TokenType.END_OF_LINE, NQuadsTokenizer.TokenType.END_OF_INPUT);
            this.tokenizer.next();
        }
        consumer.quad(subject, predicate, this.ltObject, this.ltDatatype, this.ltLangTag, this.ltDirection, graphName);
    }

    protected String resource(String name) throws NQuadsReaderException {
        NQuadsTokenizer.Token token = this.tokenizer.token();
        if (NQuadsTokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            String iri = token.getValue();
            this.assertAbsoluteIri(iri, name);
            return iri;
        }
        if (NQuadsTokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            return "_:".concat(token.getValue());
        }
        return (String)NQuadsReader.unexpected(token, new NQuadsTokenizer.TokenType[0]);
    }

    protected void object() throws NQuadsReaderException {
        this.ltObject = null;
        this.ltDatatype = null;
        this.ltLangTag = null;
        this.ltDirection = null;
        NQuadsTokenizer.Token token = this.tokenizer.token();
        if (NQuadsTokenizer.TokenType.IRI_REF == token.getType()) {
            this.tokenizer.next();
            String iri = token.getValue();
            this.assertAbsoluteIri(iri, "Object");
            this.ltObject = iri;
            return;
        }
        if (NQuadsTokenizer.TokenType.BLANK_NODE_LABEL == token.getType()) {
            this.tokenizer.next();
            this.ltObject = "_:".concat(token.getValue());
            return;
        }
        if (NQuadsTokenizer.TokenType.STRING_LITERAL_QUOTE != token.getType()) {
            NQuadsReader.unexpected(token, new NQuadsTokenizer.TokenType[0]);
        }
        this.tokenizer.next();
        this.skipWhitespace(0);
        if (NQuadsTokenizer.TokenType.LANGTAG == this.tokenizer.token().getType()) {
            String langTag = this.tokenizer.token().getValue();
            this.tokenizer.next();
            this.ltDatatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
            this.ltObject = token.getValue();
            this.ltLangTag = langTag;
            return;
        }
        if (NQuadsTokenizer.TokenType.LITERAL_DATA_TYPE == this.tokenizer.token().getType()) {
            this.tokenizer.next();
            this.skipWhitespace(0);
            NQuadsTokenizer.Token attr = this.tokenizer.token();
            if (NQuadsTokenizer.TokenType.IRI_REF == attr.getType()) {
                this.tokenizer.next();
                String datatype = attr.getValue();
                this.assertAbsoluteIri(datatype, "DataType");
                this.ltObject = token.getValue();
                NQuadsReader.datatype(datatype, (a, b) -> {
                    this.ltDatatype = a;
                    if (b != null) {
                        if (((String[])b).length > 1) {
                            this.ltDirection = b[1];
                        }
                        if (((String[])b).length > 0) {
                            this.ltLangTag = b[0];
                        }
                    }
                });
                return;
            }
            NQuadsReader.unexpected(attr, new NQuadsTokenizer.TokenType[0]);
        }
        this.ltObject = token.getValue();
        this.ltDatatype = "http://www.w3.org/2001/XMLSchema#string";
    }

    protected static final <T> T unexpected(NQuadsTokenizer.Token token, NQuadsTokenizer.TokenType ... types) throws NQuadsReaderException {
        throw new NQuadsReaderException("Unexpected token " + (Object)((Object)token.getType()) + (token.getValue() != null ? "[" + token.getValue() + "]" : "") + ". Expected one of " + Arrays.toString((Object[])types) + ".");
    }

    protected void skipWhitespace(int min) throws NQuadsReaderException {
        int count = 0;
        while (this.tokenizer.accept(NQuadsTokenizer.TokenType.WHITE_SPACE)) {
            ++count;
        }
        if (count < min) {
            NQuadsReader.unexpected(this.tokenizer.token(), new NQuadsTokenizer.TokenType[0]);
        }
    }

    protected final void assertAbsoluteIri(String uri, String what) throws NQuadsReaderException {
        if (!this.testAbsoluteIRI.test(uri)) {
            throw new NQuadsReaderException(what + " must be an absolute URI [" + uri + "]. ");
        }
    }

    protected static final void datatype(String datatype, BiConsumer<String, String[]> result) {
        if (datatype.startsWith("https://www.w3.org/ns/i18n#")) {
            String[] langDir = datatype.substring("https://www.w3.org/ns/i18n#".length()).split("_");
            result.accept("https://www.w3.org/ns/i18n#", langDir);
            return;
        }
        result.accept(datatype, null);
    }

    protected static final boolean startsWithScheme(String uri) {
        if (uri == null || uri.length() < 2 || !Character.isLetter(uri.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < uri.length(); ++i) {
            if (Character.isLetterOrDigit(uri.codePointAt(i)) || uri.charAt(i) == '-' || uri.charAt(i) == '+' || uri.charAt(i) == '.') continue;
            return uri.charAt(i) == ':';
        }
        return false;
    }
}

