/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.plan.ClusterTopology;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.AbstractFragmentParallelPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.SubPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TreeModelTimePredicate;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.MultiChildrenSinkNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastSeriesSourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainAnalyzeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowQueriesStatement;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.Pair;

public class SimpleFragmentParallelPlanner
extends AbstractFragmentParallelPlanner {
    private final SubPlan subPlan;
    private final Analysis analysis;
    private final MPPQueryContext queryContext;
    private final Map<PlanFragmentId, FragmentInstance> instanceMap;
    private final Map<PlanNodeId, Pair<PlanFragmentId, PlanNode>> planNodeMap;
    private final List<FragmentInstance> fragmentInstanceList;
    private final Map<TDataNodeLocation, List<FragmentInstance>> dataNodeFIMap;
    private final ClusterTopology topology = ClusterTopology.getInstance();

    public SimpleFragmentParallelPlanner(SubPlan subPlan, Analysis analysis, MPPQueryContext context) {
        super(context);
        this.subPlan = subPlan;
        this.analysis = analysis;
        this.queryContext = context;
        this.instanceMap = new HashMap<PlanFragmentId, FragmentInstance>();
        this.planNodeMap = new HashMap<PlanNodeId, Pair<PlanFragmentId, PlanNode>>();
        this.fragmentInstanceList = new ArrayList<FragmentInstance>();
        this.dataNodeFIMap = new HashMap<TDataNodeLocation, List<FragmentInstance>>();
    }

    @Override
    public List<FragmentInstance> parallelPlan() {
        this.prepare();
        this.calculateNodeTopologyBetweenInstance();
        return this.fragmentInstanceList;
    }

    private void prepare() {
        List<PlanFragment> fragments = this.subPlan.getPlanFragmentList();
        for (PlanFragment fragment : fragments) {
            this.recordPlanNodeRelation(fragment.getPlanNodeTree(), fragment.getId());
            this.produceFragmentInstance(fragment);
        }
        this.fragmentInstanceList.forEach(fragmentInstance -> fragmentInstance.setDataNodeFINum(this.dataNodeFIMap.get(fragmentInstance.getHostDataNode()).size()));
        if (this.analysis.getTreeStatement() instanceof QueryStatement && ((QueryStatement)this.analysis.getTreeStatement()).isLastQuery()) {
            HashMap pathSumMap = new HashMap();
            this.dataNodeFIMap.values().forEach(fragmentInstances -> {
                fragmentInstances.forEach(fragmentInstance -> this.updateScanNum(fragmentInstance.getFragment().getPlanNodeTree(), pathSumMap));
                pathSumMap.clear();
            });
        }
    }

    private void updateScanNum(PlanNode planNode, Map<Path, AtomicInteger> pathSumMap) {
        if (planNode instanceof LastSeriesSourceNode) {
            LastSeriesSourceNode lastSeriesSourceNode = (LastSeriesSourceNode)planNode;
            pathSumMap.merge((Path)lastSeriesSourceNode.getSeriesPath(), lastSeriesSourceNode.getDataNodeSeriesScanNum(), (k, v) -> {
                v.incrementAndGet();
                return v;
            });
        }
        planNode.getChildren().forEach(node -> this.updateScanNum((PlanNode)node, pathSumMap));
    }

    private void produceFragmentInstance(PlanFragment fragment) {
        Expression globalTimePredicate = this.analysis.getGlobalTimePredicate();
        FragmentInstance fragmentInstance = new FragmentInstance(fragment, fragment.getId().genFragmentInstanceId(), globalTimePredicate == null ? null : new TreeModelTimePredicate(globalTimePredicate), this.queryContext.getQueryType(), this.queryContext.getTimeOut() - (System.currentTimeMillis() - this.queryContext.getStartTime()), this.queryContext.getSession(), this.queryContext.isExplainAnalyze(), fragment.isRoot());
        this.selectExecutorAndHost(fragment, fragmentInstance, fragment::getTargetRegionForTreeModel, this.topology::getValidatedReplicaSet, this.dataNodeFIMap);
        if (this.analysis.getTreeStatement() instanceof QueryStatement || this.analysis.getTreeStatement() instanceof ExplainAnalyzeStatement || this.analysis.getTreeStatement() instanceof ShowQueriesStatement || this.analysis.getTreeStatement() instanceof ShowTimeSeriesStatement && ((ShowTimeSeriesStatement)this.analysis.getTreeStatement()).isOrderByHeat()) {
            fragmentInstance.getFragment().generateTypeProvider(this.queryContext.getTypeProvider());
        }
        this.instanceMap.putIfAbsent(fragment.getId(), fragmentInstance);
        this.fragmentInstanceList.add(fragmentInstance);
    }

    private void calculateNodeTopologyBetweenInstance() {
        for (FragmentInstance instance : this.fragmentInstanceList) {
            PlanNode rootNode = instance.getFragment().getPlanNodeTree();
            if (!(rootNode instanceof MultiChildrenSinkNode)) continue;
            MultiChildrenSinkNode sinkNode = (MultiChildrenSinkNode)rootNode;
            sinkNode.getDownStreamChannelLocationList().forEach(downStreamChannelLocation -> {
                PlanNodeId downStreamNodeId = new PlanNodeId(downStreamChannelLocation.getRemotePlanNodeId());
                FragmentInstance downStreamInstance = this.findDownStreamInstance(this.planNodeMap, this.instanceMap, downStreamNodeId);
                downStreamChannelLocation.setRemoteEndpoint(downStreamInstance.getHostDataNode().getMPPDataExchangeEndPoint());
                downStreamChannelLocation.setRemoteFragmentInstanceId(downStreamInstance.getId().toThrift());
                PlanNode downStreamExchangeNode = (PlanNode)this.planNodeMap.get((Object)downStreamNodeId).right;
                ((ExchangeNode)downStreamExchangeNode).setUpstream(instance.getHostDataNode().getMPPDataExchangeEndPoint(), instance.getId(), sinkNode.getPlanNodeId());
            });
        }
    }

    private void recordPlanNodeRelation(PlanNode root, PlanFragmentId planFragmentId) {
        this.planNodeMap.put(root.getPlanNodeId(), (Pair<PlanFragmentId, PlanNode>)new Pair((Object)planFragmentId, (Object)root));
        for (PlanNode child : root.getChildren()) {
            this.recordPlanNodeRelation(child, planFragmentId);
        }
    }
}

